// Generated by gmmproc 2.77.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <glibmm/optionentry.h>
#include <glibmm/private/optionentry_p.h>


/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/utility.h>
#include <glib.h>

namespace Glib
{

using Flags = OptionEntry::Flags;

OptionEntry::OptionEntry()
{
  gobject_ = g_new0(GOptionEntry, 1);
}

OptionEntry::~OptionEntry()
{
  release_gobject();
}

void
OptionEntry::release_gobject() noexcept
{
  if (!gobject_)
    return;

  g_free(const_cast<char*>(gobject_->long_name));
  g_free(const_cast<char*>(gobject_->description));
  g_free(const_cast<char*>(gobject_->arg_description));
  g_free(gobject_);
}

OptionEntry::OptionEntry(const OptionEntry& src)
{
  gobject_ = g_new0(GOptionEntry, 1);

  operator=(src);
}

OptionEntry&
OptionEntry::operator=(const OptionEntry& src)
{
  if (this != &src)
  {
    if (gobject_->long_name)
      g_free(const_cast<char*>(gobject_->long_name));

    gobject_->long_name = g_strdup(src.gobject_->long_name);

    gobject_->short_name = src.gobject_->short_name; // It's just one char.

    gobject_->flags = src.gobject_->flags;
    gobject_->arg = src.gobject_->arg;
    gobject_->arg_data =
      src.gobject_
        ->arg_data; // Shared, because it's not owned by any instance of this class anyway.

    if (gobject_->description)
      g_free(const_cast<char*>(gobject_->description));

    gobject_->description = g_strdup(src.gobject_->description);

    if (gobject_->arg_description)
      g_free(const_cast<char*>(gobject_->arg_description));

    gobject_->arg_description = g_strdup(src.gobject_->arg_description);
  }

  return *this;
}

OptionEntry::OptionEntry(OptionEntry&& other) noexcept : gobject_(std::move(other.gobject_))
{
  other.gobject_ = nullptr;
}

OptionEntry&
OptionEntry::operator=(OptionEntry&& other) noexcept
{
  release_gobject();

  gobject_ = std::move(other.gobject_);
  other.gobject_ = nullptr;

  return *this;
}

} // namespace Glib

namespace
{
} // anonymous namespace


namespace Glib
{


Glib::ustring OptionEntry::get_long_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->long_name);
}

void OptionEntry::set_long_name(const Glib::ustring& value)
{
  g_free((char*)gobj()->long_name); // Cast away const, if any
  gobj()->long_name = g_strdup((value).c_str());
}

gchar OptionEntry::get_short_name() const
{
  return gobj()->short_name;
}

void OptionEntry::set_short_name(const gchar& value)
{
  gobj()->short_name = value;
}

Flags OptionEntry::get_flags() const
{
  return static_cast<Flags>(gobj()->flags);
}

void OptionEntry::set_flags(const Flags& value)
{
  gobj()->flags = static_cast<int>(value);
}

Glib::ustring OptionEntry::get_description() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->description);
}

void OptionEntry::set_description(const Glib::ustring& value)
{
  g_free((char*)gobj()->description); // Cast away const, if any
  gobj()->description = g_strdup(Glib::c_str_or_nullptr(value));
}

Glib::ustring OptionEntry::get_arg_description() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->arg_description);
}

void OptionEntry::set_arg_description(const Glib::ustring& value)
{
  g_free((char*)gobj()->arg_description); // Cast away const, if any
  gobj()->arg_description = g_strdup(Glib::c_str_or_nullptr(value));
}


} // namespace Glib


