// Generated by gmmproc 2.73.2 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/dbusconnection.h>
#include <giomm/private/dbusconnection_p.h>


/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>
#include <glibmm/exceptionhandler.h>
#include <giomm/actiongroup.h>
#include <giomm/dbusauthobserver.h>
#include <giomm/dbusintrospection.h>
#include <giomm/dbusmethodinvocation.h>
#include <giomm/dbuserror.h>
#include <giomm/menumodel.h>

#ifdef G_OS_UNIX
#include <giomm/unixfdlist.h>
#endif

#include <giomm/slot_async.h>
#include <mutex>

namespace
{

extern "C" {

static void
DBusConnection_Signal_giomm_callback(GDBusConnection* connection, const char* sender_name,
  const char* object_path, const char* interface_name, const char* signal_name,
  GVariant* parameters, void* user_data)
{
  Gio::DBus::Connection::SlotSignal* the_slot =
    static_cast<Gio::DBus::Connection::SlotSignal*>(user_data);

  try
  {
    (*the_slot)(Glib::wrap(connection, true), (sender_name ? sender_name : ""),
      (object_path ? object_path : ""), (interface_name ? interface_name : ""),
      (signal_name ? signal_name : ""), Glib::VariantContainerBase(parameters, true));
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }
}

static void
DBusConnection_Signal_giomm_callback_destroy(void* data)
{
  delete static_cast<Gio::DBus::Connection::SlotSignal*>(data);
}

static GDBusMessage*
DBusConnection_Message_Filter_giomm_callback(
  GDBusConnection* connection, GDBusMessage* message, gboolean incoming, void* user_data)
{
  Gio::DBus::Connection::SlotMessageFilter* the_slot =
    static_cast<Gio::DBus::Connection::SlotMessageFilter*>(user_data);

  try
  {
    auto result = (*the_slot)(
      Glib::wrap(connection, true), Glib::wrap(message, true), static_cast<bool>(incoming));
    return (result) ? result->gobj_copy() : nullptr;
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }

  return message;
}

static void
DBusConnection_Message_Filter_giomm_callback_destroy(void* data)
{
  delete static_cast<Gio::DBus::Connection::SlotMessageFilter*>(data);
}

} // extern "C"

// Glib::wrap(GDBusConnection* object, bool take_copy) must be protected by a
// mutex while a C++ wrapper is being constructed. The same GDBusConnection
// instance can be used in more than one thread. The wrap() function can be
// called simultaneously in different threads for the same GDBusConnection
// instance before it has been given a C++ wrapper.
// https://gitlab.gnome.org/GNOME/glibmm/issues/56
std::mutex wrap_mutex;

} // anonymous namespace

namespace Gio
{

namespace DBus
{

Connection::Connection(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<AuthObserver>& observer, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "stream",Glib::unwrap(stream),"guid",Glib::c_str_or_nullptr(guid),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), nullptr))
{
  init_async(slot, cancellable);
}

Connection::Connection(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "stream",Glib::unwrap(stream),"guid",Glib::c_str_or_nullptr(guid),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(nullptr), nullptr))
{
  init_async(slot, cancellable);
}

Connection::Connection(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<AuthObserver>& observer, const SlotAsyncReady& slot, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "stream",Glib::unwrap(stream),"guid",Glib::c_str_or_nullptr(guid),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), nullptr))
{
  init_async(slot);
}

Connection::Connection(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const SlotAsyncReady& slot, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "stream",Glib::unwrap(stream),"guid",Glib::c_str_or_nullptr(guid),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(nullptr), nullptr))
{
  init_async(slot);
}

Connection::Connection(const std::string& address, const Glib::RefPtr<AuthObserver>& observer,
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "address",Glib::c_str_or_nullptr(address),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), nullptr))
{
  init_async(slot, cancellable);
}

Connection::Connection(const std::string& address, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "address",Glib::c_str_or_nullptr(address),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(nullptr), nullptr))
{
  init_async(slot, cancellable);
}

Connection::Connection(const std::string& address, const Glib::RefPtr<AuthObserver>& observer,
  const SlotAsyncReady& slot, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "address",Glib::c_str_or_nullptr(address),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), nullptr))
{
  init_async(slot);
}

Connection::Connection(
  const std::string& address, const SlotAsyncReady& slot, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "address",Glib::c_str_or_nullptr(address),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(nullptr), nullptr))
{
  init_async(slot);
}

Connection::Connection(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<AuthObserver>& observer, const Glib::RefPtr<Cancellable>& cancellable,
  ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "stream",Glib::unwrap(stream),"guid",Glib::c_str_or_nullptr(guid),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), nullptr))
{
  init(cancellable);
}

Connection::Connection(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "stream",Glib::unwrap(stream),"guid",Glib::c_str_or_nullptr(guid),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(nullptr), nullptr))
{
  init(cancellable);
}

Connection::Connection(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<AuthObserver>& observer, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "stream",Glib::unwrap(stream),"guid",Glib::c_str_or_nullptr(guid),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), nullptr))
{
  init();
}

Connection::Connection(
  const Glib::RefPtr<IOStream>& stream, const std::string& guid, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "stream",Glib::unwrap(stream),"guid",Glib::c_str_or_nullptr(guid),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(nullptr), nullptr))
{
  init();
}

Connection::Connection(const std::string& address, const Glib::RefPtr<AuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "address",Glib::c_str_or_nullptr(address),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), nullptr))
{
  init(cancellable);
}

Connection::Connection(
  const std::string& address, const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "address",Glib::c_str_or_nullptr(address),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(nullptr), nullptr))
{
  init(cancellable);
}

Connection::Connection(
  const std::string& address, const Glib::RefPtr<AuthObserver>& observer, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "address",Glib::c_str_or_nullptr(address),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), nullptr))
{
  init();
}

Connection::Connection(const std::string& address, ConnectionFlags flags)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(connection_class_.init(), "address",Glib::c_str_or_nullptr(address),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(nullptr), nullptr))
{
  init();
}

// static
void
Connection::create(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<AuthObserver>& observer, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().

  Connection(stream, guid, observer, slot, cancellable, flags);
}

// static
void
Connection::create(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().

  Connection(stream, guid, slot, cancellable, flags);
}

// static
void
Connection::create(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<AuthObserver>& observer, const SlotAsyncReady& slot, ConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  Connection(stream, guid, observer, slot, flags);
}

// static
void
Connection::create(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const SlotAsyncReady& slot, ConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  Connection(stream, guid, slot, flags);
}

// static
Glib::RefPtr<Connection>
Connection::create_sync(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<AuthObserver>& observer, const Glib::RefPtr<Cancellable>& cancellable,
  ConnectionFlags flags)
{
  return Glib::make_refptr_for_instance<Connection>(new Connection(stream, guid, observer, cancellable, flags));
}

// static
Glib::RefPtr<Connection>
Connection::create_sync(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
{
  return Glib::make_refptr_for_instance<Connection>(new Connection(stream, guid, cancellable, flags));
}

// static
Glib::RefPtr<Connection>
Connection::create_sync(const Glib::RefPtr<IOStream>& stream, const std::string& guid,
  const Glib::RefPtr<AuthObserver>& observer, ConnectionFlags flags)
{
  return Glib::make_refptr_for_instance<Connection>(new Connection(stream, guid, observer, flags));
}

// static
Glib::RefPtr<Connection>
Connection::create_sync(
  const Glib::RefPtr<IOStream>& stream, const std::string& guid, ConnectionFlags flags)
{
  return Glib::make_refptr_for_instance<Connection>(new Connection(stream, guid, flags));
}

// static
void
Connection::create_for_address(const std::string& address,
  const Glib::RefPtr<AuthObserver>& observer, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  Connection(address, observer, slot, cancellable, flags);
}

// static
void
Connection::create_for_address(const std::string& address, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  Connection(address, slot, cancellable, flags);
}

// static
void
Connection::create_for_address(const std::string& address,
  const Glib::RefPtr<AuthObserver>& observer, const SlotAsyncReady& slot, ConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  Connection(address, observer, slot, flags);
}

// static
void
Connection::create_for_address(
  const std::string& address, const SlotAsyncReady& slot, ConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  Connection(address, slot, flags);
}

// static
Glib::RefPtr<Connection>
Connection::create_for_address_sync(const std::string& address,
  const Glib::RefPtr<AuthObserver>& observer, const Glib::RefPtr<Cancellable>& cancellable,
  ConnectionFlags flags)
{
  return Glib::make_refptr_for_instance<Connection>(new Connection(address, observer, cancellable, flags));
}

// static
Glib::RefPtr<Connection>
Connection::create_for_address_sync(
  const std::string& address, const Glib::RefPtr<Cancellable>& cancellable, ConnectionFlags flags)
{
  return Glib::make_refptr_for_instance<Connection>(new Connection(address, cancellable, flags));
}

// static
Glib::RefPtr<Connection>
Connection::create_for_address_sync(
  const std::string& address, const Glib::RefPtr<AuthObserver>& observer, ConnectionFlags flags)
{
  return Glib::make_refptr_for_instance<Connection>(new Connection(address, observer, flags));
}

// static
Glib::RefPtr<Connection>
Connection::create_for_address_sync(const std::string& address, ConnectionFlags flags)
{
  return Glib::make_refptr_for_instance<Connection>(new Connection(address, flags));
}

// static
void
Connection::get(
  BusType bus_type, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  auto slot_copy = new SlotAsyncReady(slot);

  g_bus_get(static_cast<GBusType>(bus_type), Glib::unwrap(cancellable), &SignalProxy_async_callback,
    slot_copy);
}

// static
void
Connection::get(BusType bus_type, const SlotAsyncReady& slot)
{
  auto slot_copy = new SlotAsyncReady(slot);

  g_bus_get(static_cast<GBusType>(bus_type), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
Connection::close()
{
  g_dbus_connection_close(gobj(), nullptr, nullptr, nullptr);
}

void
Connection::close(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  auto slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_close(
    gobj(), Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
Connection::close(const SlotAsyncReady& slot)
{
  auto slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_close(gobj(), nullptr, &SignalProxy_async_callback, slot_copy);
}

void
Connection::flush()
{
  g_dbus_connection_flush(gobj(), nullptr, nullptr, nullptr);
}

void
Connection::flush(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  auto slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_flush(
    gobj(), Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
Connection::flush(const SlotAsyncReady& slot)
{
  auto slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_flush(gobj(), nullptr, &SignalProxy_async_callback, slot_copy);
}

bool
Connection::send_message(const Glib::RefPtr<Message>& message, SendMessageFlags flags)
{
  GError* gerror = nullptr;

  const bool result = g_dbus_connection_send_message(
    gobj(), Glib::unwrap(message), static_cast<GDBusSendMessageFlags>(flags), nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return result;
}

void
Connection::send_message_with_reply(const Glib::RefPtr<Message>& message, int timeout_msec,
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  auto slot_copy = new SlotAsyncReady(slot);
  volatile guint32 out_serial = 0;
  g_dbus_connection_send_message_with_reply(gobj(), Glib::unwrap(message),
    static_cast<GDBusSendMessageFlags>(message->get_flags()), timeout_msec, &out_serial,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
  message->set_serial(out_serial);
}

void
Connection::send_message_with_reply(
  const Glib::RefPtr<Message>& message, int timeout_msec, const SlotAsyncReady& slot)
{
  auto slot_copy = new SlotAsyncReady(slot);
  volatile guint32 out_serial = 0;
  g_dbus_connection_send_message_with_reply(gobj(), Glib::unwrap(message),
    static_cast<GDBusSendMessageFlags>(message->get_flags()), timeout_msec, &out_serial, nullptr,
    &SignalProxy_async_callback, slot_copy);
  message->set_serial(out_serial);
}

Glib::RefPtr<Message>
Connection::send_message_with_reply_sync(const Glib::RefPtr<Message>& message,
  const Glib::RefPtr<Cancellable>& cancellable, gint timeout_msec)
{
  volatile guint32 out_serial = 0;
  GError* gerror = nullptr;

  GDBusMessage* result = g_dbus_connection_send_message_with_reply_sync(gobj(),
    Glib::unwrap(message), static_cast<GDBusSendMessageFlags>(message->get_flags()), timeout_msec,
    &out_serial, Glib::unwrap(cancellable), &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);
  message->set_serial(out_serial);
  return Glib::wrap(result);
}

Glib::RefPtr<Message>
Connection::send_message_with_reply_sync(const Glib::RefPtr<Message>& message, gint timeout_msec)
{
  volatile guint32 out_serial = 0;
  GError* gerror = nullptr;

  GDBusMessage* result = g_dbus_connection_send_message_with_reply_sync(gobj(),
    Glib::unwrap(message), static_cast<GDBusSendMessageFlags>(message->get_flags()), timeout_msec,
    &out_serial, nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);
  message->set_serial(out_serial);
  return Glib::wrap(result);
}

void
Connection::call(const Glib::ustring& object_path, const Glib::ustring& interface_name,
  const Glib::ustring& method_name, const Glib::VariantContainerBase& parameters,
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  const Glib::ustring& bus_name, int timeout_msec, CallFlags flags,
  const Glib::VariantType& reply_type)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_call(gobj(), Glib::c_str_or_nullptr(bus_name), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(), const_cast<GVariant*>(parameters.gobj()),
    reply_type.gobj(), static_cast<GDBusCallFlags>(flags), timeout_msec, Glib::unwrap(cancellable),
    &SignalProxy_async_callback, slot_copy);
}

// Non-cancellable version.
void
Connection::call(const Glib::ustring& object_path, const Glib::ustring& interface_name,
  const Glib::ustring& method_name, const Glib::VariantContainerBase& parameters,
  const SlotAsyncReady& slot, const Glib::ustring& bus_name, int timeout_msec, CallFlags flags,
  const Glib::VariantType& reply_type)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_call(gobj(), Glib::c_str_or_nullptr(bus_name), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(), const_cast<GVariant*>(parameters.gobj()),
    reply_type.gobj(), static_cast<GDBusCallFlags>(flags), timeout_msec, nullptr,
    &SignalProxy_async_callback, slot_copy);
}

Glib::VariantContainerBase
Connection::call_sync(const Glib::ustring& object_path, const Glib::ustring& interface_name,
  const Glib::ustring& method_name, const Glib::VariantContainerBase& parameters,
  const Glib::RefPtr<Cancellable>& cancellable, const Glib::ustring& bus_name, int timeout_msec,
  CallFlags flags, const Glib::VariantType& reply_type)
{
  GError* gerror = nullptr;

  GVariant* const gvariant = g_dbus_connection_call_sync(gobj(), Glib::c_str_or_nullptr(bus_name),
    object_path.c_str(), interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(), static_cast<GDBusCallFlags>(flags),
    timeout_msec, Glib::unwrap(cancellable), &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return Glib::VariantContainerBase(gvariant, false); // Dont' take an extra reference.
}

// Non-cancellable version.
Glib::VariantContainerBase
Connection::call_sync(const Glib::ustring& object_path, const Glib::ustring& interface_name,
  const Glib::ustring& method_name, const Glib::VariantContainerBase& parameters,
  const Glib::ustring& bus_name, int timeout_msec, CallFlags flags,
  const Glib::VariantType& reply_type)
{
  GError* gerror = nullptr;

  GVariant* const gvariant =
    g_dbus_connection_call_sync(gobj(), Glib::c_str_or_nullptr(bus_name), object_path.c_str(),
      interface_name.c_str(), method_name.c_str(), const_cast<GVariant*>(parameters.gobj()),
      reply_type.gobj(), static_cast<GDBusCallFlags>(flags), timeout_msec, nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return Glib::VariantContainerBase(gvariant, false); // Dont' take an extra reference.
}

#ifdef G_OS_UNIX
// With a UnixFDList.
void
Connection::call(const Glib::ustring& object_path, const Glib::ustring& interface_name,
  const Glib::ustring& method_name, const Glib::VariantContainerBase& parameters,
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable,
  const Glib::RefPtr<UnixFDList>& fd_list, const Glib::ustring& bus_name, int timeout_msec,
  CallFlags flags, const Glib::VariantType& reply_type)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_call_with_unix_fd_list(gobj(), Glib::c_str_or_nullptr(bus_name),
    object_path.c_str(), interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(), static_cast<GDBusCallFlags>(flags),
    timeout_msec, Glib::unwrap(fd_list), Glib::unwrap(cancellable), &SignalProxy_async_callback,
    slot_copy);
}

// Non-cancellable version (with a UnixFDList).
void
Connection::call(const Glib::ustring& object_path, const Glib::ustring& interface_name,
  const Glib::ustring& method_name, const Glib::VariantContainerBase& parameters,
  const SlotAsyncReady& slot, const Glib::RefPtr<UnixFDList>& fd_list,
  const Glib::ustring& bus_name, int timeout_msec, CallFlags flags,
  const Glib::VariantType& reply_type)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_call_with_unix_fd_list(gobj(), Glib::c_str_or_nullptr(bus_name),
    object_path.c_str(), interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(), static_cast<GDBusCallFlags>(flags),
    timeout_msec, Glib::unwrap(fd_list), nullptr, &SignalProxy_async_callback, slot_copy);
}
#endif // G_OS_UNIX

void
Connection::emit_signal(const Glib::ustring& object_path, const Glib::ustring& interface_name,
  const Glib::ustring& signal_name, const Glib::ustring& destination_bus_name,
  const Glib::VariantContainerBase& parameters)
{
  GError* gerror = nullptr;

  // destination_bus_name is checked to see if it is empty so that nullptr can be passed
  // to the C API. This is done because the bus name can be nullptr in the C API,
  // meaning that the signal should be emitted to all the listeners.
  g_dbus_connection_emit_signal(gobj(), Glib::c_str_or_nullptr(destination_bus_name),
    object_path.c_str(), interface_name.c_str(), signal_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);
}

guint
Connection::signal_subscribe(const SlotSignal& slot, const Glib::ustring& sender,
  const Glib::ustring& interface_name, const Glib::ustring& member,
  const Glib::ustring& object_path, const Glib::ustring& arg0, SignalFlags flags)
{
  auto slot_copy = new SlotSignal(slot);

  return g_dbus_connection_signal_subscribe(gobj(), Glib::c_str_or_nullptr(sender),
    Glib::c_str_or_nullptr(interface_name), Glib::c_str_or_nullptr(member),
    Glib::c_str_or_nullptr(object_path), Glib::c_str_or_nullptr(arg0),
    static_cast<GDBusSignalFlags>(flags), &DBusConnection_Signal_giomm_callback, slot_copy,
    &DBusConnection_Signal_giomm_callback_destroy);
}

guint
Connection::add_filter(const SlotMessageFilter& slot)
{
  auto slot_copy = new SlotMessageFilter(slot);

  return g_dbus_connection_add_filter(gobj(), &DBusConnection_Message_Filter_giomm_callback,
    slot_copy, DBusConnection_Message_Filter_giomm_callback_destroy);
}

guint
Connection::register_object(const Glib::ustring& object_path,
  const Glib::RefPtr<InterfaceInfo>& interface_info, const InterfaceVTable& vtable)
{
  GError* gerror = nullptr;

  const guint result =
    g_dbus_connection_register_object(gobj(), object_path.c_str(), Glib::unwrap(interface_info),
      vtable.gobj(), const_cast<InterfaceVTable*>(&vtable), nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return result;
}

guint
Connection::register_object(
  const Glib::ustring& object_path, const Glib::RefPtr<InterfaceInfo>& interface_info)
{
  GError* gerror = nullptr;

  const guint result = g_dbus_connection_register_object(
    gobj(), object_path.c_str(), Glib::unwrap(interface_info), nullptr, nullptr, nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return result;
}

guint
Connection::register_subtree(
  const Glib::ustring& object_path, const SubtreeVTable& vtable, SubtreeFlags flags)
{
  GError* gerror = nullptr;

  const guint result =
    g_dbus_connection_register_subtree(gobj(), object_path.c_str(), vtable.gobj(),
      static_cast<GDBusSubtreeFlags>(flags), const_cast<SubtreeVTable*>(&vtable), nullptr, &gerror);

  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return result;
}

} // namespace DBus

} // namespace Gio

namespace Glib
{

Glib::RefPtr<Gio::DBus::Connection> wrap(GDBusConnection* object, bool take_copy)
{
  Glib::ObjectBase* pCppObject = nullptr;
  if (!ObjectBase::_get_current_wrapper((GObject*)object))
  {
    // 'object' does not yet have a C++ wrapper. Construction of the C++ wrapper
    // must be thread-safe. See comments at the definition of wrap_mutex.
    std::lock_guard<std::mutex> lock(wrap_mutex);
    pCppObject = Glib::wrap_auto((GObject*)object, take_copy);
  }
  else
    pCppObject = Glib::wrap_auto((GObject*)object, take_copy);

  return Glib::make_refptr_for_instance<Gio::DBus::Connection>(dynamic_cast<Gio::DBus::Connection*>(pCppObject));
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib

namespace
{


static void Connection_signal_closed_callback(GDBusConnection* self, gboolean p0,GError* p1,void* data)
{
  using namespace Gio::DBus;
  using SlotType = sigc::slot<void(bool, const Glib::Error&)>;

  auto obj = dynamic_cast<Connection*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
, Glib::Error(p1, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Connection_signal_closed_info =
{
  "closed",
  (GCallback) &Connection_signal_closed_callback,
  (GCallback) &Connection_signal_closed_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gio::DBus::BusType>::value_type()
{
  return g_bus_type_get_type();
}

// static
GType Glib::Value<Gio::DBus::ConnectionFlags>::value_type()
{
  return g_dbus_connection_flags_get_type();
}


namespace Gio
{

namespace DBus
{


/* The *_Class implementation: */

const Glib::Class& Connection_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Connection_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_dbus_connection_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Initable::add_interface(get_type());
  AsyncInitable::add_interface(get_type());

  }

  return *this;
}


void Connection_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Connection_Class::wrap_new(GObject* object)
{
  return new Connection((GDBusConnection*)object);
}


/* The implementation: */

GDBusConnection* Connection::gobj_copy()
{
  reference();
  return gobj();
}

Connection::Connection(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Connection::Connection(GDBusConnection* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Connection::Connection(Connection&& src) noexcept
: Glib::Object(std::move(src))
  , Initable(std::move(src))
  , AsyncInitable(std::move(src))
{}

Connection& Connection::operator=(Connection&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  Initable::operator=(std::move(src));
  AsyncInitable::operator=(std::move(src));
  return *this;
}


Connection::~Connection() noexcept
{}


Connection::CppClassType Connection::connection_class_; // initialize static member

GType Connection::get_type()
{
  return connection_class_.init().get_type();
}


GType Connection::get_base_type()
{
  return g_dbus_connection_get_type();
}


Glib::RefPtr<Connection> Connection::get_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_bus_get_finish(Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Connection> Connection::get_sync(BusType bus_type, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_bus_get_sync(static_cast<GBusType>(bus_type), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Connection> Connection::get_sync(BusType bus_type)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_bus_get_sync(static_cast<GBusType>(bus_type), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Connection> Connection::create_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_dbus_connection_new_finish(Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Connection> Connection::create_for_address_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_dbus_connection_new_for_address_finish(Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Connection::close_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  auto retvalue = g_dbus_connection_close_finish(gobj(), Glib::unwrap(res), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Connection::close_sync(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  g_dbus_connection_close_sync(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Connection::close_sync()
{
  GError* gerror = nullptr;
  g_dbus_connection_close_sync(gobj(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

bool Connection::flush_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  auto retvalue = g_dbus_connection_flush_finish(gobj(), Glib::unwrap(res), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Connection::flush_sync(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  g_dbus_connection_flush_sync(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Connection::flush_sync()
{
  GError* gerror = nullptr;
  g_dbus_connection_flush_sync(gobj(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

bool Connection::get_exit_on_close() const
{
  return g_dbus_connection_get_exit_on_close(const_cast<GDBusConnection*>(gobj()));
}

void Connection::set_exit_on_close(bool exit_on_close)
{
  g_dbus_connection_set_exit_on_close(gobj(), static_cast<int>(exit_on_close));
}

bool Connection::send_message(const Glib::RefPtr<Message>& message, SendMessageFlags flags, guint32& out_serial)
{
  GError* gerror = nullptr;
  auto retvalue = g_dbus_connection_send_message(gobj(), Glib::unwrap(message), static_cast<GDBusSendMessageFlags>(flags), &(out_serial), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Message> Connection::send_message_with_reply_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_dbus_connection_send_message_with_reply_finish(gobj(), Glib::unwrap(res), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Connection::start_message_processing()
{
  g_dbus_connection_start_message_processing(gobj());
}

bool Connection::is_closed() const
{
  return g_dbus_connection_is_closed(const_cast<GDBusConnection*>(gobj()));
}

Glib::RefPtr<IOStream> Connection::get_stream()
{
  auto retvalue = Glib::wrap(g_dbus_connection_get_stream(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const IOStream> Connection::get_stream() const
{
  return const_cast<Connection*>(this)->get_stream();
}

std::string Connection::get_guid() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(g_dbus_connection_get_guid(const_cast<GDBusConnection*>(gobj())));
}

Glib::ustring Connection::get_unique_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(g_dbus_connection_get_unique_name(const_cast<GDBusConnection*>(gobj())));
}

CapabilityFlags Connection::get_capabilities() const
{
  return static_cast<CapabilityFlags>(g_dbus_connection_get_capabilities(const_cast<GDBusConnection*>(gobj())));
}

ConnectionFlags Connection::get_flags() const
{
  return static_cast<ConnectionFlags>(g_dbus_connection_get_flags(const_cast<GDBusConnection*>(gobj())));
}

Glib::RefPtr<Credentials> Connection::get_peer_credentials()
{
  auto retvalue = Glib::wrap(g_dbus_connection_get_peer_credentials(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Credentials> Connection::get_peer_credentials() const
{
  return const_cast<Connection*>(this)->get_peer_credentials();
}

guint32 Connection::get_last_serial() const
{
  return g_dbus_connection_get_last_serial(const_cast<GDBusConnection*>(gobj()));
}

Glib::VariantContainerBase Connection::call_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::VariantContainerBase(g_dbus_connection_call_finish(gobj(), Glib::unwrap(res), &(gerror)), false);
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

#ifdef G_OS_UNIX
Glib::VariantContainerBase Connection::call_finish(const Glib::RefPtr<AsyncResult>& res, Glib::RefPtr<UnixFDList>& out_fd_list)
{
  GError* gerror = nullptr;
  GUnixFDList* g_out_fd_list = nullptr;
  auto retvalue = Glib::VariantContainerBase(g_dbus_connection_call_with_unix_fd_list_finish(gobj(), &g_out_fd_list, Glib::unwrap(res), &(gerror)), false);
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
out_fd_list = Glib::wrap(g_out_fd_list);
  return retvalue;
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
Glib::VariantContainerBase Connection::call_sync(const Glib::ustring& object_path, const Glib::ustring& interface_name, const Glib::ustring& method_name, const Glib::VariantContainerBase& parameters, const Glib::RefPtr<Cancellable>& cancellable, const Glib::RefPtr<UnixFDList>& fd_list, Glib::RefPtr<UnixFDList>& out_fd_list, const Glib::ustring& bus_name, int timeout_msec, CallFlags flags, const Glib::VariantType& reply_type)
{
  GError* gerror = nullptr;
  GUnixFDList* g_out_fd_list = nullptr;
  auto retvalue = Glib::VariantContainerBase(g_dbus_connection_call_with_unix_fd_list_sync(gobj(), bus_name.empty() ? nullptr : bus_name.c_str(), object_path.c_str(), interface_name.c_str(), method_name.c_str(), const_cast<GVariant*>((parameters).gobj()), (reply_type).gobj(), static_cast<GDBusCallFlags>(flags), timeout_msec, Glib::unwrap(fd_list), &g_out_fd_list, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)), false);
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
out_fd_list = Glib::wrap(g_out_fd_list);
  return retvalue;
}
#endif // G_OS_UNIX

#ifdef G_OS_UNIX
Glib::VariantContainerBase Connection::call_sync(const Glib::ustring& object_path, const Glib::ustring& interface_name, const Glib::ustring& method_name, const Glib::VariantContainerBase& parameters, const Glib::RefPtr<UnixFDList>& fd_list, Glib::RefPtr<UnixFDList>& out_fd_list, const Glib::ustring& bus_name, int timeout_msec, CallFlags flags, const Glib::VariantType& reply_type)
{
  GError* gerror = nullptr;
  GUnixFDList* g_out_fd_list = nullptr;
  auto retvalue = Glib::VariantContainerBase(g_dbus_connection_call_with_unix_fd_list_sync(gobj(), bus_name.empty() ? nullptr : bus_name.c_str(), object_path.c_str(), interface_name.c_str(), method_name.c_str(), const_cast<GVariant*>((parameters).gobj()), (reply_type).gobj(), static_cast<GDBusCallFlags>(flags), timeout_msec, Glib::unwrap(fd_list), &g_out_fd_list, nullptr, &(gerror)), false);
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
out_fd_list = Glib::wrap(g_out_fd_list);
  return retvalue;
}
#endif // G_OS_UNIX

void Connection::signal_unsubscribe(guint subscription_id)
{
  g_dbus_connection_signal_unsubscribe(gobj(), subscription_id);
}

void Connection::remove_filter(guint filter_id)
{
  g_dbus_connection_remove_filter(gobj(), filter_id);
}

bool Connection::unregister_object(guint registration_id)
{
  return g_dbus_connection_unregister_object(gobj(), registration_id);
}

bool Connection::unregister_subtree(guint registration_id)
{
  return g_dbus_connection_unregister_subtree(gobj(), registration_id);
}

guint Connection::export_action_group(const Glib::ustring& object_path, const Glib::RefPtr<ActionGroup>& action_group)
{
  GError* gerror = nullptr;
  auto retvalue = g_dbus_connection_export_action_group(gobj(), object_path.c_str(), Glib::unwrap(action_group), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Connection::unexport_action_group(guint export_id)
{
  g_dbus_connection_unexport_action_group(gobj(), export_id);
}

guint Connection::export_menu_model(const Glib::ustring& object_path, const Glib::RefPtr<MenuModel>& menu)
{
  GError* gerror = nullptr;
  auto retvalue = g_dbus_connection_export_menu_model(gobj(), object_path.c_str(), const_cast<GMenuModel*>(Glib::unwrap(menu)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Connection::unexport_menu_model(guint export_id)
{
  g_dbus_connection_unexport_menu_model(gobj(), export_id);
}


Glib::SignalProxy<void(bool, const Glib::Error&)> Connection::signal_closed()
{
  return Glib::SignalProxy<void(bool, const Glib::Error&) >(this, &Connection_signal_closed_info);
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<CapabilityFlags>::value,
  "Type CapabilityFlags cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< CapabilityFlags > Connection::property_capabilities() const
{
  return Glib::PropertyProxy_ReadOnly< CapabilityFlags >(this, "capabilities");
}

Glib::PropertyProxy_ReadOnly< bool > Connection::property_closed() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "closed");
}

Glib::PropertyProxy< bool > Connection::property_exit_on_close() 
{
  return Glib::PropertyProxy< bool >(this, "exit-on-close");
}

Glib::PropertyProxy_ReadOnly< bool > Connection::property_exit_on_close() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "exit-on-close");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<ConnectionFlags>::value,
  "Type ConnectionFlags cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< ConnectionFlags > Connection::property_flags() const
{
  return Glib::PropertyProxy_ReadOnly< ConnectionFlags >(this, "flags");
}

Glib::PropertyProxy_ReadOnly< std::string > Connection::property_guid() const
{
  return Glib::PropertyProxy_ReadOnly< std::string >(this, "guid");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<IOStream>>::value,
  "Type Glib::RefPtr<IOStream> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<IOStream> > Connection::property_stream() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<IOStream> >(this, "stream");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Connection::property_unique_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "unique-name");
}


} // namespace DBus

} // namespace Gio


