// Generated by gmmproc 2.62.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/iostream.h>
#include <giomm/private/iostream_p.h>


/* Copyright (C) 2007 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>
#include <glibmm/error.h>
#include <giomm/asyncresult.h>
#include "slot_async.h"

namespace Gio
{

void
IOStream::close_async(
  const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_io_stream_close_async(
    gobj(), io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
IOStream::close_async(const SlotAsyncReady& slot, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_io_stream_close_async(gobj(), io_priority, nullptr, &SignalProxy_async_callback, slot_copy);
}

void
IOStream::splice_async(const Glib::RefPtr<IOStream>& stream2, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable, IOStreamSpliceFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_io_stream_splice_async(gobj(), Glib::unwrap(stream2), static_cast<GIOStreamSpliceFlags>(flags),
    io_priority, Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

void
IOStream::splice_async(const Glib::RefPtr<IOStream>& stream2, const SlotAsyncReady& slot,
  IOStreamSpliceFlags flags, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  auto slot_copy = new SlotAsyncReady(slot);

  g_io_stream_splice_async(gobj(), Glib::unwrap(stream2), static_cast<GIOStreamSpliceFlags>(flags),
    io_priority, nullptr, &SignalProxy_async_callback, slot_copy);
}

} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::IOStream> wrap(GIOStream* object, bool take_copy)
{
  return Glib::RefPtr<Gio::IOStream>( dynamic_cast<Gio::IOStream*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& IOStream_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &IOStream_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_io_stream_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void IOStream_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* IOStream_Class::wrap_new(GObject* object)
{
  return new IOStream((GIOStream*)object);
}


/* The implementation: */

GIOStream* IOStream::gobj_copy()
{
  reference();
  return gobj();
}

IOStream::IOStream(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

IOStream::IOStream(GIOStream* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


IOStream::IOStream(IOStream&& src) noexcept
: Glib::Object(std::move(src))
{}

IOStream& IOStream::operator=(IOStream&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


IOStream::~IOStream() noexcept
{}


IOStream::CppClassType IOStream::iostream_class_; // initialize static member

GType IOStream::get_type()
{
  return iostream_class_.init().get_type();
}


GType IOStream::get_base_type()
{
  return g_io_stream_get_type();
}


bool IOStream::splice_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_io_stream_splice_finish(Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<InputStream> IOStream::get_input_stream()
{
  Glib::RefPtr<InputStream> retvalue = Glib::wrap(g_io_stream_get_input_stream(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<OutputStream> IOStream::get_output_stream()
{
  Glib::RefPtr<OutputStream> retvalue = Glib::wrap(g_io_stream_get_output_stream(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

bool IOStream::close(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  bool retvalue = g_io_stream_close(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool IOStream::close()
{
  GError* gerror = nullptr;
  bool retvalue = g_io_stream_close(gobj(), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool IOStream::close_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = nullptr;
  bool retvalue = g_io_stream_close_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool IOStream::is_closed() const
{
  return g_io_stream_is_closed(const_cast<GIOStream*>(gobj()));
}

bool IOStream::has_pending() const
{
  return g_io_stream_has_pending(const_cast<GIOStream*>(gobj()));
}

bool IOStream::set_pending()
{
  GError* gerror = nullptr;
  bool retvalue = g_io_stream_set_pending(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void IOStream::clear_pending()
{
  g_io_stream_clear_pending(gobj());
}


} // namespace Gio


