// -*- c++ -*-
// Generated by gmmproc 2.44.0 -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSINTROSPECTION_H
#define _GIOMM_DBUSINTROSPECTION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <glibmm/arrayhandle.h>


namespace Gio
{

namespace DBus
{

/** @addtogroup giommEnums giomm Enums and Flags */

/** 
 *  @var PropertyInfoFlags PROPERTY_INFO_FLAGS_NONE
 * No flags set.
 * 
 *  @var PropertyInfoFlags PROPERTY_INFO_FLAGS_READABLE
 * Property is readable.
 * 
 *  @var PropertyInfoFlags PROPERTY_INFO_FLAGS_WRITABLE
 * Property is writable.
 * 
 *  @enum PropertyInfoFlags
 * 
 * Flags describing the access control of a D-Bus property.
 * 
 * @newin{2,26}
 *
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%PropertyInfoFlags operator|(PropertyInfoFlags, PropertyInfoFlags)</tt><br>
 * <tt>%PropertyInfoFlags operator&(PropertyInfoFlags, PropertyInfoFlags)</tt><br>
 * <tt>%PropertyInfoFlags operator^(PropertyInfoFlags, PropertyInfoFlags)</tt><br>
 * <tt>%PropertyInfoFlags operator~(PropertyInfoFlags)</tt><br>
 * <tt>%PropertyInfoFlags& operator|=(PropertyInfoFlags&, PropertyInfoFlags)</tt><br>
 * <tt>%PropertyInfoFlags& operator&=(PropertyInfoFlags&, PropertyInfoFlags)</tt><br>
 * <tt>%PropertyInfoFlags& operator^=(PropertyInfoFlags&, PropertyInfoFlags)</tt><br>
 */
enum PropertyInfoFlags
{
  PROPERTY_INFO_FLAGS_NONE = 0x0,
  PROPERTY_INFO_FLAGS_READABLE = (1<<0),
  PROPERTY_INFO_FLAGS_WRITABLE = (1<<1)
};

/** @ingroup giommEnums */
inline PropertyInfoFlags operator|(PropertyInfoFlags lhs, PropertyInfoFlags rhs)
  { return static_cast<PropertyInfoFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline PropertyInfoFlags operator&(PropertyInfoFlags lhs, PropertyInfoFlags rhs)
  { return static_cast<PropertyInfoFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline PropertyInfoFlags operator^(PropertyInfoFlags lhs, PropertyInfoFlags rhs)
  { return static_cast<PropertyInfoFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline PropertyInfoFlags operator~(PropertyInfoFlags flags)
  { return static_cast<PropertyInfoFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline PropertyInfoFlags& operator|=(PropertyInfoFlags& lhs, PropertyInfoFlags rhs)
  { return (lhs = static_cast<PropertyInfoFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline PropertyInfoFlags& operator&=(PropertyInfoFlags& lhs, PropertyInfoFlags rhs)
  { return (lhs = static_cast<PropertyInfoFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline PropertyInfoFlags& operator^=(PropertyInfoFlags& lhs, PropertyInfoFlags rhs)
  { return (lhs = static_cast<PropertyInfoFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** Stores information about an annotation.
 *
 * @newin{2,28}
 * @ingroup DBus
 */
class AnnotationInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AnnotationInfo CppObjectType;
  typedef GDBusAnnotationInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusAnnotationInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusAnnotationInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusAnnotationInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBus::AnnotationInfo can neither be constructed nor deleted.
  AnnotationInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  AnnotationInfo(const AnnotationInfo&);
  AnnotationInfo& operator=(const AnnotationInfo&);


public:
 

  /** Looks up the value of an annotation.
   * 
   * The cost of this function is O(n) in number of annotations.
   * 
   * @newin{2,26}
   * 
   * @param annotations A <tt>0</tt>-terminated array of annotations or <tt>0</tt>.
   * @param name The name of the annotation to look up.
   * @return The value or <tt>0</tt> if not found. Do not free, it is owned by @a annotations.
   */
  static Glib::ustring info_lookup(const Glib::ArrayHandle< Glib::RefPtr<AnnotationInfo> >& annotations, const Glib::ustring& name);


};

/** ArgInfo - Stores information about an argument for a method or a
 * signal.
 *
 * @newin{2,28}
 * @ingroup DBus
 */
class ArgInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ArgInfo CppObjectType;
  typedef GDBusArgInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusArgInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusArgInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusArgInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBus::ArgInfo can neither be constructed nor deleted.
  ArgInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  ArgInfo(const ArgInfo&);
  ArgInfo& operator=(const ArgInfo&);


public:


};

/** Stores information about a method on an D-Bus interface.
 *
 * @newin{2,28}
 * @ingroup DBus
 */
class MethodInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef MethodInfo CppObjectType;
  typedef GDBusMethodInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusMethodInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusMethodInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusMethodInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBus::MethodInfo can neither be constructed nor deleted.
  MethodInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  MethodInfo(const MethodInfo&);
  MethodInfo& operator=(const MethodInfo&);


public:


};

/** Stores information about a signal on a D-Bus interface.
 *
 * @newin{2,28}
 * @ingroup DBus
 */
class SignalInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SignalInfo CppObjectType;
  typedef GDBusSignalInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusSignalInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusSignalInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusSignalInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBus::SignalInfo can neither be constructed nor deleted.
  SignalInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  SignalInfo(const SignalInfo&);
  SignalInfo& operator=(const SignalInfo&);


public:


};

/** Stores information about a property on a D-Bus interface.
 *
 * @newin{2,28}
 * @ingroup DBus
 */
class PropertyInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PropertyInfo CppObjectType;
  typedef GDBusPropertyInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusPropertyInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusPropertyInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusPropertyInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBus::PropertyInfo can neither be constructed nor deleted.
  PropertyInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  PropertyInfo(const PropertyInfo&);
  PropertyInfo& operator=(const PropertyInfo&);


public:


};

/** Stores information about a D-Bus interface.
 *
 * @newin{2,28}
 * @ingroup DBus
 */
class InterfaceInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef InterfaceInfo CppObjectType;
  typedef GDBusInterfaceInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusInterfaceInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusInterfaceInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusInterfaceInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBus::InterfaceInfo can neither be constructed nor deleted.
  InterfaceInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  InterfaceInfo(const InterfaceInfo&);
  InterfaceInfo& operator=(const InterfaceInfo&);


public:
  
  /** Looks up information about a method.
   * 
   * The cost of this function is O(n) in number of methods unless
   * g_dbus_interface_info_cache_build() has been used on @a info.
   * 
   * @newin{2,26}
   * 
   * @param name A D-Bus method name (typically in CamelCase).
   * @return A DBusMethodInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<MethodInfo> lookup_method(const Glib::ustring& name);
  
  /** Looks up information about a method.
   * 
   * The cost of this function is O(n) in number of methods unless
   * g_dbus_interface_info_cache_build() has been used on @a info.
   * 
   * @newin{2,26}
   * 
   * @param name A D-Bus method name (typically in CamelCase).
   * @return A DBusMethodInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<const MethodInfo> lookup_method(const Glib::ustring& name) const;

  
  /** Looks up information about a signal.
   * 
   * The cost of this function is O(n) in number of signals unless
   * g_dbus_interface_info_cache_build() has been used on @a info.
   * 
   * @newin{2,26}
   * 
   * @param name A D-Bus signal name (typically in CamelCase).
   * @return A DBusSignalInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<SignalInfo> lookup_signal(const Glib::ustring& name);
  
  /** Looks up information about a signal.
   * 
   * The cost of this function is O(n) in number of signals unless
   * g_dbus_interface_info_cache_build() has been used on @a info.
   * 
   * @newin{2,26}
   * 
   * @param name A D-Bus signal name (typically in CamelCase).
   * @return A DBusSignalInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<const SignalInfo> lookup_signal(const Glib::ustring& name) const;

  
  /** Looks up information about a property.
   * 
   * The cost of this function is O(n) in number of properties unless
   * g_dbus_interface_info_cache_build() has been used on @a info.
   * 
   * @newin{2,26}
   * 
   * @param name A D-Bus property name (typically in CamelCase).
   * @return A DBusPropertyInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<PropertyInfo> lookup_property(const Glib::ustring& name);
  
  /** Looks up information about a property.
   * 
   * The cost of this function is O(n) in number of properties unless
   * g_dbus_interface_info_cache_build() has been used on @a info.
   * 
   * @newin{2,26}
   * 
   * @param name A D-Bus property name (typically in CamelCase).
   * @return A DBusPropertyInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<const PropertyInfo> lookup_property(const Glib::ustring& name) const;

  
  /** Builds a lookup-cache to speed up
   * g_dbus_interface_info_lookup_method(),
   * g_dbus_interface_info_lookup_signal() and
   * g_dbus_interface_info_lookup_property().
   * 
   * If this has already been called with @a info, the existing cache is
   * used and its use count is increased.
   * 
   * Note that @a info cannot be modified until
   * g_dbus_interface_info_cache_release() is called.
   * 
   * @newin{2,30}
   * 
   */
  void cache_build();
  
  /** Decrements the usage count for the cache for @a info built by
   * g_dbus_interface_info_cache_build() (if any) and frees the
   * resources used by the cache if the usage count drops to zero.
   * 
   * @newin{2,30}
   * 
   */
  void cache_release();

  //TODO: _WRAP_METHOD(void generate_xml(guint indent, GString* string_builder), g_dbus_interface_info_generate_xml)


};

/** NodeInfo - Stores information about nodes in a remote object
 * hierarchy.
 *
 * @newin{2,28}
 * @ingroup DBus
 */
class NodeInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef NodeInfo CppObjectType;
  typedef GDBusNodeInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusNodeInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusNodeInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusNodeInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBus::NodeInfo can neither be constructed nor deleted.
  NodeInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  NodeInfo(const NodeInfo&);
  NodeInfo& operator=(const NodeInfo&);


public:
  
  /** Parses @a xml_data and returns a DBusNodeInfo representing the data.
   * 
   * The introspection XML must contain exactly one top-level
   * <node> element.
   * 
   * Note that this routine is using a
   * [GMarkup][glib-Simple-XML-Subset-Parser.description]-based
   * parser that only accepts a subset of valid XML documents.
   * 
   * @newin{2,26}
   * 
   * @param xml_data Valid D-Bus introspection XML.
   * @return A DBusNodeInfo structure or <tt>0</tt> if @a error is set. Free
   * with g_dbus_node_info_unref().
   */

  
  /** @throw Glib::Error.
   */
  static Glib::RefPtr<NodeInfo> create_for_xml(const Glib::ustring& xml_data);

  
  /** Looks up information about an interface.
   * 
   * The cost of this function is O(n) in number of interfaces.
   * 
   * @newin{2,26}
   * 
   * @param name A D-Bus interface name.
   * @return A DBusInterfaceInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<InterfaceInfo> lookup_interface(const Glib::ustring& name);
  
  /** Looks up information about an interface.
   * 
   * The cost of this function is O(n) in number of interfaces.
   * 
   * @newin{2,26}
   * 
   * @param name A D-Bus interface name.
   * @return A DBusInterfaceInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<const InterfaceInfo> lookup_interface(const Glib::ustring& name) const;

  /** Looks up information about the first interface.
   */
  Glib::RefPtr<InterfaceInfo> lookup_interface();

  /** Looks up information about the first interface.
   */
  Glib::RefPtr<const InterfaceInfo> lookup_interface() const;

  //TODO: _WRAP_METHOD(void generate_xml(guint indent, GString* string_builder), g_dbus_node_info_generate_xml)


};

} //namespace DBus

} // namespace Gio


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBus::AnnotationInfo
   */
  Glib::RefPtr<Gio::DBus::AnnotationInfo> wrap(GDBusAnnotationInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBus::ArgInfo
   */
  Glib::RefPtr<Gio::DBus::ArgInfo> wrap(GDBusArgInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBus::MethodInfo
   */
  Glib::RefPtr<Gio::DBus::MethodInfo> wrap(GDBusMethodInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBus::SignalInfo
   */
  Glib::RefPtr<Gio::DBus::SignalInfo> wrap(GDBusSignalInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBus::PropertyInfo
   */
  Glib::RefPtr<Gio::DBus::PropertyInfo> wrap(GDBusPropertyInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBus::InterfaceInfo
   */
  Glib::RefPtr<Gio::DBus::InterfaceInfo> wrap(GDBusInterfaceInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBus::NodeInfo
   */
  Glib::RefPtr<Gio::DBus::NodeInfo> wrap(GDBusNodeInfo* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_DBUSINTROSPECTION_H */

