// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/dbusserver.h>
#include <giomm/private/dbusserver_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <giomm/dbusconnection.h>
#include <giomm/dbusauthobserver.h>

namespace Gio
{

//TODO: Uncomment when bug #639478 is resolved.
/*
DBusServer::DBusServer(const std::string& address,
  const std::string& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusServerFlags flags)
  : _CONSTRUCT("address",
    (address.empty() ? static_cast<char*>(0) : address.c_str()),
    "flags", static_cast<GDBusServerFlags>(flags),
    "guid", (guid.empty() ? static_cast<char*>(0) : guid.c_str()),
    "authentication-observer", Glib::unwrap(observer))
{
  init(cancellable);
}

DBusServer::DBusServer(const std::string& address,
  const std::string& guid,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusServerFlags flags)
  : _CONSTRUCT("address",
    (address.empty() ? static_cast<char*>(0) : address.c_str()),
    "flags", static_cast<GDBusServerFlags>(flags),
    "guid", (guid.empty() ? static_cast<char*>(0) : guid.c_str()),
    "authentication-observer", static_cast<GDBusAuthObserver*>(0))
{
  init(cancellable);
}

DBusServer::DBusServer(const std::string& address,
  const std::string& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusServerFlags flags)
  : _CONSTRUCT("address",
    (address.empty() ? static_cast<char*>(0) : address.c_str()),
    "flags", static_cast<GDBusServerFlags>(flags),
    "guid", (guid.empty() ? static_cast<char*>(0) : guid.c_str()),
    "authentication-observer", Glib::unwrap(observer))
{
  init();
}

DBusServer::DBusServer(const std::string& address,
  const std::string& guid,
  DBusServerFlags flags)
  : _CONSTRUCT("address",
    (address.empty() ? static_cast<char*>(0) : address.c_str()),
    "flags", static_cast<GDBusServerFlags>(flags),
    "guid", (guid.empty() ? static_cast<char*>(0) : guid.c_str()),
    "authentication-observer", static_cast<GDBusAuthObserver*>(0))
{
  init();
}
*/

Glib::RefPtr<DBusServer> DBusServer::create_sync(const std::string& address,
  const std::string& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusServerFlags flags)
{
  //TODO: Use the constructor instead of the code underneath when
  //g_dbus_server_new_sync() does not do more than call g_initable_new().
  //https://bugzilla.gnome.org/show_bug.cgi?id=639478
  //return Glib::RefPtr<DBusServer>(new DBusServer(address, guid, observer,
    //cancellable, flags));

  GError* gerror = 0;

  Glib::RefPtr<DBusServer> result =
    Glib::wrap(g_dbus_server_new_sync(address.c_str(),
                                      static_cast<GDBusServerFlags>(flags),
                                      guid.c_str(),
                                      Glib::unwrap(observer),
                                      Glib::unwrap(cancellable),
                                      &gerror));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return result;
}

Glib::RefPtr<DBusServer> DBusServer::create_sync(const std::string& address,
  const std::string& guid,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusServerFlags flags)
{
  //TODO: Use the constructor instead of the code underneath when
  //g_dbus_server_new_sync() does not do more than call g_initable_new().
  //https://bugzilla.gnome.org/show_bug.cgi?id=639478
  //return Glib::RefPtr<DBusServer>(new DBusServer(address, guid,
    //cancellable, flags));

  GError* gerror = 0;

  Glib::RefPtr<DBusServer> result =
    Glib::wrap(g_dbus_server_new_sync(address.c_str(),
                                      static_cast<GDBusServerFlags>(flags),
                                      guid.c_str(), 0,
                                      Glib::unwrap(cancellable),
                                      &gerror));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return result;
}

Glib::RefPtr<DBusServer> DBusServer::create_sync(const std::string& address,
  const std::string& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusServerFlags flags)
{
  //TODO: Use the constructor instead of the code underneath when
  //g_dbus_server_new_sync() does not do more than call g_initable_new().
  //https://bugzilla.gnome.org/show_bug.cgi?id=639478
  //return Glib::RefPtr<DBusServer>(new DBusServer(address, guid, observer,
    //flags));

  GError* gerror = 0;

  Glib::RefPtr<DBusServer> result =
    Glib::wrap(g_dbus_server_new_sync(address.c_str(),
                                      static_cast<GDBusServerFlags>(flags),
                                      guid.c_str(),
                                      Glib::unwrap(observer),
                                      0,
                                      &gerror));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return result;
}

Glib::RefPtr<DBusServer> DBusServer::create_sync(const std::string& address,
  const std::string& guid,
  DBusServerFlags flags)
{
  //TODO: Use the constructor instead of the code underneath when
  //g_dbus_server_new_sync() does not do more than call g_initable_new().
  //https://bugzilla.gnome.org/show_bug.cgi?id=639478
  //return Glib::RefPtr<DBusServer>(new DBusServer(address, guid, flags));

  GError* gerror = 0;

  Glib::RefPtr<DBusServer> result =
    Glib::wrap(g_dbus_server_new_sync(address.c_str(),
                                      static_cast<GDBusServerFlags>(flags),
                                      guid.c_str(), 0, 0, &gerror));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return result;
}

} // namespace Gio

namespace
{


static gboolean DBusServer_signal_new_connection_callback(GDBusServer* self, GDBusConnection* p0,void* data)
{
  using namespace Gio;
  typedef sigc::slot< bool,const Glib::RefPtr<DBusConnection>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static gboolean DBusServer_signal_new_connection_notify_callback(GDBusServer* self, GDBusConnection* p0, void* data)
{
  using namespace Gio;
  typedef sigc::slot< void,const Glib::RefPtr<DBusConnection>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }

  typedef gboolean RType;
  return RType();
}

static const Glib::SignalProxyInfo DBusServer_signal_new_connection_info =
{
  "new-connection",
  (GCallback) &DBusServer_signal_new_connection_callback,
  (GCallback) &DBusServer_signal_new_connection_notify_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::DBusServer> wrap(GDBusServer* object, bool take_copy)
{
  return Glib::RefPtr<Gio::DBusServer>( dynamic_cast<Gio::DBusServer*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& DBusServer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &DBusServer_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_dbus_server_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Initable::add_interface(get_type());

  }

  return *this;
}


void DBusServer_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* DBusServer_Class::wrap_new(GObject* object)
{
  return new DBusServer((GDBusServer*)object);
}


/* The implementation: */

GDBusServer* DBusServer::gobj_copy()
{
  reference();
  return gobj();
}

DBusServer::DBusServer(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

DBusServer::DBusServer(GDBusServer* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


DBusServer::~DBusServer()
{}


DBusServer::CppClassType DBusServer::dbusserver_class_; // initialize static member

GType DBusServer::get_type()
{
  return dbusserver_class_.init().get_type();
}


GType DBusServer::get_base_type()
{
  return g_dbus_server_get_type();
}


void DBusServer::start()
{
g_dbus_server_start(gobj()); 
}

void DBusServer::stop()
{
g_dbus_server_stop(gobj()); 
}

bool DBusServer::is_active() const
{
  return g_dbus_server_is_active(const_cast<GDBusServer*>(gobj()));
}

std::string DBusServer::get_guid() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(g_dbus_server_get_guid(const_cast<GDBusServer*>(gobj())));
}

DBusServerFlags DBusServer::get_flags() const
{
  return ((DBusServerFlags)(g_dbus_server_get_flags(const_cast<GDBusServer*>(gobj()))));
}

std::string DBusServer::get_client_address() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(g_dbus_server_get_client_address(const_cast<GDBusServer*>(gobj())));
}


Glib::SignalProxy1< bool,const Glib::RefPtr<DBusConnection>& > DBusServer::signal_new_connection()
{
  return Glib::SignalProxy1< bool,const Glib::RefPtr<DBusConnection>& >(this, &DBusServer_signal_new_connection_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> DBusServer::property_active() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "active");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<std::string> DBusServer::property_address() const
{
  return Glib::PropertyProxy_ReadOnly<std::string>(this, "address");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DBusAuthObserver> > DBusServer::property_authentication_observer() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DBusAuthObserver> >(this, "authentication-observer");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<std::string> DBusServer::property_client_address() const
{
  return Glib::PropertyProxy_ReadOnly<std::string>(this, "client-address");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<DBusServerFlags> DBusServer::property_flags() const
{
  return Glib::PropertyProxy_ReadOnly<DBusServerFlags>(this, "flags");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<std::string> DBusServer::property_guid() const
{
  return Glib::PropertyProxy_ReadOnly<std::string>(this, "guid");
}
#endif //GLIBMM_PROPERTIES_ENABLED


} // namespace Gio


