// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/dbusconnection.h>
#include <giomm/private/dbusconnection_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <giomm/dbusauthobserver.h>
#include <giomm/dbusintrospection.h>
#include <giomm/dbusmethodinvocation.h>
#include "slot_async.h"

namespace
{

// struct to hold the slots in the DBusInterfaceVTable class.  This is used to
// pass the slots to the callbacks and later destroy them.
struct TypeDBusInterfaceVTableSlots
{
  Gio::DBusInterfaceVTable::SlotInterfaceMethodCall* slot_method_call;
  Gio::DBusInterfaceVTable::SlotInterfaceGetProperty* slot_get_property;
  Gio::DBusInterfaceVTable::SlotInterfaceSetProperty* slot_set_property;
};

extern "C"
{

static void DBusConnection_Signal_giomm_callback(GDBusConnection* connection,
  const char* sender_name, const char* object_path,
  const char* interface_name, const char* signal_name, GVariant* parameters,
  void* user_data)
{
  Gio::DBusConnection::SlotSignal* the_slot =
    static_cast<Gio::DBusConnection::SlotSignal*>(user_data);

  try
  {
    (*the_slot)(Glib::wrap(connection, true), Glib::ustring(sender_name),
      Glib::ustring(object_path), Glib::ustring(interface_name),
      Glib::ustring(signal_name), Glib::VariantBase(parameters, true));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

static void DBusConnection_Signal_giomm_callback_destroy(void* data)
{
  delete static_cast<Gio::DBusConnection::SlotSignal*>(data);
}

static GDBusMessage* DBusConnection_Message_Filter_giomm_callback(
  GDBusConnection* connection, GDBusMessage* message, gboolean incoming,
  void* user_data)
{
  Gio::DBusConnection::SlotMessageFilter* the_slot =
    static_cast<Gio::DBusConnection::SlotMessageFilter*>(user_data);

  try
  {
    Glib::RefPtr<Gio::DBusMessage> result = (*the_slot)(
      Glib::wrap(connection, true), Glib::wrap(message, true),
      static_cast<bool>(incoming));
    return (result) ? result->gobj_copy() : 0;
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return message;
}

static void DBusConnection_Message_Filter_giomm_callback_destroy(void* data)
{
  delete static_cast<Gio::DBusConnection::SlotMessageFilter*>(data);
}

static void DBusInterfaceVTable_MethodCall_giomm_callback(
  GDBusConnection* connection, const char* sender, const char* object_path,
  const char* interface_name, const char* method_name, GVariant* parameters,
  GDBusMethodInvocation* invocation, void* user_data)
{
  TypeDBusInterfaceVTableSlots* the_slots =
    static_cast<TypeDBusInterfaceVTableSlots*>(user_data);

  Gio::DBusInterfaceVTable::SlotInterfaceMethodCall* the_slot =
    the_slots->slot_method_call;

  try
  {
    (*the_slot)(Glib::wrap(connection, true), Glib::ustring(sender),
      Glib::ustring(object_path), Glib::ustring(interface_name),
      Glib::ustring(method_name), Glib::VariantBase(parameters, true),
      Glib::wrap(invocation, true));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

static GVariant* DBusInterfaceVTable_GetProperty_giomm_callback(
  GDBusConnection* connection, const char* sender, const char* object_path,
  const char* interface_name, const char* property_name, GError**,
  void* user_data)
{
  TypeDBusInterfaceVTableSlots* the_slots =
    static_cast<TypeDBusInterfaceVTableSlots*>(user_data);

  Gio::DBusInterfaceVTable::SlotInterfaceGetProperty* the_slot =
    the_slots->slot_get_property;

  try
  {
    Glib::VariantBase result;

    (*the_slot)(result, Glib::wrap(connection, true),
      Glib::ustring(sender), Glib::ustring(object_path),
      Glib::ustring(interface_name), Glib::ustring(property_name));
    return result.gobj_copy();
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 0;
}

static gboolean DBusInterfaceVTable_SetProperty_giomm_callback(
  GDBusConnection* connection, const char* sender, const char* object_path,
  const char* interface_name, const char* property_name, GVariant* value,
  GError**, void* user_data)
{
  TypeDBusInterfaceVTableSlots* the_slots =
    static_cast<TypeDBusInterfaceVTableSlots*>(user_data);

  Gio::DBusInterfaceVTable::SlotInterfaceSetProperty* the_slot =
    the_slots->slot_set_property;

  try
  {
    return static_cast<gboolean>((*the_slot)(Glib::wrap(connection, true),
      Glib::ustring(sender), Glib::ustring(object_path),
      Glib::ustring(interface_name), Glib::ustring(property_name),
      Glib::VariantBase(value, true)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return false;
}

static void DBusInterfaceVTable_giomm_callback_destory(void* data)
{
  TypeDBusInterfaceVTableSlots* the_slots =
    static_cast<TypeDBusInterfaceVTableSlots*>(data);

  delete the_slots->slot_method_call;
  delete the_slots->slot_get_property;
  delete the_slots->slot_set_property;

  delete the_slots;
}

} // extern "C"

}

namespace Gio
{

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init_async(slot, cancellable);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(0), static_cast<char*>(0)))
{
  init_async(slot, cancellable);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init_async(slot);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(0), static_cast<char*>(0)))
{
  init_async(slot);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init_async(slot, cancellable);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(0), static_cast<char*>(0)))
{
  init_async(slot, cancellable);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init_async(slot);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(0), static_cast<char*>(0)))
{
  init_async(slot);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init(cancellable);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(0), static_cast<char*>(0)))
{
  init(cancellable);
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init();
}

DBusConnection::DBusConnection(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "stream",Glib::unwrap(stream),"guid",(guid.empty() ? 0 : guid.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(0), static_cast<char*>(0)))
{
  init();
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init(cancellable);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(0), static_cast<char*>(0)))
{
  init(cancellable);
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",Glib::unwrap(observer), static_cast<char*>(0)))
{
  init();
}

DBusConnection::DBusConnection(const Glib::ustring& address,
  DBusConnectionFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(dbusconnection_class_.init(), "address",(address.empty() ? 0 : address.c_str()),"flags",static_cast<GDBusConnectionFlags>(flags),"authentication-observer",static_cast<GDBusAuthObserver*>(0), static_cast<char*>(0)))
{
  init();
}

//static
void DBusConnection::create(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().

  DBusConnection(stream, guid, observer, slot, cancellable, flags);
}

//static
void DBusConnection::create(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().

  DBusConnection(stream, guid, slot, cancellable, flags);
}

//static
void DBusConnection::create(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  DBusConnection(stream, guid, observer, slot, flags);
}

//static
void DBusConnection::create(const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  DBusConnection(stream, guid, slot, flags);
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::create_sync(
  const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(stream, guid,
    observer, cancellable, flags));
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::create_sync(
  const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(stream, guid,
    cancellable, flags));
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::create_sync(
  const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(stream, guid,
    observer, flags));
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::create_sync(
  const Glib::RefPtr<IOStream>& stream,
  const Glib::ustring& guid,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(stream, guid,
    flags));
}

//static
void DBusConnection::create_for_address(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  DBusConnection(address, observer, slot, cancellable, flags);
}

//static
void DBusConnection::create_for_address(const Glib::ustring& address,
  const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  DBusConnection(address, slot, cancellable, flags);
}

//static
void DBusConnection::create_for_address(const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  DBusConnection(address, observer, slot, flags);
}

//static
void DBusConnection::create_for_address(const Glib::ustring& address,
  const SlotAsyncReady& slot,
  DBusConnectionFlags flags)
{
  // Note that this does not return anything, because it is async - see
  // create_finish().
  DBusConnection(address, slot, flags);
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::create_for_address_sync(
  const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(address, observer,
    cancellable, flags));
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::create_for_address_sync(
  const Glib::ustring& address,
  const Glib::RefPtr<Cancellable>& cancellable,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(address, cancellable,
    flags));
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::create_for_address_sync(
  const Glib::ustring& address,
  const Glib::RefPtr<DBusAuthObserver>& observer,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(address, observer,
    flags));
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::create_for_address_sync(
  const Glib::ustring& address,
  DBusConnectionFlags flags)
{
  return Glib::RefPtr<DBusConnection>(new DBusConnection(address, flags));
}

//static
void DBusConnection::get(BusType bus_type, const SlotAsyncReady& slot,
  const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_bus_get(static_cast<GBusType>(bus_type), Glib::unwrap(cancellable),
    &SignalProxy_async_callback, slot_copy);
}

//static
void DBusConnection::get(BusType bus_type, const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_bus_get(static_cast<GBusType>(bus_type), 0, &SignalProxy_async_callback,
    slot_copy);
}

//static
Glib::RefPtr<DBusConnection> DBusConnection::get_sync(BusType bus_type)
{
  GError* gerror = 0;

  GDBusConnection* result = g_bus_get_sync(static_cast<GBusType>(bus_type),
    0, & gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return Glib::wrap(result);
}

void DBusConnection::close()
{
  g_dbus_connection_close(gobj(), 0, 0, 0);
}

void DBusConnection::close(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_close(gobj(),
                    Glib::unwrap(cancellable),
                    &SignalProxy_async_callback,
                    slot_copy);
}

void DBusConnection::close(const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_close(gobj(),
                    0,
                    &SignalProxy_async_callback,
                    slot_copy);
}

void DBusConnection::close_sync()
{
  GError* gerror = 0;
  g_dbus_connection_close_sync(gobj(), 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void DBusConnection::flush()
{
  g_dbus_connection_flush(gobj(), 0, 0, 0);
}

void DBusConnection::flush(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_flush(gobj(),
                    Glib::unwrap(cancellable),
                    &SignalProxy_async_callback,
                    slot_copy);
}

void DBusConnection::flush(const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_flush(gobj(),
                    0,
                    &SignalProxy_async_callback,
                    slot_copy);
}

void DBusConnection::flush_sync()
{
  GError* gerror = 0;
  g_dbus_connection_flush_sync(gobj(), 0, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void DBusConnection::send_message_with_reply(const Glib::RefPtr<DBusMessage>& message, int timeout_msec,const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);
  volatile guint32 out_serial = 0;
  g_dbus_connection_send_message_with_reply(gobj(), Glib::unwrap(message),
                                      static_cast<GDBusSendMessageFlags>(message->get_flags()),
                                      timeout_msec, &out_serial,
                                      Glib::unwrap(cancellable), &SignalProxy_async_callback,
                                      slot_copy);
  message->set_serial(out_serial);
}

void DBusConnection::send_message_with_reply(const Glib::RefPtr<DBusMessage>& message, int timeout_msec,const SlotAsyncReady& slot)
{
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);
  volatile guint32 out_serial = 0;
  g_dbus_connection_send_message_with_reply(gobj(), Glib::unwrap(message),
                                      static_cast<GDBusSendMessageFlags>(message->get_flags()),
                                      timeout_msec, &out_serial,
                                      0, &SignalProxy_async_callback,
                                      slot_copy);
  message->set_serial(out_serial);
}

Glib::RefPtr<DBusMessage> DBusConnection::send_message_with_reply_sync(
  const Glib::RefPtr<DBusMessage>& message,
  const Glib::RefPtr<Cancellable>& cancellable,
  gint timeout_msec
)
{
  volatile guint32 out_serial = 0;
  GError* gerror = 0;

  GDBusMessage* result =
    g_dbus_connection_send_message_with_reply_sync(gobj(),
    Glib::unwrap(message),
    static_cast<GDBusSendMessageFlags>(message->get_flags()),
    timeout_msec, &out_serial, Glib::unwrap(cancellable), &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  message->set_serial(out_serial);
  return Glib::wrap(result);
}

Glib::RefPtr<DBusMessage> DBusConnection::send_message_with_reply_sync(
  const Glib::RefPtr<DBusMessage>& message,
  gint timeout_msec
)
{
  volatile guint32 out_serial = 0;
  GError* gerror = 0;

  GDBusMessage* result =
    g_dbus_connection_send_message_with_reply_sync(gobj(),
    Glib::unwrap(message),
    static_cast<GDBusSendMessageFlags>(message->get_flags()), timeout_msec,
    &out_serial, 0, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  message->set_serial(out_serial);
  return Glib::wrap(result);
}

void DBusConnection::call(
  const Glib::ustring&                  object_path,
  const Glib::ustring&                  interface_name,
  const Glib::ustring&                  method_name,
  const SlotAsyncReady&                 slot,
  const Glib::RefPtr<Cancellable>&      cancellable,
  int                                   timeout_msec,
  const Glib::ustring&                  bus_name,
  DBusCallFlags                         flags,
  const Glib::VariantBase&              parameters,
  const Glib::VariantType&              reply_type
)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_call(gobj(), bus_name.c_str(), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(),
    static_cast<GDBusCallFlags>(flags), timeout_msec,
    Glib::unwrap(cancellable), &SignalProxy_async_callback, slot_copy);
}

// Non-cancellable version.
void DBusConnection::call(
  const Glib::ustring&                  object_path,
  const Glib::ustring&                  interface_name,
  const Glib::ustring&                  method_name,
  const SlotAsyncReady&                 slot,
  int                                   timeout_msec,
  const Glib::ustring&                  bus_name,
  DBusCallFlags                         flags,
  const Glib::VariantBase&              parameters,
  const Glib::VariantType&              reply_type
)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_dbus_connection_call(gobj(), bus_name.c_str(), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(),
    static_cast<GDBusCallFlags>(flags), timeout_msec, 0,
    &SignalProxy_async_callback, slot_copy);
}

void DBusConnection::call_finish(
  Glib::VariantBase&                    output,
  const Glib::RefPtr<AsyncResult>&      res
)
{
  GError* gerror = 0;
  GVariant* const gvariant =
    g_dbus_connection_call_finish(gobj(), Glib::unwrap(res), &gerror);
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  output.init(gvariant); // No need for extra ref.
}

void DBusConnection::call_sync(
  Glib::VariantBase&                    output,
  const Glib::ustring&                  object_path,
  const Glib::ustring&                  interface_name,
  const Glib::ustring&                  method_name,
  const Glib::RefPtr<Cancellable>&      cancellable,
  int                                   timeout_msec,
  const Glib::ustring&                  bus_name,
  DBusCallFlags                         flags,
  const Glib::VariantBase&              parameters,
  const Glib::VariantType&              reply_type
)
{
  GError* gerror = 0;

  GVariant* const gvariant =
    g_dbus_connection_call_sync(gobj(), bus_name.c_str(), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(),
    static_cast<GDBusCallFlags>(flags), timeout_msec,
    Glib::unwrap(cancellable), &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  output.init(gvariant); // No need to take extra reference.
}

// Non-cancellable version.
void DBusConnection::call_sync(
  Glib::VariantBase&                    output,
  const Glib::ustring&                  object_path,
  const Glib::ustring&                  interface_name,
  const Glib::ustring&                  method_name,
  int                                   timeout_msec,
  const Glib::ustring&                  bus_name,
  DBusCallFlags                         flags,
  const Glib::VariantBase&              parameters,
  const Glib::VariantType&              reply_type
)
{
  GError* gerror = 0;

  GVariant* const gvariant =
    g_dbus_connection_call_sync(gobj(), bus_name.c_str(), object_path.c_str(),
    interface_name.c_str(), method_name.c_str(),
    const_cast<GVariant*>(parameters.gobj()), reply_type.gobj(),
    static_cast<GDBusCallFlags>(flags), timeout_msec, 0, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  output.init(gvariant); // No need to take extra reference.
}

void DBusConnection::emit_signal(
  const Glib::ustring&                object_path,
  const Glib::ustring&                interface_name,
  const Glib::ustring&                signal_name,
  const Glib::ustring&                destination_bus_name,
  const Glib::VariantBase&            parameters
)
{
  GError* gerror = 0;

  g_dbus_connection_emit_signal(gobj(),
    destination_bus_name.c_str(), object_path.c_str(), interface_name.c_str(),
    signal_name.c_str(), const_cast<GVariant*>(parameters.gobj()), &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

guint DBusConnection::signal_subscribe(
  const SlotSignal& slot,
  const Glib::ustring& sender,
  const Glib::ustring& interface_name,
  const Glib::ustring& member,
  const Glib::ustring& object_path,
  const Glib::ustring& arg0,
  DBusSignalFlags flags
)
{
  SlotSignal* slot_copy = new SlotSignal(slot);

  return g_dbus_connection_signal_subscribe(gobj(), sender.c_str(),
    interface_name.c_str(), member.c_str(), object_path.c_str(), arg0.c_str(),
    static_cast<GDBusSignalFlags>(flags), 
    &DBusConnection_Signal_giomm_callback, slot_copy,
    &DBusConnection_Signal_giomm_callback_destroy);
}

guint DBusConnection::add_filter(const SlotMessageFilter& slot)
{
  SlotMessageFilter* slot_copy = new SlotMessageFilter(slot);

  return g_dbus_connection_add_filter(gobj(),
    &DBusConnection_Message_Filter_giomm_callback, slot_copy,
    DBusConnection_Message_Filter_giomm_callback_destroy);
}

guint DBusConnection::register_object(const Glib::ustring& object_path,
  const Glib::RefPtr<DBusInterfaceInfo>& interface_info,
  const DBusInterfaceVTable& vtable)
{
  TypeDBusInterfaceVTableSlots* the_slots = new TypeDBusInterfaceVTableSlots();

  the_slots->slot_method_call = vtable.get_slot_method_call();
  the_slots->slot_get_property = vtable.get_slot_get_property();
  the_slots->slot_set_property = vtable.get_slot_set_property();

  GError* gerror = 0;

  guint const result = g_dbus_connection_register_object(gobj(),
    object_path.c_str(), Glib::unwrap(interface_info),
    reinterpret_cast<GDBusInterfaceVTable*>(const_cast<DBusInterfaceVTable*>(&vtable)),
    the_slots, &DBusInterfaceVTable_giomm_callback_destory, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  const_cast<DBusInterfaceVTable&>(vtable).signal_slots_registered();

  return result;
}

DBusInterfaceVTable::DBusInterfaceVTable(
  const SlotInterfaceMethodCall& slot_method_call,
  const SlotInterfaceGetProperty& slot_get_property,
  const SlotInterfaceSetProperty& slot_set_property
)
: slot_method_call(new SlotInterfaceMethodCall(slot_method_call)),
  slot_get_property(new SlotInterfaceGetProperty(slot_get_property)),
  slot_set_property(new SlotInterfaceSetProperty(slot_set_property)),
  slots_registered(false)
{
  gobject_.method_call = &DBusInterfaceVTable_MethodCall_giomm_callback;
  gobject_.get_property = &DBusInterfaceVTable_GetProperty_giomm_callback;
  gobject_.set_property = &DBusInterfaceVTable_SetProperty_giomm_callback;
}

DBusInterfaceVTable::~DBusInterfaceVTable()
{
  if(!slots_registered)
  {
    delete slot_method_call;
    delete slot_get_property;
    delete slot_set_property;
  }
}

DBusInterfaceVTable::SlotInterfaceMethodCall*
  DBusInterfaceVTable::get_slot_method_call() const
{
  return slot_method_call;
}

DBusInterfaceVTable::SlotInterfaceGetProperty*
  DBusInterfaceVTable::get_slot_get_property() const
{
  return slot_get_property;
}

DBusInterfaceVTable::SlotInterfaceSetProperty*
  DBusInterfaceVTable::get_slot_set_property() const
{
  return slot_set_property;
}

void DBusInterfaceVTable::signal_slots_registered()
{
  slots_registered = true;
}

} // namespace Gio

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gio::BusType>::value_type()
{
  return g_bus_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Gio::DBusConnection> wrap(GDBusConnection* object, bool take_copy)
{
  return Glib::RefPtr<Gio::DBusConnection>( dynamic_cast<Gio::DBusConnection*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& DBusConnection_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &DBusConnection_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_dbus_connection_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Initable::add_interface(get_type());
  AsyncInitable::add_interface(get_type());

  }

  return *this;
}


void DBusConnection_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* DBusConnection_Class::wrap_new(GObject* object)
{
  return new DBusConnection((GDBusConnection*)object);
}


/* The implementation: */

GDBusConnection* DBusConnection::gobj_copy()
{
  reference();
  return gobj();
}

DBusConnection::DBusConnection(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

DBusConnection::DBusConnection(GDBusConnection* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


DBusConnection::~DBusConnection()
{}


DBusConnection::CppClassType DBusConnection::dbusconnection_class_; // initialize static member

GType DBusConnection::get_type()
{
  return dbusconnection_class_.init().get_type();
}


GType DBusConnection::get_base_type()
{
  return g_dbus_connection_get_type();
}


Glib::RefPtr<DBusConnection> DBusConnection::get_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusConnection> retvalue = Glib::wrap(g_bus_get_finish(Glib::unwrap(res), &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


Glib::RefPtr<DBusConnection> DBusConnection::get_sync(BusType bus_type, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusConnection> retvalue = Glib::wrap(g_bus_get_sync(((GBusType)(bus_type)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


Glib::RefPtr<DBusConnection> DBusConnection::create_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusConnection> retvalue = Glib::wrap(g_dbus_connection_new_finish(Glib::unwrap(res), &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


Glib::RefPtr<DBusConnection> DBusConnection::create_for_address_finish(const Glib::RefPtr<AsyncResult>& res)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusConnection> retvalue = Glib::wrap(g_dbus_connection_new_for_address_finish(Glib::unwrap(res), &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


bool DBusConnection::close_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = 0;
  bool retvalue = g_dbus_connection_close_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void DBusConnection::close_sync(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  g_dbus_connection_close_sync(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);


}

bool DBusConnection::flush_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = 0;
  bool retvalue = g_dbus_connection_flush_finish(gobj(), Glib::unwrap(result), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void DBusConnection::flush_sync(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = 0;
  g_dbus_connection_flush_sync(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);


}

bool DBusConnection::get_exit_on_close() const
{
  return g_dbus_connection_get_exit_on_close(const_cast<GDBusConnection*>(gobj()));
}

void DBusConnection::set_exit_on_close(bool exit_on_close)
{
g_dbus_connection_set_exit_on_close(gobj(), static_cast<int>(exit_on_close)); 
}

bool DBusConnection::send_message(const Glib::RefPtr<DBusMessage>& message, DBusSendMessageFlags flags, guint32* out_serial)
{
  GError* gerror = 0;
  bool retvalue = g_dbus_connection_send_message(gobj(), Glib::unwrap(message), ((GDBusSendMessageFlags)(flags)), (out_serial), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::RefPtr<DBusMessage> DBusConnection::send_message_with_reply_finish(const Glib::RefPtr<AsyncResult>& result)
{
  GError* gerror = 0;
  Glib::RefPtr<DBusMessage> retvalue = Glib::wrap(g_dbus_connection_send_message_with_reply_finish(gobj(), Glib::unwrap(result), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

void DBusConnection::start_message_processing()
{
g_dbus_connection_start_message_processing(gobj()); 
}

bool DBusConnection::is_closed() const
{
  return g_dbus_connection_is_closed(const_cast<GDBusConnection*>(gobj()));
}

Glib::RefPtr<IOStream> DBusConnection::get_stream()
{

  Glib::RefPtr<IOStream> retvalue = Glib::wrap(g_dbus_connection_get_stream(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const IOStream> DBusConnection::get_stream() const
{
  return const_cast<DBusConnection*>(this)->get_stream();
}

Glib::ustring DBusConnection::get_guid() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(g_dbus_connection_get_guid(const_cast<GDBusConnection*>(gobj())));
}

Glib::ustring DBusConnection::get_unique_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(g_dbus_connection_get_unique_name(const_cast<GDBusConnection*>(gobj())));
}

DBusCapabilityFlags DBusConnection::get_capabilities() const
{
  return ((DBusCapabilityFlags)(g_dbus_connection_get_capabilities(const_cast<GDBusConnection*>(gobj()))));
}

Glib::RefPtr<Credentials> DBusConnection::get_peer_credentials()
{

  Glib::RefPtr<Credentials> retvalue = Glib::wrap(g_dbus_connection_get_peer_credentials(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Credentials> DBusConnection::get_peer_credentials() const
{
  return const_cast<DBusConnection*>(this)->get_peer_credentials();
}

void DBusConnection::signal_unsubscribe(guint subscription_id)
{
g_dbus_connection_signal_unsubscribe(gobj(), subscription_id); 
}

void DBusConnection::remove_filter(guint filter_id)
{
g_dbus_connection_remove_filter(gobj(), filter_id); 
}

bool DBusConnection::unregister_object(guint registration_id)
{
  return g_dbus_connection_unregister_object(gobj(), registration_id);
}


} // namespace Gio


namespace Gio
{


} // namespace Gio


