// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GLIBMM_REGEX_H
#define _GLIBMM_REGEX_H


/* Copyright (C) 2007 The glibmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmmconfig.h>
#include <glibmm/refptr.h>
#include <glibmm/ustring.h>
#include <glibmm/error.h>
#include <glibmm/arrayhandle.h>
#include <glib.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GRegex GRegex;
#endif

namespace Glib
{

/** @addtogroup glibmmEnums glibmm Enums and Flags */

/**
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%RegexCompileFlags operator|(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator&(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator^(RegexCompileFlags, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags operator~(RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator|=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator&=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 * <tt>%RegexCompileFlags& operator^=(RegexCompileFlags&, RegexCompileFlags)</tt><br>
 */
enum RegexCompileFlags
{
  REGEX_CASELESS = 1 << 0,
  REGEX_MULTILINE = 1 << 1,
  REGEX_DOTALL = 1 << 2,
  REGEX_EXTENDED = 1 << 3,
  REGEX_ANCHORED = 1 << 4,
  REGEX_DOLLAR_ENDONLY = 1 << 5,
  REGEX_UNGREEDY = 1 << 9,
  REGEX_RAW = 1 << 11,
  REGEX_NO_AUTO_CAPTURE = 1 << 12,
  REGEX_OPTIMIZE = 1 << 13,
  REGEX_DUPNAMES = 1 << 19,
  REGEX_NEWLINE_CR = 1 << 20,
  REGEX_NEWLINE_LF = 1 << 21,
  REGEX_NEWLINE_CRLF = 0x300000
};

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator|(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator&(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator^(RegexCompileFlags lhs, RegexCompileFlags rhs)
  { return static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags operator~(RegexCompileFlags flags)
  { return static_cast<RegexCompileFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator|=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator&=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexCompileFlags& operator^=(RegexCompileFlags& lhs, RegexCompileFlags rhs)
  { return (lhs = static_cast<RegexCompileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%RegexMatchFlags operator|(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator&(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator^(RegexMatchFlags, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags operator~(RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator|=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator&=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 * <tt>%RegexMatchFlags& operator^=(RegexMatchFlags&, RegexMatchFlags)</tt><br>
 */
enum RegexMatchFlags
{
  REGEX_MATCH_ANCHORED = 1 << 4,
  REGEX_MATCH_NOTBOL = 1 << 7,
  REGEX_MATCH_NOTEOL = 1 << 8,
  REGEX_MATCH_NOTEMPTY = 1 << 10,
  REGEX_MATCH_PARTIAL = 1 << 15,
  REGEX_MATCH_NEWLINE_CR = 1 << 20,
  REGEX_MATCH_NEWLINE_LF = 1 << 21,
  REGEX_MATCH_NEWLINE_CRLF = 0x300000,
  REGEX_MATCH_NEWLINE_ANY = 1 << 22
};

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator|(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator&(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator^(RegexMatchFlags lhs, RegexMatchFlags rhs)
  { return static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags operator~(RegexMatchFlags flags)
  { return static_cast<RegexMatchFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator|=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator&=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline RegexMatchFlags& operator^=(RegexMatchFlags& lhs, RegexMatchFlags rhs)
  { return (lhs = static_cast<RegexMatchFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** Exception class for Regex
 */
class RegexError : public Glib::Error
{
public:
  enum Code
  {
    COMPILE = 0,
    OPTIMIZE = 1,
    REPLACE = 2,
    MATCH = 3,
    INTERNAL = 4,
    STRAY_BACKSLASH = 101,
    MISSING_CONTROL_CHAR = 102,
    UNRECOGNIZED_ESCAPE = 103,
    QUANTIFIERS_OUT_OF_ORDER = 104,
    QUANTIFIER_TOO_BIG = 105,
    UNTERMINATED_CHARACTER_CLASS = 106,
    INVALID_ESCAPE_IN_CHARACTER_CLASS = 107,
    RANGE_OUT_OF_ORDER = 108,
    NOTHING_TO_REPEAT = 109,
    UNRECOGNIZED_CHARACTER = 112,
    POSIX_NAMED_CLASS_OUTSIDE_CLASS = 113,
    UNMATCHED_PARENTHESIS = 114,
    INEXISTENT_SUBPATTERN_REFERENCE = 115,
    UNTERMINATED_COMMENT = 118,
    EXPRESSION_TOO_LARGE = 120,
    MEMORY_ERROR = 121,
    VARIABLE_LENGTH_LOOKBEHIND = 125,
    MALFORMED_CONDITION = 126,
    TOO_MANY_CONDITIONAL_BRANCHES = 127,
    ASSERTION_EXPECTED = 128,
    UNKNOWN_POSIX_CLASS_NAME = 130,
    POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED = 131,
    HEX_CODE_TOO_LARGE = 134,
    INVALID_CONDITION = 135,
    SINGLE_BYTE_MATCH_IN_LOOKBEHIND = 136,
    INFINITE_LOOP = 140,
    MISSING_SUBPATTERN_NAME_TERMINATOR = 142,
    DUPLICATE_SUBPATTERN_NAME = 143,
    MALFORMED_PROPERTY = 146,
    UNKNOWN_PROPERTY = 147,
    SUBPATTERN_NAME_TOO_LONG = 148,
    TOO_MANY_SUBPATTERNS = 149,
    INVALID_OCTAL_VALUE = 151,
    TOO_MANY_BRANCHES_IN_DEFINE = 154,
    DEFINE_REPETION = 155,
    INCONSISTENT_NEWLINE_OPTIONS = 156,
    MISSING_BACK_REFERENCE = 157
  };

  RegexError(Code error_code, const Glib::ustring& error_message);
  explicit RegexError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()
#endif //DOXYGEN_SHOULD_SKIP_THIS
};


/** Perl-compatible regular expressions - matches strings against regular expressions.
 *
 * The Glib::Regex functions implement regular expression pattern matching using 
 * syntax and semantics similar to Perl regular expression.
 *
 * Some functions accept a start_position argument, setting it differs from just 
 * passing over a shortened string and setting REGEX_MATCH_NOTBOL in the case 
 * of a pattern that begins with any kind of lookbehind assertion. For example, 
 * consider the pattern "\Biss\B" which finds occurrences of "iss" in the middle 
 * of words. ("\B" matches only if the current position in the subject is not a 
 * word boundary.) When applied to the string "Mississipi" from the fourth byte, 
 * namely "issipi", it does not match, because "\B" is always false at the 
 * start of the subject, which is deemed to be a word boundary. However, if 
 * the entire string is passed , but with start_position set to 4, it finds the 
 * second occurrence of "iss" because it is able to look behind the starting point
 * to discover that it is preceded by a letter.
 *
 * Note that, unless you set the REGEX_RAW flag, all the strings passed to these 
 * functions must be encoded in UTF-8. The lengths and the positions inside the
 *  strings are in bytes and not in characters, so, for instance, 
 * "\xc3\xa0" (i.e. "à") is two bytes long but it is treated as a single 
 * character. If you set REGEX_RAW the strings can be non-valid UTF-8 strings
 * and a byte is treated as a character, so "\xc3\xa0" is two bytes and 
 * two characters long.
 *
 * When matching a pattern, "\n" matches only against a "\n" character in the 
 * string, and "\r" matches only a "\r" character. To match any newline sequence 
 * use "\R". This particular group matches either the two-character sequence 
 * CR + LF ("\r\n"), or one of the single characters LF (linefeed, U+000A, "\n"),
 *  VT (vertical tab, U+000B, "\v"), FF (formfeed, U+000C, "\f"), CR (carriage 
 * return, U+000D, "\r"), NEL (next line, U+0085), LS (line separator, U+2028), 
 * or PS (paragraph separator, U+2029).
 *
 * The behaviour of the dot, circumflex, and dollar metacharacters are affected 
 * by newline characters, the default is to recognize any newline character (the
 * same characters recognized by "\R"). This can be changed with REGEX_NEWLINE_CR,
 * REGEX_NEWLINE_LF and REGEX_NEWLINE_CRLF compile options, and with 
 * REGEX_MATCH_NEWLINE_ANY, REGEX_MATCH_NEWLINE_CR, REGEX_MATCH_NEWLINE_LF 
 * and REGEX_MATCH_NEWLINE_CRLF match options. These settings are also 
 * relevant when compiling a pattern if REGEX_EXTENDED is set, and an unescaped
 * "#" outside a character class is encountered. This indicates a comment that 
 * lasts until after the next newline.
 *
 * Creating and manipulating the same Glib::Regex class from different threads is 
 * not a problem as Glib::Regex does not modify its internal state between creation and 
 * destruction, on the other hand Glib::MatchInfo is not threadsafe.
 *
 * The regular expressions low level functionalities are obtained through the 
 * excellent PCRE library written by Philip Hazel. 
 *
 * @newin{2,14}
 */
class Regex
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Regex CppObjectType;
  typedef GRegex BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GRegex*       gobj();

  ///Provides access to the underlying C instance.
  const GRegex* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GRegex* gobj_copy() const;

protected:
  // Do not derive this.  Glib::Regex can neither be constructed nor deleted.
  Regex();
  void operator delete(void*, size_t);

private:
  // noncopyable
  Regex(const Regex&);
  Regex& operator=(const Regex&);


public:

  static Glib::RefPtr<Glib::Regex> create(const Glib::ustring& pattern, RegexCompileFlags compile_options = static_cast<RegexCompileFlags>(0), RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));
  
  
  /** Gets the pattern string associated with @a regex, i.e.\ a copy of
   * the string passed to g_regex_new().
   * 
   * @newin{2,14}
   * @return The pattern of @a regex.
   */
  Glib::ustring get_pattern() const;
  
  /** Returns the number of the highest back reference
   * in the pattern, or 0 if the pattern does not contain
   * back references.
   * 
   * @newin{2,14}
   * @return The number of the highest back reference.
   */
  int get_max_backref() const;
  
  /** Returns the number of capturing subpatterns in the pattern.
   * 
   * @newin{2,14}
   * @return The number of capturing subpatterns.
   */
  int get_capture_count() const;
  
  /** Retrieves the number of the subexpression named @a name.
   * 
   * @newin{2,14}
   * @param name Name of the subexpression.
   * @return The number of the subexpression or -1 if @a name
   * does not exists.
   */
  int get_string_number(const Glib::ustring& name) const;
  
  /** Returns the compile options that @a regex was created with.
   * 
   * @newin{2,26}
   * @return Flags from RegexCompileFlags.
   */
  RegexCompileFlags get_compile_flags() const;
  
  /** Returns the match options that @a regex was created with.
   * 
   * @newin{2,26}
   * @return Flags from RegexMatchFlags.
   */
  RegexMatchFlags get_match_flags() const;

  static Glib::ustring escape_string(const Glib::ustring& string);

  
  /** Scans for a match in @a string for @a pattern.
   * 
   * This function is equivalent to g_regex_match() but it does not
   * require to compile the pattern with g_regex_new(), avoiding some
   * lines of code when you need just to do a match without extracting
   * substrings, capture counts, and so on.
   * 
   * If this function is to be called on the same @a pattern more than
   * once, it's more efficient to compile the pattern once with
   * g_regex_new() and then use g_regex_match().
   * 
   * @newin{2,14}
   * @param pattern The regular expression.
   * @param string The string to scan for matches.
   * @param compile_options Compile options for the regular expression, or 0.
   * @param match_options Match options, or 0.
   * @return <tt>true</tt> if the string matched, <tt>false</tt> otherwise.
   */
  static bool match_simple(const Glib::ustring& pattern, const Glib::ustring& string, RegexCompileFlags compile_options = static_cast<RegexCompileFlags>(0), RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));

  //TODO: _WRAP_METHOD(bool match(const Glib::ustring& string, RegexMatchFlags match_options = (RegexMatchFlags)0, GMatchInfo **match_info = 0), g_regex_match)
  bool match(const Glib::ustring& string, RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));

  //TODO: Wrap GMatchInfo as an iterator:
  //_WRAP_METHOD(bool match_full(const gchar* string, gssize string_len, int start_position, RegexMatchFlags match_options = (RegexMatchFlags)0, GMatchInfo** match_info = 0), g_regex_match_full, errthrow)

  bool match(const Glib::ustring& string, int start_position, RegexMatchFlags match_options);

  bool match(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options);

  //TODO: _WRAP_METHOD(bool match_all(const Glib::ustring& string, RegexMatchFlags match_options = (RegexMatchFlags)0, GMatchInfo ** match_info = 0), g_regex_match_all)
  bool match_all(const Glib::ustring& string, RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));

  //TODO: _WRAP_METHOD(bool match_all_full(const gchar* string, gssize string_len, int start_position, RegexMatchFlags match_options = (RegexMatchFlags)0, GMatchInfo** match_info = 0), g_regex_match_all_full, errthrow)

  bool match_all(const Glib::ustring& string, int start_position, RegexMatchFlags match_options);

  bool match_all(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options);

 
  /** Breaks the string on the pattern, and returns an array of
   * the tokens. If the pattern contains capturing parentheses,
   * then the text for each of the substrings will also be returned.
   * If the pattern does not match anywhere in the string, then the
   * whole string is returned as the first token.
   * 
   * This function is equivalent to g_regex_split() but it does
   * not require to compile the pattern with g_regex_new(), avoiding
   * some lines of code when you need just to do a split without
   * extracting substrings, capture counts, and so on.
   * 
   * If this function is to be called on the same @a pattern more than
   * once, it's more efficient to compile the pattern once with
   * g_regex_new() and then use g_regex_split().
   * 
   * As a special case, the result of splitting the empty string ""
   * is an empty vector, not a vector containing a single string.
   * The reason for this special case is that being able to represent
   * a empty vector is typically more useful than consistent handling
   * of empty elements. If you do need to represent empty elements,
   * you'll need to check for the empty string before calling this
   * function.
   * 
   * A pattern that can match empty strings splits @a string into
   * separate characters wherever it matches the empty string between
   * characters. For example splitting "ab c" using as a separator
   * "\s*", you will get "a", "b" and "c".
   * 
   * @newin{2,14}
   * @param pattern The regular expression.
   * @param string The string to scan for matches.
   * @param compile_options Compile options for the regular expression, or 0.
   * @param match_options Match options, or 0.
   * @return A <tt>0</tt>-terminated array of strings. Free it using g_strfreev().
   */
  static Glib::StringArrayHandle split_simple(const Glib::ustring& pattern, const Glib::ustring& string, RegexCompileFlags compile_options = static_cast<RegexCompileFlags>(0), RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));
  
  /** Breaks the string on the pattern, and returns an array of the tokens.
   * If the pattern contains capturing parentheses, then the text for each
   * of the substrings will also be returned. If the pattern does not match
   * anywhere in the string, then the whole string is returned as the first
   * token.
   * 
   * As a special case, the result of splitting the empty string "" is an
   * empty vector, not a vector containing a single string. The reason for
   * this special case is that being able to represent a empty vector is
   * typically more useful than consistent handling of empty elements. If
   * you do need to represent empty elements, you'll need to check for the
   * empty string before calling this function.
   * 
   * A pattern that can match empty strings splits @a string into separate
   * characters wherever it matches the empty string between characters.
   * For example splitting "ab c" using as a separator "\s*", you will get
   * "a", "b" and "c".
   * 
   * @newin{2,14}
   * @param string The string to split with the pattern.
   * @param match_options Match time option flags.
   * @return A <tt>0</tt>-terminated gchar ** array. Free it using g_strfreev().
   */
  Glib::StringArrayHandle split(const Glib::ustring& string, RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));

  
  /** Breaks the string on the pattern, and returns an array of the tokens.
   * If the pattern contains capturing parentheses, then the text for each
   * of the substrings will also be returned. If the pattern does not match
   * anywhere in the string, then the whole string is returned as the first
   * token.
   * 
   * As a special case, the result of splitting the empty string "" is an
   * empty vector, not a vector containing a single string. The reason for
   * this special case is that being able to represent a empty vector is
   * typically more useful than consistent handling of empty elements. If
   * you do need to represent empty elements, you'll need to check for the
   * empty string before calling this function.
   * 
   * A pattern that can match empty strings splits @a string into separate
   * characters wherever it matches the empty string between characters.
   * For example splitting "ab c" using as a separator "\s*", you will get
   * "a", "b" and "c".
   * 
   * Setting @a start_position differs from just passing over a shortened
   * string and setting REGEX_MATCH_NOTBOL in the case of a pattern
   * that begins with any kind of lookbehind assertion, such as "\b".
   * 
   * @newin{2,14}
   * @param string The string to split with the pattern.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param match_options Match time option flags.
   * @param max_tokens The maximum number of tokens to split @a string into.
   * If this is less than 1, the string is split completely.
   * @return A <tt>0</tt>-terminated gchar ** array. Free it using g_strfreev().
   */
  Glib::StringArrayHandle split(const gchar* string, gssize string_len, int start_position, RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0), int max_tokens = 0) const;

  Glib::StringArrayHandle split(const Glib::ustring& string, int start_position, RegexMatchFlags match_options, int max_tokens) const;

  
  /** Replaces all occurrences of the pattern in @a regex with the
   * replacement text. Backreferences of the form '\number' or
   * '\g<number>' in the replacement text are interpolated by the
   * number-th captured subexpression of the match, '\g<name>' refers
   * to the captured subexpression with the given name. '\0' refers to the
   * complete match, but '\0' followed by a number is the octal representation
   * of a character. To include a literal '\' in the replacement, write '\\'.
   * There are also escapes that changes the case of the following text:
   * 
   * <variablelist>
   * <varlistentry><term>\l</term>
   * <listitem>
   * Convert to lower case the next character
   * </listitem>
   * </varlistentry>
   * <varlistentry><term>\u</term>
   * <listitem>
   * Convert to upper case the next character
   * </listitem>
   * </varlistentry>
   * <varlistentry><term>\L</term>
   * <listitem>
   * Convert to lower case till \E
   * </listitem>
   * </varlistentry>
   * <varlistentry><term>\U</term>
   * <listitem>
   * Convert to upper case till \E
   * </listitem>
   * </varlistentry>
   * <varlistentry><term>\E</term>
   * <listitem>
   * End case modification
   * </listitem>
   * </varlistentry>
   * </variablelist>
   * 
   * If you do not need to use backreferences use g_regex_replace_literal().
   * 
   * The @a replacement string must be UTF-8 encoded even if REGEX_RAW was
   * passed to g_regex_new(). If you want to use not UTF-8 encoded stings
   * you can use g_regex_replace_literal().
   * 
   * Setting @a start_position differs from just passing over a shortened
   * string and setting REGEX_MATCH_NOTBOL in the case of a pattern that
   * begins with any kind of lookbehind assertion, such as "\b".
   * 
   * @newin{2,14}
   * @param string The string to perform matches against.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param replacement Text to replace each match with.
   * @param match_options Options for the match.
   * @return A newly allocated string containing the replacements.
   */
  Glib::ustring replace(const gchar* string, gssize string_len, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));
  Glib::ustring replace(const Glib::ustring& string, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options);

  
  /** Replaces all occurrences of the pattern in @a regex with the
   * replacement text. @a replacement is replaced literally, to
   * include backreferences use g_regex_replace().
   * 
   * Setting @a start_position differs from just passing over a
   * shortened string and setting REGEX_MATCH_NOTBOL in the
   * case of a pattern that begins with any kind of lookbehind
   * assertion, such as "\b".
   * 
   * @newin{2,14}
   * @param string The string to perform matches against.
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param replacement Text to replace each match with.
   * @param match_options Options for the match.
   * @return A newly allocated string containing the replacements.
   */
  Glib::ustring replace_literal(const gchar *string, gssize string_len, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options = static_cast<RegexMatchFlags>(0));
  Glib::ustring replace_literal(const Glib::ustring& string, int start_position, const Glib::ustring& replacement, RegexMatchFlags match_options);

  
  /** Replaces occurrences of the pattern in regex with the output of
   *  @a eval for that occurrence.
   * 
   * Setting @a start_position differs from just passing over a shortened
   * string and setting REGEX_MATCH_NOTBOL in the case of a pattern
   * that begins with any kind of lookbehind assertion, such as "\b".
   * 
   * The following example uses g_regex_replace_eval() to replace multiple
   * strings at once:
   * |[
   * static <tt>bool</tt>
   * eval_cb (const GMatchInfo *info,
   * GString          *res,
   * gpointer          data)
   * {
   * gchar *match;
   * gchar *r;
   * 
   * match = g_match_info_fetch (info, 0);
   * r = g_hash_table_lookup ((GHashTable *)data, match);
   * g_string_append (res, r);
   * g_free (match);
   * 
   * return <tt>false</tt>;
   * }
   * 
   * / * ... * /
   * 
   * GRegex *reg;
   * GHashTable *h;
   * gchar *res;
   * 
   * h = g_hash_table_new (g_str_hash, g_str_equal);
   * 
   * g_hash_table_insert (h, "1", "ONE");
   * g_hash_table_insert (h, "2", "TWO");
   * g_hash_table_insert (h, "3", "THREE");
   * g_hash_table_insert (h, "4", "FOUR");
   * 
   * reg = g_regex_new ("1|2|3|4", 0, 0, <tt>0</tt>);
   * res = g_regex_replace_eval (reg, text, -1, 0, 0, eval_cb, h, <tt>0</tt>);
   * g_hash_table_destroy (h);
   * 
   * / * ... * /
   * ]|
   * 
   * @newin{2,14}
   * @param string_len The length of @a string, or -1 if @a string is nul-terminated.
   * @param start_position Starting index of the string to match.
   * @param match_options Options for the match.
   * @param eval A function to call for each match.
   * @param user_data User data to pass to the function.
   * @return A newly allocated string containing the replacements.
   */
  Glib::ustring replace_eval(const Glib::ustring& string, gssize string_len, int start_position, RegexMatchFlags match_options, GRegexEvalCallback eval,  gpointer user_data);
  
  /** Checks whether @a replacement is a valid replacement string
   * (see g_regex_replace()), i.e.\ that all escape sequences in
   * it are valid.
   * 
   * If @a has_references is not <tt>0</tt> then @a replacement is checked
   * for pattern references. For instance, replacement text 'foo<tt>\\n</tt>'
   * does not contain references and may be evaluated without information
   * about actual match, but '\0\1' (whole match followed by first
   * subpattern) requires valid MatchInfo object.
   * 
   * @newin{2,14}
   * @param replacement The replacement string.
   * @param has_references Location to store information about
   * references in @a replacement or <tt>0</tt>.
   * @return Whether @a replacement is a valid replacement string.
   */
  static bool check_replacement(const Glib::ustring& replacement, gboolean* has_references);

/* Match info */
/*
GRegex		 *g_match_info_get_regex	(const GMatchInfo    *match_info);
const gchar      *g_match_info_get_string       (const GMatchInfo    *match_info);

void		  g_match_info_free		(GMatchInfo          *match_info);
  _WRAP_METHOD(bool g_match_info_next		(GMatchInfo          *match_info,
						 GError             **error);
  _WRAP_METHOD(bool g_match_info_matches		(const GMatchInfo    *match_info);
  _WRAP_METHOD(int g_match_info_get_match_count	(const GMatchInfo    *match_info);
  _WRAP_METHOD(bool g_match_info_is_partial_match	(const GMatchInfo    *match_info);
Glib::ustring g_match_info_expand_references(const GMatchInfo    *match_info,
						 Glib::ustring& string_to_expand,
						 GError             **error);
Glib::ustring g_match_info_fetch		(const GMatchInfo    *match_info,
						 int match_num);
  _WRAP_METHOD(bool g_match_info_fetch_pos	(const GMatchInfo    *match_info,
						 int match_num,
						 int                 *start_pos,
						 int                 *end_pos);
Glib::ustring g_match_info_fetch_named	(const GMatchInfo    *match_info,
						 Glib::ustring& name);
  _WRAP_METHOD(bool g_match_info_fetch_named_pos	(const GMatchInfo    *match_info,
						 Glib::ustring& name,
						 int                 *start_pos,
						 int                 *end_pos);
gchar		**g_match_info_fetch_all	(const GMatchInfo    *match_info);
*/


};

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Glib::Regex
   */
  Glib::RefPtr<Glib::Regex> wrap(GRegex* object, bool take_copy = false);

} // namespace Glib


#endif /* _GLIBMM_REGEX_H */

