// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm/keyfile.h>
#include <glibmm/private/keyfile_p.h>

/* Copyright 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Glib
{

/**** Glib::KeyFile ********************************************************/

KeyFile::KeyFile()
{
  gobject_ = g_key_file_new();
  owns_gobject_ = true;
}

KeyFile::KeyFile(GKeyFile* castitem, bool takes_ownership)
{
  gobject_ = castitem;
  owns_gobject_ = takes_ownership;
}

KeyFile::~KeyFile()
{
  if (owns_gobject_)
    g_key_file_free(gobject_);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool KeyFile::load_from_data(const Glib::ustring& data, KeyFileFlags flags)
#else
bool KeyFile::load_from_data(const Glib::ustring& data, KeyFileFlags flags, std::auto_ptr<Glib::Error>& error)
#endif
{
  GError* gerror = 0;

  const gboolean result = g_key_file_load_from_data(
      gobj(), data.c_str(), data.bytes(),
      static_cast<GKeyFileFlags>(unsigned(flags)),
      &gerror);

  if(gerror)
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    Glib::Error::throw_exception(gerror);
#else
    error = Glib::Error::throw_exception(gerror);
#endif

  return (result != 0);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool KeyFile::load_from_data_dirs(const std::string& file, std::string& full_path, KeyFileFlags flags)
#else
bool KeyFile::load_from_data_dirs(const std::string& file, std::string& full_path, KeyFileFlags flags, std::auto_ptr<Glib::Error>& error)
#endif
{
  GError* gerror = 0;
  char* full_path_c = 0;

  const gboolean result = g_key_file_load_from_data_dirs(
      gobj(), file.c_str(), &full_path_c,
      static_cast<GKeyFileFlags>(unsigned(flags)),
      &gerror);

  if(gerror)
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    Glib::Error::throw_exception(gerror);
#else
    error = Glib::Error::throw_exception(gerror);
#endif

  if(full_path_c)
    full_path = Glib::ScopedPtr<char>(full_path_c).get();
  else
    full_path.erase();

  return (result != 0);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring KeyFile::to_data()
#else
Glib::ustring KeyFile::to_data(std::auto_ptr<Glib::Error>& error)
#endif
{
  GError* gerror = 0;
  char *const str = g_key_file_to_data(gobj(), 0, &gerror);

  if(gerror)
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    Glib::Error::throw_exception(gerror);
#else
    error = Glib::Error::throw_exception(gerror);
#endif

  return Glib::convert_return_gchar_ptr_to_ustring(str);
}

Glib::ArrayHandle<Glib::ustring> KeyFile::get_groups() const
{
  gsize length = 0;
  char** const array = g_key_file_get_groups(const_cast<GKeyFile*>(gobj()), &length);

  return Glib::ArrayHandle<Glib::ustring>(array, length, Glib::OWNERSHIP_DEEP);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ArrayHandle<Glib::ustring> KeyFile::get_keys(const Glib::ustring& group_name) const
#else
Glib::ArrayHandle<Glib::ustring> KeyFile::get_keys(const Glib::ustring& group_name, std::auto_ptr<Glib::Error>& error) const
#endif
{
  gsize length  = 0;
  GError* gerror = 0;

  char** const array = g_key_file_get_keys(
      const_cast<GKeyFile*>(gobj()),
      (group_name.empty()) ? 0 : group_name.c_str(),
      &length, &gerror);

  if(gerror)
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    Glib::Error::throw_exception(gerror);
#else
    error = Glib::Error::throw_exception(gerror);
#endif

  return Glib::ArrayHandle<Glib::ustring>(array, length, Glib::OWNERSHIP_DEEP);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring KeyFile::get_locale_string(const Glib::ustring& group_name,
  const Glib::ustring& key) const
#else
Glib::ustring KeyFile::get_locale_string(const Glib::ustring& group_name,
  const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif
{
  GError* gerror = 0;
  char *const str = g_key_file_get_locale_string(
      const_cast<GKeyFile*>(gobj()),
      (group_name.empty()) ? 0 : group_name.c_str(),
      key.c_str(), 0, &gerror);

  if(gerror)
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    Glib::Error::throw_exception(gerror);
#else
    error = Glib::Error::throw_exception(gerror);
#endif

  return Glib::convert_return_gchar_ptr_to_ustring(str);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int KeyFile::get_integer(const Glib::ustring& key) const
#else
int KeyFile::get_integer(const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  const int value = g_key_file_get_integer(const_cast<GKeyFile*>(gobj()),
                                           0, key.c_str(), &gerror);
  if(gerror)
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    Glib::Error::throw_exception(gerror);
#else
    error = Glib::Error::throw_exception(gerror);
#endif

  return value;
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
double KeyFile::get_double(const Glib::ustring& key) const
#else
double KeyFile::get_double(const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  double retvalue = g_key_file_get_double(const_cast<GKeyFile*>(gobj()), 0, key.c_str(), &(gerror));

  if(gerror)
#ifdef GLIBMM_EXCEPTIONS_ENABLED
    ::Glib::Error::throw_exception(gerror);
#else
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

void KeyFile::set_double(const Glib::ustring& key, double value)
{
  g_key_file_set_double(gobj(), 0, key.c_str(), value); 
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
# define GLIBMM_ERROR_ARG
# define GLIBMM_THROW(err) if (err) Glib::Error::throw_exception(err)
#else
# define GLIBMM_ERROR_ARG , std::auto_ptr<Glib::Error>& error
# define GLIBMM_THROW(err) if (err) error = Glib::Error::throw_exception(err)
#endif

Glib::ArrayHandle<Glib::ustring> KeyFile::get_string_list(const Glib::ustring& group_name,
                                                          const Glib::ustring& key
                                                          GLIBMM_ERROR_ARG) const
{
  gsize   length = 0;
  GError* gerror = 0;

  char** const array = g_key_file_get_string_list(
      const_cast<GKeyFile*>(gobj()),
      (group_name.empty()) ? 0 : group_name.c_str(),
      key.c_str(), &length, &gerror);

  GLIBMM_THROW(gerror);

  return Glib::ArrayHandle<Glib::ustring>(array, length, Glib::OWNERSHIP_DEEP);
}

Glib::ArrayHandle<Glib::ustring> KeyFile::get_locale_string_list(const Glib::ustring& group_name,
                                                                 const Glib::ustring& key,
                                                                 const Glib::ustring& locale
                                                                 GLIBMM_ERROR_ARG) const
{
  gsize   length = 0;
  GError* gerror = 0;

  char** const array = g_key_file_get_locale_string_list(
      const_cast<GKeyFile*>(gobj()),
      (group_name.empty()) ? 0 : group_name.c_str(),
      key.c_str(), locale.c_str(), &length, &gerror);

  GLIBMM_THROW(gerror);

  return Glib::ArrayHandle<Glib::ustring>(array, length, Glib::OWNERSHIP_DEEP);
}

Glib::ArrayHandle<bool> KeyFile::get_boolean_list(const Glib::ustring& group_name,
                                                  const Glib::ustring& key
                                                  GLIBMM_ERROR_ARG) const
{
  gsize   length = 0;
  GError* gerror = 0;

  gboolean *const array = g_key_file_get_boolean_list(
      const_cast<GKeyFile*>(gobj()),
      (group_name.empty()) ? 0 : group_name.c_str(),
      key.c_str(), &length, &gerror);

  GLIBMM_THROW(gerror);

  return Glib::ArrayHandle<bool>(array, length, Glib::OWNERSHIP_SHALLOW);
}

Glib::ArrayHandle<int> KeyFile::get_integer_list(const Glib::ustring& group_name,
                                                 const Glib::ustring& key
                                                 GLIBMM_ERROR_ARG) const
{
  gsize   length = 0;
  GError* gerror = 0;

  int *const array = g_key_file_get_integer_list(
      const_cast<GKeyFile*>(gobj()),
      (group_name.empty()) ? 0 : group_name.c_str(),
      key.c_str(), &length, &gerror);

  GLIBMM_THROW(gerror);

  return Glib::ArrayHandle<int>(array, length, Glib::OWNERSHIP_SHALLOW);
}

Glib::ArrayHandle<double> KeyFile::get_double_list(const Glib::ustring& group_name,
                                                   const Glib::ustring& key
                                                   GLIBMM_ERROR_ARG) const
{
  gsize   length = 0;
  GError* gerror = 0;

  double *const array = g_key_file_get_double_list(const_cast<GKeyFile*>(gobj()),
                                                   group_name.c_str(), key.c_str(),
                                                   &length, &gerror);
  GLIBMM_THROW(gerror);

  return Glib::ArrayHandle<double>(array, length, Glib::OWNERSHIP_SHALLOW);
}

void KeyFile::set_string_list(const Glib::ustring& group_name, const Glib::ustring& key,
                              const Glib::ArrayHandle<Glib::ustring>& list)
{
  g_key_file_set_string_list(gobj(), (group_name.empty()) ? 0 : group_name.c_str(),
                             key.c_str(), list.data(), list.size());
}

void KeyFile::set_locale_string_list(const Glib::ustring& group_name,
                                     const Glib::ustring& key, const Glib::ustring& locale,
                                     const Glib::ArrayHandle<Glib::ustring>& list)
{
  g_key_file_set_locale_string_list(gobj(), (group_name.empty()) ? 0 : group_name.c_str(),
                                    key.c_str(), locale.c_str(), list.data(), list.size());
}

void KeyFile::set_integer_list(const Glib::ustring& group_name, const Glib::ustring& key,
                               const Glib::ArrayHandle<int>& list)
{
  g_key_file_set_integer_list(gobj(), (group_name.empty()) ? 0 : group_name.c_str(),
                              key.c_str(), const_cast<int*>(list.data()), list.size());
}

void KeyFile::set_double_list(const Glib::ustring& group_name, const Glib::ustring& key,
                              const Glib::ArrayHandle<double>& list)
{
  g_key_file_set_double_list(gobj(), group_name.c_str(), key.c_str(),
                             const_cast<double*>(list.data()), list.size());
}

void KeyFile::set_boolean_list(const Glib::ustring& group_name, const Glib::ustring& key,
                               const Glib::ArrayHandle<bool>& list)
{
  g_key_file_set_boolean_list(gobj(), (group_name.empty()) ? 0 : group_name.c_str(),
                              key.c_str(), const_cast<gboolean*>(list.data()), list.size());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring KeyFile::get_comment() const
#else
Glib::ustring KeyFile::get_comment(std::auto_ptr<Glib::Error>& error) const
#endif
{
  GError* gerror = 0;
  char *const str = g_key_file_get_comment(const_cast<GKeyFile*>(gobj()), 0, 0, &gerror);

  GLIBMM_THROW(gerror);

  return Glib::convert_return_gchar_ptr_to_ustring(str);
}

Glib::ustring KeyFile::get_comment(const Glib::ustring& group_name GLIBMM_ERROR_ARG) const
{
  GError* gerror = 0;
  char *const str = g_key_file_get_comment(const_cast<GKeyFile*>(gobj()),
                                           (group_name.empty()) ? 0 : group_name.c_str(),
                                           0, &gerror);
  GLIBMM_THROW(gerror);

  return Glib::convert_return_gchar_ptr_to_ustring(str);
}

void KeyFile::set_comment(const Glib::ustring& comment GLIBMM_ERROR_ARG)
{
  GError* gerror = 0;
  g_key_file_set_comment(gobj(), 0, 0, comment.c_str(), &gerror);

  GLIBMM_THROW(gerror);
}

void KeyFile::set_comment(const Glib::ustring& group_name, const Glib::ustring& comment
                          GLIBMM_ERROR_ARG)
{
  GError* gerror = 0;
  g_key_file_set_comment(gobj(), (group_name.empty()) ? 0 : group_name.c_str(),
                         0, comment.c_str(), &gerror);
  GLIBMM_THROW(gerror);
}

} // namespace Glib

namespace
{
} // anonymous namespace


Glib::KeyFileError::KeyFileError(Glib::KeyFileError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (G_KEY_FILE_ERROR, error_code, error_message)
{}

Glib::KeyFileError::KeyFileError(GError* gobject)
:
  Glib::Error (gobject)
{}

Glib::KeyFileError::Code Glib::KeyFileError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Glib::KeyFileError::throw_func(GError* gobject)
{
  throw Glib::KeyFileError(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Glib::KeyFileError::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Glib::KeyFileError(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED


namespace Glib
{


#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool KeyFile::load_from_file(const std::string& filename, KeyFileFlags flags)
#else
bool KeyFile::load_from_file(const std::string& filename, KeyFileFlags flags, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_key_file_load_from_file(gobj(), filename.c_str(), ((GKeyFileFlags)(flags)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

Glib::ustring KeyFile::get_start_group() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(g_key_file_get_start_group(const_cast<GKeyFile*>(gobj())));
}

bool KeyFile::has_group(const Glib::ustring& group_name) const
{
  return g_key_file_has_group(const_cast<GKeyFile*>(gobj()), group_name.c_str());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool KeyFile::has_key(const Glib::ustring& group_name, const Glib::ustring& key) const
#else
bool KeyFile::has_key(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_key_file_has_key(const_cast<GKeyFile*>(gobj()), group_name.c_str(), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring KeyFile::get_value(const Glib::ustring& group_name, const Glib::ustring& key) const
#else
Glib::ustring KeyFile::get_value(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(g_key_file_get_value(const_cast<GKeyFile*>(gobj()), group_name.c_str(), key.c_str(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring KeyFile::get_string(const Glib::ustring& group_name, const Glib::ustring& key) const
#else
Glib::ustring KeyFile::get_string(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(g_key_file_get_string(const_cast<GKeyFile*>(gobj()), group_name.c_str(), key.c_str(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring KeyFile::get_locale_string(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& locale) const
#else
Glib::ustring KeyFile::get_locale_string(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& locale, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(g_key_file_get_locale_string(const_cast<GKeyFile*>(gobj()), group_name.c_str(), key.c_str(), locale.c_str(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool KeyFile::get_boolean(const Glib::ustring& group_name, const Glib::ustring& key) const
#else
bool KeyFile::get_boolean(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_key_file_get_boolean(const_cast<GKeyFile*>(gobj()), group_name.c_str(), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int KeyFile::get_integer(const Glib::ustring& group_name, const Glib::ustring& key) const
#else
int KeyFile::get_integer(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  int retvalue = g_key_file_get_integer(const_cast<GKeyFile*>(gobj()), group_name.c_str(), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
double KeyFile::get_double(const Glib::ustring& group_name, const Glib::ustring& key) const
#else
double KeyFile::get_double(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  double retvalue = g_key_file_get_double(const_cast<GKeyFile*>(gobj()), group_name.c_str(), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

void KeyFile::set_double(const Glib::ustring& group_name, const Glib::ustring& key, double value)
{
g_key_file_set_double(gobj(), group_name.c_str(), key.c_str(), value); 
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::ustring KeyFile::get_comment(const Glib::ustring& group_name, const Glib::ustring& key) const
#else
Glib::ustring KeyFile::get_comment(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(g_key_file_get_comment(const_cast<GKeyFile*>(gobj()), group_name.c_str(), key.c_str(), &(gerror)));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

void KeyFile::set_list_separator(gchar separator)
{
g_key_file_set_list_separator(gobj(), separator); 
}

void KeyFile::set_value(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& value)
{
g_key_file_set_value(gobj(), group_name.c_str(), key.c_str(), value.c_str()); 
}

void KeyFile::set_string(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& string)
{
g_key_file_set_string(gobj(), group_name.c_str(), key.c_str(), string.c_str()); 
}

void KeyFile::set_locale_string(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& locale, const Glib::ustring& string)
{
g_key_file_set_locale_string(gobj(), group_name.c_str(), key.c_str(), locale.c_str(), string.c_str()); 
}

void KeyFile::set_boolean(const Glib::ustring& group_name, const Glib::ustring& key, bool value)
{
g_key_file_set_boolean(gobj(), group_name.c_str(), key.c_str(), static_cast<int>(value)); 
}

void KeyFile::set_integer(const Glib::ustring& group_name, const Glib::ustring& key, int value)
{
g_key_file_set_integer(gobj(), group_name.c_str(), key.c_str(), value); 
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void KeyFile::set_comment(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& comment)
#else
void KeyFile::set_comment(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& comment, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_key_file_set_comment(gobj(), group_name.c_str(), key.c_str(), comment.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void KeyFile::remove_comment(const Glib::ustring& group_name, const Glib::ustring& key)
#else
void KeyFile::remove_comment(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_key_file_remove_comment(gobj(), group_name.c_str(), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void KeyFile::remove_key(const Glib::ustring& group_name, const Glib::ustring& key)
#else
void KeyFile::remove_key(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_key_file_remove_key(gobj(), group_name.c_str(), key.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void KeyFile::remove_group(const Glib::ustring& group_name)
#else
void KeyFile::remove_group(const Glib::ustring& group_name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  g_key_file_remove_group(gobj(), group_name.c_str(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}


} // namespace Glib


