/* test-commit.c generated by valac 0.35.5.2-9e6c0, the Vala compiler
 * generated from test-commit.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libgit2-glib/ggit.h>
#include <glib/gstdio.h>
#include <gitg-assert.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;

#define LIB_GITG_TEST_TYPE_COMMIT (lib_gitg_test_commit_get_type ())
#define LIB_GITG_TEST_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GITG_TEST_TYPE_COMMIT, LibGitgTestCommit))
#define LIB_GITG_TEST_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GITG_TEST_TYPE_COMMIT, LibGitgTestCommitClass))
#define LIB_GITG_TEST_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GITG_TEST_TYPE_COMMIT))
#define LIB_GITG_TEST_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GITG_TEST_TYPE_COMMIT))
#define LIB_GITG_TEST_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GITG_TEST_TYPE_COMMIT, LibGitgTestCommitClass))

typedef struct _LibGitgTestCommit LibGitgTestCommit;
typedef struct _LibGitgTestCommitClass LibGitgTestCommitClass;
typedef struct _LibGitgTestCommitPrivate LibGitgTestCommitPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_reflog_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_reflog_entry_unref (var), NULL)))
#define _ggit_reflog_unref0(var) ((var == NULL) ? NULL : (var = (ggit_reflog_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
enum  {
	LIB_GITG_TEST_COMMIT_TEST_COMMIT_SIGNAL,
	LIB_GITG_TEST_COMMIT_TEST_SIGN_OFF_SIGNAL,
	LIB_GITG_TEST_COMMIT_TEST_PRE_COMMIT_HOOK_SIGNAL,
	LIB_GITG_TEST_COMMIT_TEST_COMMIT_MSG_HOOK_SIGNAL,
	LIB_GITG_TEST_COMMIT_TEST_SKIP_HOOKS_SIGNAL,
	LIB_GITG_TEST_COMMIT_TEST_AMEND_SIGNAL,
	LIB_GITG_TEST_COMMIT_LAST_SIGNAL
};
static guint lib_gitg_test_commit_signals[LIB_GITG_TEST_COMMIT_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _LibGitgTestCommit {
	GitgTestRepository parent_instance;
	LibGitgTestCommitPrivate * priv;
};

struct _LibGitgTestCommitClass {
	GitgTestRepositoryClass parent_class;
	void (*test_commit) (LibGitgTestCommit* self);
	void (*test_sign_off) (LibGitgTestCommit* self);
	void (*test_pre_commit_hook) (LibGitgTestCommit* self);
	void (*test_commit_msg_hook) (LibGitgTestCommit* self);
	void (*test_skip_hooks) (LibGitgTestCommit* self);
	void (*test_amend) (LibGitgTestCommit* self);
};

struct _Block6Data {
	int _ref_count_;
	LibGitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
	GgitSignature* sig;
	gchar* msg;
};

struct _Block7Data {
	int _ref_count_;
	LibGitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
	GgitSignature* author;
	GgitSignature* sig;
	gchar* msg;
};

struct _Block8Data {
	int _ref_count_;
	LibGitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block9Data {
	int _ref_count_;
	LibGitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block10Data {
	int _ref_count_;
	LibGitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block11Data {
	int _ref_count_;
	LibGitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
	GgitSignature* sig;
	gchar* msg;
};


static gpointer lib_gitg_test_commit_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
GType lib_gitg_test_commit_get_type (void) G_GNUC_CONST;
enum  {
	LIB_GITG_TEST_COMMIT_DUMMY_PROPERTY
};
static void lib_gitg_test_commit_real_set_up (GitgTestTest* base);
void gitg_test_test_set_up (GitgTestTest* self);
void gitg_test_repository_index_modify (GitgTestRepository* self, const gchar* filename, ...);
static void lib_gitg_test_commit_setup_failing_pre_commit_hook (LibGitgTestCommit* self);
LibGitgTestCommit* lib_gitg_test_commit_new (void);
LibGitgTestCommit* lib_gitg_test_commit_construct (GType object_type);
GitgTestRepository* gitg_test_repository_new (void);
GitgTestRepository* gitg_test_repository_construct (GType object_type);
static void lib_gitg_test_commit_real_test_commit (LibGitgTestCommit* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda9_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res);
static void _vala_GgitOId_free (GgitOId* self);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void lib_gitg_test_commit_real_test_sign_off (LibGitgTestCommit* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda10_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res);
static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void lib_gitg_test_commit_real_test_pre_commit_hook (LibGitgTestCommit* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda11_ (Block8Data* _data8_, GObject* obj, GAsyncResult* res);
static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void lib_gitg_test_commit_real_test_commit_msg_hook (LibGitgTestCommit* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda12_ (Block9Data* _data9_, GObject* obj, GAsyncResult* res);
static void ___lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void lib_gitg_test_commit_real_test_skip_hooks (LibGitgTestCommit* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda13_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void lib_gitg_test_commit_real_test_amend (LibGitgTestCommit* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
static void __lambda14_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res);
guint ggit_commit_parents_get_size (GgitCommitParents* self);
static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);


/**
 * Create basic repository with files in a variety of states.
 */
static void lib_gitg_test_commit_real_set_up (GitgTestTest* base) {
	LibGitgTestCommit * self;
#line 27 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	self = (LibGitgTestCommit*) base;
#line 29 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	GITG_TEST_TEST_CLASS (lib_gitg_test_commit_parent_class)->set_up ((GitgTestTest*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TEST_TYPE_REPOSITORY, GitgTestRepository));
#line 31 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_repository_index_modify ((GitgTestRepository*) self, "b", "staged changes\n", NULL);
#line 32 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_repository_index_modify ((GitgTestRepository*) self, "a", "lala\n", NULL);
#line 245 "test-commit.c"
}


static void lib_gitg_test_commit_setup_failing_pre_commit_hook (LibGitgTestCommit* self) {
	GFile* hookdir;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* pc;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gint _tmp11_;
	GError * _inner_error_ = NULL;
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = ggit_repository_get_location ((GgitRepository*) _tmp0_);
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_file_get_child (_tmp2_, "hooks");
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = _tmp3_;
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp2_);
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	hookdir = _tmp4_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = g_file_get_child (hookdir, "pre-commit");
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = _tmp5_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = g_file_get_path (_tmp6_);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _tmp7_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp6_);
#line 119 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	pc = _tmp8_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = g_file_set_contents (pc, "#!/bin/bash\n\necho 'pre-commit failed'; exit 1;\n", (gssize) -1, &_inner_error_);
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _tmp10_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 309 "test-commit.c"
	}
#line 121 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (_tmp9_, "FileUtils.set_contents(pc, \"#!/bin/bash\\n\\necho 'pre-commit failed'; exit 1;\\n\")");
#line 122 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = g_chmod (pc, 0744);
#line 122 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_inteq (_tmp11_, 0);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (pc);
#line 116 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (hookdir);
#line 321 "test-commit.c"
}


LibGitgTestCommit* lib_gitg_test_commit_construct (GType object_type) {
	LibGitgTestCommit * self = NULL;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	self = (LibGitgTestCommit*) gitg_test_repository_construct (object_type);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return self;
#line 331 "test-commit.c"
}


LibGitgTestCommit* lib_gitg_test_commit_new (void) {
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return lib_gitg_test_commit_construct (LIB_GITG_TEST_TYPE_COMMIT);
#line 338 "test-commit.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return _data6_;
#line 347 "test-commit.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 356 "test-commit.c"
		LibGitgTestCommit* self;
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		self = _data6_->self;
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (_data6_->msg);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data6_->sig);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data6_->loop);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data6_->stage);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block6Data, _data6_);
#line 372 "test-commit.c"
	}
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 380 "test-commit.c"
}


static void __lambda9_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res) {
	LibGitgTestCommit* self;
	GgitOId* oid;
	GAsyncResult* _tmp0_;
	GgitOId* _tmp1_;
	GitgCommit* commit;
	GitgRepository* _tmp2_;
	GgitOId* _tmp3_;
	gpointer _tmp4_;
	GitgCommit* _tmp5_;
	GgitSignature* _tmp6_;
	GgitSignature* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GitgCommit* _tmp10_;
	GgitSignature* _tmp11_;
	GgitSignature* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GitgCommit* _tmp15_;
	GgitSignature* _tmp16_;
	GgitSignature* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GitgCommit* _tmp20_;
	GgitSignature* _tmp21_;
	GgitSignature* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GitgCommit* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GitgCommit* _tmp28_;
	const gchar* _tmp29_;
	GitgRef* _tmp30_;
	GitgRepository* _tmp31_;
	GitgRef* _tmp32_;
	GitgRef* _tmp33_;
	GitgRef* _tmp34_;
	GgitOId* _tmp35_;
	GgitOId* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GgitOId* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GitgRef* _tmp42_;
	GitgRepository* _tmp43_;
	GitgRef* _tmp44_;
	GgitReflog* reflog;
	GitgRef* _tmp45_;
	GitgRef* _tmp46_;
	GgitReflog* _tmp47_;
	GgitReflog* _tmp48_;
	GgitReflogEntry* entry;
	GgitReflog* _tmp49_;
	GgitReflogEntry* _tmp50_;
	GgitReflogEntry* _tmp51_;
	GgitOId* _tmp52_;
	GgitOId* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GgitOId* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	GgitReflogEntry* _tmp59_;
	const gchar* _tmp60_;
	GError * _inner_error_ = NULL;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	self = _data6_->self;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 53 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = res;
#line 53 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_stage_commit_finish (_data6_->stage, _tmp0_, &_inner_error_);
#line 53 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp1_;
#line 53 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 53 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 53 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 53 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 470 "test-commit.c"
	}
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = ((GitgTestRepository*) self)->d_repository;
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = oid;
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = gitg_repository_lookup (_tmp2_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp3_, &_inner_error_);
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp4_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 54 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 490 "test-commit.c"
	}
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = commit;
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = ggit_commit_get_author ((GgitCommit*) _tmp5_);
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = _tmp6_;
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = ggit_signature_get_name (_tmp7_);
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = ggit_signature_get_name (_data6_->sig);
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp8_, _tmp9_);
#line 56 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = commit;
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = ggit_commit_get_author ((GgitCommit*) _tmp10_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = _tmp11_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = ggit_signature_get_email (_tmp12_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = ggit_signature_get_email (_data6_->sig);
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp13_, _tmp14_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = commit;
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = ggit_commit_get_committer ((GgitCommit*) _tmp15_);
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = _tmp16_;
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = ggit_signature_get_name (_tmp17_);
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = ggit_signature_get_name (_data6_->sig);
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp18_, _tmp19_);
#line 59 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp17_);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = commit;
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = ggit_commit_get_committer ((GgitCommit*) _tmp20_);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = _tmp21_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = ggit_signature_get_email (_tmp22_);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = ggit_signature_get_email (_data6_->sig);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp23_, _tmp24_);
#line 60 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp22_);
#line 62 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = commit;
#line 62 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp26_ = ggit_commit_get_message ((GgitCommit*) _tmp25_);
#line 62 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp27_ = _data6_->msg;
#line 62 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp26_, _tmp27_);
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp28_ = commit;
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp29_ = ggit_commit_get_subject ((GgitCommit*) _tmp28_);
#line 63 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp29_, "This is the commit");
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp31_ = ((GitgTestRepository*) self)->d_repository;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp32_ = gitg_repository_get_head (_tmp31_, &_inner_error_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp30_ = _tmp32_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 580 "test-commit.c"
	}
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp33_ = _tmp30_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp30_ = NULL;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp34_ = _tmp33_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp35_ = ggit_ref_get_target ((GgitRef*) _tmp34_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp36_ = _tmp35_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp37_ = ggit_oid_to_string (_tmp36_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp38_ = _tmp37_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp39_ = oid;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp40_ = ggit_oid_to_string (_tmp39_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp41_ = _tmp40_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp38_, _tmp41_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp41_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp38_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (_tmp36_);
#line 65 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp34_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp43_ = ((GitgTestRepository*) self)->d_repository;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp44_ = gitg_repository_lookup_reference (_tmp43_, "HEAD", &_inner_error_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp42_ = _tmp44_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp30_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 632 "test-commit.c"
	}
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp45_ = _tmp42_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp42_ = NULL;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp46_ = _tmp45_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp47_ = ggit_ref_get_log ((GgitRef*) _tmp46_, &_inner_error_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp48_ = _tmp47_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp46_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	reflog = _tmp48_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp42_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp30_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 68 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 664 "test-commit.c"
	}
#line 69 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp49_ = reflog;
#line 69 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp50_ = ggit_reflog_get_entry_from_index (_tmp49_, (guint) 0);
#line 69 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	entry = _tmp50_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp51_ = entry;
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp52_ = ggit_reflog_entry_get_new_id (_tmp51_);
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp53_ = _tmp52_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp54_ = ggit_oid_to_string (_tmp53_);
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp55_ = _tmp54_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp56_ = oid;
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp57_ = ggit_oid_to_string (_tmp56_);
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp58_ = _tmp57_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp55_, _tmp58_);
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp58_);
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp55_);
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (_tmp53_);
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp59_ = entry;
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp60_ = ggit_reflog_entry_get_message (_tmp59_);
#line 72 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp60_, "commit: This is the commit");
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_data6_->loop);
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_ggit_reflog_entry_unref0 (entry);
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_ggit_reflog_unref0 (reflog);
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp42_);
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp30_);
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 716 "test-commit.c"
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__lambda9_ (self, source_object, res);
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block6_data_unref (self);
#line 725 "test-commit.c"
}


static void lib_gitg_test_commit_real_test_commit (LibGitgTestCommit* self) {
	Block6Data* _data6_;
	GitgRepository* _tmp0_;
	GitgStage* _tmp1_;
	GitgStage* _tmp2_;
	GMainLoop* _tmp3_;
	GgitSignature* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data6_->_ref_count_ = 1;
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data6_->self = g_object_ref (self);
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data6_->stage = _tmp2_;
#line 41 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 41 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data6_->loop = _tmp3_;
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data6_->sig = _tmp4_;
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block6_data_unref (_data6_);
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data6_ = NULL;
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 43 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 773 "test-commit.c"
	}
#line 46 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = g_strdup ("This is the commit\n\nWith a message.\n");
#line 46 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data6_->msg = _tmp5_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = _data6_->msg;
#line 48 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_data6_->stage, _tmp6_, _data6_->sig, _data6_->sig, GITG_STAGE_COMMIT_OPTIONS_NONE, ___lambda9__gasync_ready_callback, block6_data_ref (_data6_));
#line 77 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_data6_->loop);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block6_data_unref (_data6_);
#line 38 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data6_ = NULL;
#line 789 "test-commit.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return _data7_;
#line 798 "test-commit.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 807 "test-commit.c"
		LibGitgTestCommit* self;
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		self = _data7_->self;
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (_data7_->msg);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data7_->sig);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data7_->author);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data7_->loop);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data7_->stage);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block7Data, _data7_);
#line 825 "test-commit.c"
	}
}


static void __lambda10_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res) {
	LibGitgTestCommit* self;
	GgitOId* oid;
	GitgStage* _tmp0_;
	GAsyncResult* _tmp1_;
	GgitOId* _tmp2_;
	GitgCommit* commit;
	GitgRepository* _tmp3_;
	GgitOId* _tmp4_;
	gpointer _tmp5_;
	GitgCommit* _tmp6_;
	GgitSignature* _tmp7_;
	GgitSignature* _tmp8_;
	const gchar* _tmp9_;
	GgitSignature* _tmp10_;
	const gchar* _tmp11_;
	GitgCommit* _tmp12_;
	GgitSignature* _tmp13_;
	GgitSignature* _tmp14_;
	const gchar* _tmp15_;
	GgitSignature* _tmp16_;
	const gchar* _tmp17_;
	GitgCommit* _tmp18_;
	GgitSignature* _tmp19_;
	GgitSignature* _tmp20_;
	const gchar* _tmp21_;
	GgitSignature* _tmp22_;
	const gchar* _tmp23_;
	GitgCommit* _tmp24_;
	GgitSignature* _tmp25_;
	GgitSignature* _tmp26_;
	const gchar* _tmp27_;
	GgitSignature* _tmp28_;
	const gchar* _tmp29_;
	GitgCommit* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GMainLoop* _tmp35_;
	GError * _inner_error_ = NULL;
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	self = _data7_->self;
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = _data7_->stage;
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = res;
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = gitg_stage_commit_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp2_;
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 98 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 891 "test-commit.c"
	}
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = ((GitgTestRepository*) self)->d_repository;
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = oid;
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp4_, &_inner_error_);
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp5_;
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 100 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 911 "test-commit.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = commit;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = ggit_commit_get_author ((GgitCommit*) _tmp6_);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _tmp7_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = ggit_signature_get_name (_tmp8_);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = _data7_->author;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = ggit_signature_get_name (_tmp10_);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp9_, _tmp11_);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = commit;
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = ggit_commit_get_author ((GgitCommit*) _tmp12_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = _tmp13_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = ggit_signature_get_email (_tmp14_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = _data7_->author;
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = ggit_signature_get_email (_tmp16_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp15_, _tmp17_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp14_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = commit;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = ggit_commit_get_committer ((GgitCommit*) _tmp18_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = _tmp19_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = ggit_signature_get_name (_tmp20_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = _data7_->sig;
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = ggit_signature_get_name (_tmp22_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp21_, _tmp23_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp20_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = commit;
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = ggit_commit_get_committer ((GgitCommit*) _tmp24_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp26_ = _tmp25_;
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp27_ = ggit_signature_get_email (_tmp26_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp28_ = _data7_->sig;
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp29_ = ggit_signature_get_email (_tmp28_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp27_, _tmp29_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp26_);
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp30_ = commit;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp31_ = ggit_commit_get_message ((GgitCommit*) _tmp30_);
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp32_ = _data7_->msg;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp33_ = g_strconcat (_tmp32_, "\nSigned-off-by: Jesse van den Kieboom <jessevdk@gmail.com>\n", NULL);
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp34_ = _tmp33_;
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp31_, _tmp34_);
#line 108 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp34_);
#line 110 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp35_ = _data7_->loop;
#line 110 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_tmp35_);
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 999 "test-commit.c"
}


static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__lambda10_ (self, source_object, res);
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block7_data_unref (self);
#line 1008 "test-commit.c"
}


static void lib_gitg_test_commit_real_test_sign_off (LibGitgTestCommit* self) {
	Block7Data* _data7_;
	GitgRepository* _tmp0_;
	GitgStage* _tmp1_;
	GitgStage* _tmp2_;
	GMainLoop* _tmp3_;
	GgitSignature* _tmp4_;
	GgitSignature* _tmp5_;
	gchar* _tmp6_;
	GitgStage* _tmp7_;
	const gchar* _tmp8_;
	GgitSignature* _tmp9_;
	GgitSignature* _tmp10_;
	GMainLoop* _tmp11_;
	GError * _inner_error_ = NULL;
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_->_ref_count_ = 1;
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_->self = g_object_ref (self);
#line 82 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 82 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 82 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_->stage = _tmp2_;
#line 83 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 83 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_->loop = _tmp3_;
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = ggit_signature_new_now ("Jesse", "jessevdk@gnome.org", &_inner_error_);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_->author = _tmp4_;
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block7_data_unref (_data7_);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data7_ = NULL;
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 85 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1061 "test-commit.c"
	}
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gmail.com", &_inner_error_);
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_->sig = _tmp5_;
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block7_data_unref (_data7_);
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data7_ = NULL;
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1079 "test-commit.c"
	}
#line 91 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = g_strdup ("This is the commit\n\nWith a message.\n");
#line 91 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_->msg = _tmp6_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = _data7_->stage;
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _data7_->msg;
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _data7_->author;
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = _data7_->sig;
#line 93 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_tmp7_, _tmp8_, _tmp9_, _tmp10_, GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF, ___lambda10__gasync_ready_callback, block7_data_ref (_data7_));
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = _data7_->loop;
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_tmp11_);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block7_data_unref (_data7_);
#line 80 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data7_ = NULL;
#line 1103 "test-commit.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return _data8_;
#line 1112 "test-commit.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 1121 "test-commit.c"
		LibGitgTestCommit* self;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		self = _data8_->self;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data8_->loop);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data8_->stage);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block8Data, _data8_);
#line 1133 "test-commit.c"
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 144 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return self ? g_error_copy (self) : NULL;
#line 1141 "test-commit.c"
}


static void __lambda11_ (Block8Data* _data8_, GObject* obj, GAsyncResult* res) {
	LibGitgTestCommit* self;
	GError* e;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	self = _data8_->self;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 136 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	e = NULL;
#line 1159 "test-commit.c"
	{
		GAsyncResult* _tmp0_;
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_tmp0_ = res;
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		gitg_stage_pre_commit_hook_finish (_data8_->stage, _tmp0_, &_inner_error_);
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
			if (_inner_error_->domain == GITG_STAGE_ERROR) {
#line 1170 "test-commit.c"
				goto __catch4_gitg_stage_error;
			}
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
			_g_error_free0 (e);
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
			g_clear_error (&_inner_error_);
#line 140 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
			return;
#line 1181 "test-commit.c"
		}
	}
	goto __finally4;
	__catch4_gitg_stage_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		GError* _tmp2_;
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		err = _inner_error_;
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_inner_error_ = NULL;
#line 144 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_tmp1_ = err;
#line 144 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_tmp2_ = _g_error_copy0 (_tmp1_);
#line 144 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_error_free0 (e);
#line 144 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		e = _tmp2_;
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_error_free0 (err);
#line 1204 "test-commit.c"
	}
	__finally4:
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_error_free0 (e);
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 138 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1217 "test-commit.c"
	}
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = e;
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (_tmp3_ != NULL, "e != null");
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = e;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (g_error_matches (_tmp4_, GITG_STAGE_ERROR, GITG_STAGE_ERROR_PRE_COMMIT_HOOK_FAILED), "e is Gitg.StageError.PRE_COMMIT_HOOK_FAILED");
#line 149 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = e;
#line 149 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = _tmp5_->message;
#line 149 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp6_, "pre-commit failed");
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_data8_->loop);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_error_free0 (e);
#line 1237 "test-commit.c"
}


static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__lambda11_ (self, source_object, res);
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block8_data_unref (self);
#line 1246 "test-commit.c"
}


static void lib_gitg_test_commit_real_test_pre_commit_hook (LibGitgTestCommit* self) {
	Block8Data* _data8_;
	GitgRepository* _tmp0_;
	GitgStage* _tmp1_;
	GitgStage* _tmp2_;
	GMainLoop* _tmp3_;
	GgitSignature* sig;
	GgitSignature* _tmp4_;
	GError * _inner_error_ = NULL;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data8_->_ref_count_ = 1;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data8_->self = g_object_ref (self);
#line 127 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	lib_gitg_test_commit_setup_failing_pre_commit_hook (self);
#line 129 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 129 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 129 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 129 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data8_->stage = _tmp2_;
#line 130 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 130 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data8_->loop = _tmp3_;
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	sig = _tmp4_;
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block8_data_unref (_data8_);
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data8_ = NULL;
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 132 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1295 "test-commit.c"
	}
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_pre_commit_hook (_data8_->stage, sig, ___lambda11__gasync_ready_callback, block8_data_ref (_data8_));
#line 154 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_data8_->loop);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (sig);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block8_data_unref (_data8_);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data8_ = NULL;
#line 1307 "test-commit.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return _data9_;
#line 1316 "test-commit.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 1325 "test-commit.c"
		LibGitgTestCommit* self;
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		self = _data9_->self;
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data9_->loop);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data9_->stage);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block9Data, _data9_);
#line 1337 "test-commit.c"
	}
}


static void __lambda12_ (Block9Data* _data9_, GObject* obj, GAsyncResult* res) {
	LibGitgTestCommit* self;
	GgitOId* oid;
	GitgStage* _tmp0_;
	GAsyncResult* _tmp1_;
	GgitOId* _tmp2_;
	GitgCommit* commit;
	GitgRepository* _tmp3_;
	GgitOId* _tmp4_;
	gpointer _tmp5_;
	GitgCommit* _tmp6_;
	const gchar* _tmp7_;
	GMainLoop* _tmp8_;
	GError * _inner_error_ = NULL;
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	self = _data9_->self;
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = _data9_->stage;
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = res;
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = gitg_stage_commit_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp2_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 177 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1376 "test-commit.c"
	}
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = ((GitgTestRepository*) self)->d_repository;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = oid;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp4_, &_inner_error_);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp5_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 179 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1396 "test-commit.c"
	}
#line 180 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = commit;
#line 180 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = ggit_commit_get_message ((GgitCommit*) _tmp6_);
#line 180 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp7_, "override message\n");
#line 182 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _data9_->loop;
#line 182 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_tmp8_);
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 1412 "test-commit.c"
}


static void ___lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__lambda12_ (self, source_object, res);
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block9_data_unref (self);
#line 1421 "test-commit.c"
}


static void lib_gitg_test_commit_real_test_commit_msg_hook (LibGitgTestCommit* self) {
	Block9Data* _data9_;
	GFile* hookdir;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* pc;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	GitgRepository* _tmp15_;
	GitgStage* _tmp16_;
	GitgStage* _tmp17_;
	GMainLoop* _tmp18_;
	gchar* msg;
	gchar* _tmp19_;
	GgitSignature* sig;
	GgitSignature* _tmp20_;
	GitgStage* _tmp21_;
	const gchar* _tmp22_;
	GgitSignature* _tmp23_;
	GgitSignature* _tmp24_;
	GMainLoop* _tmp25_;
	GError * _inner_error_ = NULL;
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data9_->_ref_count_ = 1;
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data9_->self = g_object_ref (self);
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = ggit_repository_get_location ((GgitRepository*) _tmp0_);
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_file_get_child (_tmp2_, "hooks");
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = _tmp3_;
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp2_);
#line 159 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	hookdir = _tmp4_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = hookdir;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = g_file_get_child (_tmp5_, "commit-msg");
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = _tmp6_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _tmp8_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	pc = _tmp9_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = pc;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = g_file_set_contents (_tmp11_, "#!/bin/bash\n\necho 'override message' > $1\n", (gssize) -1, &_inner_error_);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = _tmp12_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block9_data_unref (_data9_);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data9_ = NULL;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1514 "test-commit.c"
	}
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (_tmp10_, "FileUtils.set_contents(pc, \"#!/bin/bash\\n\\necho 'override message' > $1\\n\")");
#line 163 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = pc;
#line 163 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = g_chmod (_tmp13_, 0744);
#line 163 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_inteq (_tmp14_, 0);
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = ((GitgTestRepository*) self)->d_repository;
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = gitg_repository_get_stage (_tmp15_);
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = _tmp16_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data9_->stage = _tmp17_;
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = g_main_loop_new (NULL, FALSE);
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data9_->loop = _tmp18_;
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = g_strdup ("original message\n");
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	msg = _tmp19_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	sig = _tmp20_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (msg);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block9_data_unref (_data9_);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data9_ = NULL;
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 170 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1562 "test-commit.c"
	}
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = _data9_->stage;
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = msg;
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = sig;
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = sig;
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_tmp21_, _tmp22_, _tmp23_, _tmp24_, GITG_STAGE_COMMIT_OPTIONS_NONE, ___lambda12__gasync_ready_callback, block9_data_ref (_data9_));
#line 185 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = _data9_->loop;
#line 185 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_tmp25_);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (sig);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (msg);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (pc);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (hookdir);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block9_data_unref (_data9_);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data9_ = NULL;
#line 1590 "test-commit.c"
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return _data10_;
#line 1599 "test-commit.c"
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 1608 "test-commit.c"
		LibGitgTestCommit* self;
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		self = _data10_->self;
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data10_->loop);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data10_->stage);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block10Data, _data10_);
#line 1620 "test-commit.c"
	}
}


static void __lambda13_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res) {
	LibGitgTestCommit* self;
	GgitOId* oid;
	GitgStage* _tmp0_;
	GAsyncResult* _tmp1_;
	GgitOId* _tmp2_;
	GitgCommit* commit;
	GitgRepository* _tmp3_;
	GgitOId* _tmp4_;
	gpointer _tmp5_;
	GitgCommit* _tmp6_;
	const gchar* _tmp7_;
	GMainLoop* _tmp8_;
	GError * _inner_error_ = NULL;
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	self = _data10_->self;
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 208 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = _data10_->stage;
#line 208 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = res;
#line 208 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = gitg_stage_commit_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 208 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp2_;
#line 208 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 208 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1659 "test-commit.c"
	}
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = ((GitgTestRepository*) self)->d_repository;
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = oid;
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp4_, &_inner_error_);
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp5_;
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1679 "test-commit.c"
	}
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = commit;
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = ggit_commit_get_message ((GgitCommit*) _tmp6_);
#line 211 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp7_, "original message\n");
#line 213 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _data10_->loop;
#line 213 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_tmp8_);
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 1695 "test-commit.c"
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__lambda13_ (self, source_object, res);
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block10_data_unref (self);
#line 1704 "test-commit.c"
}


static void lib_gitg_test_commit_real_test_skip_hooks (LibGitgTestCommit* self) {
	Block10Data* _data10_;
	GFile* hookdir;
	GitgRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* pc;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	GitgRepository* _tmp15_;
	GitgStage* _tmp16_;
	GitgStage* _tmp17_;
	GMainLoop* _tmp18_;
	gchar* msg;
	gchar* _tmp19_;
	GgitSignature* sig;
	GgitSignature* _tmp20_;
	GitgStage* _tmp21_;
	const gchar* _tmp22_;
	GgitSignature* _tmp23_;
	GgitSignature* _tmp24_;
	GMainLoop* _tmp25_;
	GError * _inner_error_ = NULL;
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data10_->_ref_count_ = 1;
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data10_->self = g_object_ref (self);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = ggit_repository_get_location ((GgitRepository*) _tmp0_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_file_get_child (_tmp2_, "hooks");
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = _tmp3_;
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp2_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	hookdir = _tmp4_;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = hookdir;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = g_file_get_child (_tmp5_, "commit-msg");
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = _tmp6_;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _tmp8_;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	pc = _tmp9_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = pc;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = g_file_set_contents (_tmp11_, "#!/bin/bash\n\necho 'override message' > $1\n", (gssize) -1, &_inner_error_);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = _tmp12_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block10_data_unref (_data10_);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data10_ = NULL;
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1797 "test-commit.c"
	}
#line 193 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (_tmp10_, "FileUtils.set_contents(pc, \"#!/bin/bash\\n\\necho 'override message' > $1\\n\")");
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = pc;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = g_chmod (_tmp13_, 0744);
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_inteq (_tmp14_, 0);
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = ((GitgTestRepository*) self)->d_repository;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = gitg_repository_get_stage (_tmp15_);
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = _tmp16_;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data10_->stage = _tmp17_;
#line 197 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = g_main_loop_new (NULL, FALSE);
#line 197 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data10_->loop = _tmp18_;
#line 199 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = g_strdup ("original message\n");
#line 199 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	msg = _tmp19_;
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	sig = _tmp20_;
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (msg);
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block10_data_unref (_data10_);
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data10_ = NULL;
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1845 "test-commit.c"
	}
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = _data10_->stage;
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = msg;
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = sig;
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = sig;
#line 204 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_tmp21_, _tmp22_, _tmp23_, _tmp24_, GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS, ___lambda13__gasync_ready_callback, block10_data_ref (_data10_));
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = _data10_->loop;
#line 216 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_tmp25_);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (sig);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (msg);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (pc);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (hookdir);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block10_data_unref (_data10_);
#line 188 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data10_ = NULL;
#line 1873 "test-commit.c"
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	return _data11_;
#line 1882 "test-commit.c"
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 1891 "test-commit.c"
		LibGitgTestCommit* self;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		self = _data11_->self;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (_data11_->msg);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data11_->sig);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data11_->loop);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data11_->stage);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block11Data, _data11_);
#line 1907 "test-commit.c"
	}
}


static void __lambda14_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res) {
	LibGitgTestCommit* self;
	GgitOId* oid;
	GitgStage* _tmp0_;
	GAsyncResult* _tmp1_;
	GgitOId* _tmp2_;
	GitgCommit* commit;
	GitgRepository* _tmp3_;
	GgitOId* _tmp4_;
	gpointer _tmp5_;
	GitgCommit* _tmp6_;
	GgitSignature* _tmp7_;
	GgitSignature* _tmp8_;
	const gchar* _tmp9_;
	GitgCommit* _tmp10_;
	GgitSignature* _tmp11_;
	GgitSignature* _tmp12_;
	const gchar* _tmp13_;
	GitgCommit* _tmp14_;
	GgitSignature* _tmp15_;
	GgitSignature* _tmp16_;
	const gchar* _tmp17_;
	GgitSignature* _tmp18_;
	const gchar* _tmp19_;
	GitgCommit* _tmp20_;
	GgitSignature* _tmp21_;
	GgitSignature* _tmp22_;
	const gchar* _tmp23_;
	GgitSignature* _tmp24_;
	const gchar* _tmp25_;
	GitgCommit* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GitgCommit* _tmp29_;
	const gchar* _tmp30_;
	GitgRef* _tmp31_;
	GitgRepository* _tmp32_;
	GitgRef* _tmp33_;
	GitgRef* _tmp34_;
	GitgRef* _tmp35_;
	GgitOId* _tmp36_;
	GgitOId* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GgitOId* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GitgCommit* _tmp43_;
	GgitCommitParents* _tmp44_;
	GgitCommitParents* _tmp45_;
	guint _tmp46_;
	guint _tmp47_;
	GitgRef* _tmp48_;
	GitgRepository* _tmp49_;
	GitgRef* _tmp50_;
	GgitReflog* reflog;
	GitgRef* _tmp51_;
	GitgRef* _tmp52_;
	GgitReflog* _tmp53_;
	GgitReflog* _tmp54_;
	GgitReflogEntry* entry;
	GgitReflog* _tmp55_;
	GgitReflogEntry* _tmp56_;
	GgitReflogEntry* _tmp57_;
	GgitOId* _tmp58_;
	GgitOId* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	GgitOId* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	GgitReflogEntry* _tmp65_;
	const gchar* _tmp66_;
	GMainLoop* _tmp67_;
	GError * _inner_error_ = NULL;
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	self = _data11_->self;
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 240 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = _data11_->stage;
#line 240 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = res;
#line 240 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = gitg_stage_commit_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 240 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp2_;
#line 240 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 240 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 240 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 240 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2007 "test-commit.c"
	}
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = ((GitgTestRepository*) self)->d_repository;
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = oid;
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp4_, &_inner_error_);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp5_;
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2027 "test-commit.c"
	}
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = commit;
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = ggit_commit_get_author ((GgitCommit*) _tmp6_);
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _tmp7_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = ggit_signature_get_name (_tmp8_);
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp9_, "gitg tester");
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = commit;
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = ggit_commit_get_author ((GgitCommit*) _tmp10_);
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = _tmp11_;
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = ggit_signature_get_email (_tmp12_);
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp13_, "gitg-tester@gnome.org");
#line 244 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = commit;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = ggit_commit_get_committer ((GgitCommit*) _tmp14_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = _tmp15_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = ggit_signature_get_name (_tmp16_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = _data11_->sig;
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = ggit_signature_get_name (_tmp18_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp17_, _tmp19_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp16_);
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = commit;
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = ggit_commit_get_committer ((GgitCommit*) _tmp20_);
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = _tmp21_;
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = ggit_signature_get_email (_tmp22_);
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = _data11_->sig;
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = ggit_signature_get_email (_tmp24_);
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp23_, _tmp25_);
#line 247 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp22_);
#line 249 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp26_ = commit;
#line 249 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp27_ = ggit_commit_get_message ((GgitCommit*) _tmp26_);
#line 249 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp28_ = _data11_->msg;
#line 249 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp27_, _tmp28_);
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp29_ = commit;
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp30_ = ggit_commit_get_subject ((GgitCommit*) _tmp29_);
#line 250 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp30_, "This is the commit");
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp32_ = ((GitgTestRepository*) self)->d_repository;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp33_ = gitg_repository_get_head (_tmp32_, &_inner_error_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp31_ = _tmp33_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2117 "test-commit.c"
	}
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp34_ = _tmp31_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp31_ = NULL;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp35_ = _tmp34_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp36_ = ggit_ref_get_target ((GgitRef*) _tmp35_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp37_ = _tmp36_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp38_ = ggit_oid_to_string (_tmp37_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp39_ = _tmp38_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp40_ = oid;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp41_ = ggit_oid_to_string (_tmp40_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp42_ = _tmp41_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp39_, _tmp42_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp42_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp39_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (_tmp37_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp35_);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp43_ = commit;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp44_ = ggit_commit_get_parents ((GgitCommit*) _tmp43_);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp45_ = _tmp44_;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp46_ = ggit_commit_parents_get_size (_tmp45_);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp47_ = _tmp46_;
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_uinteq (_tmp47_, (guint) 0);
#line 255 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp45_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp49_ = ((GitgTestRepository*) self)->d_repository;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp50_ = gitg_repository_lookup_reference (_tmp49_, "HEAD", &_inner_error_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp48_ = _tmp50_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp31_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2183 "test-commit.c"
	}
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp51_ = _tmp48_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp48_ = NULL;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp52_ = _tmp51_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp53_ = ggit_ref_get_log ((GgitRef*) _tmp52_, &_inner_error_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp54_ = _tmp53_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp52_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	reflog = _tmp54_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp48_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp31_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 257 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2215 "test-commit.c"
	}
#line 258 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp55_ = reflog;
#line 258 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp56_ = ggit_reflog_get_entry_from_index (_tmp55_, (guint) 0);
#line 258 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	entry = _tmp56_;
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp57_ = entry;
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp58_ = ggit_reflog_entry_get_new_id (_tmp57_);
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp59_ = _tmp58_;
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp60_ = ggit_oid_to_string (_tmp59_);
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp61_ = _tmp60_;
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp62_ = oid;
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp63_ = ggit_oid_to_string (_tmp62_);
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp64_ = _tmp63_;
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp61_, _tmp64_);
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp64_);
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp61_);
#line 260 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (_tmp59_);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp65_ = entry;
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp66_ = ggit_reflog_entry_get_message (_tmp65_);
#line 261 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp66_, "commit (amend): This is the commit");
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp67_ = _data11_->loop;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_tmp67_);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_ggit_reflog_entry_unref0 (entry);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_ggit_reflog_unref0 (reflog);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp48_);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp31_);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 238 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 2269 "test-commit.c"
}


static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__lambda14_ (self, source_object, res);
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block11_data_unref (self);
#line 2278 "test-commit.c"
}


static void lib_gitg_test_commit_real_test_amend (LibGitgTestCommit* self) {
	Block11Data* _data11_;
	GitgRepository* _tmp0_;
	GitgStage* _tmp1_;
	GitgStage* _tmp2_;
	GMainLoop* _tmp3_;
	GgitSignature* _tmp4_;
	GitgRef* _tmp5_;
	GitgRepository* _tmp6_;
	GitgRef* _tmp7_;
	GgitOId* headoid;
	GitgRef* _tmp8_;
	GitgRef* _tmp9_;
	GgitOId* _tmp10_;
	GgitOId* _tmp11_;
	GgitCommit* headc;
	GitgRepository* _tmp12_;
	GgitOId* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	GitgStage* _tmp16_;
	const gchar* _tmp17_;
	GgitCommit* _tmp18_;
	GgitSignature* _tmp19_;
	GgitSignature* _tmp20_;
	GgitSignature* _tmp21_;
	GMainLoop* _tmp22_;
	GError * _inner_error_ = NULL;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data11_->_ref_count_ = 1;
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data11_->self = g_object_ref (self);
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "a", "lala\n", "b", "for real\n", NULL);
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data11_->stage = _tmp2_;
#line 225 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 225 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data11_->loop = _tmp3_;
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data11_->sig = _tmp4_;
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block11_data_unref (_data11_);
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data11_ = NULL;
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 227 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2346 "test-commit.c"
	}
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = ((GitgTestRepository*) self)->d_repository;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = gitg_repository_get_head (_tmp6_, &_inner_error_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = _tmp7_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block11_data_unref (_data11_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data11_ = NULL;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2366 "test-commit.c"
	}
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _tmp5_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = NULL;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _tmp8_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = ggit_ref_get_target ((GgitRef*) _tmp9_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = _tmp10_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp9_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	headoid = _tmp11_;
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = ((GitgTestRepository*) self)->d_repository;
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = headoid;
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = gitg_repository_lookup (_tmp12_, ggit_commit_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp13_, &_inner_error_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	headc = (GgitCommit*) _tmp14_;
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (headoid);
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp5_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		block11_data_unref (_data11_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		_data11_ = NULL;
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2406 "test-commit.c"
	}
#line 233 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = g_strdup ("This is the commit\n\nWith a message.\n");
#line 233 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data11_->msg = _tmp15_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = _data11_->stage;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = _data11_->msg;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = headc;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = ggit_commit_get_author (_tmp18_);
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = _tmp19_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = _data11_->sig;
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_tmp16_, _tmp17_, _tmp20_, _tmp21_, GITG_STAGE_COMMIT_OPTIONS_AMEND, ___lambda14__gasync_ready_callback, block11_data_ref (_data11_));
#line 235 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp20_);
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = _data11_->loop;
#line 266 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_tmp22_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (headc);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (headoid);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp5_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	block11_data_unref (_data11_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	_data11_ = NULL;
#line 2442 "test-commit.c"
}


static void lib_gitg_test_commit_class_init (LibGitgTestCommitClass * klass) {
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	lib_gitg_test_commit_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	((GitgTestTestClass *) klass)->set_up = lib_gitg_test_commit_real_set_up;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	((LibGitgTestCommitClass *) klass)->test_commit = lib_gitg_test_commit_real_test_commit;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	((LibGitgTestCommitClass *) klass)->test_sign_off = lib_gitg_test_commit_real_test_sign_off;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	((LibGitgTestCommitClass *) klass)->test_pre_commit_hook = lib_gitg_test_commit_real_test_pre_commit_hook;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	((LibGitgTestCommitClass *) klass)->test_commit_msg_hook = lib_gitg_test_commit_real_test_commit_msg_hook;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	((LibGitgTestCommitClass *) klass)->test_skip_hooks = lib_gitg_test_commit_real_test_skip_hooks;
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	((LibGitgTestCommitClass *) klass)->test_amend = lib_gitg_test_commit_real_test_amend;
#line 2463 "test-commit.c"
	/**
	 * test commit.
	 */
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	lib_gitg_test_commit_signals[LIB_GITG_TEST_COMMIT_TEST_COMMIT_SIGNAL] = g_signal_new ("test_commit", LIB_GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestCommitClass, test_commit), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	lib_gitg_test_commit_signals[LIB_GITG_TEST_COMMIT_TEST_SIGN_OFF_SIGNAL] = g_signal_new ("test_sign_off", LIB_GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestCommitClass, test_sign_off), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	lib_gitg_test_commit_signals[LIB_GITG_TEST_COMMIT_TEST_PRE_COMMIT_HOOK_SIGNAL] = g_signal_new ("test_pre_commit_hook", LIB_GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestCommitClass, test_pre_commit_hook), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	lib_gitg_test_commit_signals[LIB_GITG_TEST_COMMIT_TEST_COMMIT_MSG_HOOK_SIGNAL] = g_signal_new ("test_commit_msg_hook", LIB_GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestCommitClass, test_commit_msg_hook), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	lib_gitg_test_commit_signals[LIB_GITG_TEST_COMMIT_TEST_SKIP_HOOKS_SIGNAL] = g_signal_new ("test_skip_hooks", LIB_GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestCommitClass, test_skip_hooks), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/mcatanzaro/Projects/GNOME/gitg/tests/libgitg/test-commit.vala"
	lib_gitg_test_commit_signals[LIB_GITG_TEST_COMMIT_TEST_AMEND_SIGNAL] = g_signal_new ("test_amend", LIB_GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibGitgTestCommitClass, test_amend), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2479 "test-commit.c"
}


static void lib_gitg_test_commit_instance_init (LibGitgTestCommit * self) {
}


GType lib_gitg_test_commit_get_type (void) {
	static volatile gsize lib_gitg_test_commit_type_id__volatile = 0;
	if (g_once_init_enter (&lib_gitg_test_commit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LibGitgTestCommitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lib_gitg_test_commit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibGitgTestCommit), 0, (GInstanceInitFunc) lib_gitg_test_commit_instance_init, NULL };
		GType lib_gitg_test_commit_type_id;
		lib_gitg_test_commit_type_id = g_type_register_static (GITG_TEST_TYPE_REPOSITORY, "LibGitgTestCommit", &g_define_type_info, 0);
		g_once_init_leave (&lib_gitg_test_commit_type_id__volatile, lib_gitg_test_commit_type_id);
	}
	return lib_gitg_test_commit_type_id__volatile;
}



