/* gitg-repository-list-box.c generated by valac 0.30.0.38-a55d, the Vala compiler
 * generated from gitg-repository-list-box.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Ignacio Casal Quinteiro
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>


#define GITG_TYPE_SELECTION_MODE (gitg_selection_mode_get_type ())

#define GITG_TYPE_REPOSITORY_LIST_BOX (gitg_repository_list_box_get_type ())
#define GITG_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox))
#define GITG_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))
#define GITG_IS_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_IS_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_REPOSITORY_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))

typedef struct _GitgRepositoryListBox GitgRepositoryListBox;
typedef struct _GitgRepositoryListBoxClass GitgRepositoryListBoxClass;
typedef struct _GitgRepositoryListBoxPrivate GitgRepositoryListBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_REPOSITORY_LIST_BOX_TYPE_ROW (gitg_repository_list_box_row_get_type ())
#define GITG_REPOSITORY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow))
#define GITG_REPOSITORY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))

typedef struct _GitgRepositoryListBoxRow GitgRepositoryListBoxRow;
typedef struct _GitgRepositoryListBoxRowClass GitgRepositoryListBoxRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GitgRepositoryListBoxRowPrivate GitgRepositoryListBoxRowPrivate;

#define GITG_TYPE_PROGRESS_BIN (gitg_progress_bin_get_type ())
#define GITG_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBin))
#define GITG_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))
#define GITG_IS_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PROGRESS_BIN))
#define GITG_IS_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PROGRESS_BIN))
#define GITG_PROGRESS_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))

typedef struct _GitgProgressBin GitgProgressBin;
typedef struct _GitgProgressBinClass GitgProgressBinClass;

typedef enum  {
	GITG_SELECTION_MODE_NORMAL,
	GITG_SELECTION_MODE_SELECTION
} GitgSelectionMode;

struct _GitgRepositoryListBox {
	GtkListBox parent_instance;
	GitgRepositoryListBoxPrivate * priv;
};

struct _GitgRepositoryListBoxClass {
	GtkListBoxClass parent_class;
};

struct _GitgRepositoryListBoxPrivate {
	gchar* d_filter_text;
	GitgSelectionMode _mode;
};

struct _Block16Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
	GFile* f;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _GitgRepositoryListBoxRow {
	GtkListBoxRow parent_instance;
	GitgRepositoryListBoxRowPrivate * priv;
};

struct _GitgRepositoryListBoxRowClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgRepositoryListBoxRowPrivate {
	GitgRepository* d_repository;
	GDateTime* d_time;
	gboolean d_loading;
	gboolean d_has_remote;
	GitgProgressBin* d_progress_bin;
	GtkImage* d_image;
	GtkLabel* d_repository_label;
	GtkLabel* d_branch_label;
	GtkArrow* d_arrow;
	GtkSpinner* d_spinner;
	GtkCheckButton* d_remove_check_button;
	GtkRevealer* d_remove_revealer;
	GtkBox* d_submodule_box;
	GitgSelectionMode d_mode;
	gchar* d_dirname;
	gchar* d_branch_name;
	gboolean _selected;
};


static gpointer gitg_repository_list_box_parent_class = NULL;
static gpointer gitg_repository_list_box_row_parent_class = NULL;
static GtkIconSize gitg_repository_list_box_row_s_icon_size;
static GtkIconSize gitg_repository_list_box_row_s_icon_size = 0;

GType gitg_selection_mode_get_type (void) G_GNUC_CONST;
GType gitg_repository_list_box_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_MODE,
	GITG_REPOSITORY_LIST_BOX_HAS_SELECTION
};
static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event);
GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self);
void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value);
GType gitg_repository_list_box_row_get_type (void) G_GNUC_CONST;
void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value);
static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row);
gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self);
GType gitg_repository_get_type (void) G_GNUC_CONST;
GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before);
static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row);
const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self);
static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b);
GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self);
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
GitgRepositoryListBoxRow* gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri);
static void gtk_recent_data_destroy (GtkRecentData* self);
void gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, GitgRepository* repository);
void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value);
void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value);
GitgRepositoryListBoxRow* gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self, GFile* location);
gchar* gitg_utils_replace_home_dir_with_tilde (GFile* file);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (const gchar* name, const gchar* dirname, const gchar* branch_name, gboolean has_remote);
GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, const gchar* name, const gchar* dirname, const gchar* branch_name, gboolean has_remote);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self);
gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self);
gchar* gitg_repository_get_name (GitgRepository* self);
static gint ____lambda63_ (Block16Data* _data16_, GgitSubmodule* module);
void gitg_repository_list_box_row_add_submodule (GitgRepositoryListBoxRow* self, GgitSubmodule* module);
static gint _____lambda63__ggit_submodule_callback (GgitSubmodule* submodule, const gchar* name, gpointer self);
static void ____lambda64_ (GitgRepositoryListBox* self);
static void _____lambda64__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ____lambda65_ (Block16Data* _data16_);
static void _____lambda65__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self);
void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value);
void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value);
void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text);
GitgRepositoryListBox* gitg_repository_list_box_new (void);
GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type);
GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1);
static void _vala_array_add14 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value);
gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
GType gitg_progress_bin_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_ROW_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_MODE,
	GITG_REPOSITORY_LIST_BOX_ROW_SELECTED,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY,
	GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE,
	GITG_REPOSITORY_LIST_BOX_ROW_TIME,
	GITG_REPOSITORY_LIST_BOX_ROW_FRACTION,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME,
	GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_LOADING,
	GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE
};
static void gitg_repository_list_box_row_update_branch_label (GitgRepositoryListBoxRow* self);
GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value);
void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value);
gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value);
void gitg_progress_bin_set_fraction (GitgProgressBin* self, gdouble value);
void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value);
const gchar* gitg_repository_list_box_row_get_dirname (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_dirname (GitgRepositoryListBoxRow* self, const gchar* value);
const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self);
gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self);
gboolean gitg_repository_list_box_row_get_has_remote (GitgRepositoryListBoxRow* self);
void gitg_repository_list_box_row_set_has_remote (GitgRepositoryListBoxRow* self, gboolean value);
static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gitg_repository_list_box_row_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gitg_repository_list_box_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType gitg_selection_mode_get_type (void) {
	static volatile gsize gitg_selection_mode_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_selection_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_SELECTION_MODE_NORMAL, "GITG_SELECTION_MODE_NORMAL", "normal"}, {GITG_SELECTION_MODE_SELECTION, "GITG_SELECTION_MODE_SELECTION", "selection"}, {0, NULL, NULL}};
		GType gitg_selection_mode_type_id;
		gitg_selection_mode_type_id = g_enum_register_static ("GitgSelectionMode", values);
		g_once_init_leave (&gitg_selection_mode_type_id__volatile, gitg_selection_mode_type_id);
	}
	return gitg_selection_mode_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 313 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GitgRepositoryListBox * self;
	gboolean result = FALSE;
	GdkEvent* ev = NULL;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GdkEvent* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GdkEventButton* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
#line 275 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 275 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = event;
#line 277 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	ev = (GdkEvent*) _tmp0_;
#line 279 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = ev;
#line 279 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gdk_event_triggers_context_menu (_tmp2_);
#line 279 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp3_) {
#line 341 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp4_ = 0;
#line 279 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->_mode;
#line 279 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _tmp4_ == GITG_SELECTION_MODE_NORMAL;
#line 347 "gitg-repository-list-box.c"
	} else {
#line 279 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = FALSE;
#line 351 "gitg-repository-list-box.c"
	}
#line 279 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_) {
#line 355 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* row = NULL;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		GtkListBoxRow* _tmp7_ = NULL;
		GitgRepositoryListBoxRow* _tmp8_ = NULL;
		GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 281 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, GITG_SELECTION_MODE_SELECTION);
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = event;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_->y;
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, (gint) _tmp6_);
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW) ? ((GitgRepositoryListBoxRow*) _tmp7_) : NULL);
#line 283 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		row = _tmp8_;
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = row;
#line 285 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp9_ != NULL) {
#line 378 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp10_ = NULL;
#line 287 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = row;
#line 287 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_selected (_tmp10_, TRUE);
#line 384 "gitg-repository-list-box.c"
		}
#line 290 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		result = TRUE;
#line 290 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (row);
#line 290 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return result;
#line 392 "gitg-repository-list-box.c"
	}
#line 293 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp11_ = event;
#line 293 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp12_ = GTK_WIDGET_CLASS (gitg_repository_list_box_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp11_);
#line 293 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp12_;
#line 293 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 402 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row) {
	GitgRepositoryListBox * self;
	GitgRepositoryListBoxRow* r = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgSelectionMode _tmp2_ = 0;
	GitgRepositoryListBoxRow* _tmp7_ = NULL;
	GitgRepository* _tmp8_ = NULL;
	GitgRepository* _tmp9_ = NULL;
#line 296 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 296 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 298 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 298 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 298 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	r = _tmp1_;
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->_mode;
#line 300 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ == GITG_SELECTION_MODE_SELECTION) {
#line 429 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp3_ = NULL;
		GitgRepositoryListBoxRow* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 302 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = r;
#line 302 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = r;
#line 302 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 302 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_;
#line 302 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (_tmp3_, !_tmp6_);
#line 303 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (r);
#line 303 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 448 "gitg-repository-list-box.c"
	}
#line 306 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = r;
#line 306 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = gitg_repository_list_box_row_get_repository (_tmp7_);
#line 306 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = _tmp8_;
#line 306 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp9_ != NULL) {
#line 458 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp10_ = NULL;
		GitgRepository* _tmp11_ = NULL;
		GitgRepository* _tmp12_ = NULL;
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = r;
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = gitg_repository_list_box_row_get_repository (_tmp10_);
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = _tmp11_;
#line 308 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "repository-activated", _tmp12_);
#line 470 "gitg-repository-list-box.c"
	}
#line 296 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (r);
#line 474 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkSeparator* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
#line 324 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 324 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = before;
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 490 "gitg-repository-list-box.c"
		GtkSeparator* _tmp2_ = NULL;
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp2_);
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp2_;
#line 500 "gitg-repository-list-box.c"
	} else {
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = NULL;
#line 506 "gitg-repository-list-box.c"
	}
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = row;
#line 326 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_row_set_header (_tmp3_, (GtkWidget*) _tmp0_);
#line 324 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp0_);
#line 514 "gitg-repository-list-box.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 534 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 329 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 329 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (row != NULL, FALSE);
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_filter_text;
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 550 "gitg-repository-list-box.c"
		GtkListBoxRow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = row;
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = gitg_repository_list_box_row_get_repository_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_filter_text;
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = string_contains (_tmp4_, _tmp5_);
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp6_;
#line 568 "gitg-repository-list-box.c"
	} else {
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 572 "gitg-repository-list-box.c"
	}
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 331 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 578 "gitg-repository-list-box.c"
}


static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 334 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 334 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 334 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = a;
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = b;
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_date_time_compare (_tmp2_, _tmp5_);
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = -_tmp6_;
#line 336 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 615 "gitg-repository-list-box.c"
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? gtk_recent_info_ref (self) : NULL;
#line 622 "gitg-repository-list-box.c"
}


static void _gtk_recent_info_unref0_ (gpointer var) {
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
#line 629 "gitg-repository-list-box.c"
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_free (self);
#line 638 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GList* reversed_items = NULL;
	GtkRecentManager* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 341 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 342 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = recent_manager;
#line 342 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
#line 342 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = _tmp3_;
#line 343 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = g_list_reverse (reversed_items);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = reversed_items;
#line 669 "gitg-repository-list-box.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		item_collection = _tmp4_;
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 677 "gitg-repository-list-box.c"
			GtkRecentInfo* _tmp5_ = NULL;
			GtkRecentInfo* item = NULL;
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			item = _tmp5_;
#line 684 "gitg-repository-list-box.c"
			{
				GtkRecentInfo* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = item;
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = gtk_recent_info_has_group (_tmp6_, "gitg");
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp7_) {
#line 694 "gitg-repository-list-box.c"
					GFile* repo_file = NULL;
					GtkRecentInfo* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					GFile* _tmp10_ = NULL;
					GitgRepository* repo = NULL;
					GitgRepository* _tmp18_ = NULL;
					GitgRepositoryListBoxRow* _tmp19_ = NULL;
					GitgRepositoryListBoxRow* _tmp20_ = NULL;
#line 349 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = item;
#line 349 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = gtk_recent_info_get_uri (_tmp8_);
#line 349 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 349 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					repo_file = _tmp10_;
#line 711 "gitg-repository-list-box.c"
					{
						GitgRepository* _tmp11_ = NULL;
						GFile* _tmp12_ = NULL;
						GitgRepository* _tmp13_ = NULL;
						GitgRepository* _tmp14_ = NULL;
#line 354 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp12_ = repo_file;
#line 354 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp13_ = gitg_repository_new (_tmp12_, NULL, &_inner_error_);
#line 354 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = _tmp13_;
#line 354 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 725 "gitg-repository-list-box.c"
							goto __catch46_g_error;
						}
#line 354 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp14_ = _tmp11_;
#line 354 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = NULL;
#line 354 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 354 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						repo = _tmp14_;
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (_tmp11_);
#line 738 "gitg-repository-list-box.c"
					}
					goto __finally46;
					__catch46_g_error:
					{
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 747 "gitg-repository-list-box.c"
						{
							GtkRecentManager* _tmp15_ = NULL;
							GtkRecentInfo* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
#line 360 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp15_ = recent_manager;
#line 360 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp16_ = item;
#line 360 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp17_ = gtk_recent_info_get_uri (_tmp16_);
#line 360 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_recent_manager_remove_item (_tmp15_, _tmp17_, &_inner_error_);
#line 360 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 762 "gitg-repository-list-box.c"
								goto __catch47_g_error;
							}
						}
						goto __finally47;
						__catch47_g_error:
						{
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_inner_error_ = NULL;
#line 773 "gitg-repository-list-box.c"
						}
						__finally47:
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo_file);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_gtk_recent_info_unref0 (item);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (recent_manager);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 358 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							return;
#line 794 "gitg-repository-list-box.c"
						}
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 363 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						continue;
#line 804 "gitg-repository-list-box.c"
					}
					__finally46:
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 352 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 825 "gitg-repository-list-box.c"
					}
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp18_ = repo;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp19_ = gitg_repository_list_box_add_repository (self, _tmp18_);
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp20_ = _tmp19_;
#line 366 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (_tmp20_);
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 347 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo_file);
#line 839 "gitg-repository-list-box.c"
				}
#line 345 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_gtk_recent_info_unref0 (item);
#line 843 "gitg-repository-list-box.c"
			}
		}
	}
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 339 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 851 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GList* _tmp0_ = NULL;
#line 371 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 371 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 373 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	row = NULL;
#line 375 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 867 "gitg-repository-list-box.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 375 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		child_collection = _tmp0_;
#line 375 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 875 "gitg-repository-list-box.c"
			GtkWidget* child = NULL;
#line 375 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			child = (GtkWidget*) child_it->data;
#line 879 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* d = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepository* _tmp4_ = NULL;
				GitgRepository* _tmp5_ = NULL;
				GFile* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
				GitgRepository* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = child;
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 377 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				d = _tmp2_;
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = d;
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_repository (_tmp3_);
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = _tmp6_;
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp8_ = repository;
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp9_ = ggit_repository_get_location ((GgitRepository*) _tmp8_);
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp10_ = _tmp9_;
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp11_ = g_file_equal (_tmp7_, _tmp10_);
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp12_ = _tmp11_;
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp10_);
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp7_);
#line 379 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp12_) {
#line 926 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow* _tmp13_ = NULL;
					GitgRepositoryListBoxRow* _tmp14_ = NULL;
#line 381 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp13_ = d;
#line 381 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 381 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (row);
#line 381 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					row = _tmp14_;
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (d);
#line 382 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					break;
#line 941 "gitg-repository-list-box.c"
				}
#line 375 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (d);
#line 945 "gitg-repository-list-box.c"
			}
		}
#line 375 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (child_collection);
#line 950 "gitg-repository-list-box.c"
	}
#line 386 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 386 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 956 "gitg-repository-list-box.c"
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).display_name);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).description);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).mime_type);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_name);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_exec);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
#line 973 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GtkRecentData item = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkRecentData _tmp10_ = {0};
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (uri != NULL);
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 391 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 392 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	memset (&item, 0, sizeof (GtkRecentData));
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_get_application_name ();
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_name);
#line 394 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_name = _tmp3_;
#line 395 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_strdup ("inode/directory");
#line 395 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.mime_type);
#line 395 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.mime_type = _tmp4_;
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = g_get_prgname ();
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_strjoin (" ", _tmp5_, "%f", NULL);
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_exec);
#line 396 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_exec = _tmp6_;
#line 397 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = g_strdup ("gitg");
#line 397 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = g_new0 (gchar*, 2 + 1);
#line 397 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[0] = _tmp7_;
#line 397 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[1] = NULL;
#line 397 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = (_vala_array_free (item.groups, _vala_array_length (item.groups), (GDestroyNotify) g_free), NULL);
#line 397 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = _tmp8_;
#line 399 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = uri;
#line 399 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = item;
#line 399 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_manager_add_full (recent_manager, _tmp9_, &_tmp10_);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_data_destroy (&item);
#line 389 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 1047 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_end_cloning (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, GitgRepository* repository) {
	GitgRepository* _tmp0_ = NULL;
#line 402 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 402 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != NULL) {
#line 1061 "gitg-repository-list-box.c"
		GFile* workdir = NULL;
		GitgRepository* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* repo_file = NULL;
		GitgRepository* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* uri = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GitgRepositoryListBoxRow* _tmp13_ = NULL;
		GitgRepository* _tmp14_ = NULL;
		GitgRepositoryListBoxRow* _tmp15_ = NULL;
#line 406 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = repository;
#line 406 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _tmp1_);
#line 406 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		workdir = _tmp2_;
#line 407 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = repository;
#line 407 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = ggit_repository_get_location ((GgitRepository*) _tmp3_);
#line 407 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		repo_file = _tmp4_;
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = workdir;
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp6_ != NULL) {
#line 1092 "gitg-repository-list-box.c"
			GFile* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = workdir;
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = g_file_get_uri (_tmp7_);
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp5_);
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _tmp8_;
#line 1103 "gitg-repository-list-box.c"
		} else {
			GFile* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = repo_file;
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = g_file_get_uri (_tmp9_);
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp5_);
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _tmp10_;
#line 1115 "gitg-repository-list-box.c"
		}
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = g_strdup (_tmp5_);
#line 409 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		uri = _tmp11_;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = uri;
#line 410 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp12_);
#line 412 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = row;
#line 412 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = repository;
#line 412 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (_tmp13_, _tmp14_);
#line 413 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = row;
#line 413 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (_tmp15_, FALSE);
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (uri);
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp5_);
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (repo_file);
#line 404 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (workdir);
#line 1143 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp16_ = NULL;
#line 417 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = row;
#line 417 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp16_);
#line 1150 "gitg-repository-list-box.c"
	}
}


GitgRepositoryListBoxRow* gitg_repository_list_box_begin_cloning (GitgRepositoryListBox* self, GFile* location) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GitgRepositoryListBoxRow* _tmp9_ = NULL;
	GitgRepositoryListBoxRow* _tmp10_ = NULL;
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 421 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = location;
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_file_get_basename (_tmp0_);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = location;
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_file_get_parent (_tmp3_);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = gitg_utils_replace_home_dir_with_tilde (_tmp5_);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = _tmp6_;
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = _ ("Cloning…");
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = gitg_repository_list_box_row_new (_tmp2_, _tmp7_, _tmp8_, TRUE);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp9_);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = _tmp9_;
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp7_);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp5_);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp2_);
#line 423 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	row = _tmp10_;
#line 425 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_loading (row, TRUE);
#line 426 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) row);
#line 428 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) row);
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 429 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1215 "gitg-repository-list-box.c"
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return _data16_;
#line 1224 "gitg-repository-list-box.c"
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 1233 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data16_->self;
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->f);
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->row);
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block16Data, _data16_);
#line 1245 "gitg-repository-list-box.c"
	}
}


static gint ____lambda63_ (Block16Data* _data16_, GgitSubmodule* module) {
	GitgRepositoryListBox* self;
	gint result = 0;
	GitgRepositoryListBoxRow* _tmp0_ = NULL;
	GgitSubmodule* _tmp1_ = NULL;
#line 463 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data16_->self;
#line 463 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (module != NULL, 0);
#line 464 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = _data16_->row;
#line 464 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = module;
#line 464 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_add_submodule (_tmp0_, _tmp1_);
#line 465 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = 0;
#line 465 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1269 "gitg-repository-list-box.c"
}


static gint _____lambda63__ggit_submodule_callback (GgitSubmodule* submodule, const gchar* name, gpointer self) {
	gint result;
	result = ____lambda63_ (self, submodule);
#line 463 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1278 "gitg-repository-list-box.c"
}


static void ____lambda64_ (GitgRepositoryListBox* self) {
#line 480 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject*) self, "has-selection");
#line 1285 "gitg-repository-list-box.c"
}


static void _____lambda64__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 479 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda64_ ((GitgRepositoryListBox*) self);
#line 1292 "gitg-repository-list-box.c"
}


static void ____lambda65_ (Block16Data* _data16_) {
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 483 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data16_->self;
#line 1302 "gitg-repository-list-box.c"
	{
		GtkRecentManager* recent_manager = NULL;
		GtkRecentManager* _tmp0_ = NULL;
		GtkRecentManager* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 486 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = gtk_recent_manager_get_default ();
#line 486 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 486 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		recent_manager = _tmp1_;
#line 487 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _data16_->f;
#line 487 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = g_file_get_uri (_tmp2_);
#line 487 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 487 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_recent_manager_remove_item (recent_manager, _tmp4_, &_inner_error_);
#line 487 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp4_);
#line 487 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 487 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (recent_manager);
#line 1330 "gitg-repository-list-box.c"
			goto __catch50_g_error;
		}
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (recent_manager);
#line 1335 "gitg-repository-list-box.c"
	}
	goto __finally50;
	__catch50_g_error:
	{
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 1344 "gitg-repository-list-box.c"
	}
	__finally50:
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 484 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 1355 "gitg-repository-list-box.c"
	}
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _data16_->row;
#line 490 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp5_);
#line 1361 "gitg-repository-list-box.c"
}


static void _____lambda65__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self) {
#line 483 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda65_ (self);
#line 1368 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	Block16Data* _data16_;
	GitgRepository* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp14_ = NULL;
	GitgRepositoryListBoxRow* _tmp15_ = NULL;
	GFile* _tmp68_ = NULL;
	GitgRepositoryListBoxRow* _tmp72_ = NULL;
	GitgRepositoryListBoxRow* _tmp73_ = NULL;
	GError * _inner_error_ = NULL;
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->_ref_count_ = 1;
#line 432 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->self = g_object_ref (self);
#line 434 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 434 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_get_row_for_repository (self, _tmp0_);
#line 434 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->row = _tmp1_;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = repository;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_get ((GgitRepository*) _tmp3_, "workdir", &_tmp4_, NULL);
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = _tmp6_ != NULL;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp6_);
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp7_) {
#line 1419 "gitg-repository-list-box.c"
		GitgRepository* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = repository;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp8_, "workdir", &_tmp9_, NULL);
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = _tmp9_;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp10_;
#line 1433 "gitg-repository-list-box.c"
	} else {
		GitgRepository* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = repository;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = ggit_repository_get_location ((GgitRepository*) _tmp11_);
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = _tmp12_;
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp13_;
#line 1448 "gitg-repository-list-box.c"
	}
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = _g_object_ref0 (_tmp2_);
#line 436 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_->f = _tmp14_;
#line 438 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = _data16_->row;
#line 438 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp15_ == NULL) {
#line 1458 "gitg-repository-list-box.c"
		gchar* head_name = NULL;
		gchar* _tmp16_ = NULL;
		gboolean has_remote = FALSE;
		GFile* _tmp29_ = NULL;
		GitgRepository* _tmp30_ = NULL;
		GFile* _tmp31_ = NULL;
		GFile* _tmp32_ = NULL;
		GFile* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		gchar* dirname = NULL;
		GFile* _tmp41_ = NULL;
		GFile* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		GitgRepository* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
		GitgRepositoryListBoxRow* _tmp52_ = NULL;
		GitgRepositoryListBoxRow* _tmp53_ = NULL;
		GitgRepository* _tmp54_ = NULL;
		GitgRepositoryListBoxRow* _tmp55_ = NULL;
		GFile* _tmp57_ = NULL;
		GFile* _tmp59_ = NULL;
		GitgRepositoryListBoxRow* _tmp64_ = NULL;
#line 440 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = g_strdup ("");
#line 440 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		head_name = _tmp16_;
#line 441 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		has_remote = TRUE;
#line 1493 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp17_ = NULL;
			GitgRef* _tmp18_ = NULL;
			GitgRef* _tmp19_ = NULL;
			GitgParsedRefName* _tmp20_ = NULL;
			GitgParsedRefName* _tmp21_ = NULL;
			GitgParsedRefName* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar** remotes = NULL;
			GitgRepository* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gchar** _tmp27_ = NULL;
			gint remotes_length1 = 0;
			gint _remotes_size_ = 0;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp17_ = repository;
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp18_ = gitg_repository_get_head (_tmp17_, &_inner_error_);
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp18_;
#line 445 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1520 "gitg-repository-list-box.c"
				goto __catch48_g_error;
			}
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp19_ = head;
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp20_ = gitg_ref_get_parsed_name (_tmp19_);
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp21_ = _tmp20_;
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp22_ = _tmp21_;
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp23_ = gitg_parsed_ref_name_get_shortname (_tmp22_);
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp24_ = _tmp23_;
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			head_name = _tmp24_;
#line 446 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp22_);
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp25_ = repository;
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp27_ = _tmp26_ = ggit_repository_list_remotes ((GgitRepository*) _tmp25_, &_inner_error_);
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			remotes = _tmp27_;
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			remotes_length1 = _vala_array_length (_tmp26_);
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_remotes_size_ = remotes_length1;
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 448 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (head);
#line 1555 "gitg-repository-list-box.c"
				goto __catch48_g_error;
			}
#line 450 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp28_ = remotes;
#line 450 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp28__length1 = remotes_length1;
#line 450 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (_tmp28__length1 == 0) {
#line 452 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				has_remote = FALSE;
#line 1566 "gitg-repository-list-box.c"
			}
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			remotes = (_vala_array_free (remotes, remotes_length1, (GDestroyNotify) g_free), NULL);
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 1572 "gitg-repository-list-box.c"
		}
		goto __finally48;
		__catch48_g_error:
		{
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 1581 "gitg-repository-list-box.c"
		}
		__finally48:
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp2_);
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			block16_data_unref (_data16_);
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_data16_ = NULL;
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 443 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			return NULL;
#line 1600 "gitg-repository-list-box.c"
		}
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp30_ = repository;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp30_, "workdir", &_tmp31_, NULL);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp32_ = _tmp31_;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp33_ = _tmp32_;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp34_ = _tmp33_ != NULL;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp33_);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp34_) {
#line 1616 "gitg-repository-list-box.c"
			GitgRepository* _tmp35_ = NULL;
			GFile* _tmp36_ = NULL;
			GFile* _tmp37_ = NULL;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp35_ = repository;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_object_get ((GgitRepository*) _tmp35_, "workdir", &_tmp36_, NULL);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp37_ = _tmp36_;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp29_);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp29_ = _tmp37_;
#line 1630 "gitg-repository-list-box.c"
		} else {
			GitgRepository* _tmp38_ = NULL;
			GFile* _tmp39_ = NULL;
			GFile* _tmp40_ = NULL;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp38_ = repository;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp39_ = ggit_repository_get_location ((GgitRepository*) _tmp38_);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp40_ = _tmp39_;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp29_);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp29_ = _tmp40_;
#line 1645 "gitg-repository-list-box.c"
		}
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp41_ = g_file_get_parent (_tmp29_);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp42_ = _tmp41_;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp43_ = gitg_utils_replace_home_dir_with_tilde (_tmp42_);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp44_ = _tmp43_;
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp42_);
#line 456 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		dirname = _tmp44_;
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp45_ = repository;
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp46_ = gitg_repository_get_name (_tmp45_);
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp47_ = _tmp46_;
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp48_ = _tmp47_;
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp49_ = dirname;
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp50_ = head_name;
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp51_ = has_remote;
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp52_ = gitg_repository_list_box_row_new (_tmp48_, _tmp49_, _tmp50_, _tmp51_);
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp52_);
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data16_->row);
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data16_->row = _tmp52_;
#line 457 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp48_);
#line 458 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp53_ = _data16_->row;
#line 458 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp54_ = repository;
#line 458 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (_tmp53_, _tmp54_);
#line 459 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp55_ = _data16_->row;
#line 459 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp55_);
#line 1693 "gitg-repository-list-box.c"
		{
			GitgRepository* _tmp56_ = NULL;
#line 463 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp56_ = repository;
#line 463 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			ggit_repository_submodule_foreach ((GgitRepository*) _tmp56_, _____lambda63__ggit_submodule_callback, _data16_, &_inner_error_);
#line 463 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1702 "gitg-repository-list-box.c"
				goto __catch49_g_error;
			}
		}
		goto __finally49;
		__catch49_g_error:
		{
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 1713 "gitg-repository-list-box.c"
		}
		__finally49:
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (dirname);
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp29_);
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp2_);
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			block16_data_unref (_data16_);
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_data16_ = NULL;
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 461 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			return NULL;
#line 1736 "gitg-repository-list-box.c"
		}
#line 470 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp57_ = _data16_->f;
#line 470 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp57_ != NULL) {
#line 1742 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp58_ = NULL;
#line 472 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp58_ = _data16_->row;
#line 472 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _tmp58_, "mode", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 1748 "gitg-repository-list-box.c"
		}
#line 477 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp59_ = _data16_->f;
#line 477 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp59_ != NULL) {
#line 1754 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp60_ = NULL;
			GitgRepositoryListBoxRow* _tmp61_ = NULL;
			GitgRepositoryListBoxRow* _tmp62_ = NULL;
#line 479 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp60_ = _data16_->row;
#line 479 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_object ((GObject*) _tmp60_, "notify::selected", (GCallback) _____lambda64__g_object_notify, self, 0);
#line 483 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp61_ = _data16_->row;
#line 483 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_data (_tmp61_, "request-remove", (GCallback) _____lambda65__gitg_repository_list_box_row_request_remove, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 493 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp62_ = _data16_->row;
#line 493 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp62_, TRUE);
#line 1770 "gitg-repository-list-box.c"
		} else {
			GitgRepositoryListBoxRow* _tmp63_ = NULL;
#line 497 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp63_ = _data16_->row;
#line 497 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp63_, FALSE);
#line 1777 "gitg-repository-list-box.c"
		}
#line 500 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp64_ = _data16_->row;
#line 500 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp64_);
#line 438 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (dirname);
#line 438 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp29_);
#line 438 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (head_name);
#line 1789 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp65_ = NULL;
		GDateTime* _tmp66_ = NULL;
		GDateTime* _tmp67_ = NULL;
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp65_ = _data16_->row;
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp66_ = g_date_time_new_now_local ();
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp67_ = _tmp66_;
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (_tmp65_, _tmp67_);
#line 505 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_date_time_unref0 (_tmp67_);
#line 506 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_list_box_invalidate_sort ((GtkListBox*) self);
#line 1806 "gitg-repository-list-box.c"
	}
#line 509 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp68_ = _data16_->f;
#line 509 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp68_ != NULL) {
#line 1812 "gitg-repository-list-box.c"
		GFile* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
#line 511 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp69_ = _data16_->f;
#line 511 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp70_ = g_file_get_uri (_tmp69_);
#line 511 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp71_ = _tmp70_;
#line 511 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp71_);
#line 511 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp71_);
#line 1826 "gitg-repository-list-box.c"
	}
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp72_ = _data16_->row;
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp73_ = _g_object_ref0 (_tmp72_);
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp73_;
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp2_);
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	block16_data_unref (_data16_);
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data16_ = NULL;
#line 514 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1842 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 555 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 557 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = text;
#line 557 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 557 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 557 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_filter_text = _tmp1_;
#line 559 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
#line 1861 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type) {
	GitgRepositoryListBox * self = NULL;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) g_object_new (object_type, NULL);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 1871 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_new (void) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_construct (GITG_TYPE_REPOSITORY_LIST_BOX);
#line 1878 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_get_mode (GitgRepositoryListBox* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_mode;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1893 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_set_mode (GitgRepositoryListBox* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_mode = _tmp0_;
#line 273 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 1907 "gitg-repository-list-box.c"
}


static void _vala_array_add14 (GitgRepositoryListBoxRow*** array, int* length, int* size, GitgRepositoryListBoxRow* value) {
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if ((*length) == (*size)) {
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		*array = g_renew (GitgRepositoryListBoxRow*, *array, (*size) + 1);
#line 1918 "gitg-repository-list-box.c"
	}
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[(*length)++] = value;
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(*array)[*length] = NULL;
#line 1924 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow** gitg_repository_list_box_get_selection (GitgRepositoryListBox* self, int* result_length1) {
	GitgRepositoryListBoxRow** result;
	GitgRepositoryListBoxRow** ret = NULL;
	GitgRepositoryListBoxRow** _tmp0_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GList* _tmp1_ = NULL;
	GitgRepositoryListBoxRow** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 519 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 521 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_new0 (GitgRepositoryListBoxRow*, 0 + 1);
#line 521 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	ret = _tmp0_;
#line 521 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	ret_length1 = 0;
#line 521 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_ret_size_ = ret_length1;
#line 523 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
#line 1949 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 523 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp1_;
#line 523 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 1957 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 523 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 1961 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepositoryListBoxRow* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
#line 525 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = row;
#line 525 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 525 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp3_;
#line 527 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = r;
#line 527 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = gitg_repository_list_box_row_get_selected (_tmp4_);
#line 527 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = _tmp5_;
#line 527 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp6_) {
#line 1983 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					GitgRepositoryListBoxRow* _tmp8_ = NULL;
					GitgRepositoryListBoxRow* _tmp9_ = NULL;
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7_ = ret;
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp7__length1 = ret_length1;
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = r;
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = _g_object_ref0 (_tmp8_);
#line 529 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_vala_array_add14 (&ret, &ret_length1, &_ret_size_, _tmp9_);
#line 1998 "gitg-repository-list-box.c"
				}
#line 523 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 2002 "gitg-repository-list-box.c"
			}
		}
#line 523 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 2007 "gitg-repository-list-box.c"
	}
#line 533 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = ret;
#line 533 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10__length1 = ret_length1;
#line 533 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (result_length1) {
#line 533 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		*result_length1 = _tmp10__length1;
#line 2017 "gitg-repository-list-box.c"
	}
#line 533 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp10_;
#line 533 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2023 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_get_has_selection (GitgRepositoryListBox* self) {
	gboolean result;
	GList* _tmp0_ = NULL;
#line 539 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 541 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 2034 "gitg-repository-list-box.c"
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
#line 541 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		row_collection = _tmp0_;
#line 541 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
#line 2042 "gitg-repository-list-box.c"
			GtkWidget* row = NULL;
#line 541 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			row = (GtkWidget*) row_it->data;
#line 2046 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* r = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
#line 543 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = row;
#line 543 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 543 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				r = _tmp2_;
#line 545 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = r;
#line 545 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_selected (_tmp3_);
#line 545 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 545 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp5_) {
#line 547 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					result = TRUE;
#line 547 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (r);
#line 547 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_list_free0 (row_collection);
#line 547 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					return result;
#line 2076 "gitg-repository-list-box.c"
				}
#line 541 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (r);
#line 2080 "gitg-repository-list-box.c"
			}
		}
#line 541 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (row_collection);
#line 2085 "gitg-repository-list-box.c"
	}
#line 551 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = FALSE;
#line 551 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2091 "gitg-repository-list-box.c"
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (n_param_values == 3);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = closure->data;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = param_values->data[0].v_pointer;
#line 2110 "gitg-repository-list-box.c"
	} else {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = param_values->data[0].v_pointer;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = closure->data;
#line 2116 "gitg-repository-list-box.c"
	}
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 2122 "gitg-repository-list-box.c"
}


static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
#line 314 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_update_header ((GitgRepositoryListBox*) self, row, before);
#line 2129 "gitg-repository-list-box.c"
}


static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_filter ((GitgRepositoryListBox*) self, row);
#line 315 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2138 "gitg-repository-list-box.c"
}


static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = gitg_repository_list_box_compare_widgets ((GitgRepositoryListBox*) self, row1, row2);
#line 316 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2147 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBox * self;
#line 312 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_parent_class);
#line 312 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 312 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 314 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_header_func ((GtkListBox*) self, _gitg_repository_list_box_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
#line 315 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_filter_func ((GtkListBox*) self, _gitg_repository_list_box_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
#line 316 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
#line 317 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 319 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
#line 321 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_add_recent_info (self);
#line 312 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 2175 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_update_branch_label (GitgRepositoryListBoxRow* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 170 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_branch_name;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ == NULL) {
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 2190 "gitg-repository-list-box.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_branch_name;
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 2197 "gitg-repository-list-box.c"
	}
#line 172 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_) {
#line 2201 "gitg-repository-list-box.c"
		GtkLabel* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_branch_label;
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _ ("at %s");
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_dirname;
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_);
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = _tmp6_;
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_label_set_label (_tmp3_, _tmp7_);
#line 175 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp7_);
#line 2221 "gitg-repository-list-box.c"
	} else {
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_ = NULL;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = self->priv->d_dirname;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp9_ == NULL) {
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = TRUE;
#line 2231 "gitg-repository-list-box.c"
		} else {
			const gchar* _tmp10_ = NULL;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = self->priv->d_dirname;
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = g_strcmp0 (_tmp10_, "") == 0;
#line 2238 "gitg-repository-list-box.c"
		}
#line 177 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp8_) {
#line 2242 "gitg-repository-list-box.c"
			GtkLabel* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = self->priv->d_branch_label;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp12_ = self->priv->d_branch_name;
#line 179 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gtk_label_set_label (_tmp11_, _tmp12_);
#line 2251 "gitg-repository-list-box.c"
		} else {
			GtkLabel* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp13_ = self->priv->d_branch_label;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp14_ = _ ("%s at %s");
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp15_ = self->priv->d_branch_name;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp16_ = self->priv->d_dirname;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp17_ = g_strdup_printf (_tmp14_, _tmp15_, _tmp16_);
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp18_ = _tmp17_;
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gtk_label_set_label (_tmp13_, _tmp18_);
#line 184 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp18_);
#line 2275 "gitg-repository-list-box.c"
		}
	}
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, const gchar* name, const gchar* dirname, const gchar* branch_name, gboolean has_remote) {
	GitgRepositoryListBoxRow * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (dirname != NULL, NULL);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (branch_name != NULL, NULL);
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = name;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = dirname;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = branch_name;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = has_remote;
#line 225 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxRow*) g_object_new (object_type, "repository-name", _tmp0_, "dirname", _tmp1_, "branch-name", _tmp2_, "has-remote", _tmp3_, NULL);
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 2305 "gitg-repository-list-box.c"
}


GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (const gchar* name, const gchar* dirname, const gchar* branch_name, gboolean has_remote) {
#line 223 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_row_construct (GITG_REPOSITORY_LIST_BOX_TYPE_ROW, name, dirname, branch_name, has_remote);
#line 2312 "gitg-repository-list-box.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1314 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	result = self;
#line 1315 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 2324 "gitg-repository-list-box.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2357 "gitg-repository-list-box.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2366 "gitg-repository-list-box.c"
	}
#line 1235 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2372 "gitg-repository-list-box.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2381 "gitg-repository-list-box.c"
	}
#line 1238 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2387 "gitg-repository-list-box.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2396 "gitg-repository-list-box.c"
	} else {
#line 1238 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2400 "gitg-repository-list-box.c"
	}
#line 1238 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 2408 "gitg-repository-list-box.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 2417 "gitg-repository-list-box.c"
	} else {
#line 1239 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 2421 "gitg-repository-list-box.c"
	}
#line 1239 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/opt/gnome/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 2443 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_add_submodule (GitgRepositoryListBoxRow* self, GgitSubmodule* module) {
	gchar* submodule_url = NULL;
	GgitSubmodule* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp4_ = NULL;
	gchar* tip = NULL;
	GgitSubmodule* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkImage* icon = NULL;
	GtkImage* _tmp14_ = NULL;
	GtkImage* _tmp15_ = NULL;
	gchar* name = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GtkLabel* labelName = NULL;
	const gchar* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkArrow* arrow = NULL;
	GtkArrow* _tmp25_ = NULL;
	GtkArrow* _tmp26_ = NULL;
	gchar* path = NULL;
	GgitSubmodule* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GtkLabel* labelPath = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkImage* _tmp39_ = NULL;
	GtkBox* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	GtkBox* _tmp42_ = NULL;
	GtkArrow* _tmp43_ = NULL;
	GtkBox* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkBox* _tmp46_ = NULL;
	GtkBox* _tmp47_ = NULL;
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (module != NULL);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = module;
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = ggit_submodule_get_url (_tmp0_);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 230 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	submodule_url = _tmp2_;
#line 231 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = submodule_url;
#line 231 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp3_ == NULL) {
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (submodule_url);
#line 233 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 2523 "gitg-repository-list-box.c"
	}
#line 236 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
#line 236 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp4_);
#line 236 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	box = _tmp4_;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = module;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = ggit_submodule_get_path (_tmp5_);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = string_to_string (_tmp6_);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = submodule_url;
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = string_to_string (_tmp8_);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = g_strconcat (_tmp7_, "/ (", _tmp9_, ")", NULL);
#line 237 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	tip = _tmp10_;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp11_ = box;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp12_ = tip;
#line 239 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp12_);
#line 240 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp13_ = box;
#line 240 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp13_);
#line 242 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = (GtkImage*) gtk_image_new_from_icon_name ("folder-remote-symbolic", GTK_ICON_SIZE_MENU);
#line 242 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp14_);
#line 242 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	icon = _tmp14_;
#line 244 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = icon;
#line 244 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp15_);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp16_ = submodule_url;
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17_ = g_path_get_basename (_tmp16_);
#line 246 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	name = _tmp17_;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp18_ = name;
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp19_ = g_str_has_suffix (_tmp18_, ".git");
#line 248 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp19_) {
#line 2577 "gitg-repository-list-box.c"
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 250 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp20_ = name;
#line 250 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp21_ = string_slice (_tmp20_, (glong) 0, (glong) -4);
#line 250 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (name);
#line 250 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		name = _tmp21_;
#line 2588 "gitg-repository-list-box.c"
	}
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp22_ = name;
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp23_ = (GtkLabel*) gtk_label_new (_tmp22_);
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp23_);
#line 253 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	labelName = _tmp23_;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp24_ = labelName;
#line 254 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp24_);
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp25_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_RIGHT, GTK_SHADOW_NONE);
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp25_);
#line 256 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	arrow = _tmp25_;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp26_ = arrow;
#line 257 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp26_);
#line 259 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp27_ = module;
#line 259 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp28_ = ggit_submodule_get_path (_tmp27_);
#line 259 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 259 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	path = _tmp29_;
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp30_ = path;
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp31_ = string_to_string (_tmp30_);
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp32_ = g_strconcat (_tmp31_, "/", NULL);
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp33_ = _tmp32_;
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp34_ = (GtkLabel*) gtk_label_new (_tmp33_);
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp34_);
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp35_ = _tmp34_;
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp33_);
#line 260 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	labelPath = _tmp35_;
#line 261 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp36_ = labelPath;
#line 261 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_ellipsize (_tmp36_, PANGO_ELLIPSIZE_MIDDLE);
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp37_ = labelPath;
#line 262 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp37_);
#line 264 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp38_ = box;
#line 264 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp39_ = icon;
#line 264 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
#line 265 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp40_ = box;
#line 265 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp41_ = labelName;
#line 265 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
#line 266 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp42_ = box;
#line 266 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp43_ = arrow;
#line 266 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp44_ = box;
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp45_ = labelPath;
#line 267 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp46_ = self->priv->d_submodule_box;
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp47_ = box;
#line 269 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (labelPath);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (path);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (arrow);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (labelName);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (name);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (icon);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (tip);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (box);
#line 228 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (submodule_url);
#line 2694 "gitg-repository-list-box.c"
}


GitgSelectionMode gitg_repository_list_box_row_get_mode (GitgRepositoryListBoxRow* self) {
	GitgSelectionMode result;
	GitgSelectionMode _tmp0_ = 0;
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 76 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2709 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_mode (GitgRepositoryListBoxRow* self, GitgSelectionMode value) {
	GitgSelectionMode _tmp0_ = 0;
	GitgSelectionMode _tmp1_ = 0;
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_mode;
#line 80 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 80 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp0_ != _tmp1_) {
#line 2724 "gitg-repository-list-box.c"
		GitgSelectionMode _tmp2_ = 0;
		GtkRevealer* _tmp3_ = NULL;
		GitgSelectionMode _tmp4_ = 0;
		GtkCheckButton* _tmp5_ = NULL;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = value;
#line 82 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		self->priv->d_mode = _tmp2_;
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_remove_revealer;
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_mode;
#line 84 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_revealer_set_reveal_child (_tmp3_, _tmp4_ == GITG_SELECTION_MODE_SELECTION);
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_remove_check_button;
#line 86 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, FALSE);
#line 2743 "gitg-repository-list-box.c"
	}
#line 78 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "mode");
#line 2747 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_selected (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->_selected;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2762 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_selected (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->_selected = _tmp0_;
#line 93 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "selected");
#line 2776 "gitg-repository-list-box.c"
}


GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository;
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 107 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2791 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 110 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_repository = _tmp1_;
#line 112 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_branch_name (self, "");
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_repository;
#line 114 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ != NULL) {
#line 2816 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp3_ = NULL;
			GitgRef* _tmp4_ = NULL;
			GitgRef* _tmp5_ = NULL;
			GitgParsedRefName* _tmp6_ = NULL;
			GitgParsedRefName* _tmp7_ = NULL;
			GitgParsedRefName* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp3_ = self->priv->d_repository;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp4_ = gitg_repository_get_head (_tmp3_, &_inner_error_);
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp4_;
#line 118 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2836 "gitg-repository-list-box.c"
				goto __catch51_g_error;
			}
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = head;
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp6_ = gitg_ref_get_parsed_name (_tmp5_);
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp6_;
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = _tmp7_;
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = gitg_parsed_ref_name_get_shortname (_tmp8_);
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = _tmp9_;
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = _tmp10_;
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_branch_name (self, _tmp11_);
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp11_);
#line 119 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp8_);
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 2861 "gitg-repository-list-box.c"
		}
		goto __finally51;
		__catch51_g_error:
		{
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 2870 "gitg-repository-list-box.c"
		}
		__finally51:
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 116 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			return;
#line 2881 "gitg-repository-list-box.c"
		}
	}
#line 108 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository");
#line 2886 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_can_remove (GitgRepositoryListBoxRow* self) {
	gboolean result;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp2_;
#line 128 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2907 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 129 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 129 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 129 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_);
#line 129 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "can-remove");
#line 2924 "gitg-repository-list-box.c"
}


GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_time;
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 134 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2939 "gitg-repository-list-box.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 2946 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_time = _tmp1_;
#line 135 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "time");
#line 2965 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value) {
	GitgProgressBin* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_progress_bin;
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_progress_bin_set_fraction (_tmp0_, _tmp1_);
#line 141 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "fraction");
#line 2982 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 146 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 146 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 146 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 146 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3000 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_label (_tmp0_, _tmp1_);
#line 147 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository-name");
#line 3017 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_dirname (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_dirname;
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 152 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3032 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_dirname (GitgRepositoryListBoxRow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 155 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 155 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 155 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_dirname);
#line 155 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_dirname = _tmp1_;
#line 156 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_update_branch_label (self);
#line 153 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "dirname");
#line 3053 "gitg-repository-list-box.c"
}


const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 162 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_name;
#line 162 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 162 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3068 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 165 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 165 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 165 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_branch_name);
#line 165 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_branch_name = _tmp1_;
#line 166 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_update_branch_label (self);
#line 163 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "branch-name");
#line 3089 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 190 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 190 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_loading;
#line 190 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 190 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3104 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 193 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 193 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_loading = _tmp0_;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_loading;
#line 195 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (!_tmp1_) {
#line 3121 "gitg-repository-list-box.c"
		GtkSpinner* _tmp2_ = NULL;
		GtkSpinner* _tmp3_ = NULL;
		GtkArrow* _tmp4_ = NULL;
		GitgProgressBin* _tmp5_ = NULL;
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_spinner;
#line 197 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_stop (_tmp2_);
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_spinner;
#line 198 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 199 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_arrow;
#line 199 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp4_);
#line 200 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_progress_bin;
#line 200 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_progress_bin_set_fraction (_tmp5_, (gdouble) 0);
#line 3142 "gitg-repository-list-box.c"
	} else {
		GtkArrow* _tmp6_ = NULL;
		GtkSpinner* _tmp7_ = NULL;
		GtkSpinner* _tmp8_ = NULL;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = self->priv->d_arrow;
#line 204 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = self->priv->d_spinner;
#line 205 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp7_);
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = self->priv->d_spinner;
#line 206 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_start (_tmp8_);
#line 3159 "gitg-repository-list-box.c"
	}
#line 191 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "loading");
#line 3163 "gitg-repository-list-box.c"
}


gboolean gitg_repository_list_box_row_get_has_remote (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_has_remote;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 213 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3178 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_row_set_has_remote (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* folder_icon_name = NULL;
	gchar* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkIconSize _tmp5_ = 0;
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 216 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 216 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_has_remote = _tmp0_;
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_has_remote;
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_) {
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = "folder-remote";
#line 3202 "gitg-repository-list-box.c"
	} else {
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = "folder";
#line 3206 "gitg-repository-list-box.c"
	}
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp1_);
#line 218 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	folder_icon_name = _tmp3_;
#line 219 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = self->priv->d_image;
#line 219 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = gitg_repository_list_box_row_s_icon_size;
#line 219 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_image_set_from_icon_name (_tmp4_, folder_icon_name, _tmp5_);
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (folder_icon_name);
#line 214 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "has-remote");
#line 3222 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_row_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBoxRow * self;
	GtkCheckButton* _tmp0_ = NULL;
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class);
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 98 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_check_button;
#line 98 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "active", (GObject*) self, "selected", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 96 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 3243 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_class_init (GitgRepositoryListBoxRowClass * klass) {
	gint GitgRepositoryListBoxRow_private_offset;
	GtkIconSize _tmp0_ = 0;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxRowPrivate));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_row_get_property;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_row_set_property;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_row_constructor;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_row_finalize;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE, g_param_spec_boolean ("can-remove", "can-remove", "can-remove", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_TIME, g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_FRACTION, g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME, g_param_spec_string ("repository-name", "repository-name", "repository-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME, g_param_spec_string ("dirname", "dirname", "dirname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME, g_param_spec_string ("branch-name", "branch-name", "branch-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_LOADING, g_param_spec_boolean ("loading", "loading", "loading", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE, g_param_spec_boolean ("has-remote", "has-remote", "has-remote", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	GitgRepositoryListBoxRow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-repository-list-box-row.ui");
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("request_remove", GITG_REPOSITORY_LIST_BOX_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_progress_bin", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_progress_bin));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_image", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_image));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_repository_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_repository_label));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_branch_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_branch_label));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_arrow", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_arrow));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_spinner", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_spinner));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_check_button", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_check_button));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_revealer", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_revealer));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_submodule_box", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_submodule_box));
#line 71 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_icon_size_register ("gitg", 64, 64);
#line 71 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_s_icon_size = _tmp0_;
#line 3312 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_instance_init (GitgRepositoryListBoxRow * self) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE (self);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _tmp0_;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_time (self, _tmp1_);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_ensure (GITG_TYPE_PROGRESS_BIN);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3331 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_finalize (GObject* obj) {
	GitgRepositoryListBoxRow * self;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 38 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 39 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 43 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_progress_bin);
#line 45 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_image);
#line 47 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository_label);
#line 49 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_branch_label);
#line 51 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_arrow);
#line 53 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_spinner);
#line 55 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_check_button);
#line 57 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_revealer);
#line 59 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_submodule_box);
#line 64 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_dirname);
#line 65 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_branch_name);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class)->finalize (obj);
#line 3367 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_row_get_type (void) {
	static volatile gsize gitg_repository_list_box_row_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxRow), 0, (GInstanceInitFunc) gitg_repository_list_box_row_instance_init, NULL };
		GType gitg_repository_list_box_row_type_id;
		gitg_repository_list_box_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgRepositoryListBoxRow", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_row_type_id__volatile, gitg_repository_list_box_row_type_id);
	}
	return gitg_repository_list_box_row_type_id__volatile;
}


static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_row_get_mode (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_selected (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_object (value, gitg_repository_list_box_row_get_repository (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_can_remove (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boxed (value, gitg_repository_list_box_row_get_time (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_repository_name (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_dirname (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_branch_name (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_loading (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_has_remote (self));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3448 "gitg-repository-list-box.c"
		default:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3454 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_MODE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_mode (self, g_value_get_enum (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_SELECTED:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_selected (self, g_value_get_boolean (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (self, g_value_get_object (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_can_remove (self, g_value_get_boolean (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (self, g_value_get_boxed (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_FRACTION:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_fraction (self, g_value_get_double (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository_name (self, g_value_get_string (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_DIRNAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_dirname (self, g_value_get_string (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_branch_name (self, g_value_get_string (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (self, g_value_get_boolean (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_has_remote (self, g_value_get_boolean (value));
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3530 "gitg-repository-list-box.c"
		default:
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3536 "gitg-repository-list-box.c"
	}
}


static void gitg_repository_list_box_class_init (GitgRepositoryListBoxClass * klass) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxPrivate));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkWidgetClass *) klass)->button_press_event = gitg_repository_list_box_real_button_press_event;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	((GtkListBoxClass *) klass)->row_activated = gitg_repository_list_box_real_row_activated;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_get_property;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_set_property;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_constructor;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_finalize;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_MODE, g_param_spec_enum ("mode", "mode", "mode", GITG_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_HAS_SELECTION, g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("repository_activated", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_TYPE_REPOSITORY);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("show_error", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
#line 3566 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_instance_init (GitgRepositoryListBox * self) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_GET_PRIVATE (self);
#line 3573 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_finalize (GObject* obj) {
	GitgRepositoryListBox * self;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 30 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_parent_class)->finalize (obj);
#line 3585 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_get_type (void) {
	static volatile gsize gitg_repository_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBox), 0, (GInstanceInitFunc) gitg_repository_list_box_instance_init, NULL };
		GType gitg_repository_list_box_type_id;
		gitg_repository_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "GitgRepositoryListBox", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_type_id__volatile, gitg_repository_list_box_type_id);
	}
	return gitg_repository_list_box_type_id__volatile;
}


static void _vala_gitg_repository_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_enum (value, gitg_repository_list_box_get_mode (self));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_HAS_SELECTION:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_get_has_selection (self));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3618 "gitg-repository-list-box.c"
		default:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3624 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_MODE:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_set_mode (self, g_value_get_enum (value));
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3640 "gitg-repository-list-box.c"
		default:
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/nacho/checkout/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3646 "gitg-repository-list-box.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



