/* test-commit.c generated by valac 0.24.0.144-702ba, the Vala compiler
 * generated from test-commit.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libgit2-glib/ggit.h>
#include <glib/gstdio.h>
#include <gitg-assert.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;

#define GITG_TEST_TYPE_COMMIT (gitg_test_commit_get_type ())
#define GITG_TEST_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_COMMIT, GitgTestCommit))
#define GITG_TEST_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_COMMIT, GitgTestCommitClass))
#define GITG_TEST_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_COMMIT))
#define GITG_TEST_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_COMMIT))
#define GITG_TEST_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_COMMIT, GitgTestCommitClass))

typedef struct _GitgTestCommit GitgTestCommit;
typedef struct _GitgTestCommitClass GitgTestCommitClass;
typedef struct _GitgTestCommitPrivate GitgTestCommitPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_reflog_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_reflog_entry_unref (var), NULL)))
#define _ggit_reflog_unref0(var) ((var == NULL) ? NULL : (var = (ggit_reflog_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
#define _ggit_commit_parents_unref0(var) ((var == NULL) ? NULL : (var = (ggit_commit_parents_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _GitgTestCommit {
	GitgTestRepository parent_instance;
	GitgTestCommitPrivate * priv;
};

struct _GitgTestCommitClass {
	GitgTestRepositoryClass parent_class;
	void (*test_commit) (GitgTestCommit* self);
	void (*test_sign_off) (GitgTestCommit* self);
	void (*test_pre_commit_hook) (GitgTestCommit* self);
	void (*test_commit_msg_hook) (GitgTestCommit* self);
	void (*test_skip_hooks) (GitgTestCommit* self);
	void (*test_amend) (GitgTestCommit* self);
};

struct _Block6Data {
	int _ref_count_;
	GitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
	GgitSignature* sig;
	gchar* msg;
};

struct _Block7Data {
	int _ref_count_;
	GitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
	GgitSignature* author;
	GgitSignature* sig;
	gchar* msg;
};

struct _Block8Data {
	int _ref_count_;
	GitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block9Data {
	int _ref_count_;
	GitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block10Data {
	int _ref_count_;
	GitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
};

struct _Block11Data {
	int _ref_count_;
	GitgTestCommit* self;
	GitgStage* stage;
	GMainLoop* loop;
	GgitSignature* sig;
	gchar* msg;
};


static gpointer gitg_test_commit_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
GType gitg_test_commit_get_type (void) G_GNUC_CONST;
enum  {
	GITG_TEST_COMMIT_DUMMY_PROPERTY
};
static void gitg_test_commit_real_set_up (GitgTestTest* base);
void gitg_test_test_set_up (GitgTestTest* self);
void gitg_test_repository_index_modify (GitgTestRepository* self, const gchar* filename, ...);
static void gitg_test_commit_setup_failing_pre_commit_hook (GitgTestCommit* self);
GitgTestCommit* gitg_test_commit_new (void);
GitgTestCommit* gitg_test_commit_construct (GType object_type);
GitgTestRepository* gitg_test_repository_new (void);
GitgTestRepository* gitg_test_repository_construct (GType object_type);
static void gitg_test_commit_real_test_commit (GitgTestCommit* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda9_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res);
static void _vala_GgitOId_free (GgitOId* self);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_commit_real_test_sign_off (GitgTestCommit* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda10_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res);
static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_commit_real_test_pre_commit_hook (GitgTestCommit* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda11_ (Block8Data* _data8_, GObject* obj, GAsyncResult* res);
static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_commit_real_test_commit_msg_hook (GitgTestCommit* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda12_ (Block9Data* _data9_, GObject* obj, GAsyncResult* res);
static void ___lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_commit_real_test_skip_hooks (GitgTestCommit* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda13_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_test_commit_real_test_amend (GitgTestCommit* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
static void __lambda14_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res);
static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);


/**
 * Create basic repository with files in a variety of states.
 */
static void gitg_test_commit_real_set_up (GitgTestTest* base) {
	GitgTestCommit * self;
#line 27 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	self = (GitgTestCommit*) base;
#line 29 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	GITG_TEST_TEST_CLASS (gitg_test_commit_parent_class)->set_up ((GitgTestTest*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TEST_TYPE_REPOSITORY, GitgTestRepository));
#line 31 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_repository_index_modify ((GitgTestRepository*) self, "b", "staged changes\n", NULL);
#line 32 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_repository_index_modify ((GitgTestRepository*) self, "a", "lala\n", NULL);
#line 232 "test-commit.c"
}


static void gitg_test_commit_setup_failing_pre_commit_hook (GitgTestCommit* self) {
	GFile* hookdir = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gchar* pc = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = ggit_repository_get_location ((GgitRepository*) _tmp0_);
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_file_get_child (_tmp2_, "hooks");
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = _tmp3_;
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp2_);
#line 118 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	hookdir = _tmp4_;
#line 119 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = g_file_get_child (hookdir, "pre-commit");
#line 119 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = _tmp5_;
#line 119 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = g_file_get_path (_tmp6_);
#line 119 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _tmp7_;
#line 119 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp6_);
#line 119 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	pc = _tmp8_;
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = g_file_set_contents (pc, "#!/bin/bash\n\necho 'pre-commit failed'; exit 1;\n", (gssize) (-1), &_inner_error_);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _tmp10_;
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 296 "test-commit.c"
	}
#line 121 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (_tmp9_, "FileUtils.set_contents(pc, \"#!/bin/bash\\n\\necho 'pre-commit failed'; exit 1;\\n\")");
#line 122 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = g_chmod (pc, 0744);
#line 122 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_inteq (_tmp11_, 0);
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (pc);
#line 116 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (hookdir);
#line 308 "test-commit.c"
}


GitgTestCommit* gitg_test_commit_construct (GType object_type) {
	GitgTestCommit * self = NULL;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	self = (GitgTestCommit*) gitg_test_repository_construct (object_type);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return self;
#line 318 "test-commit.c"
}


GitgTestCommit* gitg_test_commit_new (void) {
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return gitg_test_commit_construct (GITG_TEST_TYPE_COMMIT);
#line 325 "test-commit.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return _data6_;
#line 334 "test-commit.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 343 "test-commit.c"
		GitgTestCommit* self;
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		self = _data6_->self;
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (_data6_->msg);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data6_->sig);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data6_->loop);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data6_->stage);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block6Data, _data6_);
#line 359 "test-commit.c"
	}
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 367 "test-commit.c"
}


static void __lambda9_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res) {
	GitgTestCommit* self;
	GgitOId* oid = NULL;
	GAsyncResult* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GitgCommit* commit = NULL;
	GitgRepository* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	GitgCommit* _tmp5_ = NULL;
	GgitSignature* _tmp6_ = NULL;
	GgitSignature* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GitgCommit* _tmp10_ = NULL;
	GgitSignature* _tmp11_ = NULL;
	GgitSignature* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GitgCommit* _tmp15_ = NULL;
	GgitSignature* _tmp16_ = NULL;
	GgitSignature* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GitgCommit* _tmp20_ = NULL;
	GgitSignature* _tmp21_ = NULL;
	GgitSignature* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GitgCommit* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GitgCommit* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GitgRef* _tmp30_ = NULL;
	GitgRepository* _tmp31_ = NULL;
	GitgRef* _tmp32_ = NULL;
	GitgRef* _tmp33_ = NULL;
	GitgRef* _tmp34_ = NULL;
	GgitOId* _tmp35_ = NULL;
	GgitOId* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GgitOId* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	GitgRef* _tmp42_ = NULL;
	GitgRepository* _tmp43_ = NULL;
	GitgRef* _tmp44_ = NULL;
	GgitReflog* reflog = NULL;
	GitgRef* _tmp45_ = NULL;
	GitgRef* _tmp46_ = NULL;
	GgitReflog* _tmp47_ = NULL;
	GgitReflog* _tmp48_ = NULL;
	GgitReflogEntry* entry = NULL;
	GgitReflog* _tmp49_ = NULL;
	GgitReflogEntry* _tmp50_ = NULL;
	GgitReflogEntry* _tmp51_ = NULL;
	GgitOId* _tmp52_ = NULL;
	GgitOId* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	GgitOId* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	GgitReflogEntry* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GError * _inner_error_ = NULL;
#line 51 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	self = _data6_->self;
#line 51 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = res;
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_stage_commit_finish (_data6_->stage, _tmp0_, &_inner_error_);
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp1_;
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 53 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 457 "test-commit.c"
	}
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = ((GitgTestRepository*) self)->d_repository;
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = oid;
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = gitg_repository_lookup (_tmp2_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp3_, &_inner_error_);
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp4_;
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 54 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 477 "test-commit.c"
	}
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = commit;
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = ggit_commit_get_author ((GgitCommit*) _tmp5_);
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = _tmp6_;
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = ggit_signature_get_name (_tmp7_);
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = ggit_signature_get_name (_data6_->sig);
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp8_, _tmp9_);
#line 56 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 57 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = commit;
#line 57 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = ggit_commit_get_author ((GgitCommit*) _tmp10_);
#line 57 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = _tmp11_;
#line 57 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = ggit_signature_get_email (_tmp12_);
#line 57 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = ggit_signature_get_email (_data6_->sig);
#line 57 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp13_, _tmp14_);
#line 57 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 59 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = commit;
#line 59 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = ggit_commit_get_committer ((GgitCommit*) _tmp15_);
#line 59 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = _tmp16_;
#line 59 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = ggit_signature_get_name (_tmp17_);
#line 59 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = ggit_signature_get_name (_data6_->sig);
#line 59 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp18_, _tmp19_);
#line 59 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp17_);
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = commit;
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = ggit_commit_get_committer ((GgitCommit*) _tmp20_);
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = _tmp21_;
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = ggit_signature_get_email (_tmp22_);
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = ggit_signature_get_email (_data6_->sig);
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp23_, _tmp24_);
#line 60 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp22_);
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = commit;
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp26_ = ggit_commit_get_message ((GgitCommit*) _tmp25_);
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp27_ = _data6_->msg;
#line 62 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp26_, _tmp27_);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp28_ = commit;
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp29_ = ggit_commit_get_subject ((GgitCommit*) _tmp28_);
#line 63 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp29_, "This is the commit");
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp31_ = ((GitgTestRepository*) self)->d_repository;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp32_ = gitg_repository_get_head (_tmp31_, &_inner_error_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp30_ = _tmp32_;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 567 "test-commit.c"
	}
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp33_ = _tmp30_;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp30_ = NULL;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp34_ = _tmp33_;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp35_ = ggit_ref_get_target ((GgitRef*) _tmp34_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp36_ = _tmp35_;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp37_ = ggit_oid_to_string (_tmp36_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp38_ = _tmp37_;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp39_ = oid;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp40_ = ggit_oid_to_string (_tmp39_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp41_ = _tmp40_;
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp38_, _tmp41_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp41_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp38_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (_tmp36_);
#line 65 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp34_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp43_ = ((GitgTestRepository*) self)->d_repository;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp44_ = gitg_repository_lookup_reference (_tmp43_, "HEAD", &_inner_error_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp42_ = _tmp44_;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp30_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 619 "test-commit.c"
	}
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp45_ = _tmp42_;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp42_ = NULL;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp46_ = _tmp45_;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp47_ = ggit_ref_get_log ((GgitRef*) _tmp46_, &_inner_error_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp48_ = _tmp47_;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp46_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	reflog = _tmp48_;
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp42_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp30_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 68 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 651 "test-commit.c"
	}
#line 69 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp49_ = reflog;
#line 69 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp50_ = ggit_reflog_get_entry_from_index (_tmp49_, (guint) 0);
#line 69 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	entry = _tmp50_;
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp51_ = entry;
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp52_ = ggit_reflog_entry_get_new_id (_tmp51_);
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp53_ = _tmp52_;
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp54_ = ggit_oid_to_string (_tmp53_);
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp55_ = _tmp54_;
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp56_ = oid;
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp57_ = ggit_oid_to_string (_tmp56_);
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp58_ = _tmp57_;
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp55_, _tmp58_);
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp58_);
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp55_);
#line 71 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (_tmp53_);
#line 72 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp59_ = entry;
#line 72 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp60_ = ggit_reflog_entry_get_message (_tmp59_);
#line 72 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp60_, "commit: This is the commit");
#line 74 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_data6_->loop);
#line 51 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_ggit_reflog_entry_unref0 (entry);
#line 51 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_ggit_reflog_unref0 (reflog);
#line 51 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp42_);
#line 51 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp30_);
#line 51 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 51 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 703 "test-commit.c"
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 48 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__lambda9_ (self, source_object, res);
#line 48 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block6_data_unref (self);
#line 712 "test-commit.c"
}


static void gitg_test_commit_real_test_commit (GitgTestCommit* self) {
	Block6Data* _data6_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
	GgitSignature* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data6_->_ref_count_ = 1;
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data6_->self = g_object_ref (self);
#line 40 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 40 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 40 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 40 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data6_->stage = _tmp2_;
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 41 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data6_->loop = _tmp3_;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data6_->sig = _tmp4_;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block6_data_unref (_data6_);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data6_ = NULL;
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 43 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 760 "test-commit.c"
	}
#line 46 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = g_strdup ("This is the commit\n\nWith a message.\n");
#line 46 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data6_->msg = _tmp5_;
#line 48 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = _data6_->msg;
#line 48 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_data6_->stage, _tmp6_, _data6_->sig, _data6_->sig, GITG_STAGE_COMMIT_OPTIONS_NONE, ___lambda9__gasync_ready_callback, block6_data_ref (_data6_));
#line 77 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_data6_->loop);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block6_data_unref (_data6_);
#line 38 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data6_ = NULL;
#line 776 "test-commit.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return _data7_;
#line 785 "test-commit.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 794 "test-commit.c"
		GitgTestCommit* self;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		self = _data7_->self;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (_data7_->msg);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data7_->sig);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data7_->author);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data7_->loop);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data7_->stage);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block7Data, _data7_);
#line 812 "test-commit.c"
	}
}


static void __lambda10_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res) {
	GitgTestCommit* self;
	GgitOId* oid = NULL;
	GitgStage* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GitgCommit* commit = NULL;
	GitgRepository* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GitgCommit* _tmp6_ = NULL;
	GgitSignature* _tmp7_ = NULL;
	GgitSignature* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GgitSignature* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GitgCommit* _tmp12_ = NULL;
	GgitSignature* _tmp13_ = NULL;
	GgitSignature* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GgitSignature* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GitgCommit* _tmp18_ = NULL;
	GgitSignature* _tmp19_ = NULL;
	GgitSignature* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GgitSignature* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GitgCommit* _tmp24_ = NULL;
	GgitSignature* _tmp25_ = NULL;
	GgitSignature* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GgitSignature* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GitgCommit* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GMainLoop* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
#line 96 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	self = _data7_->self;
#line 96 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = _data7_->stage;
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = res;
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = gitg_stage_commit_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp2_;
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 98 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 878 "test-commit.c"
	}
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = ((GitgTestRepository*) self)->d_repository;
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = oid;
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp4_, &_inner_error_);
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp5_;
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 100 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 898 "test-commit.c"
	}
#line 102 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = commit;
#line 102 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = ggit_commit_get_author ((GgitCommit*) _tmp6_);
#line 102 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _tmp7_;
#line 102 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = ggit_signature_get_name (_tmp8_);
#line 102 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = _data7_->author;
#line 102 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = ggit_signature_get_name (_tmp10_);
#line 102 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp9_, _tmp11_);
#line 102 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = commit;
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = ggit_commit_get_author ((GgitCommit*) _tmp12_);
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = _tmp13_;
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = ggit_signature_get_email (_tmp14_);
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = _data7_->author;
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = ggit_signature_get_email (_tmp16_);
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp15_, _tmp17_);
#line 103 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp14_);
#line 105 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = commit;
#line 105 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = ggit_commit_get_committer ((GgitCommit*) _tmp18_);
#line 105 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = _tmp19_;
#line 105 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = ggit_signature_get_name (_tmp20_);
#line 105 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = _data7_->sig;
#line 105 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = ggit_signature_get_name (_tmp22_);
#line 105 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp21_, _tmp23_);
#line 105 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp20_);
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = commit;
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = ggit_commit_get_committer ((GgitCommit*) _tmp24_);
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp26_ = _tmp25_;
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp27_ = ggit_signature_get_email (_tmp26_);
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp28_ = _data7_->sig;
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp29_ = ggit_signature_get_email (_tmp28_);
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp27_, _tmp29_);
#line 106 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp26_);
#line 108 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp30_ = commit;
#line 108 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp31_ = ggit_commit_get_message ((GgitCommit*) _tmp30_);
#line 108 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp32_ = _data7_->msg;
#line 108 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp33_ = g_strconcat (_tmp32_, "\nSigned-off-by: Jesse van den Kieboom <jessevdk@gmail.com>\n", NULL);
#line 108 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp34_ = _tmp33_;
#line 108 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp31_, _tmp34_);
#line 108 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp34_);
#line 110 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp35_ = _data7_->loop;
#line 110 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_tmp35_);
#line 96 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 96 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 986 "test-commit.c"
}


static void ___lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 93 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__lambda10_ (self, source_object, res);
#line 93 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block7_data_unref (self);
#line 995 "test-commit.c"
}


static void gitg_test_commit_real_test_sign_off (GitgTestCommit* self) {
	Block7Data* _data7_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
	GgitSignature* _tmp4_ = NULL;
	GgitSignature* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GitgStage* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GgitSignature* _tmp9_ = NULL;
	GgitSignature* _tmp10_ = NULL;
	GMainLoop* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_->_ref_count_ = 1;
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_->self = g_object_ref (self);
#line 82 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 82 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 82 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 82 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_->stage = _tmp2_;
#line 83 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 83 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_->loop = _tmp3_;
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = ggit_signature_new_now ("Jesse", "jessevdk@gnome.org", &_inner_error_);
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_->author = _tmp4_;
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block7_data_unref (_data7_);
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data7_ = NULL;
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 85 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1048 "test-commit.c"
	}
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gmail.com", &_inner_error_);
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_->sig = _tmp5_;
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block7_data_unref (_data7_);
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data7_ = NULL;
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 88 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1066 "test-commit.c"
	}
#line 91 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = g_strdup ("This is the commit\n\nWith a message.\n");
#line 91 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_->msg = _tmp6_;
#line 93 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = _data7_->stage;
#line 93 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _data7_->msg;
#line 93 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _data7_->author;
#line 93 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = _data7_->sig;
#line 93 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_tmp7_, _tmp8_, _tmp9_, _tmp10_, GITG_STAGE_COMMIT_OPTIONS_SIGN_OFF, ___lambda10__gasync_ready_callback, block7_data_ref (_data7_));
#line 113 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = _data7_->loop;
#line 113 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_tmp11_);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block7_data_unref (_data7_);
#line 80 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data7_ = NULL;
#line 1090 "test-commit.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return _data8_;
#line 1099 "test-commit.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 1108 "test-commit.c"
		GitgTestCommit* self;
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		self = _data8_->self;
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data8_->loop);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data8_->stage);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block8Data, _data8_);
#line 1120 "test-commit.c"
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return self ? g_error_copy (self) : NULL;
#line 1128 "test-commit.c"
}


static void __lambda11_ (Block8Data* _data8_, GObject* obj, GAsyncResult* res) {
	GitgTestCommit* self;
	GError* e = NULL;
	GError* _tmp3_ = NULL;
	GError* _tmp4_ = NULL;
	GError* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	self = _data8_->self;
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 136 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	e = NULL;
#line 1146 "test-commit.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 140 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_tmp0_ = res;
#line 140 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		gitg_stage_pre_commit_hook_finish (_data8_->stage, _tmp0_, &_inner_error_);
#line 140 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 140 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
			if (_inner_error_->domain == GITG_STAGE_ERROR) {
#line 1157 "test-commit.c"
				goto __catch19_gitg_stage_error;
			}
#line 140 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
			_g_error_free0 (e);
#line 140 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 140 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
			g_clear_error (&_inner_error_);
#line 140 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
			return;
#line 1168 "test-commit.c"
		}
	}
	goto __finally19;
	__catch19_gitg_stage_error:
	{
		GError* err = NULL;
		GError* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
#line 138 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		err = _inner_error_;
#line 138 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_inner_error_ = NULL;
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_tmp1_ = err;
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_tmp2_ = _g_error_copy0 (_tmp1_);
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_error_free0 (e);
#line 144 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		e = _tmp2_;
#line 138 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_error_free0 (err);
#line 1191 "test-commit.c"
	}
	__finally19:
#line 138 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 138 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_error_free0 (e);
#line 138 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 138 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1204 "test-commit.c"
	}
#line 147 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = e;
#line 147 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (_tmp3_ != NULL, "e != null");
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = e;
#line 148 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (g_error_matches (_tmp4_, GITG_STAGE_ERROR, GITG_STAGE_ERROR_PRE_COMMIT_HOOK_FAILED), "e is StageError.PRE_COMMIT_HOOK_FAILED");
#line 149 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = e;
#line 149 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = _tmp5_->message;
#line 149 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp6_, "pre-commit failed");
#line 151 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_data8_->loop);
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_error_free0 (e);
#line 1224 "test-commit.c"
}


static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__lambda11_ (self, source_object, res);
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block8_data_unref (self);
#line 1233 "test-commit.c"
}


static void gitg_test_commit_real_test_pre_commit_hook (GitgTestCommit* self) {
	Block8Data* _data8_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
	GgitSignature* sig = NULL;
	GgitSignature* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data8_->_ref_count_ = 1;
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data8_->self = g_object_ref (self);
#line 127 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_commit_setup_failing_pre_commit_hook (self);
#line 129 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 129 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 129 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 129 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data8_->stage = _tmp2_;
#line 130 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 130 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data8_->loop = _tmp3_;
#line 132 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 132 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	sig = _tmp4_;
#line 132 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block8_data_unref (_data8_);
#line 132 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data8_ = NULL;
#line 132 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 132 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1282 "test-commit.c"
	}
#line 135 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_pre_commit_hook (_data8_->stage, sig, ___lambda11__gasync_ready_callback, block8_data_ref (_data8_));
#line 154 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_data8_->loop);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (sig);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block8_data_unref (_data8_);
#line 125 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data8_ = NULL;
#line 1294 "test-commit.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return _data9_;
#line 1303 "test-commit.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 1312 "test-commit.c"
		GitgTestCommit* self;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		self = _data9_->self;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data9_->loop);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data9_->stage);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block9Data, _data9_);
#line 1324 "test-commit.c"
	}
}


static void __lambda12_ (Block9Data* _data9_, GObject* obj, GAsyncResult* res) {
	GitgTestCommit* self;
	GgitOId* oid = NULL;
	GitgStage* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GitgCommit* commit = NULL;
	GitgRepository* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GitgCommit* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GMainLoop* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 176 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	self = _data9_->self;
#line 176 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = _data9_->stage;
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = res;
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = gitg_stage_commit_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp2_;
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 177 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1363 "test-commit.c"
	}
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = ((GitgTestRepository*) self)->d_repository;
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = oid;
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp4_, &_inner_error_);
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp5_;
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 179 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1383 "test-commit.c"
	}
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = commit;
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = ggit_commit_get_message ((GgitCommit*) _tmp6_);
#line 180 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp7_, "override message\n");
#line 182 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _data9_->loop;
#line 182 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_tmp8_);
#line 176 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 176 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 1399 "test-commit.c"
}


static void ___lambda12__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__lambda12_ (self, source_object, res);
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block9_data_unref (self);
#line 1408 "test-commit.c"
}


static void gitg_test_commit_real_test_commit_msg_hook (GitgTestCommit* self) {
	Block9Data* _data9_;
	GFile* hookdir = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gchar* pc = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GitgRepository* _tmp15_ = NULL;
	GitgStage* _tmp16_ = NULL;
	GitgStage* _tmp17_ = NULL;
	GMainLoop* _tmp18_ = NULL;
	gchar* msg = NULL;
	gchar* _tmp19_ = NULL;
	GgitSignature* sig = NULL;
	GgitSignature* _tmp20_ = NULL;
	GitgStage* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GgitSignature* _tmp23_ = NULL;
	GgitSignature* _tmp24_ = NULL;
	GMainLoop* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data9_->_ref_count_ = 1;
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data9_->self = g_object_ref (self);
#line 159 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 159 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = ggit_repository_get_location ((GgitRepository*) _tmp0_);
#line 159 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 159 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_file_get_child (_tmp2_, "hooks");
#line 159 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = _tmp3_;
#line 159 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp2_);
#line 159 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	hookdir = _tmp4_;
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = hookdir;
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = g_file_get_child (_tmp5_, "commit-msg");
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = _tmp6_;
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _tmp8_;
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 160 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	pc = _tmp9_;
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = pc;
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = g_file_set_contents (_tmp11_, "#!/bin/bash\n\necho 'override message' > $1\n", (gssize) (-1), &_inner_error_);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = _tmp12_;
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block9_data_unref (_data9_);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data9_ = NULL;
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1501 "test-commit.c"
	}
#line 162 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (_tmp10_, "FileUtils.set_contents(pc, \"#!/bin/bash\\n\\necho 'override message' > $1\\n\")");
#line 163 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = pc;
#line 163 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = g_chmod (_tmp13_, 0744);
#line 163 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_inteq (_tmp14_, 0);
#line 165 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = ((GitgTestRepository*) self)->d_repository;
#line 165 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = gitg_repository_get_stage (_tmp15_);
#line 165 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = _tmp16_;
#line 165 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data9_->stage = _tmp17_;
#line 166 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = g_main_loop_new (NULL, FALSE);
#line 166 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data9_->loop = _tmp18_;
#line 168 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = g_strdup ("original message\n");
#line 168 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	msg = _tmp19_;
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	sig = _tmp20_;
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (msg);
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block9_data_unref (_data9_);
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data9_ = NULL;
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 170 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1549 "test-commit.c"
	}
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = _data9_->stage;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = msg;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = sig;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = sig;
#line 173 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_tmp21_, _tmp22_, _tmp23_, _tmp24_, GITG_STAGE_COMMIT_OPTIONS_NONE, ___lambda12__gasync_ready_callback, block9_data_ref (_data9_));
#line 185 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = _data9_->loop;
#line 185 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_tmp25_);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (sig);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (msg);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (pc);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (hookdir);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block9_data_unref (_data9_);
#line 157 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data9_ = NULL;
#line 1577 "test-commit.c"
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return _data10_;
#line 1586 "test-commit.c"
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 1595 "test-commit.c"
		GitgTestCommit* self;
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		self = _data10_->self;
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data10_->loop);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data10_->stage);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block10Data, _data10_);
#line 1607 "test-commit.c"
	}
}


static void __lambda13_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res) {
	GitgTestCommit* self;
	GgitOId* oid = NULL;
	GitgStage* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GitgCommit* commit = NULL;
	GitgRepository* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GitgCommit* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GMainLoop* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 207 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	self = _data10_->self;
#line 207 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = _data10_->stage;
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = res;
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = gitg_stage_commit_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp2_;
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 208 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1646 "test-commit.c"
	}
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = ((GitgTestRepository*) self)->d_repository;
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = oid;
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp4_, &_inner_error_);
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp5_;
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 210 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1666 "test-commit.c"
	}
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = commit;
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = ggit_commit_get_message ((GgitCommit*) _tmp6_);
#line 211 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp7_, "original message\n");
#line 213 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _data10_->loop;
#line 213 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_tmp8_);
#line 207 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 207 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 1682 "test-commit.c"
}


static void ___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__lambda13_ (self, source_object, res);
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block10_data_unref (self);
#line 1691 "test-commit.c"
}


static void gitg_test_commit_real_test_skip_hooks (GitgTestCommit* self) {
	Block10Data* _data10_;
	GFile* hookdir = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gchar* pc = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GitgRepository* _tmp15_ = NULL;
	GitgStage* _tmp16_ = NULL;
	GitgStage* _tmp17_ = NULL;
	GMainLoop* _tmp18_ = NULL;
	gchar* msg = NULL;
	gchar* _tmp19_ = NULL;
	GgitSignature* sig = NULL;
	GgitSignature* _tmp20_ = NULL;
	GitgStage* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GgitSignature* _tmp23_ = NULL;
	GgitSignature* _tmp24_ = NULL;
	GMainLoop* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data10_->_ref_count_ = 1;
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data10_->self = g_object_ref (self);
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = ggit_repository_get_location ((GgitRepository*) _tmp0_);
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_file_get_child (_tmp2_, "hooks");
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = _tmp3_;
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp2_);
#line 190 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	hookdir = _tmp4_;
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = hookdir;
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = g_file_get_child (_tmp5_, "commit-msg");
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = _tmp6_;
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _tmp8_;
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp7_);
#line 191 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	pc = _tmp9_;
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = pc;
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = g_file_set_contents (_tmp11_, "#!/bin/bash\n\necho 'override message' > $1\n", (gssize) (-1), &_inner_error_);
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = _tmp12_;
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block10_data_unref (_data10_);
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data10_ = NULL;
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1784 "test-commit.c"
	}
#line 193 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_vala_assert (_tmp10_, "FileUtils.set_contents(pc, \"#!/bin/bash\\n\\necho 'override message' > $1\\n\")");
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = pc;
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = g_chmod (_tmp13_, 0744);
#line 194 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_inteq (_tmp14_, 0);
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = ((GitgTestRepository*) self)->d_repository;
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = gitg_repository_get_stage (_tmp15_);
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = _tmp16_;
#line 196 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data10_->stage = _tmp17_;
#line 197 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = g_main_loop_new (NULL, FALSE);
#line 197 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data10_->loop = _tmp18_;
#line 199 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = g_strdup ("original message\n");
#line 199 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	msg = _tmp19_;
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	sig = _tmp20_;
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (msg);
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (pc);
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (hookdir);
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block10_data_unref (_data10_);
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data10_ = NULL;
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1832 "test-commit.c"
	}
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = _data10_->stage;
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = msg;
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = sig;
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = sig;
#line 204 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_tmp21_, _tmp22_, _tmp23_, _tmp24_, GITG_STAGE_COMMIT_OPTIONS_SKIP_HOOKS, ___lambda13__gasync_ready_callback, block10_data_ref (_data10_));
#line 216 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = _data10_->loop;
#line 216 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_tmp25_);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (sig);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (msg);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (pc);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (hookdir);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block10_data_unref (_data10_);
#line 188 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data10_ = NULL;
#line 1860 "test-commit.c"
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	return _data11_;
#line 1869 "test-commit.c"
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 1878 "test-commit.c"
		GitgTestCommit* self;
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		self = _data11_->self;
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_free0 (_data11_->msg);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data11_->sig);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_main_loop_unref0 (_data11_->loop);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_data11_->stage);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (self);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_slice_free (Block11Data, _data11_);
#line 1894 "test-commit.c"
	}
}


static void __lambda14_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res) {
	GitgTestCommit* self;
	GgitOId* oid = NULL;
	GitgStage* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GitgCommit* commit = NULL;
	GitgRepository* _tmp3_ = NULL;
	GgitOId* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GitgCommit* _tmp6_ = NULL;
	GgitSignature* _tmp7_ = NULL;
	GgitSignature* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GitgCommit* _tmp10_ = NULL;
	GgitSignature* _tmp11_ = NULL;
	GgitSignature* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GitgCommit* _tmp14_ = NULL;
	GgitSignature* _tmp15_ = NULL;
	GgitSignature* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GgitSignature* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GitgCommit* _tmp20_ = NULL;
	GgitSignature* _tmp21_ = NULL;
	GgitSignature* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GgitSignature* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GitgCommit* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GitgCommit* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GitgRef* _tmp31_ = NULL;
	GitgRepository* _tmp32_ = NULL;
	GitgRef* _tmp33_ = NULL;
	GitgRef* _tmp34_ = NULL;
	GitgRef* _tmp35_ = NULL;
	GgitOId* _tmp36_ = NULL;
	GgitOId* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	GgitOId* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	GitgCommit* _tmp43_ = NULL;
	GgitCommitParents* _tmp44_ = NULL;
	GgitCommitParents* _tmp45_ = NULL;
	guint _tmp46_ = 0U;
	GitgRef* _tmp47_ = NULL;
	GitgRepository* _tmp48_ = NULL;
	GitgRef* _tmp49_ = NULL;
	GgitReflog* reflog = NULL;
	GitgRef* _tmp50_ = NULL;
	GitgRef* _tmp51_ = NULL;
	GgitReflog* _tmp52_ = NULL;
	GgitReflog* _tmp53_ = NULL;
	GgitReflogEntry* entry = NULL;
	GgitReflog* _tmp54_ = NULL;
	GgitReflogEntry* _tmp55_ = NULL;
	GgitReflogEntry* _tmp56_ = NULL;
	GgitOId* _tmp57_ = NULL;
	GgitOId* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	GgitOId* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	GgitReflogEntry* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	GMainLoop* _tmp66_ = NULL;
	GError * _inner_error_ = NULL;
#line 238 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	self = _data11_->self;
#line 238 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_return_if_fail (res != NULL);
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = _data11_->stage;
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = res;
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = gitg_stage_commit_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	oid = _tmp2_;
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 240 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 1993 "test-commit.c"
	}
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = ((GitgTestRepository*) self)->d_repository;
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = oid;
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp4_, &_inner_error_);
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	commit = (GitgCommit*) _tmp5_;
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 241 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2013 "test-commit.c"
	}
#line 243 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = commit;
#line 243 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = ggit_commit_get_author ((GgitCommit*) _tmp6_);
#line 243 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _tmp7_;
#line 243 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = ggit_signature_get_name (_tmp8_);
#line 243 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp9_, "gitg tester");
#line 243 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp8_);
#line 244 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = commit;
#line 244 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = ggit_commit_get_author ((GgitCommit*) _tmp10_);
#line 244 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = _tmp11_;
#line 244 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = ggit_signature_get_email (_tmp12_);
#line 244 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp13_, "gitg-tester@gnome.org");
#line 244 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp12_);
#line 246 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = commit;
#line 246 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = ggit_commit_get_committer ((GgitCommit*) _tmp14_);
#line 246 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = _tmp15_;
#line 246 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = ggit_signature_get_name (_tmp16_);
#line 246 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = _data11_->sig;
#line 246 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = ggit_signature_get_name (_tmp18_);
#line 246 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp17_, _tmp19_);
#line 246 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp16_);
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = commit;
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = ggit_commit_get_committer ((GgitCommit*) _tmp20_);
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = _tmp21_;
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp23_ = ggit_signature_get_email (_tmp22_);
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp24_ = _data11_->sig;
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp25_ = ggit_signature_get_email (_tmp24_);
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp23_, _tmp25_);
#line 247 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp22_);
#line 249 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp26_ = commit;
#line 249 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp27_ = ggit_commit_get_message ((GgitCommit*) _tmp26_);
#line 249 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp28_ = _data11_->msg;
#line 249 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp27_, _tmp28_);
#line 250 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp29_ = commit;
#line 250 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp30_ = ggit_commit_get_subject ((GgitCommit*) _tmp29_);
#line 250 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp30_, "This is the commit");
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp32_ = ((GitgTestRepository*) self)->d_repository;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp33_ = gitg_repository_get_head (_tmp32_, &_inner_error_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp31_ = _tmp33_;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2103 "test-commit.c"
	}
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp34_ = _tmp31_;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp31_ = NULL;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp35_ = _tmp34_;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp36_ = ggit_ref_get_target ((GgitRef*) _tmp35_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp37_ = _tmp36_;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp38_ = ggit_oid_to_string (_tmp37_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp39_ = _tmp38_;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp40_ = oid;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp41_ = ggit_oid_to_string (_tmp40_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp42_ = _tmp41_;
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp39_, _tmp42_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp42_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp39_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (_tmp37_);
#line 252 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp35_);
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp43_ = commit;
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp44_ = ggit_commit_get_parents ((GgitCommit*) _tmp43_);
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp45_ = _tmp44_;
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp46_ = ggit_commit_parents_size (_tmp45_);
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_uinteq (_tmp46_, (guint) 0);
#line 255 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_ggit_commit_parents_unref0 (_tmp45_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp48_ = ((GitgTestRepository*) self)->d_repository;
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp49_ = gitg_repository_lookup_reference (_tmp48_, "HEAD", &_inner_error_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp47_ = _tmp49_;
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp31_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2167 "test-commit.c"
	}
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp50_ = _tmp47_;
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp47_ = NULL;
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp51_ = _tmp50_;
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp52_ = ggit_ref_get_log ((GgitRef*) _tmp51_, &_inner_error_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp53_ = _tmp52_;
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp51_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	reflog = _tmp53_;
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp47_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp31_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (commit);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (oid);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 257 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2199 "test-commit.c"
	}
#line 258 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp54_ = reflog;
#line 258 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp55_ = ggit_reflog_get_entry_from_index (_tmp54_, (guint) 0);
#line 258 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	entry = _tmp55_;
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp56_ = entry;
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp57_ = ggit_reflog_entry_get_new_id (_tmp56_);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp58_ = _tmp57_;
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp59_ = ggit_oid_to_string (_tmp58_);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp60_ = _tmp59_;
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp61_ = oid;
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp62_ = ggit_oid_to_string (_tmp61_);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp63_ = _tmp62_;
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp60_, _tmp63_);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp63_);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_free0 (_tmp60_);
#line 260 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (_tmp58_);
#line 261 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp64_ = entry;
#line 261 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp65_ = ggit_reflog_entry_get_message (_tmp64_);
#line 261 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_assert_assert_streq (_tmp65_, "commit (amend): This is the commit");
#line 263 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp66_ = _data11_->loop;
#line 263 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_quit (_tmp66_);
#line 238 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_ggit_reflog_entry_unref0 (entry);
#line 238 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_ggit_reflog_unref0 (reflog);
#line 238 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp47_);
#line 238 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp31_);
#line 238 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (commit);
#line 238 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (oid);
#line 2253 "test-commit.c"
}


static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__lambda14_ (self, source_object, res);
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block11_data_unref (self);
#line 2262 "test-commit.c"
}


static void gitg_test_commit_real_test_amend (GitgTestCommit* self) {
	Block11Data* _data11_;
	GitgRepository* _tmp0_ = NULL;
	GitgStage* _tmp1_ = NULL;
	GitgStage* _tmp2_ = NULL;
	GMainLoop* _tmp3_ = NULL;
	GgitSignature* _tmp4_ = NULL;
	GitgRef* _tmp5_ = NULL;
	GitgRepository* _tmp6_ = NULL;
	GitgRef* _tmp7_ = NULL;
	GgitOId* headoid = NULL;
	GitgRef* _tmp8_ = NULL;
	GitgRef* _tmp9_ = NULL;
	GgitOId* _tmp10_ = NULL;
	GgitOId* _tmp11_ = NULL;
	GgitCommit* headc = NULL;
	GitgRepository* _tmp12_ = NULL;
	GgitOId* _tmp13_ = NULL;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GitgStage* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GgitCommit* _tmp18_ = NULL;
	GgitSignature* _tmp19_ = NULL;
	GgitSignature* _tmp20_ = NULL;
	GgitSignature* _tmp21_ = NULL;
	GMainLoop* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data11_->_ref_count_ = 1;
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data11_->self = g_object_ref (self);
#line 221 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_repository_commit ((GitgTestRepository*) self, "a", "lala\n", "b", "for real\n", NULL);
#line 224 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp0_ = ((GitgTestRepository*) self)->d_repository;
#line 224 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp1_ = gitg_repository_get_stage (_tmp0_);
#line 224 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp2_ = _tmp1_;
#line 224 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data11_->stage = _tmp2_;
#line 225 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 225 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data11_->loop = _tmp3_;
#line 227 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp4_ = ggit_signature_new_now ("Jesse van den Kieboom", "jessevdk@gnome.org", &_inner_error_);
#line 227 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data11_->sig = _tmp4_;
#line 227 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block11_data_unref (_data11_);
#line 227 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data11_ = NULL;
#line 227 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 227 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2330 "test-commit.c"
	}
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp6_ = ((GitgTestRepository*) self)->d_repository;
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp7_ = gitg_repository_get_head (_tmp6_, &_inner_error_);
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = _tmp7_;
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block11_data_unref (_data11_);
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data11_ = NULL;
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2350 "test-commit.c"
	}
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp8_ = _tmp5_;
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp5_ = NULL;
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp9_ = _tmp8_;
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp10_ = ggit_ref_get_target ((GgitRef*) _tmp9_);
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp11_ = _tmp10_;
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp9_);
#line 230 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	headoid = _tmp11_;
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp12_ = ((GitgTestRepository*) self)->d_repository;
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp13_ = headoid;
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp14_ = gitg_repository_lookup (_tmp12_, ggit_commit_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp13_, &_inner_error_);
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	headc = (GgitCommit*) _tmp14_;
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		__vala_GgitOId_free0 (headoid);
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_g_object_unref0 (_tmp5_);
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		block11_data_unref (_data11_);
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		_data11_ = NULL;
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		g_clear_error (&_inner_error_);
#line 231 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
		return;
#line 2390 "test-commit.c"
	}
#line 233 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp15_ = g_strdup ("This is the commit\n\nWith a message.\n");
#line 233 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data11_->msg = _tmp15_;
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp16_ = _data11_->stage;
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp17_ = _data11_->msg;
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp18_ = headc;
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp19_ = ggit_commit_get_author (_tmp18_);
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp20_ = _tmp19_;
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp21_ = _data11_->sig;
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_stage_commit (_tmp16_, _tmp17_, _tmp20_, _tmp21_, GITG_STAGE_COMMIT_OPTIONS_AMEND, ___lambda14__gasync_ready_callback, block11_data_ref (_data11_));
#line 235 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp20_);
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_tmp22_ = _data11_->loop;
#line 266 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_main_loop_run (_tmp22_);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (headc);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	__vala_GgitOId_free0 (headoid);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_g_object_unref0 (_tmp5_);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	block11_data_unref (_data11_);
#line 219 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	_data11_ = NULL;
#line 2426 "test-commit.c"
}


static void gitg_test_commit_class_init (GitgTestCommitClass * klass) {
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	gitg_test_commit_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	((GitgTestTestClass *) klass)->set_up = gitg_test_commit_real_set_up;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	((GitgTestCommitClass *) klass)->test_commit = gitg_test_commit_real_test_commit;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	((GitgTestCommitClass *) klass)->test_sign_off = gitg_test_commit_real_test_sign_off;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	((GitgTestCommitClass *) klass)->test_pre_commit_hook = gitg_test_commit_real_test_pre_commit_hook;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	((GitgTestCommitClass *) klass)->test_commit_msg_hook = gitg_test_commit_real_test_commit_msg_hook;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	((GitgTestCommitClass *) klass)->test_skip_hooks = gitg_test_commit_real_test_skip_hooks;
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	((GitgTestCommitClass *) klass)->test_amend = gitg_test_commit_real_test_amend;
#line 2447 "test-commit.c"
	/**
	 * test commit.
	 */
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_signal_new ("test_commit", GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCommitClass, test_commit), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_signal_new ("test_sign_off", GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCommitClass, test_sign_off), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_signal_new ("test_pre_commit_hook", GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCommitClass, test_pre_commit_hook), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_signal_new ("test_commit_msg_hook", GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCommitClass, test_commit_msg_hook), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_signal_new ("test_skip_hooks", GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCommitClass, test_skip_hooks), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 22 "/home/jesse/git/gnome/gitg/tests/libgitg/test-commit.vala"
	g_signal_new ("test_amend", GITG_TEST_TYPE_COMMIT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgTestCommitClass, test_amend), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2463 "test-commit.c"
}


static void gitg_test_commit_instance_init (GitgTestCommit * self) {
}


GType gitg_test_commit_get_type (void) {
	static volatile gsize gitg_test_commit_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_commit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgTestCommitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_test_commit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgTestCommit), 0, (GInstanceInitFunc) gitg_test_commit_instance_init, NULL };
		GType gitg_test_commit_type_id;
		gitg_test_commit_type_id = g_type_register_static (GITG_TEST_TYPE_REPOSITORY, "GitgTestCommit", &g_define_type_info, 0);
		g_once_init_leave (&gitg_test_commit_type_id__volatile, gitg_test_commit_type_id);
	}
	return gitg_test_commit_type_id__volatile;
}



