/* gitg-repository-list-box.c generated by valac 0.24.0.87-362e, the Vala compiler
 * generated from gitg-repository-list-box.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Ignacio Casal Quinteiro
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define GITG_TYPE_REPOSITORY_LIST_BOX (gitg_repository_list_box_get_type ())
#define GITG_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox))
#define GITG_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))
#define GITG_IS_REPOSITORY_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_IS_REPOSITORY_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY_LIST_BOX))
#define GITG_REPOSITORY_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxClass))

typedef struct _GitgRepositoryListBox GitgRepositoryListBox;
typedef struct _GitgRepositoryListBoxClass GitgRepositoryListBoxClass;
typedef struct _GitgRepositoryListBoxPrivate GitgRepositoryListBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_REPOSITORY_LIST_BOX_TYPE_ROW (gitg_repository_list_box_row_get_type ())
#define GITG_REPOSITORY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow))
#define GITG_REPOSITORY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_ROW))
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowClass))

typedef struct _GitgRepositoryListBoxRow GitgRepositoryListBoxRow;
typedef struct _GitgRepositoryListBoxRowClass GitgRepositoryListBoxRowClass;

#define GITG_TYPE_REPOSITORY (gitg_repository_get_type ())
#define GITG_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REPOSITORY, GitgRepository))
#define GITG_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REPOSITORY, GitgRepositoryClass))
#define GITG_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REPOSITORY))
#define GITG_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REPOSITORY))
#define GITG_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REPOSITORY, GitgRepositoryClass))

typedef struct _GitgRepository GitgRepository;
typedef struct _GitgRepositoryClass GitgRepositoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block9Data Block9Data;

#define GITG_TYPE_REF (gitg_ref_get_type ())
#define GITG_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF, GitgRef))
#define GITG_IS_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF))
#define GITG_REF_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_REF, GitgRefIface))

typedef struct _GitgRef GitgRef;
typedef struct _GitgRefIface GitgRefIface;

#define GITG_TYPE_PARSED_REF_NAME (gitg_parsed_ref_name_get_type ())
#define GITG_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefName))
#define GITG_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))
#define GITG_IS_PARSED_REF_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PARSED_REF_NAME))
#define GITG_IS_PARSED_REF_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PARSED_REF_NAME))
#define GITG_PARSED_REF_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PARSED_REF_NAME, GitgParsedRefNameClass))

typedef struct _GitgParsedRefName GitgParsedRefName;
typedef struct _GitgParsedRefNameClass GitgParsedRefNameClass;

#define GITG_TYPE_REF_STATE (gitg_ref_state_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block10Data Block10Data;

#define GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS (gitg_repository_list_box_clone_progress_get_type ())
#define GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgress))
#define GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgressClass))
#define GITG_REPOSITORY_LIST_BOX_IS_CLONE_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS))
#define GITG_REPOSITORY_LIST_BOX_IS_CLONE_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS))
#define GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgressClass))

typedef struct _GitgRepositoryListBoxCloneProgress GitgRepositoryListBoxCloneProgress;
typedef struct _GitgRepositoryListBoxCloneProgressClass GitgRepositoryListBoxCloneProgressClass;
#define __vala_GgitCloneOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitCloneOptions_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _GitgRepositoryListBoxCloneData GitgRepositoryListBoxCloneData;
typedef struct _Block11Data Block11Data;
typedef struct _GitgRepositoryListBoxRowPrivate GitgRepositoryListBoxRowPrivate;

#define GITG_TYPE_PROGRESS_BIN (gitg_progress_bin_get_type ())
#define GITG_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBin))
#define GITG_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))
#define GITG_IS_PROGRESS_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PROGRESS_BIN))
#define GITG_IS_PROGRESS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PROGRESS_BIN))
#define GITG_PROGRESS_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PROGRESS_BIN, GitgProgressBinClass))

typedef struct _GitgProgressBin GitgProgressBin;
typedef struct _GitgProgressBinClass GitgProgressBinClass;
typedef struct _GitgRepositoryListBoxCloneProgressPrivate GitgRepositoryListBoxCloneProgressPrivate;

struct _GitgRepositoryListBox {
	GtkListBox parent_instance;
	GitgRepositoryListBoxPrivate * priv;
};

struct _GitgRepositoryListBoxClass {
	GtkListBoxClass parent_class;
};

struct _GitgRepositoryListBoxPrivate {
	gchar* d_filter_text;
};

struct _Block9Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
	GFile* f;
};

typedef enum  {
	GITG_REF_STATE_NONE,
	GITG_REF_STATE_SELECTED,
	GITG_REF_STATE_PRELIGHT
} GitgRefState;

struct _GitgRefIface {
	GTypeInterface parent_iface;
	GitgRepository* (*get_owner) (GitgRef* self);
	GitgParsedRefName* (*get_d_parsed_name) (GitgRef* self);
	void (*set_d_parsed_name) (GitgRef* self, GitgParsedRefName* value);
	GList* (*get_d_pushes) (GitgRef* self);
	void (*set_d_pushes) (GitgRef* self, GList* value);
	GitgRefState (*get_state) (GitgRef* self);
	void (*set_state) (GitgRef* self, GitgRefState value);
	gboolean (*get_working) (GitgRef* self);
	void (*set_working) (GitgRef* self, gboolean value);
};

struct _Block10Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GitgRepository* repository;
	GitgRepositoryListBoxRow* row;
	gchar* url;
	GFile* location;
	gboolean is_bare;
	gpointer _async_data_;
};

struct _GitgRepositoryListBoxCloneData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
	gchar* url;
	GFile* location;
	gboolean is_bare;
	GitgRepository* result;
	Block10Data* _data10_;
	GitgRepositoryListBoxRow* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	GThreadFunc run;
	void* run_target;
	GDestroyNotify run_target_destroy_notify;
	GThreadFunc _tmp4_;
	void* _tmp4__target;
	GDestroyNotify _tmp4__target_destroy_notify;
	GThread* _tmp5_;
	GThread* _tmp6_;
	GitgRepository* _tmp7_;
	GError * _inner_error_;
};

struct _Block11Data {
	int _ref_count_;
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* row;
};

struct _GitgRepositoryListBoxRow {
	GtkListBoxRow parent_instance;
	GitgRepositoryListBoxRowPrivate * priv;
};

struct _GitgRepositoryListBoxRowClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgRepositoryListBoxRowPrivate {
	GitgRepository* d_repository;
	GDateTime* d_time;
	gboolean d_loading;
	gboolean d_has_remote;
	GitgProgressBin* d_progress_bin;
	GtkImage* d_image;
	GtkLabel* d_repository_label;
	GtkLabel* d_branch_label;
	GtkArrow* d_arrow;
	GtkSpinner* d_spinner;
	GtkButton* d_remove_button;
};

struct _GitgRepositoryListBoxCloneProgress {
	GgitRemoteCallbacks parent_instance;
	GitgRepositoryListBoxCloneProgressPrivate * priv;
};

struct _GitgRepositoryListBoxCloneProgressClass {
	GgitRemoteCallbacksClass parent_class;
};

struct _GitgRepositoryListBoxCloneProgressPrivate {
	GitgRepositoryListBoxRow* d_row;
};


static gpointer gitg_repository_list_box_parent_class = NULL;
static GtkIconSize gitg_repository_list_box_d_icon_size;
static GtkIconSize gitg_repository_list_box_d_icon_size = 0;
static gpointer gitg_repository_list_box_row_parent_class = NULL;
static gpointer gitg_repository_list_box_clone_progress_parent_class = NULL;

GType gitg_repository_list_box_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBoxPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_DUMMY_PROPERTY
};
static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row);
static GType gitg_repository_list_box_row_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType gitg_repository_get_type (void) G_GNUC_CONST;
static GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before);
static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row);
static const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self);
static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b);
static GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
GitgRepository* gitg_repository_new (GFile* location, GFile* workdir, GError** error);
GitgRepository* gitg_repository_construct (GType object_type, GFile* location, GFile* workdir, GError** error);
void gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository);
static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri);
static void gtk_recent_data_destroy (GtkRecentData* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
GFile* ggit_repository_get_workdir (GgitRepository* self);
GType gitg_parsed_ref_name_get_type (void) G_GNUC_CONST;
GType gitg_ref_state_get_type (void) G_GNUC_CONST;
GType gitg_ref_get_type (void) G_GNUC_CONST;
GitgRef* gitg_repository_get_head (GitgRepository* self, GError** error);
GitgParsedRefName* gitg_ref_get_parsed_name (GitgRef* self);
gchar* gitg_parsed_ref_name_get_shortname (GitgParsedRefName* self);
gchar* gitg_repository_get_name (GitgRepository* self);
static GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (const gchar* name, const gchar* branch_name, gboolean has_remote);
static GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, const gchar* name, const gchar* branch_name, gboolean has_remote);
static void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value);
static void ____lambda41_ (Block9Data* _data9_);
static void _____lambda41__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self);
static void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value);
static void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value);
static void gitg_repository_list_box_clone_data_free (gpointer _data);
static void gitg_repository_list_box_clone (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, const gchar* url, GFile* location, gboolean is_bare, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GitgRepository* gitg_repository_list_box_clone_finish (GitgRepositoryListBox* self, GAsyncResult* _res_);
static gboolean gitg_repository_list_box_clone_co (GitgRepositoryListBoxCloneData* _data_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean _gitg_repository_list_box_clone_co_gsource_func (gpointer self);
static void* __lambda42_ (Block10Data* _data10_);
static GitgRepositoryListBoxCloneProgress* gitg_repository_list_box_clone_progress_new (GitgRepositoryListBoxRow* row);
static GitgRepositoryListBoxCloneProgress* gitg_repository_list_box_clone_progress_construct (GType object_type, GitgRepositoryListBoxRow* row);
static GType gitg_repository_list_box_clone_progress_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _vala_GgitCloneOptions_free (GgitCloneOptions* self);
static gpointer ___lambda42__gthread_func (gpointer self);
void gitg_repository_list_box_clone_repository (GitgRepositoryListBox* self, const gchar* url, GFile* location, gboolean is_bare);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value);
static void __lambda43_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res);
static void ___lambda43__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text);
GitgRepositoryListBox* gitg_repository_list_box_new (void);
GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
GType gitg_progress_bin_get_type (void) G_GNUC_CONST;
#define GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRowPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_ROW_DUMMY_PROPERTY,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY,
	GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE,
	GITG_REPOSITORY_LIST_BOX_ROW_TIME,
	GITG_REPOSITORY_LIST_BOX_ROW_FRACTION,
	GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME,
	GITG_REPOSITORY_LIST_BOX_ROW_LOADING,
	GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE
};
static void gitg_repository_list_box_row_remove_button_clicked (GitgRepositoryListBoxRow* self, GtkButton* remove);
static void _gitg_repository_list_box_row_remove_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value);
static void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value);
void gitg_progress_bin_set_fraction (GitgProgressBin* self, gdouble value);
static void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value);
static const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self);
static gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self);
static gboolean gitg_repository_list_box_row_get_has_remote (GitgRepositoryListBoxRow* self);
static void gitg_repository_list_box_row_set_has_remote (GitgRepositoryListBoxRow* self, gboolean value);
static void gitg_repository_list_box_row_finalize (GObject* obj);
static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgressPrivate))
enum  {
	GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_DUMMY_PROPERTY
};
static gboolean gitg_repository_list_box_clone_progress_real_transfer_progress (GgitRemoteCallbacks* base, GgitTransferProgress* stats, GError** error);
static void gitg_repository_list_box_clone_progress_finalize (GObject* obj);
static void gitg_repository_list_box_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 155 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 359 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_real_row_activated (GtkListBox* base, GtkListBoxRow* row) {
	GitgRepositoryListBox * self;
	GitgRepositoryListBoxRow* r = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgRepositoryListBoxRow* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GitgRepository* _tmp4_ = NULL;
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) base;
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 155 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 155 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 155 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	r = _tmp1_;
#line 157 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = r;
#line 157 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gitg_repository_list_box_row_get_repository (_tmp2_);
#line 157 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = _tmp3_;
#line 157 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp4_ != NULL) {
#line 389 "gitg-repository-list-box.c"
		GitgRepositoryListBoxRow* _tmp5_ = NULL;
		GitgRepository* _tmp6_ = NULL;
		GitgRepository* _tmp7_ = NULL;
#line 159 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = r;
#line 159 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = gitg_repository_list_box_row_get_repository (_tmp5_);
#line 159 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = _tmp6_;
#line 159 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "repository-activated", _tmp7_);
#line 401 "gitg-repository-list-box.c"
	}
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (r);
#line 405 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_update_header (GitgRepositoryListBox* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkSeparator* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (row != NULL);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = before;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 421 "gitg-repository-list-box.c"
		GtkSeparator* _tmp2_ = NULL;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp2_);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp2_;
#line 431 "gitg-repository-list-box.c"
	} else {
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp0_);
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = NULL;
#line 437 "gitg-repository-list-box.c"
	}
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = row;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_row_set_header (_tmp3_, (GtkWidget*) _tmp0_);
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp0_);
#line 445 "gitg-repository-list-box.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 465 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_filter (GitgRepositoryListBox* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (row != NULL, FALSE);
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_filter_text;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_ != NULL) {
#line 481 "gitg-repository-list-box.c"
		GtkListBoxRow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = row;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = gitg_repository_list_box_row_get_repository_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_filter_text;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = string_contains (_tmp4_, _tmp5_);
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = _tmp6_;
#line 499 "gitg-repository-list-box.c"
	} else {
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = TRUE;
#line 503 "gitg-repository-list-box.c"
	}
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 509 "gitg-repository-list-box.c"
}


static gint gitg_repository_list_box_compare_widgets (GitgRepositoryListBox* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 187 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 187 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 187 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = a;
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _tmp1_;
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = b;
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = gitg_repository_list_box_row_get_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_date_time_compare (_tmp2_, _tmp5_);
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = -_tmp6_;
#line 189 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 546 "gitg-repository-list-box.c"
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? gtk_recent_info_ref (self) : NULL;
#line 553 "gitg-repository-list-box.c"
}


static void _gtk_recent_info_unref0_ (gpointer var) {
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
#line 560 "gitg-repository-list-box.c"
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_list_free (self);
#line 569 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_recent_info (GitgRepositoryListBox* self) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GList* reversed_items = NULL;
	GtkRecentManager* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 192 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 194 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = recent_manager;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = _tmp3_;
#line 196 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	reversed_items = g_list_reverse (reversed_items);
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = reversed_items;
#line 600 "gitg-repository-list-box.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		item_collection = _tmp4_;
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 608 "gitg-repository-list-box.c"
			GtkRecentInfo* _tmp5_ = NULL;
			GtkRecentInfo* item = NULL;
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) item_it->data);
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			item = _tmp5_;
#line 615 "gitg-repository-list-box.c"
			{
				GtkRecentInfo* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 200 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = item;
#line 200 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = gtk_recent_info_has_group (_tmp6_, "gitg");
#line 200 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp7_) {
#line 625 "gitg-repository-list-box.c"
					GFile* info_file = NULL;
					GtkRecentInfo* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					GFile* _tmp10_ = NULL;
					GFile* repo_file = NULL;
					GitgRepository* repo = NULL;
					GitgRepository* _tmp25_ = NULL;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp8_ = item;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp9_ = gtk_recent_info_get_uri (_tmp8_);
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					info_file = _tmp10_;
#line 641 "gitg-repository-list-box.c"
					{
						GFile* _tmp11_ = NULL;
						GFile* _tmp12_ = NULL;
						GFile* _tmp13_ = NULL;
						GFile* _tmp14_ = NULL;
#line 207 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp12_ = info_file;
#line 207 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp13_ = ggit_repository_discover (_tmp12_, &_inner_error_);
#line 207 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = _tmp13_;
#line 207 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 655 "gitg-repository-list-box.c"
							goto __catch34_g_error;
						}
#line 207 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp14_ = _tmp11_;
#line 207 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp11_ = NULL;
#line 207 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 207 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						repo_file = _tmp14_;
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (_tmp11_);
#line 668 "gitg-repository-list-box.c"
					}
					goto __finally34;
					__catch34_g_error:
					{
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 677 "gitg-repository-list-box.c"
						{
							GtkRecentManager* _tmp15_ = NULL;
							GtkRecentInfo* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
#line 213 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp15_ = recent_manager;
#line 213 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp16_ = item;
#line 213 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp17_ = gtk_recent_info_get_uri (_tmp16_);
#line 213 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_recent_manager_remove_item (_tmp15_, _tmp17_, &_inner_error_);
#line 213 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 692 "gitg-repository-list-box.c"
								goto __catch35_g_error;
							}
						}
						goto __finally35;
						__catch35_g_error:
						{
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_inner_error_ = NULL;
#line 703 "gitg-repository-list-box.c"
						}
						__finally35:
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo_file);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (info_file);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_gtk_recent_info_unref0 (item);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (recent_manager);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							return;
#line 724 "gitg-repository-list-box.c"
						}
#line 216 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 216 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 216 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 216 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 216 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 216 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 738 "gitg-repository-list-box.c"
					}
					__finally34:
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 759 "gitg-repository-list-box.c"
					}
					{
						GitgRepository* _tmp18_ = NULL;
						GFile* _tmp19_ = NULL;
						GitgRepository* _tmp20_ = NULL;
						GitgRepository* _tmp21_ = NULL;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp19_ = repo_file;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp20_ = gitg_repository_new (_tmp19_, NULL, &_inner_error_);
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp18_ = _tmp20_;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 774 "gitg-repository-list-box.c"
							goto __catch36_g_error;
						}
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp21_ = _tmp18_;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_tmp18_ = NULL;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						repo = _tmp21_;
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (_tmp18_);
#line 787 "gitg-repository-list-box.c"
					}
					goto __finally36;
					__catch36_g_error:
					{
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_inner_error_ = NULL;
#line 796 "gitg-repository-list-box.c"
						{
							GtkRecentManager* _tmp22_ = NULL;
							GtkRecentInfo* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp22_ = recent_manager;
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp23_ = item;
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_tmp24_ = gtk_recent_info_get_uri (_tmp23_);
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							gtk_recent_manager_remove_item (_tmp22_, _tmp24_, &_inner_error_);
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 811 "gitg-repository-list-box.c"
								goto __catch37_g_error;
							}
						}
						goto __finally37;
						__catch37_g_error:
						{
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_inner_error_ = NULL;
#line 822 "gitg-repository-list-box.c"
						}
						__finally37:
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (repo_file);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (info_file);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_gtk_recent_info_unref0 (item);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							_g_object_unref0 (recent_manager);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							g_clear_error (&_inner_error_);
#line 227 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
							return;
#line 845 "gitg-repository-list-box.c"
						}
#line 232 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 232 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 232 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 232 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 232 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 232 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 232 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 861 "gitg-repository-list-box.c"
					}
					__finally36:
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (repo_file);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (info_file);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_gtk_recent_info_unref0 (item);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						_g_object_unref0 (recent_manager);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						g_clear_error (&_inner_error_);
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
						return;
#line 884 "gitg-repository-list-box.c"
					}
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp25_ = repo;
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					gitg_repository_list_box_add_repository (self, _tmp25_);
#line 200 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo);
#line 200 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (repo_file);
#line 200 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (info_file);
#line 896 "gitg-repository-list-box.c"
				}
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_gtk_recent_info_unref0 (item);
#line 900 "gitg-repository-list-box.c"
			}
		}
	}
#line 192 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	__g_list_free__gtk_recent_info_unref0_0 (reversed_items);
#line 192 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 908 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxRow* gitg_repository_list_box_get_row_for_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBoxRow* row = NULL;
	GList* _tmp0_ = NULL;
#line 240 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 240 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 242 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	row = NULL;
#line 244 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
#line 924 "gitg-repository-list-box.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 244 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		child_collection = _tmp0_;
#line 244 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 932 "gitg-repository-list-box.c"
			GtkWidget* child = NULL;
#line 244 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			child = (GtkWidget*) child_it->data;
#line 936 "gitg-repository-list-box.c"
			{
				GitgRepositoryListBoxRow* d = NULL;
				GtkWidget* _tmp1_ = NULL;
				GitgRepositoryListBoxRow* _tmp2_ = NULL;
				GitgRepositoryListBoxRow* _tmp3_ = NULL;
				GitgRepository* _tmp4_ = NULL;
				GitgRepository* _tmp5_ = NULL;
				GFile* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
				GitgRepository* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 246 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp1_ = child;
#line 246 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow));
#line 246 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				d = _tmp2_;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp3_ = d;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp4_ = gitg_repository_list_box_row_get_repository (_tmp3_);
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp5_ = _tmp4_;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp7_ = _tmp6_;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp8_ = repository;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp9_ = ggit_repository_get_location ((GgitRepository*) _tmp8_);
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp10_ = _tmp9_;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp11_ = g_file_equal (_tmp7_, _tmp10_);
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_tmp12_ = _tmp11_;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp10_);
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (_tmp7_);
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				if (_tmp12_) {
#line 983 "gitg-repository-list-box.c"
					GitgRepositoryListBoxRow* _tmp13_ = NULL;
					GitgRepositoryListBoxRow* _tmp14_ = NULL;
#line 249 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp13_ = d;
#line 249 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 249 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (row);
#line 249 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					row = _tmp14_;
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					_g_object_unref0 (d);
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
					break;
#line 998 "gitg-repository-list-box.c"
				}
#line 244 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (d);
#line 1002 "gitg-repository-list-box.c"
			}
		}
#line 244 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_list_free0 (child_collection);
#line 1007 "gitg-repository-list-box.c"
	}
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = row;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1013 "gitg-repository-list-box.c"
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).display_name);
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).description);
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).mime_type);
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_name);
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 ((*self).app_exec);
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
#line 1030 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_add_repository_to_recent_manager (GitgRepositoryListBox* self, const gchar* uri) {
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GtkRecentData item = {0};
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkRecentData _tmp10_ = {0};
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (uri != NULL);
#line 259 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_recent_manager_get_default ();
#line 259 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 259 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	recent_manager = _tmp1_;
#line 260 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	memset (&item, 0, sizeof (GtkRecentData));
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_get_application_name ();
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_name);
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_name = _tmp3_;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_strdup ("inode/directory");
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.mime_type);
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.mime_type = _tmp4_;
#line 263 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = g_get_prgname ();
#line 263 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_strjoin (" ", _tmp5_, "%f", NULL);
#line 263 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (item.app_exec);
#line 263 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.app_exec = _tmp6_;
#line 264 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = g_strdup ("gitg");
#line 264 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_ = g_new0 (gchar*, 2 + 1);
#line 264 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[0] = _tmp7_;
#line 264 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp8_[1] = NULL;
#line 264 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = (_vala_array_free (item.groups, _vala_array_length (item.groups), (GDestroyNotify) g_free), NULL);
#line 264 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	item.groups = _tmp8_;
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp9_ = uri;
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp10_ = item;
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_manager_add_full (recent_manager, _tmp9_, &_tmp10_);
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_recent_data_destroy (&item);
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (recent_manager);
#line 1104 "gitg-repository-list-box.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return _data9_;
#line 1113 "gitg-repository-list-box.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 1122 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data9_->self;
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data9_->f);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data9_->row);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block9Data, _data9_);
#line 1134 "gitg-repository-list-box.c"
	}
}


static void ____lambda41_ (Block9Data* _data9_) {
	GitgRepositoryListBox* self;
	GitgRepositoryListBoxRow* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data9_->self;
#line 1145 "gitg-repository-list-box.c"
	{
		GtkRecentManager* recent_manager = NULL;
		GtkRecentManager* _tmp0_ = NULL;
		GtkRecentManager* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 300 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = gtk_recent_manager_get_default ();
#line 300 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 300 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		recent_manager = _tmp1_;
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _data9_->f;
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = g_file_get_uri (_tmp2_);
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _tmp3_;
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_recent_manager_remove_item (recent_manager, _tmp4_, &_inner_error_);
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp4_);
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (recent_manager);
#line 1173 "gitg-repository-list-box.c"
			goto __catch39_g_error;
		}
#line 298 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (recent_manager);
#line 1178 "gitg-repository-list-box.c"
	}
	goto __finally39;
	__catch39_g_error:
	{
#line 298 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 298 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 1187 "gitg-repository-list-box.c"
	}
	__finally39:
#line 298 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 298 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 298 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 298 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 1198 "gitg-repository-list-box.c"
	}
#line 304 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _data9_->row;
#line 304 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _tmp5_);
#line 1204 "gitg-repository-list-box.c"
}


static void _____lambda41__gitg_repository_list_box_row_request_remove (GitgRepositoryListBoxRow* _sender, gpointer self) {
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	____lambda41_ (self);
#line 1211 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_add_repository (GitgRepositoryListBox* self, GitgRepository* repository) {
	Block9Data* _data9_;
	GitgRepository* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp14_ = NULL;
	GitgRepositoryListBoxRow* _tmp15_ = NULL;
	GFile* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (repository != NULL);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data9_->_ref_count_ = 1;
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data9_->self = g_object_ref (self);
#line 270 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = repository;
#line 270 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_get_row_for_repository (self, _tmp0_);
#line 270 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data9_->row = _tmp1_;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = repository;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_get ((GgitRepository*) _tmp3_, "workdir", &_tmp4_, NULL);
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = _tmp4_;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _tmp5_;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = _tmp6_ != NULL;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp6_);
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp7_) {
#line 1259 "gitg-repository-list-box.c"
		GitgRepository* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = repository;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_get ((GgitRepository*) _tmp8_, "workdir", &_tmp9_, NULL);
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = _tmp9_;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp10_;
#line 1273 "gitg-repository-list-box.c"
	} else {
		GitgRepository* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = repository;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = ggit_repository_get_location ((GgitRepository*) _tmp11_);
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = _tmp12_;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp2_);
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _tmp13_;
#line 1288 "gitg-repository-list-box.c"
	}
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp14_ = _g_object_ref0 (_tmp2_);
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data9_->f = _tmp14_;
#line 274 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = _data9_->row;
#line 274 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp15_ == NULL) {
#line 1298 "gitg-repository-list-box.c"
		gchar* head_name = NULL;
		gchar* _tmp16_ = NULL;
		gboolean has_remote = FALSE;
		GitgRepository* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		GitgRepositoryListBoxRow* _tmp35_ = NULL;
		GitgRepositoryListBoxRow* _tmp36_ = NULL;
		GitgRepository* _tmp37_ = NULL;
		GitgRepositoryListBoxRow* _tmp38_ = NULL;
		GFile* _tmp39_ = NULL;
		GitgRepositoryListBoxRow* _tmp43_ = NULL;
#line 276 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = g_strdup ("");
#line 276 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		head_name = _tmp16_;
#line 277 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		has_remote = TRUE;
#line 1320 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp17_ = NULL;
			GitgRef* _tmp18_ = NULL;
			GitgRef* _tmp19_ = NULL;
			GitgParsedRefName* _tmp20_ = NULL;
			GitgParsedRefName* _tmp21_ = NULL;
			GitgParsedRefName* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar** remotes = NULL;
			GitgRepository* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gchar** _tmp27_ = NULL;
			gint remotes_length1 = 0;
			gint _remotes_size_ = 0;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
#line 281 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp17_ = repository;
#line 281 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp18_ = gitg_repository_get_head (_tmp17_, &_inner_error_);
#line 281 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp18_;
#line 281 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1347 "gitg-repository-list-box.c"
				goto __catch38_g_error;
			}
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp19_ = head;
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp20_ = gitg_ref_get_parsed_name (_tmp19_);
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp21_ = _tmp20_;
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp22_ = _tmp21_;
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp23_ = gitg_parsed_ref_name_get_shortname (_tmp22_);
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp24_ = _tmp23_;
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			head_name = _tmp24_;
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp22_);
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp25_ = repository;
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp27_ = _tmp26_ = ggit_repository_list_remotes ((GgitRepository*) _tmp25_, &_inner_error_);
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			remotes = _tmp27_;
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			remotes_length1 = _vala_array_length (_tmp26_);
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_remotes_size_ = remotes_length1;
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 283 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				_g_object_unref0 (head);
#line 1382 "gitg-repository-list-box.c"
				goto __catch38_g_error;
			}
#line 284 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp28_ = remotes;
#line 284 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp28__length1 = remotes_length1;
#line 284 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (_tmp28__length1 == 0) {
#line 286 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
				has_remote = FALSE;
#line 1393 "gitg-repository-list-box.c"
			}
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			remotes = (_vala_array_free (remotes, remotes_length1, (GDestroyNotify) g_free), NULL);
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 1399 "gitg-repository-list-box.c"
		}
		goto __finally38;
		__catch38_g_error:
		{
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 1408 "gitg-repository-list-box.c"
		}
		__finally38:
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (head_name);
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp2_);
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			block9_data_unref (_data9_);
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_data9_ = NULL;
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 279 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			return;
#line 1427 "gitg-repository-list-box.c"
		}
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp29_ = repository;
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp30_ = gitg_repository_get_name (_tmp29_);
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp31_ = _tmp30_;
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp32_ = _tmp31_;
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp33_ = head_name;
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp34_ = has_remote;
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp35_ = gitg_repository_list_box_row_new (_tmp32_, _tmp33_, _tmp34_);
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_object_ref_sink (_tmp35_);
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data9_->row);
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data9_->row = _tmp35_;
#line 291 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp32_);
#line 292 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp36_ = _data9_->row;
#line 292 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp37_ = repository;
#line 292 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (_tmp36_, _tmp37_);
#line 293 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp38_ = _data9_->row;
#line 293 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp38_);
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp39_ = _data9_->f;
#line 295 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp39_ != NULL) {
#line 1465 "gitg-repository-list-box.c"
			GitgRepositoryListBoxRow* _tmp40_ = NULL;
			GitgRepositoryListBoxRow* _tmp41_ = NULL;
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp40_ = _data9_->row;
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_signal_connect_data (_tmp40_, "request-remove", (GCallback) _____lambda41__gitg_repository_list_box_row_request_remove, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 307 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp41_ = _data9_->row;
#line 307 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp41_, TRUE);
#line 1476 "gitg-repository-list-box.c"
		} else {
			GitgRepositoryListBoxRow* _tmp42_ = NULL;
#line 311 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp42_ = _data9_->row;
#line 311 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_can_remove (_tmp42_, FALSE);
#line 1483 "gitg-repository-list-box.c"
		}
#line 314 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp43_ = _data9_->row;
#line 314 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp43_);
#line 274 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (head_name);
#line 1491 "gitg-repository-list-box.c"
	} else {
		GitgRepositoryListBoxRow* _tmp44_ = NULL;
		GDateTime* _tmp45_ = NULL;
		GDateTime* _tmp46_ = NULL;
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp44_ = _data9_->row;
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp45_ = g_date_time_new_now_local ();
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp46_ = _tmp45_;
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (_tmp44_, _tmp46_);
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_date_time_unref0 (_tmp46_);
#line 320 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_list_box_invalidate_sort ((GtkListBox*) self);
#line 1508 "gitg-repository-list-box.c"
	}
#line 323 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp47_ = _data9_->f;
#line 323 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp47_ != NULL) {
#line 1514 "gitg-repository-list-box.c"
		GFile* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
#line 325 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp48_ = _data9_->f;
#line 325 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp49_ = g_file_get_uri (_tmp48_);
#line 325 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp50_ = _tmp49_;
#line 325 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp50_);
#line 325 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp50_);
#line 1528 "gitg-repository-list-box.c"
	}
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_tmp2_);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	block9_data_unref (_data9_);
#line 268 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data9_ = NULL;
#line 1536 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone_data_free (gpointer _data) {
	GitgRepositoryListBoxCloneData* _data_;
	_data_ = _data;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->result);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_slice_free (GitgRepositoryListBoxCloneData, _data_);
#line 1549 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone (GitgRepositoryListBox* self, GitgRepositoryListBoxRow* row, const gchar* url, GFile* location, gboolean is_bare, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRepositoryListBoxCloneData* _data_;
	GitgRepositoryListBox* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgRepositoryListBoxRow* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_ = g_slice_new0 (GitgRepositoryListBoxCloneData);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_repository_list_box_clone);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_repository_list_box_clone_data_free);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->self = _tmp0_;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = row;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->row);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->row = _tmp2_;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = url;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_data_->url);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->url = _tmp4_;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = location;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->location);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->location = _tmp6_;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp7_ = is_bare;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->is_bare = _tmp7_;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_clone_co (_data_);
#line 1603 "gitg-repository-list-box.c"
}


static GitgRepository* gitg_repository_list_box_clone_finish (GitgRepositoryListBox* self, GAsyncResult* _res_) {
	GitgRepository* result;
	GitgRepositoryListBoxCloneData* _data_;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _data_->result;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->result = NULL;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1618 "gitg-repository-list-box.c"
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return _data10_;
#line 1627 "gitg-repository-list-box.c"
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 1636 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data10_->self;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data10_->repository);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		(_data10_->callback_target_destroy_notify == NULL) ? NULL : (_data10_->callback_target_destroy_notify (_data10_->callback_target), NULL);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data10_->callback = NULL;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data10_->callback_target = NULL;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data10_->callback_target_destroy_notify = NULL;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data10_->row);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_data10_->url);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data10_->location);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block10Data, _data10_);
#line 1660 "gitg-repository-list-box.c"
	}
}


static gboolean _gitg_repository_list_box_clone_co_gsource_func (gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_clone_co (self);
#line 351 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1670 "gitg-repository-list-box.c"
}


static void _vala_GgitCloneOptions_free (GgitCloneOptions* self) {
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_boxed_free (ggit_clone_options_get_type (), self);
#line 1677 "gitg-repository-list-box.c"
}


static void* __lambda42_ (Block10Data* _data10_) {
	GitgRepositoryListBox* self;
	void* result = NULL;
	GSourceFunc _tmp17_ = NULL;
	void* _tmp17__target = NULL;
	GDestroyNotify _tmp17__target_destroy_notify = NULL;
	GError * _inner_error_ = NULL;
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data10_->self;
#line 1690 "gitg-repository-list-box.c"
	{
		GgitCloneOptions* options = NULL;
		GgitCloneOptions* _tmp0_ = NULL;
		GgitCloneOptions* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		GgitCloneOptions* _tmp3_ = NULL;
		GitgRepositoryListBoxRow* _tmp4_ = NULL;
		GitgRepositoryListBoxCloneProgress* _tmp5_ = NULL;
		GitgRepositoryListBoxCloneProgress* _tmp6_ = NULL;
		GgitRepository* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GgitCloneOptions* _tmp10_ = NULL;
		GgitRepository* _tmp11_ = NULL;
		GgitRepository* _tmp12_ = NULL;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp0_ = ggit_clone_options_new ();
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		options = _tmp0_;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = options;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = _data10_->is_bare;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		ggit_clone_options_set_is_bare (_tmp1_, _tmp2_);
#line 360 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = options;
#line 360 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = _data10_->row;
#line 360 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = gitg_repository_list_box_clone_progress_new (_tmp4_);
#line 360 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = _tmp5_;
#line 360 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		ggit_clone_options_set_remote_callbacks (_tmp3_, (GgitRemoteCallbacks*) _tmp6_);
#line 360 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp6_);
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = _data10_->url;
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = _data10_->location;
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = options;
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = ggit_repository_clone (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = _tmp11_;
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			__vala_GgitCloneOptions_free0 (options);
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (_inner_error_->domain == GGIT_ERROR) {
#line 1744 "gitg-repository-list-box.c"
				goto __catch40_ggit_error;
			}
			goto __catch40_g_error;
		}
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = _tmp7_;
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = NULL;
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data10_->repository);
#line 362 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data10_->repository = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GITG_TYPE_REPOSITORY, GitgRepository);
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_tmp7_);
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		__vala_GgitCloneOptions_free0 (options);
#line 1761 "gitg-repository-list-box.c"
	}
	goto __finally40;
	__catch40_ggit_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = e;
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = _tmp13_->message;
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "show-error", "Gitg could not clone the git repository.", _tmp14_);
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 1781 "gitg-repository-list-box.c"
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 370 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp15_ = e;
#line 370 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp16_ = _tmp15_->message;
#line 370 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "show-error", "Gitg could not clone the git repository.", _tmp16_);
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 1801 "gitg-repository-list-box.c"
	}
	__finally40:
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 355 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return NULL;
#line 1812 "gitg-repository-list-box.c"
	}
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17_ = _data10_->callback;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17__target = _data10_->callback_target;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17__target_destroy_notify = _data10_->callback_target_destroy_notify;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data10_->callback_target_destroy_notify = NULL;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp17_, _tmp17__target, _tmp17__target_destroy_notify);
#line 374 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = NULL;
#line 374 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1828 "gitg-repository-list-box.c"
}


static gpointer ___lambda42__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda42_ (self);
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	block10_data_unref (self);
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 1839 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_clone_co (GitgRepositoryListBoxCloneData* _data_) {
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (_data_->_state_) {
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case 0:
#line 1848 "gitg-repository-list-box.c"
		goto _state_0;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case 1:
#line 1852 "gitg-repository-list-box.c"
		goto _state_1;
		default:
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_assert_not_reached ();
#line 1857 "gitg-repository-list-box.c"
	}
	_state_0:
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_ = g_slice_new0 (Block10Data);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->_ref_count_ = 1;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->self = g_object_ref (_data_->self);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp0_ = NULL;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp0_ = _data_->row;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->_data10_->row);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->row = _data_->_tmp0_;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp1_ = NULL;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp1_ = _data_->url;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_data_->_data10_->url);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->url = _data_->_tmp1_;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp2_ = NULL;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp2_ = _data_->location;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (_data_->_data10_->location);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->location = _data_->_tmp2_;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp3_ = FALSE;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp3_ = _data_->is_bare;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->is_bare = _data_->_tmp3_;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->_async_data_ = _data_;
#line 351 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->callback = _gitg_repository_list_box_clone_co_gsource_func;
#line 351 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->callback_target = _data_;
#line 351 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->callback_target_destroy_notify = NULL;
#line 352 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_->repository = NULL;
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run_target = NULL;
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run_target_destroy_notify = NULL;
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run = ___lambda42__gthread_func;
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run_target = block10_data_ref (_data_->_data10_);
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->run_target_destroy_notify = block10_data_unref;
#line 1916 "gitg-repository-list-box.c"
	{
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4_ = NULL;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4__target = NULL;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4__target_destroy_notify = NULL;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4_ = _data_->run;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4__target = _data_->run_target;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp4__target_destroy_notify = _data_->run_target_destroy_notify;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->run_target_destroy_notify = NULL;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp5_ = NULL;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp5_ = g_thread_try_new ("gitg-clone-thread", _data_->_tmp4_, _data_->_tmp4__target, &_data_->_inner_error_);
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp6_ = NULL;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_thread_unref0 (_data_->_tmp6_);
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1944 "gitg-repository-list-box.c"
			goto __catch41_g_error;
		}
#line 380 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_state_ = 1;
#line 380 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return FALSE;
#line 1951 "gitg-repository-list-box.c"
		_state_1:
		;
	}
	goto __finally41;
	__catch41_g_error:
	{
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_data_->_inner_error_);
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_inner_error_ = NULL;
#line 1962 "gitg-repository-list-box.c"
	}
	__finally41:
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		block10_data_unref (_data_->_data10_);
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data_->_data10_ = NULL;
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_data_->_inner_error_);
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return FALSE;
#line 1977 "gitg-repository-list-box.c"
	}
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp7_ = NULL;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_tmp7_ = _g_object_ref0 (_data_->_data10_->repository);
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->result = _data_->_tmp7_;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	block10_data_unref (_data_->_data10_);
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_ = NULL;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_data_->_state_ == 0) {
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1993 "gitg-repository-list-box.c"
	} else {
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1997 "gitg-repository-list-box.c"
	}
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_unref (_data_->_async_result);
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return FALSE;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	block10_data_unref (_data_->_data10_);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data_->_data10_ = NULL;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_data_->_state_ == 0) {
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2011 "gitg-repository-list-box.c"
	} else {
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2015 "gitg-repository-list-box.c"
	}
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_unref (_data_->_async_result);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return FALSE;
#line 2021 "gitg-repository-list-box.c"
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return _data11_;
#line 2030 "gitg-repository-list-box.c"
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 2039 "gitg-repository-list-box.c"
		GitgRepositoryListBox* self;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		self = _data11_->self;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (_data11_->row);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (self);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_slice_free (Block11Data, _data11_);
#line 2049 "gitg-repository-list-box.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2073 "gitg-repository-list-box.c"
		glong _tmp4_ = 0L;
#line 1199 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2081 "gitg-repository-list-box.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2093 "gitg-repository-list-box.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2117 "gitg-repository-list-box.c"
		glong _tmp2_ = 0L;
#line 1210 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2123 "gitg-repository-list-box.c"
	} else {
#line 1210 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2127 "gitg-repository-list-box.c"
	}
#line 1210 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2131 "gitg-repository-list-box.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2143 "gitg-repository-list-box.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2153 "gitg-repository-list-box.c"
	}
#line 1217 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2159 "gitg-repository-list-box.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2173 "gitg-repository-list-box.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2183 "gitg-repository-list-box.c"
	}
#line 1223 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2189 "gitg-repository-list-box.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2198 "gitg-repository-list-box.c"
	}
#line 1226 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 2218 "gitg-repository-list-box.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2243 "gitg-repository-list-box.c"
		gchar* _tmp4_ = NULL;
#line 934 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2251 "gitg-repository-list-box.c"
	} else {
#line 936 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2257 "gitg-repository-list-box.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2291 "gitg-repository-list-box.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2300 "gitg-repository-list-box.c"
	}
#line 1235 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2306 "gitg-repository-list-box.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2315 "gitg-repository-list-box.c"
	}
#line 1238 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2321 "gitg-repository-list-box.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2330 "gitg-repository-list-box.c"
	} else {
#line 1238 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2334 "gitg-repository-list-box.c"
	}
#line 1238 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 2342 "gitg-repository-list-box.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 2351 "gitg-repository-list-box.c"
	} else {
#line 1239 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 2355 "gitg-repository-list-box.c"
	}
#line 1239 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/opt/gnome/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 2377 "gitg-repository-list-box.c"
}


static void __lambda43_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res) {
	GitgRepositoryListBox* self;
	GitgRepository* repository = NULL;
	GAsyncResult* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	GitgRepositoryListBoxRow* _tmp15_ = NULL;
	GitgRepository* _tmp16_ = NULL;
	GitgRepositoryListBoxRow* _tmp17_ = NULL;
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = _data11_->self;
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (res != NULL);
#line 419 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = res;
#line 419 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gitg_repository_list_box_clone_finish (self, _tmp0_);
#line 419 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	repository = _tmp1_;
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = repository;
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ != NULL) {
#line 2404 "gitg-repository-list-box.c"
		GFile* workdir = NULL;
		GitgRepository* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* repo_file = NULL;
		GitgRepository* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		gchar* uri = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 424 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = repository;
#line 424 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = ggit_repository_get_workdir ((GgitRepository*) _tmp3_);
#line 424 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		workdir = _tmp4_;
#line 425 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = repository;
#line 425 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = ggit_repository_get_location ((GgitRepository*) _tmp5_);
#line 425 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		repo_file = _tmp6_;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = workdir;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp8_ != NULL) {
#line 2432 "gitg-repository-list-box.c"
			GFile* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = workdir;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = g_file_get_uri (_tmp9_);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp7_);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp10_;
#line 2443 "gitg-repository-list-box.c"
		} else {
			GFile* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = repo_file;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp12_ = g_file_get_uri (_tmp11_);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp7_);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp12_;
#line 2455 "gitg-repository-list-box.c"
		}
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp13_ = g_strdup (_tmp7_);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		uri = _tmp13_;
#line 427 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp14_ = uri;
#line 427 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_add_repository_to_recent_manager (self, _tmp14_);
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (uri);
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (_tmp7_);
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (repo_file);
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (workdir);
#line 2473 "gitg-repository-list-box.c"
	}
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = _data11_->row;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp16_ = repository;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_repository (_tmp15_, _tmp16_);
#line 431 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17_ = _data11_->row;
#line 431 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_loading (_tmp17_, FALSE);
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (repository);
#line 2487 "gitg-repository-list-box.c"
}


static void ___lambda43__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	__lambda43_ (self, source_object, res);
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	block11_data_unref (self);
#line 2496 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_clone_repository (GitgRepositoryListBox* self, const gchar* url, GFile* location, gboolean is_bare) {
	Block11Data* _data11_;
	gchar* subfolder_name = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GFile* subfolder = NULL;
	GFile* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	const gchar* _tmp21_ = NULL;
	GitgRepositoryListBoxRow* _tmp22_ = NULL;
	GitgRepositoryListBoxRow* _tmp23_ = NULL;
	GitgRepositoryListBoxRow* _tmp24_ = NULL;
	GitgRepositoryListBoxRow* _tmp25_ = NULL;
	GitgRepositoryListBoxRow* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (url != NULL);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (location != NULL);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data11_->_ref_count_ = 1;
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data11_->self = g_object_ref (self);
#line 390 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = url;
#line 390 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = url;
#line 390 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = string_last_index_of_char (_tmp1_, (gunichar) '/', 0);
#line 390 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = string_substring (_tmp0_, (glong) (_tmp2_ + 1), (glong) (-1));
#line 390 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	subfolder_name = _tmp3_;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = subfolder_name;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = g_str_has_suffix (_tmp5_, ".git");
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp6_) {
#line 2552 "gitg-repository-list-box.c"
		gboolean _tmp7_ = FALSE;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = is_bare;
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = !_tmp7_;
#line 2558 "gitg-repository-list-box.c"
	} else {
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = FALSE;
#line 2562 "gitg-repository-list-box.c"
	}
#line 391 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp4_) {
#line 2566 "gitg-repository-list-box.c"
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = subfolder_name;
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp9_ = strlen (".git");
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp10_ = _tmp9_;
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp11_ = string_slice (_tmp8_, (glong) 0, (glong) (-_tmp10_));
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (subfolder_name);
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		subfolder_name = _tmp11_;
#line 2583 "gitg-repository-list-box.c"
	} else {
		gboolean _tmp12_ = FALSE;
#line 395 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp12_ = is_bare;
#line 395 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (_tmp12_) {
#line 2590 "gitg-repository-list-box.c"
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 397 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp13_ = subfolder_name;
#line 397 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp14_ = g_strconcat (_tmp13_, ".git", NULL);
#line 397 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (subfolder_name);
#line 397 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			subfolder_name = _tmp14_;
#line 2601 "gitg-repository-list-box.c"
		}
	}
#line 400 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp15_ = location;
#line 400 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp16_ = subfolder_name;
#line 400 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp17_ = g_file_resolve_relative_path (_tmp15_, _tmp16_);
#line 400 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	subfolder = _tmp17_;
#line 2612 "gitg-repository-list-box.c"
	{
		GFile* _tmp18_ = NULL;
#line 404 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp18_ = subfolder;
#line 404 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_file_make_directory_with_parents (_tmp18_, NULL, &_inner_error_);
#line 404 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2621 "gitg-repository-list-box.c"
			goto __catch42_g_error;
		}
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		e = _inner_error_;
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_inner_error_ = NULL;
#line 408 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp19_ = e;
#line 408 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp20_ = _tmp19_->message;
#line 408 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_signal_emit_by_name (self, "show-error", "Gitg could not clone the git repository.", _tmp20_);
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_error_free0 (e);
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (subfolder);
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (subfolder_name);
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		block11_data_unref (_data11_);
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data11_ = NULL;
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 2653 "gitg-repository-list-box.c"
	}
	__finally42:
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_object_unref0 (subfolder);
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_g_free0 (subfolder_name);
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		block11_data_unref (_data11_);
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_data11_ = NULL;
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_clear_error (&_inner_error_);
#line 402 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		return;
#line 2672 "gitg-repository-list-box.c"
	}
#line 413 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp21_ = subfolder_name;
#line 413 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp22_ = gitg_repository_list_box_row_new (_tmp21_, "Cloning...", TRUE);
#line 413 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_ref_sink (_tmp22_);
#line 413 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data11_->row = _tmp22_;
#line 414 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp23_ = _data11_->row;
#line 414 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_loading (_tmp23_, TRUE);
#line 415 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp24_ = _data11_->row;
#line 415 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp24_);
#line 416 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp25_ = _data11_->row;
#line 416 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp26_ = _data11_->row;
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp27_ = url;
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp28_ = subfolder;
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp29_ = is_bare;
#line 418 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_clone (self, _tmp26_, _tmp27_, _tmp28_, _tmp29_, ___lambda43__gasync_ready_callback, block11_data_ref (_data11_));
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (subfolder);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (subfolder_name);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	block11_data_unref (_data11_);
#line 387 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_data11_ = NULL;
#line 2712 "gitg-repository-list-box.c"
}


void gitg_repository_list_box_filter_text (GitgRepositoryListBox* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 435 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 437 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = text;
#line 437 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 437 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 437 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_filter_text = _tmp1_;
#line 439 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
#line 2731 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_construct (GType object_type) {
	GitgRepositoryListBox * self = NULL;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBox*) g_object_new (object_type, NULL);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 2741 "gitg-repository-list-box.c"
}


GitgRepositoryListBox* gitg_repository_list_box_new (void) {
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_construct (GITG_TYPE_REPOSITORY_LIST_BOX);
#line 2748 "gitg-repository-list-box.c"
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (n_param_values == 3);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = closure->data;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = param_values->data[0].v_pointer;
#line 2767 "gitg-repository-list-box.c"
	} else {
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data1 = param_values->data[0].v_pointer;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		data2 = closure->data;
#line 2773 "gitg-repository-list-box.c"
	}
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 2779 "gitg-repository-list-box.c"
}


static void _gitg_repository_list_box_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_update_header ((GitgRepositoryListBox*) self, row, before);
#line 2786 "gitg-repository-list-box.c"
}


static gboolean _gitg_repository_list_box_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = gitg_repository_list_box_filter ((GitgRepositoryListBox*) self, row);
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2795 "gitg-repository-list-box.c"
}


static gint _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = gitg_repository_list_box_compare_widgets ((GitgRepositoryListBox*) self, row1, row2);
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2804 "gitg-repository-list-box.c"
}


static GObject * gitg_repository_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgRepositoryListBox * self;
	GtkIconSize _tmp0_ = 0;
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	parent_class = G_OBJECT_CLASS (gitg_repository_list_box_parent_class);
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 165 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = gtk_icon_size_register ("gitg", 64, 64);
#line 165 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_d_icon_size = _tmp0_;
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_header_func ((GtkListBox*) self, _gitg_repository_list_box_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_filter_func ((GtkListBox*) self, _gitg_repository_list_box_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_repository_list_box_compare_widgets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 172 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
#line 174 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_add_recent_info (self);
#line 163 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return obj;
#line 2837 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxRow* gitg_repository_list_box_row_construct (GType object_type, const gchar* name, const gchar* branch_name, gboolean has_remote) {
	GitgRepositoryListBoxRow * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (branch_name != NULL, NULL);
#line 140 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = name;
#line 140 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = branch_name;
#line 140 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = has_remote;
#line 140 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxRow*) g_object_new (object_type, "repository-name", _tmp0_, "branch-name", _tmp1_, "has-remote", _tmp2_, NULL);
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 2860 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxRow* gitg_repository_list_box_row_new (const gchar* name, const gchar* branch_name, gboolean has_remote) {
#line 138 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_row_construct (GITG_REPOSITORY_LIST_BOX_TYPE_ROW, name, branch_name, has_remote);
#line 2867 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_remove_button_clicked (GitgRepositoryListBoxRow* self, GtkButton* remove) {
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (remove != NULL);
#line 146 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_emit_by_name (self, "request-remove");
#line 2878 "gitg-repository-list-box.c"
}


static void _gitg_repository_list_box_row_remove_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_remove_button_clicked ((GitgRepositoryListBoxRow*) self, _sender);
#line 2885 "gitg-repository-list-box.c"
}


static GitgRepository* gitg_repository_list_box_row_get_repository (GitgRepositoryListBoxRow* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 53 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository;
#line 53 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 53 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 2900 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_set_repository (GitgRepositoryListBoxRow* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 56 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 56 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_repository = _tmp1_;
#line 58 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_branch_name (self, "");
#line 59 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_repository;
#line 59 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_ != NULL) {
#line 2925 "gitg-repository-list-box.c"
		{
			GitgRef* head = NULL;
			GitgRepository* _tmp3_ = NULL;
			GitgRef* _tmp4_ = NULL;
			GitgRef* _tmp5_ = NULL;
			GitgParsedRefName* _tmp6_ = NULL;
			GitgParsedRefName* _tmp7_ = NULL;
			GitgParsedRefName* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp3_ = self->priv->d_repository;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp4_ = gitg_repository_get_head (_tmp3_, &_inner_error_);
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			head = _tmp4_;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2945 "gitg-repository-list-box.c"
				goto __catch43_g_error;
			}
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp5_ = head;
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp6_ = gitg_ref_get_parsed_name (_tmp5_);
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp7_ = _tmp6_;
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp8_ = _tmp7_;
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp9_ = gitg_parsed_ref_name_get_shortname (_tmp8_);
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp10_ = _tmp9_;
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_tmp11_ = _tmp10_;
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			gitg_repository_list_box_row_set_branch_name (self, _tmp11_);
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_free0 (_tmp11_);
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (_tmp8_);
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_g_object_unref0 (head);
#line 2970 "gitg-repository-list-box.c"
		}
		goto __finally43;
		__catch43_g_error:
		{
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			_inner_error_ = NULL;
#line 2979 "gitg-repository-list-box.c"
		}
		__finally43:
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			g_clear_error (&_inner_error_);
#line 61 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
			return;
#line 2990 "gitg-repository-list-box.c"
		}
	}
#line 54 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository");
#line 2995 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_set_can_remove (GitgRepositoryListBoxRow* self, gboolean value) {
	GtkButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 73 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_remove_button;
#line 75 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 75 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_);
#line 73 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "can-remove");
#line 3012 "gitg-repository-list-box.c"
}


static GDateTime* gitg_repository_list_box_row_get_time (GitgRepositoryListBoxRow* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 81 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 81 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_time;
#line 81 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 81 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3027 "gitg-repository-list-box.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 3034 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_set_time (GitgRepositoryListBoxRow* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_time = _tmp1_;
#line 82 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "time");
#line 3053 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_set_fraction (GitgRepositoryListBoxRow* self, gdouble value) {
	GitgProgressBin* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_progress_bin;
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_progress_bin_set_fraction (_tmp0_, _tmp1_);
#line 88 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "fraction");
#line 3070 "gitg-repository-list-box.c"
}


static const gchar* gitg_repository_list_box_row_get_repository_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 93 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3088 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_set_repository_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_repository_label;
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_strdup_printf ("<b>%s</b>", _tmp1_);
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = _tmp2_;
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_markup (_tmp0_, _tmp3_);
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp3_);
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "repository-name");
#line 3113 "gitg-repository-list-box.c"
}


static const gchar* gitg_repository_list_box_row_get_branch_name (GitgRepositoryListBoxRow* self) {
	const gchar* result;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_label;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = gtk_label_get_text (_tmp0_);
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp1_;
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3131 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_set_branch_name (GitgRepositoryListBoxRow* self, const gchar* value) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_branch_label;
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = value;
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = g_strdup_printf ("<small>%s</small>", _tmp1_);
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = _tmp2_;
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_label_set_markup (_tmp0_, _tmp3_);
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (_tmp3_);
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "branch-name");
#line 3156 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_row_get_loading (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 105 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 105 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_loading;
#line 105 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 105 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3171 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_set_loading (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 108 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_loading = _tmp0_;
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = self->priv->d_loading;
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp1_) {
#line 3188 "gitg-repository-list-box.c"
		GtkSpinner* _tmp2_ = NULL;
		GtkSpinner* _tmp3_ = NULL;
		GtkArrow* _tmp4_ = NULL;
		GitgProgressBin* _tmp5_ = NULL;
#line 112 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp2_ = self->priv->d_spinner;
#line 112 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_stop (_tmp2_);
#line 113 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp3_ = self->priv->d_spinner;
#line 113 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 114 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp4_ = self->priv->d_arrow;
#line 114 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp4_);
#line 115 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp5_ = self->priv->d_progress_bin;
#line 115 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_progress_bin_set_fraction (_tmp5_, (gdouble) 0);
#line 3209 "gitg-repository-list-box.c"
	} else {
		GtkArrow* _tmp6_ = NULL;
		GtkSpinner* _tmp7_ = NULL;
		GtkSpinner* _tmp8_ = NULL;
#line 119 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp6_ = self->priv->d_arrow;
#line 119 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 120 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp7_ = self->priv->d_spinner;
#line 120 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_widget_show ((GtkWidget*) _tmp7_);
#line 121 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp8_ = self->priv->d_spinner;
#line 121 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gtk_spinner_start (_tmp8_);
#line 3226 "gitg-repository-list-box.c"
	}
#line 106 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "loading");
#line 3230 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_row_get_has_remote (GitgRepositoryListBoxRow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = self->priv->d_has_remote;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = _tmp0_;
#line 128 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3245 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_set_has_remote (GitgRepositoryListBoxRow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* folder_icon_name = NULL;
	gchar* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkIconSize _tmp5_ = 0;
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = value;
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_has_remote = _tmp0_;
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = self->priv->d_has_remote;
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	if (_tmp2_) {
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = "folder-remote";
#line 3269 "gitg-repository-list-box.c"
	} else {
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		_tmp1_ = "folder";
#line 3273 "gitg-repository-list-box.c"
	}
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = g_strdup (_tmp1_);
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	folder_icon_name = _tmp3_;
#line 134 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = self->priv->d_image;
#line 134 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = gitg_repository_list_box_d_icon_size;
#line 134 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_image_set_from_icon_name (_tmp4_, folder_icon_name, _tmp5_);
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (folder_icon_name);
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_notify ((GObject *) self, "has-remote");
#line 3289 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_class_init (GitgRepositoryListBoxRowClass * klass) {
	gint GitgRepositoryListBoxRow_private_offset;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxRowPrivate));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_repository_list_box_row_get_property;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_repository_list_box_row_set_property;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_row_finalize;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE, g_param_spec_boolean ("can-remove", "can-remove", "can-remove", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_TIME, g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_FRACTION, g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME, g_param_spec_string ("repository-name", "repository-name", "repository-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME, g_param_spec_string ("branch-name", "branch-name", "branch-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_LOADING, g_param_spec_boolean ("loading", "loading", "loading", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE, g_param_spec_boolean ("has-remote", "has-remote", "has-remote", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	GitgRepositoryListBoxRow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/gtk/gitg-repository-list-box-row.ui");
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("request_remove", GITG_REPOSITORY_LIST_BOX_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_progress_bin", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_progress_bin));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_image", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_image));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_repository_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_repository_label));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_branch_label", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_branch_label));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_arrow", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_arrow));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_spinner", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_spinner));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_remove_button", FALSE, GitgRepositoryListBoxRow_private_offset + G_STRUCT_OFFSET (GitgRepositoryListBoxRowPrivate, d_remove_button));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "remove_button_clicked", G_CALLBACK(_gitg_repository_list_box_row_remove_button_clicked_gtk_button_clicked));
#line 3343 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_instance_init (GitgRepositoryListBoxRow * self) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_ROW_GET_PRIVATE (self);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _tmp0_;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_time (self, _tmp1_);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_ensure (GITG_TYPE_PROGRESS_BIN);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 3362 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_row_finalize (GObject* obj) {
	GitgRepositoryListBoxRow * self;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 30 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 31 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_date_time_unref0 (self->priv->d_time);
#line 35 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_progress_bin);
#line 37 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_image);
#line 39 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_repository_label);
#line 41 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_branch_label);
#line 43 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_arrow);
#line 45 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_spinner);
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_remove_button);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_row_parent_class)->finalize (obj);
#line 3390 "gitg-repository-list-box.c"
}


static GType gitg_repository_list_box_row_get_type (void) {
	static volatile gsize gitg_repository_list_box_row_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxRow), 0, (GInstanceInitFunc) gitg_repository_list_box_row_instance_init, NULL };
		GType gitg_repository_list_box_row_type_id;
		gitg_repository_list_box_row_type_id = g_type_register_static (GTK_TYPE_LIST_BOX_ROW, "GitgRepositoryListBoxRow", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_row_type_id__volatile, gitg_repository_list_box_row_type_id);
	}
	return gitg_repository_list_box_row_type_id__volatile;
}


static void _vala_gitg_repository_list_box_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_object (value, gitg_repository_list_box_row_get_repository (self));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boxed (value, gitg_repository_list_box_row_get_time (self));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_repository_name (self));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_string (value, gitg_repository_list_box_row_get_branch_name (self));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_loading (self));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		g_value_set_boolean (value, gitg_repository_list_box_row_get_has_remote (self));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3447 "gitg-repository-list-box.c"
		default:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3453 "gitg-repository-list-box.c"
	}
}


static void _vala_gitg_repository_list_box_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRepositoryListBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_REPOSITORY_LIST_BOX_TYPE_ROW, GitgRepositoryListBoxRow);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	switch (property_id) {
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository (self, g_value_get_object (value));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_CAN_REMOVE:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_can_remove (self, g_value_get_boolean (value));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_TIME:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_time (self, g_value_get_boxed (value));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_FRACTION:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_fraction (self, g_value_get_double (value));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_REPOSITORY_NAME:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_repository_name (self, g_value_get_string (value));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_BRANCH_NAME:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_branch_name (self, g_value_get_string (value));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_LOADING:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_loading (self, g_value_get_boolean (value));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		case GITG_REPOSITORY_LIST_BOX_ROW_HAS_REMOTE:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		gitg_repository_list_box_row_set_has_remote (self, g_value_get_boolean (value));
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3511 "gitg-repository-list-box.c"
		default:
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
		break;
#line 3517 "gitg-repository-list-box.c"
	}
}


static GitgRepositoryListBoxCloneProgress* gitg_repository_list_box_clone_progress_construct (GType object_type, GitgRepositoryListBoxRow* row) {
	GitgRepositoryListBoxCloneProgress * self = NULL;
	GitgRepositoryListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
#line 333 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (row != NULL, NULL);
#line 333 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxCloneProgress*) g_object_new (object_type, NULL);
#line 335 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = row;
#line 335 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 335 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_row);
#line 335 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv->d_row = _tmp1_;
#line 333 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return self;
#line 3540 "gitg-repository-list-box.c"
}


static GitgRepositoryListBoxCloneProgress* gitg_repository_list_box_clone_progress_new (GitgRepositoryListBoxRow* row) {
#line 333 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return gitg_repository_list_box_clone_progress_construct (GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, row);
#line 3547 "gitg-repository-list-box.c"
}


static gboolean gitg_repository_list_box_clone_progress_real_transfer_progress (GgitRemoteCallbacks* base, GgitTransferProgress* stats, GError** error) {
	GitgRepositoryListBoxCloneProgress * self;
	gboolean result = FALSE;
	guint recvobj = 0U;
	GgitTransferProgress* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint indxobj = 0U;
	GgitTransferProgress* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint totaobj = 0U;
	GgitTransferProgress* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GitgRepositoryListBoxRow* _tmp6_ = NULL;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = (GitgRepositoryListBoxCloneProgress*) base;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_return_val_if_fail (stats != NULL, FALSE);
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp0_ = stats;
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp1_ = ggit_transfer_progress_get_received_objects (_tmp0_);
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	recvobj = _tmp1_;
#line 341 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp2_ = stats;
#line 341 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp3_ = ggit_transfer_progress_get_indexed_objects (_tmp2_);
#line 341 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	indxobj = _tmp3_;
#line 342 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp4_ = stats;
#line 342 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp5_ = ggit_transfer_progress_get_total_objects (_tmp4_);
#line 342 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	totaobj = _tmp5_;
#line 344 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_tmp6_ = self->priv->d_row;
#line 344 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_row_set_fraction (_tmp6_, (recvobj + indxobj) / ((gdouble) (2 * totaobj)));
#line 345 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	result = TRUE;
#line 345 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	return result;
#line 3594 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone_progress_class_init (GitgRepositoryListBoxCloneProgressClass * klass) {
#line 329 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_clone_progress_parent_class = g_type_class_peek_parent (klass);
#line 329 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxCloneProgressPrivate));
#line 329 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	GGIT_REMOTE_CALLBACKS_CLASS (klass)->transfer_progress = gitg_repository_list_box_clone_progress_real_transfer_progress;
#line 329 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_clone_progress_finalize;
#line 3607 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone_progress_instance_init (GitgRepositoryListBoxCloneProgress * self) {
#line 329 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_CLONE_PROGRESS_GET_PRIVATE (self);
#line 3614 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_clone_progress_finalize (GObject* obj) {
	GitgRepositoryListBoxCloneProgress * self;
#line 329 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REPOSITORY_LIST_BOX_TYPE_CLONE_PROGRESS, GitgRepositoryListBoxCloneProgress);
#line 331 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_object_unref0 (self->priv->d_row);
#line 329 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_clone_progress_parent_class)->finalize (obj);
#line 3626 "gitg-repository-list-box.c"
}


static GType gitg_repository_list_box_clone_progress_get_type (void) {
	static volatile gsize gitg_repository_list_box_clone_progress_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_clone_progress_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxCloneProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_clone_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBoxCloneProgress), 0, (GInstanceInitFunc) gitg_repository_list_box_clone_progress_instance_init, NULL };
		GType gitg_repository_list_box_clone_progress_type_id;
		gitg_repository_list_box_clone_progress_type_id = g_type_register_static (ggit_remote_callbacks_get_type (), "GitgRepositoryListBoxCloneProgress", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_clone_progress_type_id__volatile, gitg_repository_list_box_clone_progress_type_id);
	}
	return gitg_repository_list_box_clone_progress_type_id__volatile;
}


static void gitg_repository_list_box_class_init (GitgRepositoryListBoxClass * klass) {
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	gitg_repository_list_box_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_type_class_add_private (klass, sizeof (GitgRepositoryListBoxPrivate));
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	GTK_LIST_BOX_CLASS (klass)->row_activated = gitg_repository_list_box_real_row_activated;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_repository_list_box_constructor;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_repository_list_box_finalize;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("repository_activated", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_TYPE_REPOSITORY);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	g_signal_new ("show_error", GITG_TYPE_REPOSITORY_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
#line 3657 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_instance_init (GitgRepositoryListBox * self) {
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self->priv = GITG_REPOSITORY_LIST_BOX_GET_PRIVATE (self);
#line 3664 "gitg-repository-list-box.c"
}


static void gitg_repository_list_box_finalize (GObject* obj) {
	GitgRepositoryListBox * self;
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REPOSITORY_LIST_BOX, GitgRepositoryListBox);
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	_g_free0 (self->priv->d_filter_text);
#line 22 "/home/jesse/git/gnome/gitg/libgitg/gitg-repository-list-box.vala"
	G_OBJECT_CLASS (gitg_repository_list_box_parent_class)->finalize (obj);
#line 3676 "gitg-repository-list-box.c"
}


GType gitg_repository_list_box_get_type (void) {
	static volatile gsize gitg_repository_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_repository_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRepositoryListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_repository_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRepositoryListBox), 0, (GInstanceInitFunc) gitg_repository_list_box_instance_init, NULL };
		GType gitg_repository_list_box_type_id;
		gitg_repository_list_box_type_id = g_type_register_static (GTK_TYPE_LIST_BOX, "GitgRepositoryListBox", &g_define_type_info, 0);
		g_once_init_leave (&gitg_repository_list_box_type_id__volatile, gitg_repository_list_box_type_id);
	}
	return gitg_repository_list_box_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



