/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>

#include <liboaf/liboaf.h>
#include <bonobo/bonobo-ui-util.h>
#include <bonobo/bonobo-listener.h>
#include <gal/e-paned/e-paned.h>
#include <gal/e-paned/e-vpaned.h>
#include <gal/e-paned/e-hpaned.h>
#include "gI_window.h"

#include <libgide/libgide.h>

static void
tmp_exit (GtkWidget *w, GideWindow *window)
{
	gtk_object_destroy (GTK_OBJECT (window));
	
	gtk_main_quit ();
}

static void
about_cmd_destroy (GtkWidget *w, gpointer data)
{
	GtkWidget **about = (GtkWidget **)data;
	*about = NULL;
}

static void
about_cmd (GtkWidget *w, GideWindow *window)
{
	static const gchar *authors[] = {
		"JP Rosevear",
		"Dave Camp",
		"Dirk Vangestel",
		"",
		"Original Author: Steffen Kern",
		NULL};
	
	static GtkWidget *about = NULL;
	if (!about) {
		about = gnome_about_new ( _("gIDE"), 
			VERSION,
			_("Copyright Various Authors (C) 1998-2001"),
			authors,
			"A Gnome based IDE", 
			NULL);
		gtk_signal_connect (GTK_OBJECT (about), "destroy",
				    about_cmd_destroy, &about);
		gtk_widget_show (about);
	} else
		gdk_window_raise (GTK_WIDGET (about)->window);
}

/* Menu verbs */
static BonoboUIVerb verbs [] = {
	BONOBO_UI_UNSAFE_VERB ("FileExit", tmp_exit),
#if 0
	BONOBO_UI_UNSAFE_VERB ("ToolsPlugins", dialog_plugin_manager),
	BONOBO_UI_UNSAFE_VERB ("SettingsSettings", dialog_prefs_cb),
#endif
	BONOBO_UI_UNSAFE_VERB ("HelpAbout", about_cmd),
	
	BONOBO_UI_VERB_END
};

/* Prototypes */
static void gI_window_class_init (GideWindowClass *class);
static void gI_window_init (GideWindow *tool);
static void gI_window_drag_recv(GtkWidget* widget, GdkDragContext* context,
				gint x, gint y, GtkSelectionData* seldata,
				guint info, guint time, gpointer data);
static void gI_window_destroy( GtkWidget *widget, gpointer data );

guint
gI_window_get_type()
{
	static guint window_type = 0;

	if (!window_type) {
           GtkTypeInfo window_info = {
               "GideWindow",
               sizeof (GideWindow),
               sizeof (GideWindowClass),
               (GtkClassInitFunc) gI_window_class_init,
               (GtkObjectInitFunc) gI_window_init,
               (GtkArgSetFunc) NULL,
               (GtkArgGetFunc) NULL
             };
             window_type = gtk_type_unique (bonobo_window_get_type (),
					    &window_info);
           }
		
         return window_type;
}

static void
gI_window_class_init( GideWindowClass *class )
{
	GtkObjectClass *object_class;
	
	object_class = (GtkObjectClass*) class;
}

static void
gI_window_init( GideWindow *window )
{
	BonoboUIContainer *ui_container;
	GtkWidget *vbox;
	GtkTargetEntry dragtypes[] = {{"text/uri-list", 0, 0}};
	int i;

	window->documents = NULL;

	/* Initialize Gnome Application */
	bonobo_window_construct (BONOBO_WINDOW (window), "gide", "gIDE");
	/* Set some defaults */
	window->notebook = NULL;
	window->switch_page_id = FALSE;
	window->toolbar = NULL;

	/* Setup the window */
	gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, TRUE);

	vbox = gtk_vbox_new(FALSE, 0);
	bonobo_window_set_contents (BONOBO_WINDOW (window), vbox );
	gtk_widget_show(vbox);
		
	gtk_widget_set_usize( GTK_WIDGET(window), 800, 550 );
	gtk_widget_realize( GTK_WIDGET(window) );

#if 0
	/* Add the status bar */
	window->statusbar = gide_statusbar_new();
//	gnome_app_set_statusbar( GNOME_APP(window), window->statusbar );
	gtk_widget_show(window->statusbar);
#endif
	/* Add toolbar */
	if(gdk_screen_width() < 600) {
		gnome_preferences_set_toolbar_labels(FALSE);
	}
	
//	gI_toolbar_create(GTK_WIDGET(window));			
	
	/* drag'n'drop */
	gtk_drag_dest_set( GTK_WIDGET(window),
			   GTK_DEST_DEFAULT_ALL, dragtypes,
			   sizeof(dragtypes) / sizeof(dragtypes[0]),
			   GDK_ACTION_COPY );
	gtk_signal_connect(GTK_OBJECT(window), "drag_data_received",
			   GTK_SIGNAL_FUNC(gI_window_drag_recv),
			   (gpointer)window);

	/* Menus */
	window->uic = bonobo_ui_component_new_default ();

	ui_container = bonobo_ui_container_new ();
	bonobo_ui_container_set_win (ui_container, BONOBO_WINDOW (window));
	
	bonobo_ui_component_set_container (
		window->uic, bonobo_object_corba_objref (BONOBO_OBJECT (ui_container)));

	bonobo_ui_component_add_verb_list_with_data (window->uic, verbs, window);

	bonobo_ui_util_set_ui (window->uic, GNOME_DATADIR, "gide.xml", "gide");
	
	window->ui_container = ui_container;

	for (i = 0; i < GIDE_WINDOW_LOC_LAST; i++) {
		window->notebooks[i] = gtk_notebook_new ();
		gtk_notebook_set_scrollable (GTK_NOTEBOOK (window->notebooks[i]), TRUE);
		gtk_notebook_set_show_tabs (GTK_NOTEBOOK (window->notebooks[i]),
					    FALSE);
		gtk_notebook_set_show_border (GTK_NOTEBOOK (window->notebooks[i]),
					      FALSE);
		gtk_widget_show (window->notebooks[i]);
	}

	window->hpane1 = e_hpaned_new();
	gtk_box_pack_start(GTK_BOX(vbox), window->hpane1, TRUE, TRUE, 0);
	e_paned_pack1 (E_PANED (window->hpane1),
		       window->notebooks[GIDE_WINDOW_LOC_LEFT],
		       TRUE, TRUE);
	gtk_widget_show(window->hpane1);

	window->hpane2 = e_hpaned_new();
	e_paned_pack2 (E_PANED(window->hpane1), window->hpane2, TRUE, TRUE);
	e_paned_pack2 (E_PANED (window->hpane2),
		       window->notebooks[GIDE_WINDOW_LOC_RIGHT],
		       TRUE, TRUE);
	gtk_widget_show(window->hpane2);

	window->vpane1 = e_vpaned_new ();
	e_paned_pack1(E_PANED(window->hpane2), window->vpane1, TRUE, TRUE);
	e_paned_pack1 (E_PANED (window->vpane1), 
		       window->notebooks[GIDE_WINDOW_LOC_TOP], 
		       TRUE, TRUE);
	gtk_widget_show(window->vpane1);

	window->vpane2 = e_vpaned_new ();
	e_paned_pack2 (E_PANED (window->vpane1), window->vpane2, TRUE, TRUE);
	e_paned_pack2 (E_PANED (window->vpane2), 
		       window->notebooks[GIDE_WINDOW_LOC_BOTTOM],
		       TRUE, TRUE);
	gtk_widget_show (window->vpane2);

	e_paned_pack1 (E_PANED (window->vpane2), 
		       window->notebooks[GIDE_WINDOW_LOC_CENTER],
		       TRUE, TRUE);

	bonobo_ui_engine_config_set_path (bonobo_window_get_ui_engine (BONOBO_WINDOW (window)), "/gide/UIConf/kvps");

	/* Add an empty document */
	/* added to be able to add popup menu */
	main_window = window;
	
	/* autosave */
	window->timeout_id = 0;

	gI_window_set_cfg_values (window);
	
	gtk_signal_connect( GTK_OBJECT(window), "destroy",
			    GTK_SIGNAL_FUNC(gI_window_destroy), NULL );

	gtk_widget_queue_draw( GTK_WIDGET(window) );
	gtk_widget_queue_resize( GTK_WIDGET(window) );

	/* hack to provide a decent size for the editor */
	gtk_widget_set_usize( GTK_WIDGET(window->hpane2), 300, -1 );
	e_paned_set_position (E_PANED (window->vpane2), 300);
	gtk_widget_queue_resize (GTK_WIDGET(window));
}

GtkWidget *
gI_window_new (void)
{
	GideWindow *window;
	
	window = GIDE_WINDOW (gtk_type_new (gI_window_get_type ()));

	/* create our menus */	

	return GTK_WIDGET(window);
}

void 
gI_window_add_widget (GideWindow *window, GtkWidget *w, 
		      const gchar *name,
		      GNOME_Development_Environment_Shell_WindowLocation loc)
{
	GtkWidget *notebook = window->notebooks[loc];
	GtkWidget *label = gtk_label_new (name);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), w, label);
	
	if (g_list_length (GTK_NOTEBOOK (notebook)->children) > 1) {
		gtk_notebook_set_show_tabs (GTK_NOTEBOOK (notebook), TRUE);
	}
	gtk_object_set_data (GTK_OBJECT (w), "GideWindow::notebook", notebook);

	gtk_widget_queue_resize (GTK_WIDGET (window));
}

void
gI_window_remove_widget (GideWindow *window, GtkWidget *w)
{
	gint page_num;
	GtkWidget *notebook;

	notebook = 
		gtk_object_get_data (GTK_OBJECT (w), "GideWindow::notebook");
	
	page_num = gtk_notebook_page_num (GTK_NOTEBOOK (notebook), w);
	gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
}


void 
gI_window_set_cfg_values (GideWindow *window)
{
#if 0
	if (window->timeout_id != 0) {
		gtk_timeout_remove(window->timeout_id);
	}
	window->timeout_id = 0;

	if ( cfg->autosave ) {
		window->timeout_id =
			gtk_timeout_add(cfg->autosave_freq * 1000,
					(GtkFunction)file_autosave, NULL);
	}

	g_list_foreach (window->documents, 
			(GFunc) gI_document_set_cfg_values, NULL);
#endif
}


/*
 * Function: gI_window_clear_statusbar()
 * Desc: Clears the Statusbar of a Window
 */
void
gI_window_clear_statusbar( GideWindow *window )
{
	gnome_appbar_pop( GNOME_APPBAR(window->statusbar) );
}

/*
 * Function: gI_window_set_visible_read_only()
 * Desc: This function sets the Read-Only entry sensitive true or false
 */
/* does this actually work? */
void
gI_window_set_visible_read_only(gint sensitive)
{
//	gI_menus_set_sensitive(main_window, "/Edit/Read Only", sensitive);
//	if ( sensitive == FALSE ) {
//		gtk_check_menu_item_set_state(
//			GTK_CHECK_MENU_ITEM(gI_menus_get_item_widget(main_window, "/Edit/Read Only")), FALSE);
//	}
}

static void
gI_window_drag_recv(GtkWidget* widget, GdkDragContext* context,
		    gint x, gint y, GtkSelectionData* seldata,
		    guint info, guint time, gpointer data)
{
	GList* files;
	GList* fnp;
	gint count;
	gchar* fname;
	CORBA_Environment ev;
	GNOME_Development_Environment_DocumentManager docman;
	GNOME_Development_Environment_Document document;

	g_assert(IS_GIDE_WINDOW(widget));

	/* get filenames */
	files = gnome_uri_list_extract_filenames((gchar*)seldata->data);
	count = g_list_length(files);

	CORBA_exception_init (&ev);
	docman = GNOME_Development_Environment_Shell_getObject 
		(bonobo_object_corba_objref 
		 (gtk_object_get_data (GTK_OBJECT (widget), "GideShell")),
		 "DocumentManager", &ev);
	
	/* open files */
	if(count > 0 && docman != CORBA_OBJECT_NIL)
	{
		gchar *curdir = g_get_current_dir ();
		
		fnp = g_list_first(files);
		while(fnp)
		{
			fname = (gchar*)fnp->data;
			
			/* openFile needs a full path for the file */
			if (g_path_is_absolute (fname))
				fname = g_strdup (fname);
			else
				fname = g_strdup_printf ("%s/%s", curdir, fname);

			document = GNOME_Development_Environment_DocumentManager_openFile (docman, fname, &ev);
			bonobo_object_release_unref (document, &ev);
			g_free (fname);

			fnp = g_list_next(fnp);
		}
		g_free (curdir);
	}

	gnome_uri_list_free_strings(files);
}

static void
gI_window_destroy (GtkWidget *widget, gpointer data)
{
	GideWindow *window;

	g_assert (IS_GIDE_WINDOW (widget));

	window = GIDE_WINDOW (widget);
}
