/* $Header: /cvs/gnome/gIDE/src/gide-windows.c,v 1.2 2000/04/16 04:59:58 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include "gI_menus.h"
#include "gI_file.h"
#include "gide-tools.h"
#include "gide-windows.h"

static GList *window_list;

static void gide_window_delete (GideWindow *window, gpointer data);
static void gide_window_destroy (GideWindow *window, gpointer data);

GideWindow *
gide_window_new (void)
{
	GideWindow *window;

	/* Open Main Window */
	window = GIDE_WINDOW(gI_window_new());
	window_list = g_list_append(window_list, (gpointer) window);
	gtk_widget_show (GTK_WIDGET(window));
	
	gide_add_tools (window);
	gI_menus_set_sensitive_default (window);

	gtk_signal_connect( GTK_OBJECT(window), "delete_event",
			    GTK_SIGNAL_FUNC(gide_window_delete), NULL );

	gtk_signal_connect( GTK_OBJECT(window), "destroy",
			    GTK_SIGNAL_FUNC(gide_window_destroy), NULL );

	return window;
}

static void
gide_window_delete (GideWindow *window, gpointer data)
{
	file_exit (NULL, window);
}

static void
gide_window_destroy (GideWindow *window, gpointer data)
{
	g_list_remove (window_list, window);
}
