/* $Header: /cvs/gnome/gIDE/src/gI_pathwidget.c,v 1.2 1999/12/05 09:44:36 alfi Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include <string.h>
#include "gI_pathwidget.h"

GList * gI_PWassoc_add( GList *pw_assoc, gchar *path, GtkWidget *widget )
{
	gI_PWassoc *item;

	item = (gI_PWassoc *) g_malloc0( sizeof( gI_PWassoc ) );
	item->path = g_strdup( path );
	item->widget = widget;

	pw_assoc = g_list_append( pw_assoc, item );

	return pw_assoc;
}

GList * gI_PWassoc_remove( GList *pw_assoc, gchar *path )
{
	gI_PWassoc *assoc;
	GList *tmp;

	tmp = g_list_first( pw_assoc );
	while( tmp )
	{
		if( tmp->data )
		{
			assoc = (gI_PWassoc *) tmp->data;

			if( !strcmp( assoc->path, path ) )
			{
				return g_list_remove( pw_assoc, assoc );
			}
		}

		tmp = g_list_next( tmp );
	}

	return pw_assoc;
}

GtkWidget *gI_PWassoc_lookup( GList *pw_assoc, gchar *path )
{
	gI_PWassoc *assoc;
	GList *tmp;

	tmp = g_list_first( pw_assoc );
	while( tmp )
	{
		if( tmp->data )
		{
			assoc = (gI_PWassoc *) tmp->data;

			if( !strcmp( assoc->path, path ) )
			{
				return( assoc->widget );
			}

			tmp = g_list_next( tmp );
		}
	}

	return( NULL );
}

void gI_PWassoc_free( GList *pw_assoc )
{
	gI_PWassoc *item;
	GList *tmp;

	tmp = g_list_first( pw_assoc );
	while( tmp )
	{
		if( tmp->data )
		{
			item = (gI_PWassoc *) tmp->data;
			g_free( item->path );
		}

		tmp = g_list_next( tmp );
	}

	g_list_free( pw_assoc );
}
