/* $Header: /cvs/gnome/gIDE/src/gI_menus.c,v 1.23 2000/04/22 03:13:52 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include "gI_file.h"
#include "gI_edit.h"
#include "gI_compile.h"
#include "gI_search.h"
#include "gI_pathwidget.h"
#include "gI_menus.h"
#include "gI_functions.h"
#include "gI_files.h"
#include "gI_tree.h"
#include "gI_prefs.h"
#include "gI_about.h"
#include "gI_help.h"
#include "gI_project.h"
#include "gI_tools.h"
#include "gI_hilite.h"
#include "gI_run.h"
#include "gI_debug.h"
#include "gI_common.h"
#include "gI_ftree.h"
#include "dialogs.h"
#include "gI_debug_breakpoint.h"

/* --- Local functions --- */
/*
 * Create a suitable path name from the actual menu and the menu entry.
 * Strips the _ and any trailing dots.
 */
static gchar*
menus_create_path(gchar* path, gchar* label)
{
	gchar* tmp;
	gchar** tmp2;
	gchar* tmp3;

	/* We don't want the _ in the path name */
	tmp2 = g_strsplit(label, "_", 2);
	tmp3 = g_strjoinv(NULL, tmp2);
	g_strfreev(tmp2);
	/* Strip trailing dots */
	while(tmp3[strlen(tmp3) - 1] == '.')
	{
		tmp3[strlen(tmp3) - 1] = '\0';
	}
	/* Join path and label */
	tmp = g_strjoin("/", path, tmp3, NULL);
	g_free(tmp3);
	return tmp;
}

/*
 * Adds a menu to the path/widget list.
 * This function recursively traverses the menu.
 */
static void
menus_add_menu(GideWindow *window, gchar* path, GnomeUIInfo* menu)
{
	gint i = 0;
	gchar* tmp;

	while( menu[i].type != GNOME_APP_UI_ENDOFINFO ) {
		if(menu[i].type == GNOME_APP_UI_SUBTREE ||
			menu[i].type == GNOME_APP_UI_SUBTREE_STOCK) {
			tmp = menus_create_path(path, menu[i].label);
			menus_add_menu(window, tmp, menu[i].moreinfo);
			g_free(tmp);
		} else if(menu[i].type == GNOME_APP_UI_ITEM ||
			menu[i].type == GNOME_APP_UI_TOGGLEITEM) {
			tmp = menus_create_path(path, menu[i].label);
			gI_menus_add_item_widget(window, tmp, menu[i].widget);
			g_free(tmp);
		}
		++i;
	}
}

/* --- Global functions --- */
void
gI_menus_create_menubar(GideWindow *window)
{
	GnomeUIInfo filemenu[] = {
		GNOMEUIINFO_MENU_NEW_ITEM(N_("_New"), N_("New Source File"),
					  file_new, NULL),
		GNOMEUIINFO_MENU_OPEN_ITEM(file_open, NULL),
		GNOMEUIINFO_MENU_REVERT_ITEM(file_reload, NULL),

		GNOMEUIINFO_SEPARATOR,

		GNOMEUIINFO_MENU_SAVE_ITEM(file_save, NULL),
		GNOMEUIINFO_MENU_SAVE_AS_ITEM(file_save_as, NULL),
		GNOMEUIINFO_ITEM_STOCK(_("Save all"), _("Save all open files"),
			gI_file_save_all, GNOME_STOCK_MENU_SAVE),

		GNOMEUIINFO_SEPARATOR,

		GNOMEUIINFO_MENU_PRINT_ITEM(file_print, NULL),
		GNOMEUIINFO_MENU_CLOSE_ITEM(file_close, NULL),

		GNOMEUIINFO_ITEM_NONE(N_("Close All"),
				      N_("Close all files"), gI_file_close_all),
				      
		GNOMEUIINFO_SEPARATOR,

		GNOMEUIINFO_MENU_EXIT_ITEM(file_exit, NULL),
		GNOMEUIINFO_END
	};

	GnomeUIInfo editmenu[] = {
		GNOMEUIINFO_MENU_UNDO_ITEM(edit_undo, NULL),
		GNOMEUIINFO_MENU_REDO_ITEM(edit_redo, NULL),
		GNOMEUIINFO_SEPARATOR,
		GNOMEUIINFO_MENU_CUT_ITEM(edit_cut, NULL),
		GNOMEUIINFO_MENU_COPY_ITEM(edit_copy, NULL),
		GNOMEUIINFO_MENU_PASTE_ITEM(edit_paste, NULL),

		GNOMEUIINFO_SEPARATOR,

		GNOMEUIINFO_MENU_SELECT_ALL_ITEM(edit_select_all, NULL),
		{
			GNOME_APP_UI_ITEM,
			N_("Select _Line"), N_("Select Line"),
			edit_select_line, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			'L', GDK_MOD1_MASK, NULL
		},
				      
		GNOMEUIINFO_SEPARATOR,

		GNOMEUIINFO_TOGGLEITEM(N_("Read Only"),
				       N_("Edit Read Only"),
				       edit_read_only, GNOME_APP_PIXMAP_NONE),

		GNOMEUIINFO_SEPARATOR,
				       
		GNOMEUIINFO_END
	};

	GnomeUIInfo searchmenu[] = {

		GNOMEUIINFO_MENU_FIND_ITEM(search_search, NULL),
		GNOMEUIINFO_MENU_FIND_AGAIN_ITEM(search_again, NULL),
		
		GNOMEUIINFO_SEPARATOR,
		
		GNOMEUIINFO_ITEM_NONE(N_("Find in Files..."),
				      N_("Find in Files"),
				      find_in_files),
		GNOMEUIINFO_ITEM_NONE(N_("Replace in Files..."),
				      N_("Replace in Files"),
				      replace_in_files),
				      
		GNOMEUIINFO_SEPARATOR,
		
		{
			GNOME_APP_UI_ITEM, N_("Goto Line..."), N_("Goto Line"),
			search_goto_line, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			'G', GDK_CONTROL_MASK, NULL
		},

		GNOMEUIINFO_SEPARATOR,

		GNOMEUIINFO_END
	};

	GnomeUIInfo projectmenu[] = {
		GNOMEUIINFO_ITEM_NONE(N_("_New Project..."),
				      N_("New Project"), gI_project_new),
		GNOMEUIINFO_ITEM_NONE(N_("_Open Project..."),
				      N_("Open Project"), gI_project_open),
		GNOMEUIINFO_ITEM_NONE(N_("_Edit Project..."),
				      N_("Edit Project"), gI_project_edit),
		GNOMEUIINFO_ITEM_NONE(N_("_Close Project"),
				      N_("Close Project"),
				      gI_project_close),
		GNOMEUIINFO_ITEM_NONE(N_("_Delete Project..."),
				      N_("Delete Project"), gI_project_delete),
				      
		GNOMEUIINFO_SEPARATOR,
		
		GNOMEUIINFO_ITEM_NONE(N_("Build Project"),
				      N_("Build Project"),
				      gI_project_build),
				      
		GNOMEUIINFO_SEPARATOR,
		
		GNOMEUIINFO_ITEM_NONE(N_("Create Makefile"),
				      N_("Create Makefile"),
				      gI_project_create_makefile),
				      
		GNOMEUIINFO_END
	};

	GnomeUIInfo compilemenu[] = {
		{
			GNOME_APP_UI_ITEM, N_("Compile to _Exec."),
			N_("Create Executable"),
			compile_compile_exec, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F8, 0, NULL
		},
		GNOMEUIINFO_ITEM_DATA(N_("Compile to _Obj."),
				      N_("Create Objectfile"),
				      compile_compile_obj, NULL,
				      GNOME_APP_PIXMAP_NONE),
		{
			GNOME_APP_UI_ITEM, N_("_Make"), N_("Make"),
			compile_make, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			'M', GDK_CONTROL_MASK, NULL
		},
		{
			GNOME_APP_UI_ITEM, N_("_Link"), N_("Link"),
			compile_link, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			'L', GDK_CONTROL_MASK, NULL
		},
		GNOMEUIINFO_ITEM_NONE(N_("Build _All"),
				      N_("Build All"), NULL),
		GNOMEUIINFO_ITEM_NONE(N_("Syntax Check"),
				      N_("check_syntax"),
				      compile_syntax_check),
				      
		GNOMEUIINFO_END
	};

	GnomeUIInfo debugmenu[] = {
		{
			GNOME_APP_UI_ITEM, N_("Start Debug"),
			N_("Start Debug"),
			gI_debug_start, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F5, 0, NULL
		},
		GNOMEUIINFO_ITEM_NONE(N_("Attach to Process"),
				      N_("Attach to Process"),
				      gI_debug_attach),
		{
			GNOME_APP_UI_ITEM, N_("Stop Debug"),
			N_("Stop Debug"),
			gI_debug_stop, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F5, GDK_SHIFT_MASK, NULL
		},
		{
			GNOME_APP_UI_ITEM, N_("Set|Clear Breakpoint"),
			N_("Set or Clear Breakpoint"),
			gI_breakpoint_toggle, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F9, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM, N_("Step Over"), N_("Step Over"),
			gI_debug_step_over, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F10, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM, N_("Step Into"), N_("Step Into"),
			gI_debug_step_into, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F11, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM, N_("Break"), N_("Break"),
			gI_debug_break, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F12, 0, NULL
		},
		GNOMEUIINFO_END
	};

	GnomeUIInfo runmenu[] = {
		/* this shortcut conflicts with 'find' (I think) */
		{
			GNOME_APP_UI_ITEM, N_("Run"), N_("Run Application"),
			run_run, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F6, 0, NULL
		},
		GNOMEUIINFO_ITEM_NONE(N_("Parameters..."),
				      N_("Edit Runtime Parameters"),
				      run_parameters),
		
		GNOMEUIINFO_END
	};

	GnomeUIInfo toolsmenu[] = {
		GNOMEUIINFO_ITEM_NONE(N_("Plug-in Manager..."),
				      N_("Plug-in Manager"),
				      dialog_plugin_manager),
				      
		GNOMEUIINFO_SEPARATOR,
		
		GNOMEUIINFO_END
	};

	GnomeUIInfo prefmenu[] = {
		GNOMEUIINFO_MENU_PREFERENCES_ITEM(show_preferences, NULL),

		GNOMEUIINFO_SEPARATOR,

		GNOMEUIINFO_ITEM_NONE(N_("Reload Config"),
				      N_("Reload Config"), reload_config),
		GNOMEUIINFO_ITEM_NONE(N_("Set to Defaults"),
				      N_("Set to Defaults"), set_to_defaults),

		GNOMEUIINFO_END
	};

#ifdef HAVE_GTKTEXT_PATCH
	GnomeUIInfo highlightmenu[] = {
		GNOMEUIINFO_ITEM_NONE(N_("Define Regexps..."),
				      N_("Define Regexps..."),
				      gI_hilite_set_buffer_patterns_cb),
		GNOMEUIINFO_ITEM_NONE(N_("Re-Highlight"),
				      N_("Re-Highlight"),
				      gI_hilite_rehilite),
				      
		GNOMEUIINFO_END
	};
#endif

	GnomeUIInfo windowmenu[] = {
		{
			GNOME_APP_UI_ITEM, N_("Files"), N_("Files"),
			show_all_files, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			'F', GDK_SHIFT_MASK, NULL
		},		{
			GNOME_APP_UI_ITEM, N_("Functions"), N_("Functions"),
			show_all_functions, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			'F', GDK_CONTROL_MASK, NULL
		},
		{
			GNOME_APP_UI_ITEM, N_("Tree"), N_("Tree"),
			show_tree, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			'T', GDK_SHIFT_MASK, NULL
		},
		GNOMEUIINFO_ITEM_NONE(N_("File tree"), N_("File tree"), ftree),
		GNOMEUIINFO_END
	};

	GnomeUIInfo helpmenu[] = {
		{
			GNOME_APP_UI_ITEM, N_("Help"), N_("Help"),
			show_help, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F1, 0, NULL
		},
		{
			GNOME_APP_UI_ITEM, N_("Manual Pages..."),
			N_("Manual Pages"),
			help_man_page, NULL, NULL,
			GNOME_APP_PIXMAP_NONE, NULL,
			GDK_F1, GDK_MOD1_MASK, NULL
		},
		
		GNOMEUIINFO_SEPARATOR,
		
		GNOMEUIINFO_ITEM_NONE(N_("About Help"),
				      N_("About Help"), about_help),
		GNOMEUIINFO_MENU_ABOUT_ITEM(about_gide, NULL),
		
		GNOMEUIINFO_END
	};

	GnomeUIInfo mainmenu[] = {
		GNOMEUIINFO_MENU_FILE_TREE(filemenu),
		GNOMEUIINFO_MENU_EDIT_TREE(editmenu),
		GNOMEUIINFO_SUBTREE(N_("S_earch"), searchmenu),
		GNOMEUIINFO_SUBTREE(N_("_Project"), projectmenu),
		GNOMEUIINFO_SUBTREE(N_("_Compile"), compilemenu),
		GNOMEUIINFO_SUBTREE(N_("_Debug"), debugmenu),
		GNOMEUIINFO_SUBTREE(N_("_Run"), runmenu),
		GNOMEUIINFO_SUBTREE(N_("_Tools"), toolsmenu),
		GNOMEUIINFO_MENU_SETTINGS_TREE(prefmenu),
#ifdef HAVE_GTKTEXT_PATCH
		GNOMEUIINFO_SUBTREE(N_("_Highlight"), highlightmenu),
#endif
		GNOMEUIINFO_MENU_WINDOWS_TREE(windowmenu),
		GNOMEUIINFO_MENU_HELP_TREE(helpmenu),
		
		GNOMEUIINFO_END
	};

	/* create menus */
	gnome_app_create_menus_with_data( GNOME_APP(window),
					  mainmenu,
					  (gpointer)window );

	/* install hints */
	gnome_app_install_menu_hints( GNOME_APP(window), mainmenu );

	/* now we create a GList with the widgets */
	menus_add_menu(window, "", mainmenu);
}

void
gI_menus_set_sensitive(GideWindow *window, gchar* path, gint sensitive)
{
	GtkWidget* widget = NULL;

	g_return_if_fail(path != NULL);

	widget = gI_menus_get_item_widget(window, path);
	if(widget) {
		gtk_widget_set_sensitive(widget, sensitive);
	} else {
		g_warning("Unable to set sensitivity for menu which doesn't exist: %s", path);
	}
}

static void
gI_menus_set_sensitive_unimplemented( GideWindow *window )
{
	/* not implemented */
	gI_menus_set_sensitive( window, "/Compile/Build All", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Attach to Process", FALSE );
}

void
gI_menus_set_sensitive_default( GideWindow *window )
{
	/* start-up settings */
	gI_menus_set_sensitive( window, "/Debug/Stop Debug", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Set|Clear Breakpoint", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Break", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Step Into", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Step Over", FALSE );
	gI_menus_set_sensitive( window, "/Edit/Undo", FALSE );
	gI_menus_set_sensitive( window, "/Edit/Redo", FALSE );

	gI_project_update_menu( window );

	gI_menus_set_sensitive_unimplemented( window );
}

void
gI_menus_set_sensitive_readonly( GideWindow *window, gboolean state )
{
	GtkWidget *item;

	state = !state;
	
	gI_menus_set_sensitive( window, "/File/Save", state );
	gI_menus_set_sensitive( window, "/Edit/Cut", state );
        gI_menus_set_sensitive( window, "/Edit/Paste", state );

	item = gI_menus_get_item_widget(window, "/Edit/Read Only");
	gtk_check_menu_item_set_state( GTK_CHECK_MENU_ITEM(item), !state );
}

void
gI_menus_set_sensitive_debugon( GideWindow *window )
{
	gI_menus_set_sensitive( window, "/Debug/Stop Debug", TRUE );
	gI_menus_set_sensitive( window, "/Debug/Start Debug", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Set|Clear Breakpoint", TRUE );
	gI_menus_set_sensitive( window, "/Debug/Break", TRUE );
	gI_menus_set_sensitive( window, "/Debug/Step Into", TRUE );
	gI_menus_set_sensitive( window, "/Debug/Step Over", TRUE );
	gI_menus_set_sensitive( window, "/Debug/Attach to Process", TRUE );
}

void
gI_menus_set_sensitive_debugoff( GideWindow *window )
{
	gI_menus_set_sensitive( window, "/Debug/Stop Debug", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Start Debug", TRUE );
	gI_menus_set_sensitive( window, "/Debug/Set|Clear Breakpoint", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Break", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Step Into", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Step Over", FALSE );
	gI_menus_set_sensitive( window, "/Debug/Attach to Process", FALSE );
}

GtkWidget*
gI_menus_get_item_widget(GideWindow *window, gchar* path)
{
	GtkWidget* widget = NULL;

	g_return_val_if_fail(path != NULL, NULL);

	widget = gI_PWassoc_lookup(window->menu_items, path);

	return(widget);
}

void
gI_menus_add_item_widget(GideWindow *window, gchar* path, GtkWidget* widget)
{
	window->menu_items = gI_PWassoc_add(window->menu_items, path, widget);
}

void
gI_menus_remove_item_widget(GideWindow *window, gchar* path)
{
	window->menu_items = gI_PWassoc_remove(window->menu_items, path);
}

void
gI_menus_free_items(GideWindow *window)
{
	gI_PWassoc_free(window->menu_items);
	window->menu_items = NULL;
}














