/* $Header: /cvs/gnome/gIDE/src/gI_globpatterns.h,v 1.4 2000/04/13 19:27:58 jpr Exp $ */
/*  gIDE
 *  Copyright (C) 1998-2000 Steffen Kern
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_GTKTEXT_PATCH
#ifndef GLOB_PATTERNS_H
#define GLOB_PATTERNS_H

#include <config.h>
#include <gtkeditor/gtkeditor.h>
#include "gI_hilite.h"

/* gI_globpatterns -- used for associating filenames with highlight
 * patterns, for automatically selecting the right pattern upon
 * load. */

void   gI_glob_assoc           (gchar *glob,
				gchar *pat);

void   gI_glob_unassoc         (gchar *glob);
void   gI_glob_remove          (gchar *pat);


gI_HilitePattern *
       gI_glob_lookup          (gchar *string);

#if !HAVE_GUILE
void   gI_glob_load_globassoc  (const gchar    *filename);
#endif
void   gI_glob_save_globassoc  (const gchar    *filename);


#endif /*GLOB_PATTERNS_H*/
#endif /*HAVE_GTKTEXT_PATCH*/
