/*
 * Calculator plugin
 *
 * Authors:
 *   Steffen Kern (alfi@pn.org)
 *   JP Rosevear (jpr@arcavia.com)
 */

#include "../../src/gide.h"
#include "../../src/gI_plugin.h"
#include "../../src/gI_tools.h"
#include "../../src/gide-tools.h"

#define CALCULATOR_NAME  _("Utilities - Calculator")
#define CALCULATOR_TITLE _("Calculator Plugin")
#define CALCULATOR_DESCR _("Display a calculator for use.")

static void
plugin_calculator ( Tool *tool, ToolState *state )
{
	GtkWidget *window;
	GtkWidget *calc;
	
	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( window ), _("Calculator") );
	gtk_signal_connect( GTK_OBJECT( window ), "destroy",
			    GTK_SIGNAL_FUNC( gtk_widget_destroyed ),
			    NULL );
	
	calc = gnome_calculator_new();
	gtk_container_add( GTK_CONTAINER( window ), calc );
	gtk_window_add_accel_group( GTK_WINDOW( window ),
				    GNOME_CALCULATOR( calc )->accel );
	
	gtk_widget_show_all( window );
}

static gboolean
plugin_calculator_sens ( Tool *tool, ToolState *state )
{
	return TRUE;
}

static int
can_unload (PluginData *pd)
{
	return 1;
}

static void
cleanup_plugin (PluginData *pd)
{
	gide_tool_remove( CALCULATOR_NAME );
}

PluginInitResult
init_plugin (CommandContext *context, PluginData *pd)
{
	GtkObject *tool;
	
	if (plugin_version_mismatch  (context, pd, VERSION))
		return PLUGIN_QUIET_ERROR;
	
	tool = gI_tool_new( CALCULATOR_NAME, (void *) plugin_calculator);
	gI_tool_set_menu_data( TOOL(tool), plugin_calculator_sens,
			       "Tools/Utilities/Calculator", NULL);
	gide_tool_add( TOOL(tool) );

	if (plugin_data_init (pd, can_unload, cleanup_plugin,
                              CALCULATOR_TITLE, CALCULATOR_DESCR))
                return PLUGIN_OK;
        else
                return PLUGIN_ERROR;
}









