import pygtk
pygtk.require('2.0')
import gtk
import os
import gobject

import psycopg2
import config

import gettext
gettext.textdomain(config.PACKAGE)
gtk.glade.textdomain(config.PACKAGE)
from gettext import gettext as _

class GeviceMaintainer:
    def __ini__ (self):
        self.list_mark = None
        self.list_type = None

    
    def load_interface (self,gevice,title,sql):
        glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_maintainer",None)
        self.window_maintainer = glade_file.get_widget ("window_maintainer")
        self.button_add = glade_file.get_widget ("button_add")
        self.button_rem = glade_file.get_widget ("button_rem")
        self.button_close = glade_file.get_widget ("button_close")
        self.treeview = glade_file.get_widget ("treeview")        
        
        #self.treeview.set_rules_hint (True)
        self.window_maintainer.set_title (title)
        
        # create columns
        col = gtk.TreeViewColumn (_("ID"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        cell.set_property('editable',False)
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",0)

        col = gtk.TreeViewColumn (_("Name"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        cell.set_property('editable',True)
        cell.connect('edited', self.on_name_edited,gevice,sql)
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",1)
		
        self.button_close.connect ("clicked",self.on_button_close_clicked)
        self.button_add.connect ("clicked",self.on_button_add_clicked,gevice,sql)
        self.button_rem.connect ("clicked",self.on_button_rem_clicked,gevice,sql)

    def load_interface1 (self,gevice,title,sql):
        glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_maintainer1",None)
        self.window_maintainer = glade_file.get_widget ("window_maintainer1")
        self.button_add = glade_file.get_widget ("button_add1")
        self.button_rem = glade_file.get_widget ("button_rem1")
        self.button_close = glade_file.get_widget ("button_close1")
        self.treeview = glade_file.get_widget ("treeview1")        
        
        self.window_maintainer.set_title (title)

        self.modelcell = gtk.ListStore(int, gobject.TYPE_STRING)
        
        # create columns
        col = gtk.TreeViewColumn (_("ID"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        cell.set_property('editable',False)
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",0)
        
        col = gtk.TreeViewColumn (_("Device"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        cell.set_property('editable',False)
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",1)

        col = gtk.TreeViewColumn (_("Model"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        cell.set_property('editable',True)
        cell.connect('edited', self.on_model_edited,gevice,sql)        
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",2)
		
        self.button_close.connect ("clicked",self.on_button_close_clicked,)
        self.button_rem.connect ("clicked",self.on_button_rem_model_clicked,gevice,sql)
        self.button_add.connect ("clicked",self.on_button_add_model_clicked,gevice,sql)


    def load_interface_model (self,gevice,sql):
        glade_file = gtk.glade.XML (os.path.join (config.GLADEDIR, "gevice.glade"),"window_model",None)
        self.window_model = glade_file.get_widget ("window_model")
        self.button_ok = glade_file.get_widget ("button_ok")
        self.button_cancel = glade_file.get_widget ("button_cancel")
        self.combobox_type = glade_file.get_widget ("combobox_type")
        self.combobox_mark = glade_file.get_widget ("combobox_mark")
        self.entry_model = glade_file.get_widget ("entry_model")
        
        self.button_cancel.connect ("clicked",self.on_button_model_cancel_clicked)
        self.button_ok.connect ("clicked",self.on_button_model_ok_clicked,gevice,sql)
        
        
        self.list_type = gevice.gdbase.get_list_of_type(gevice)
        self.combobox_type.set_model(self.list_type)
        cell = gtk.CellRendererText()
        self.combobox_type.pack_start(cell, True)
        self.combobox_type.add_attribute(cell, 'text', 0)  
        
        self.list_mark = gevice.gdbase.get_list_of_mark(gevice)
        self.combobox_mark.set_model (self.list_mark)
        cell = gtk.CellRendererText()
        self.combobox_mark.pack_start(cell, True)
        self.combobox_mark.add_attribute(cell, 'text', 0)  
        
        self.entry_model.set_text("")
        self.combobox_type.set_active(0)
        self.combobox_mark.set_active(0)
        
        self.window_model.show_all()


    def on_button_model_cancel_clicked (self,button):
        self.close_window (self.window_model)    


    def show_interface (self):
    	self.window_maintainer.show_all()

        
    def load_data (self,gevice,sql):
        liststore = gtk.ListStore(
            gobject.TYPE_INT,
            gobject.TYPE_STRING)
        
        self.treeview.set_model (None)
        self.treeview.set_model (liststore)
        
        rows = gevice.gdbase.execute_sql_select(gevice,sql["select"])
        
        if rows:
            for row in rows:
                iter = liststore.append ()
                liststore.set (
                    iter,
                    0,row[0],
                    1,row[1])


    def load_data1 (self,gevice,sql):
        liststore = gtk.ListStore(
            gobject.TYPE_INT,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING)
        
        self.treeview.set_model (None)
        self.treeview.set_model (liststore)

        rows = gevice.gdbase.execute_sql_select(gevice,sql["select"])
        
        if rows:
            for row in rows:
                iter = liststore.append ()
                liststore.set (
                    iter,
                    0,row[0],
                    1,row[1],
                    2,row[2])


    def close_window (self,window):
	    window.destroy()

        
    def on_button_close_clicked (self,button):
        self.close_window (self.window_maintainer)


    def on_name_edited (self, cell, path, newname,gevice,sql):
        newname = newname.strip()
        model = self.treeview.get_model()
        iter = model.get_iter_from_string(path)
        id,oldname = model.get(iter,0,1)
        
        # check, newname exists
        if oldname == newname:
            return

        self.is_in_list = False
        model.foreach(self.is_newname_in_list, newname)
        
        if not self.is_in_list:
            model.set(iter,1,newname)
            update = sql["update1"] + "'" + newname + "'" + sql["update2"] + str(id)
            if (gevice.gdbase.execute_sql_update(gevice,update)):
                gevice.gdbase.conn.commit()

        else:
            #show error message and delete the row.
            result = gevice.show_message (_("Name exist: ") + newname,gtk.MESSAGE_INFO,gtk.BUTTONS_OK)

       
    def is_newname_in_list(self,model,path,iter,newname):
        oldname = model.get(iter,1)[0]

        self.is_in_list = False;
        if oldname == newname:
            self.is_in_list = True;
            return True
        return False;
        
    def on_model_edited(self, cell, path, newname,gevice,sql):
        newname = newname.strip()
        model = self.treeview.get_model()
        iter = model.get_iter_from_string(path)
        id,oldname = model.get(iter,0,2)
        
        # check, newname exists
        if oldname == newname:
            return

        model.set(iter,2,newname)
        update = sql["update1"] + "'" + newname + "'" + sql["update2"] + str(id)
        
        if (gevice.gdbase.execute_sql_update(gevice,update)):
            gevice.gdbase.conn.commit()


    def on_button_add_clicked(self,button,gevice,sql):
        row = gevice.gdbase.execute_sql_select (gevice,sql["max_id"])
        
        liststore = self.treeview.get_model()
        iter = liststore.append ()
        liststore.set (
            iter,
            0,row[0][0],
            1,"New" + str(row[0][0]))
            
        path = liststore.get_path(iter)
        self.treeview.set_cursor(path,None,False)        
            
        insert = sql["insert"] + " (" + str(row[0][0]) + ",'" + "New" + str(row[0][0]) + "')"
        
        if (gevice.gdbase.execute_sql_insert (gevice,insert)):
            gevice.gdbase.conn.commit()

    
    def on_button_add_model_clicked(self,button,gevice,sql):
        self.load_interface_model(gevice,sql) 
         
    
    def on_button_rem_clicked(self,button,gevice,sql):
        selection = self.treeview.get_selection()
        model,iter = selection.get_selected()
        
        id = model.get(iter,0)[0]
        name = model.get(iter,1)[0]
        
        delete = sql["delete"] + str(id)
        
        result = gevice.show_message (_("Do you want to remove: ") + name,gtk.MESSAGE_QUESTION,gtk.BUTTONS_YES_NO)

        if result == gtk.RESPONSE_YES:
            if (gevice.gdbase.execute_sql_delete (gevice,delete)):
                model.remove(iter)
            
            gevice.gdbase.conn.commit()


    def on_button_rem_model_clicked(self,button,gevice,sql):
        selection = self.treeview.get_selection()
        model,iter = selection.get_selected()
        
        id = model.get(iter,0)[0]
        device = model.get(iter,1)[0]
        name = model.get(iter,2)[0]
        
        delete = sql["delete"] + str(id)
        
        result = gevice.show_message (_("Do you want to remove: ") + name,gtk.MESSAGE_QUESTION,gtk.BUTTONS_YES_NO)

        if result == gtk.RESPONSE_YES:
            if (gevice.gdbase.execute_sql_delete (gevice,delete)):
                model.remove(iter)
            
            gevice.gdbase.conn.commit()
        

    def on_button_model_ok_clicked (self,button,gevice,sql):
        nmodel = self.entry_model.get_text()
        
        iter_mark = self.combobox_mark.get_active_iter()
        id_mark = self.list_mark.get_value(iter_mark,1)
        
        iter_type = self.combobox_type.get_active_iter()
        id_type = self.list_type.get_value(iter_type,1)
        

        row = gevice.gdbase.execute_sql_select (gevice,sql["max_id"])

        insert = sql["insert"] + " (" + str(row[0][0]) + "," + str(id_type) + "," + str(id_mark) + ",'" + nmodel + "')"
        
        if (gevice.gdbase.execute_sql_insert (gevice,insert)):        
            gevice.gdbase.conn.commit()        
        
            self.load_data1(gevice,sql)
            self.on_button_model_cancel_clicked(None)
