import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import gobject

import gettext
gettext.textdomain("gevice")
from gettext import gettext as _

import config

class GeviceModel:
    def __init__ (self,gevice):
        self.treestore = gtk.TreeStore(
        gobject.TYPE_STRING,
        gobject.TYPE_STRING,
        gobject.TYPE_STRING,
        gobject.TYPE_STRING,
        gobject.TYPE_STRING,
        gobject.TYPE_STRING,
        gobject.TYPE_STRING)
        
        self.treeview = gtk.TreeView (self.treestore)
        self.treeview.set_rules_hint (True)
        self.treeview.set_reorderable (True)
        
        # create columns
        col = gtk.TreeViewColumn (_("Device"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        
        cell =  gtk.CellRendererText()
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",config.COLUMN_NAME_DEV)

        col = gtk.TreeViewColumn (_("Model"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",config.COLUMN_NAME_MODEL_DEV)

        col = gtk.TreeViewColumn (_("IP"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",config.COLUMN_IP_DEV)

        col = gtk.TreeViewColumn (_("Serial"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",config.COLUMN_SERIAL_DEV)

        col = gtk.TreeViewColumn (_("Comments"))
        col.set_resizable (True)
        self.treeview.append_column (col)
        cell =  gtk.CellRendererText()
        col.pack_start (cell,True)
        col.add_attribute (cell,"text",config.COLUMN_OBS_DEV)


        selection = self.treeview.get_selection()
        selection.connect ("changed",self.on_device_selection_changed,gevice)

        return

    def insert_new_item (self,newiter,row,id_type_link):
        self.treestore.set (newiter,
            config.COLUMN_NAME_DEV,row[0][0],
            config.COLUMN_ID_MODEL_DEV,row[0][1],
            config.COLUMN_NAME_MODEL_DEV,row[0][2],            
            config.COLUMN_IP_DEV,row[0][3],
            config.COLUMN_SERIAL_DEV,row[0][4],
            config.COLUMN_OBS_DEV,row[0][5],
            config.COLUMN_ID_TYPE_LINK_DEV,id_type_link)


    def on_device_selection_changed (self,selection,gevice):
        model,iter = selection.get_selected()

        if (iter):
            gevice.actiongroup_device.set_sensitive (True)
        else:
            gevice.actiongroup_device.set_sensitive (False)

    def get_iter_selected (self,treeview):
        treeselection = treeview.get_selection()
        model,iter = treeselection.get_selected()

        model,path = treeselection.get_selected_rows()

        selected = {"iter":iter,"path":path,"model":model}

        return selected

    def get_data_of_device_from_model(self,treeview):
        i = self.get_iter_selected (treeview)

        data = i["model"].get(i["iter"],
            config.COLUMN_NAME_DEV,
            config.COLUMN_ID_MODEL_DEV,
            config.COLUMN_IP_DEV,  
            config.COLUMN_SERIAL_DEV,
            config.COLUMN_OBS_DEV,
            config.COLUMN_ID_TYPE_LINK_DEV)

        return data


    def get_model_from_device (self,treestore,path,iter):
        name_model,type = treestore.get(iter,
            config.COLUMN_MODEL,
            config.COLUMN_TYPE)	

        if int(self.selected) == int(type):
            l_tmp = self.lists_m

            it = l_tmp.get_iter_first()

            if it:
                exist = False
                while (it):
                    tmp = l_tmp.get(it,0)

                    if tmp[0] == name_model:
                        exist = True
                        break
                    else:
                        it = l_tmp.iter_next(it)

                if not exist:
                    iter = self.lists_m.append ()
                    self.lists_m.set (iter,0,name_model)
            else:
                iter = self.lists_m.append ()
                self.lists_m.set (iter,0,name_model)

    def get_data_of_device_from_key (self,key,gevice):
        "return data of key"

        iter = gevice.list_devices.get_iter_first()

        while (iter):
            id = gevice.list_devices.get_value(iter,config.COLUMN_DEVICE)

            if str(key) == str(id):
                name_type = gevice.list_devices.get_value(iter,config.COLUMN_NAME_DEVICE)
                pix =  gevice.list_devices.get_value(iter,config.COLUMN_PIXBUF)

                return name_type, pix

            iter = gevice.list_devices.iter_next(iter)
        return None,None

    def get_data_of_link_from_key (self,key,gevice):
        iter = gevice.list_links.get_iter_first()

        while (iter):
            id = gevice.list_links.get_value(iter,config.COLUMN_ID_LINK)

            if str(key) == str(id):
                pix =  gevice.list_links.get_value(iter,config.COLUMN_PIXBUF_LINK)
                name =  gevice.list_links.get_value(iter,config.COLUMN_NAME_LINK)

                return pix,name

            iter = gevice.list_links.iter_next(iter)
        return None,None

    def expand_treeview (self,flag):
        seleccion,iterador = self.treeview.get_selection().get_selected()
        path = self.treestore.get_path(iterador)

        if flag:
            self.treeview.expand_row(path,True)
        else:
            self.treeview.collapse_row(path)
