# gevice: GNOME Network Device Manager
#
# This template was inspired from gnome-specimen.
#
# Copyright (C) 2006--2007  Wouter Bolsterlee <wbolster@gnome.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


from os.path import join, exists, dirname, realpath

PACKAGE     = "gevice"
VERSION     = "0.5.1"

# Don't bother using translations from the source directory (too much hassle,
# if not impossible because of the $LANG/LC_MESSAGES directories)
LOCALEDIR   = "/usr/local/share/locale"

# Allow to run uninstalled by detecting gnome-specimen.in
if exists(join(dirname(__file__), '../gevice.in')):
    print "Running from source directory; not using installation paths!"

    source_datadir = realpath(join(dirname(__file__), '../data'))

    DATADIR     = source_datadir
    PKGDATADIR  = source_datadir
    GLADEDIR    = join (source_datadir, "glade")
    ARTDIR	= join (source_datadir, "images")
# Normal situation: use installation paths from ./configure
else:
    DATADIR     = "/usr/local/share"
    PKGDATADIR  = "/usr/local/share/gevice"
    GLADEDIR    = "/usr/local/share/gevice/glade"
    ARTDIR	= "/usr/local/share/gevice/images"

# struct main treestore
COLUMN_NAME_DEV = 0
COLUMN_NAME_MODEL_DEV = 1
COLUMN_IP_DEV = 2
COLUMN_SERIAL_DEV = 3
COLUMN_OBS_DEV = 4
COLUMN_ID_MODEL_DEV = 5
COLUMN_ID_TYPE_LINK_DEV = 6


# struct liststore of models
COLUMN_NAME_MODEL_DEV2 = 0
COLUMN_ID_MODEL_DEV2 = 1

# struct liststore of links
COLUMN_NAME_TYPE_LINK_DEV2 = 0
COLUMN_ID_TYPE_LINK_DEV2 = 1


DEFAULT_TMP = "/tmp/"

# width and high of main window
DEFAULT_WIDTH = 750
DEFAULT_HIGH = 550

# printer
XINI = 25
YINI = 700
XLIN = 580
YLIN_END = 35
MAX_LINES_FOR_PAGE = 40

