/* gca-diagnostic-colors.c generated by valac 0.26.0.42-9d44-dirty, the Vala compiler
 * generated from gca-diagnostic-colors.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define GCA_TYPE_DIAGNOSTIC_COLORS (gca_diagnostic_colors_get_type ())
#define GCA_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColors))
#define GCA_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColorsClass))
#define GCA_IS_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_COLORS))
#define GCA_IS_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_COLORS))
#define GCA_DIAGNOSTIC_COLORS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColorsClass))

typedef struct _GcaDiagnosticColors GcaDiagnosticColors;
typedef struct _GcaDiagnosticColorsClass GcaDiagnosticColorsClass;
typedef struct _GcaDiagnosticColorsPrivate GcaDiagnosticColorsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCA_DIAGNOSTIC_TYPE_SEVERITY (gca_diagnostic_severity_get_type ())
typedef struct _GcaParamSpecDiagnosticColors GcaParamSpecDiagnosticColors;

struct _GcaDiagnosticColors {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcaDiagnosticColorsPrivate * priv;
};

struct _GcaDiagnosticColorsClass {
	GTypeClass parent_class;
	void (*finalize) (GcaDiagnosticColors *self);
};

struct _GcaDiagnosticColorsPrivate {
	GdkRGBA d_errorColor;
	GdkRGBA d_warningColor;
	GdkRGBA d_infoColor;
};

typedef enum  {
	GCA_DIAGNOSTIC_SEVERITY_NONE,
	GCA_DIAGNOSTIC_SEVERITY_INFO,
	GCA_DIAGNOSTIC_SEVERITY_WARNING,
	GCA_DIAGNOSTIC_SEVERITY_DEPRECATED,
	GCA_DIAGNOSTIC_SEVERITY_ERROR,
	GCA_DIAGNOSTIC_SEVERITY_FATAL
} GcaDiagnosticSeverity;

struct _GcaParamSpecDiagnosticColors {
	GParamSpec parent_instance;
};


static gpointer gca_diagnostic_colors_parent_class = NULL;

gpointer gca_diagnostic_colors_ref (gpointer instance);
void gca_diagnostic_colors_unref (gpointer instance);
GParamSpec* gca_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_diagnostic_colors (GValue* value, gpointer v_object);
void gca_value_take_diagnostic_colors (GValue* value, gpointer v_object);
gpointer gca_value_get_diagnostic_colors (const GValue* value);
GType gca_diagnostic_colors_get_type (void) G_GNUC_CONST;
#define GCA_DIAGNOSTIC_COLORS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColorsPrivate))
enum  {
	GCA_DIAGNOSTIC_COLORS_DUMMY_PROPERTY
};
GcaDiagnosticColors* gca_diagnostic_colors_new (GtkStyleContext* context);
GcaDiagnosticColors* gca_diagnostic_colors_construct (GType object_type, GtkStyleContext* context);
static void gca_diagnostic_colors_update_color (GcaDiagnosticColors* self, GtkStyleContext* context, const gchar* color_name, GdkRGBA* defcol, gdouble alpha, GdkRGBA* result);
static void gca_diagnostic_colors_mix_colors (GcaDiagnosticColors* self, GdkRGBA* source, GdkRGBA* dest, GdkRGBA* result);
void gca_diagnostic_colors_mix_in_widget (GcaDiagnosticColors* self, GtkWidget* widget);
void gca_diagnostic_colors_mix_in_color (GcaDiagnosticColors* self, GtkWidget* widget, GdkRGBA* dest);
GType gca_diagnostic_severity_get_type (void) G_GNUC_CONST;
GdkRGBA* gca_diagnostic_colors_get (GcaDiagnosticColors* self, GcaDiagnosticSeverity severity);
static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self);
void gca_diagnostic_colors_get_error_color (GcaDiagnosticColors* self, GdkRGBA* result);
void gca_diagnostic_colors_get_warning_color (GcaDiagnosticColors* self, GdkRGBA* result);
void gca_diagnostic_colors_get_info_color (GcaDiagnosticColors* self, GdkRGBA* result);
static void gca_diagnostic_colors_finalize (GcaDiagnosticColors* obj);


GcaDiagnosticColors* gca_diagnostic_colors_construct (GType object_type, GtkStyleContext* context) {
	GcaDiagnosticColors* self = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_ = {0};
	GtkStyleContext* _tmp3_ = NULL;
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	GtkStyleContext* _tmp6_ = NULL;
	GdkRGBA _tmp7_ = {0};
	GdkRGBA _tmp8_ = {0};
	g_return_val_if_fail (context != NULL, NULL);
	self = (GcaDiagnosticColors*) g_type_create_instance (object_type);
	_tmp0_ = context;
	_tmp1_.red = (gdouble) 1;
	_tmp1_.green = (gdouble) 0;
	_tmp1_.blue = (gdouble) 0;
	_tmp1_.alpha = (gdouble) 1;
	gca_diagnostic_colors_update_color (self, _tmp0_, "error_bg_color", &_tmp1_, 0.5, &_tmp2_);
	self->priv->d_errorColor = _tmp2_;
	_tmp3_ = context;
	_tmp4_.red = (gdouble) 1;
	_tmp4_.green = 0.5;
	_tmp4_.blue = (gdouble) 0;
	_tmp4_.alpha = (gdouble) 1;
	gca_diagnostic_colors_update_color (self, _tmp3_, "warning_bg_color", &_tmp4_, 0.5, &_tmp5_);
	self->priv->d_warningColor = _tmp5_;
	_tmp6_ = context;
	_tmp7_.red = (gdouble) 0;
	_tmp7_.green = (gdouble) 0;
	_tmp7_.blue = (gdouble) 1;
	_tmp7_.alpha = (gdouble) 1;
	gca_diagnostic_colors_update_color (self, _tmp6_, "info_bg_color", &_tmp7_, 0.5, &_tmp8_);
	self->priv->d_infoColor = _tmp8_;
	return self;
}


GcaDiagnosticColors* gca_diagnostic_colors_new (GtkStyleContext* context) {
	return gca_diagnostic_colors_construct (GCA_TYPE_DIAGNOSTIC_COLORS, context);
}


static void gca_diagnostic_colors_mix_colors (GcaDiagnosticColors* self, GdkRGBA* source, GdkRGBA* dest, GdkRGBA* result) {
	GdkRGBA mixed = {0};
	GdkRGBA _tmp0_ = {0};
	GdkRGBA _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	GdkRGBA _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	GdkRGBA _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	GdkRGBA _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	GdkRGBA _tmp11_ = {0};
	gdouble _tmp12_ = 0.0;
	GdkRGBA _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	GdkRGBA _tmp15_ = {0};
	gdouble _tmp16_ = 0.0;
	GdkRGBA _tmp17_ = {0};
	gdouble _tmp18_ = 0.0;
	GdkRGBA _tmp19_ = {0};
	gdouble _tmp20_ = 0.0;
	GdkRGBA _tmp21_ = {0};
	gdouble _tmp22_ = 0.0;
	GdkRGBA _tmp23_ = {0};
	gdouble _tmp24_ = 0.0;
	GdkRGBA _tmp25_ = {0};
	gdouble _tmp26_ = 0.0;
	GdkRGBA _tmp27_ = {0};
	gdouble _tmp28_ = 0.0;
	GdkRGBA _tmp29_ = {0};
	gdouble _tmp30_ = 0.0;
	GdkRGBA _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	GdkRGBA _tmp33_ = {0};
	gdouble _tmp34_ = 0.0;
	GdkRGBA _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	GdkRGBA _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	GdkRGBA _tmp39_ = {0};
	gdouble _tmp40_ = 0.0;
	GdkRGBA _tmp41_ = {0};
	gdouble _tmp42_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (dest != NULL);
	_tmp0_.red = (gdouble) 0;
	_tmp0_.green = (gdouble) 0;
	_tmp0_.blue = (gdouble) 0;
	_tmp0_.alpha = (gdouble) 0;
	mixed = _tmp0_;
	_tmp1_ = *source;
	_tmp2_ = _tmp1_.alpha;
	_tmp3_ = *dest;
	_tmp4_ = _tmp3_.alpha;
	_tmp5_ = *source;
	_tmp6_ = _tmp5_.alpha;
	mixed.alpha = _tmp2_ + (_tmp4_ * (1 - _tmp6_));
	_tmp7_ = *source;
	_tmp8_ = _tmp7_.red;
	_tmp9_ = *source;
	_tmp10_ = _tmp9_.alpha;
	_tmp11_ = *dest;
	_tmp12_ = _tmp11_.red;
	_tmp13_ = *dest;
	_tmp14_ = _tmp13_.alpha;
	_tmp15_ = *source;
	_tmp16_ = _tmp15_.alpha;
	_tmp17_ = mixed;
	_tmp18_ = _tmp17_.alpha;
	mixed.red = ((_tmp8_ * _tmp10_) + ((_tmp12_ * _tmp14_) * (1 - _tmp16_))) / _tmp18_;
	_tmp19_ = *source;
	_tmp20_ = _tmp19_.green;
	_tmp21_ = *source;
	_tmp22_ = _tmp21_.alpha;
	_tmp23_ = *dest;
	_tmp24_ = _tmp23_.green;
	_tmp25_ = *dest;
	_tmp26_ = _tmp25_.alpha;
	_tmp27_ = *source;
	_tmp28_ = _tmp27_.alpha;
	_tmp29_ = mixed;
	_tmp30_ = _tmp29_.alpha;
	mixed.green = ((_tmp20_ * _tmp22_) + ((_tmp24_ * _tmp26_) * (1 - _tmp28_))) / _tmp30_;
	_tmp31_ = *source;
	_tmp32_ = _tmp31_.blue;
	_tmp33_ = *source;
	_tmp34_ = _tmp33_.alpha;
	_tmp35_ = *dest;
	_tmp36_ = _tmp35_.blue;
	_tmp37_ = *dest;
	_tmp38_ = _tmp37_.alpha;
	_tmp39_ = *source;
	_tmp40_ = _tmp39_.alpha;
	_tmp41_ = mixed;
	_tmp42_ = _tmp41_.alpha;
	mixed.blue = ((_tmp32_ * _tmp34_) + ((_tmp36_ * _tmp38_) * (1 - _tmp40_))) / _tmp42_;
	*result = mixed;
	return;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gca_diagnostic_colors_mix_in_widget (GcaDiagnosticColors* self, GtkWidget* widget) {
	GtkStyleContext* ctx = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GdkRGBA dest = {0};
	GtkWidget* _tmp3_ = NULL;
	GtkStateFlags _tmp4_ = 0;
	GdkRGBA _tmp5_ = {0};
	GtkWidget* _tmp6_ = NULL;
	GdkRGBA _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ctx = _tmp2_;
	gtk_style_context_save (ctx);
	gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_VIEW);
	_tmp3_ = widget;
	_tmp4_ = gtk_widget_get_state_flags (_tmp3_);
	gtk_style_context_get_background_color (ctx, _tmp4_, &_tmp5_);
	dest = _tmp5_;
	_tmp6_ = widget;
	_tmp7_ = dest;
	gca_diagnostic_colors_mix_in_color (self, _tmp6_, &_tmp7_);
	gtk_style_context_restore (ctx);
	_g_object_unref0 (ctx);
}


void gca_diagnostic_colors_mix_in_color (GcaDiagnosticColors* self, GtkWidget* widget, GdkRGBA* dest) {
	GtkStyleContext* ctx = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	GdkRGBA _tmp6_ = {0};
	GdkRGBA _tmp7_ = {0};
	GdkRGBA _tmp8_ = {0};
	GdkRGBA _tmp9_ = {0};
	GdkRGBA _tmp10_ = {0};
	GdkRGBA _tmp11_ = {0};
	GdkRGBA _tmp12_ = {0};
	GdkRGBA _tmp13_ = {0};
	GdkRGBA _tmp14_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (dest != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ctx = _tmp2_;
	gtk_style_context_save (ctx);
	gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_VIEW);
	_tmp3_.red = (gdouble) 1;
	_tmp3_.green = (gdouble) 0;
	_tmp3_.blue = (gdouble) 0;
	_tmp3_.alpha = (gdouble) 1;
	gca_diagnostic_colors_update_color (self, ctx, "error_bg_color", &_tmp3_, 0.5, &_tmp4_);
	_tmp5_ = *dest;
	gca_diagnostic_colors_mix_colors (self, &_tmp4_, &_tmp5_, &_tmp6_);
	self->priv->d_errorColor = _tmp6_;
	_tmp7_.red = (gdouble) 1;
	_tmp7_.green = 0.5;
	_tmp7_.blue = (gdouble) 0;
	_tmp7_.alpha = (gdouble) 1;
	gca_diagnostic_colors_update_color (self, ctx, "warning_bg_color", &_tmp7_, 0.5, &_tmp8_);
	_tmp9_ = *dest;
	gca_diagnostic_colors_mix_colors (self, &_tmp8_, &_tmp9_, &_tmp10_);
	self->priv->d_warningColor = _tmp10_;
	_tmp11_.red = (gdouble) 0;
	_tmp11_.green = (gdouble) 0;
	_tmp11_.blue = (gdouble) 1;
	_tmp11_.alpha = (gdouble) 1;
	gca_diagnostic_colors_update_color (self, ctx, "info_bg_color", &_tmp11_, 0.5, &_tmp12_);
	_tmp13_ = *dest;
	gca_diagnostic_colors_mix_colors (self, &_tmp12_, &_tmp13_, &_tmp14_);
	self->priv->d_infoColor = _tmp14_;
	gtk_style_context_restore (ctx);
	_g_object_unref0 (ctx);
}


static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self) {
	GdkRGBA* dup;
	dup = g_new0 (GdkRGBA, 1);
	memcpy (dup, self, sizeof (GdkRGBA));
	return dup;
}


static gpointer __gdk_rgba_dup0 (gpointer self) {
	return self ? _gdk_rgba_dup (self) : NULL;
}


GdkRGBA* gca_diagnostic_colors_get (GcaDiagnosticColors* self, GcaDiagnosticSeverity severity) {
	GdkRGBA* result = NULL;
	GcaDiagnosticSeverity _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = severity;
	switch (_tmp0_) {
		case GCA_DIAGNOSTIC_SEVERITY_INFO:
		{
			GdkRGBA _tmp1_ = {0};
			GdkRGBA* _tmp2_ = NULL;
			_tmp1_ = self->priv->d_infoColor;
			_tmp2_ = __gdk_rgba_dup0 (&_tmp1_);
			result = _tmp2_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_WARNING:
		{
			GdkRGBA _tmp3_ = {0};
			GdkRGBA* _tmp4_ = NULL;
			_tmp3_ = self->priv->d_warningColor;
			_tmp4_ = __gdk_rgba_dup0 (&_tmp3_);
			result = _tmp4_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_ERROR:
		case GCA_DIAGNOSTIC_SEVERITY_FATAL:
		{
			GdkRGBA _tmp5_ = {0};
			GdkRGBA* _tmp6_ = NULL;
			_tmp5_ = self->priv->d_errorColor;
			_tmp6_ = __gdk_rgba_dup0 (&_tmp5_);
			result = _tmp6_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


static void gca_diagnostic_colors_update_color (GcaDiagnosticColors* self, GtkStyleContext* context, const gchar* color_name, GdkRGBA* defcol, gdouble alpha, GdkRGBA* result) {
	GdkRGBA col = {0};
	GtkStyleContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GdkRGBA _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gdouble s = 0.0;
	gdouble max = 0.0;
	GdkRGBA _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	GdkRGBA _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	GdkRGBA _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble min = 0.0;
	GdkRGBA _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	GdkRGBA _tmp15_ = {0};
	gdouble _tmp16_ = 0.0;
	GdkRGBA _tmp17_ = {0};
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	gdouble dm = 0.0;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (color_name != NULL);
	g_return_if_fail (defcol != NULL);
	_tmp0_ = context;
	_tmp1_ = color_name;
	_tmp3_ = gtk_style_context_lookup_color (_tmp0_, _tmp1_, &_tmp2_);
	col = _tmp2_;
	if (!_tmp3_) {
		GdkRGBA _tmp4_ = {0};
		_tmp4_ = *defcol;
		col = _tmp4_;
	}
	s = (gdouble) 0;
	_tmp5_ = col;
	_tmp6_ = _tmp5_.red;
	_tmp7_ = col;
	_tmp8_ = _tmp7_.green;
	_tmp9_ = col;
	_tmp10_ = _tmp9_.blue;
	_tmp11_ = MAX (_tmp8_, _tmp10_);
	_tmp12_ = MAX (_tmp6_, _tmp11_);
	max = _tmp12_;
	_tmp13_ = col;
	_tmp14_ = _tmp13_.red;
	_tmp15_ = col;
	_tmp16_ = _tmp15_.green;
	_tmp17_ = col;
	_tmp18_ = _tmp17_.blue;
	_tmp19_ = MIN (_tmp16_, _tmp18_);
	_tmp20_ = MIN (_tmp14_, _tmp19_);
	min = _tmp20_;
	_tmp21_ = max;
	_tmp22_ = min;
	dm = _tmp21_ - _tmp22_;
	_tmp23_ = dm;
	if (_tmp23_ != ((gdouble) 0)) {
		gdouble _tmp24_ = 0.0;
		gdouble _tmp25_ = 0.0;
		_tmp24_ = dm;
		_tmp25_ = max;
		s = _tmp24_ / _tmp25_;
	}
	_tmp26_ = s;
	if (_tmp26_ < 0.5) {
		gdouble _tmp27_ = 0.0;
		gdouble _tmp28_ = 0.0;
		gdouble _tmp29_ = 0.0;
		_tmp27_ = col.red;
		col.red = _tmp27_ * 0.5;
		_tmp28_ = col.blue;
		col.blue = _tmp28_ * 0.5;
		_tmp29_ = col.green;
		col.green = _tmp29_ * 0.5;
	}
	_tmp30_ = col.alpha;
	_tmp31_ = alpha;
	col.alpha = _tmp30_ * _tmp31_;
	*result = col;
	return;
}


void gca_diagnostic_colors_get_error_color (GcaDiagnosticColors* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_errorColor;
	*result = _tmp0_;
	return;
}


void gca_diagnostic_colors_get_warning_color (GcaDiagnosticColors* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_warningColor;
	*result = _tmp0_;
	return;
}


void gca_diagnostic_colors_get_info_color (GcaDiagnosticColors* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_infoColor;
	*result = _tmp0_;
	return;
}


static void gca_value_diagnostic_colors_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gca_value_diagnostic_colors_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gca_diagnostic_colors_unref (value->data[0].v_pointer);
	}
}


static void gca_value_diagnostic_colors_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gca_diagnostic_colors_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gca_value_diagnostic_colors_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gca_value_diagnostic_colors_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcaDiagnosticColors* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gca_diagnostic_colors_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gca_value_diagnostic_colors_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcaDiagnosticColors** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gca_diagnostic_colors_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gca_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcaParamSpecDiagnosticColors* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCA_TYPE_DIAGNOSTIC_COLORS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gca_value_get_diagnostic_colors (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_TYPE_DIAGNOSTIC_COLORS), NULL);
	return value->data[0].v_pointer;
}


void gca_value_set_diagnostic_colors (GValue* value, gpointer v_object) {
	GcaDiagnosticColors* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_TYPE_DIAGNOSTIC_COLORS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCA_TYPE_DIAGNOSTIC_COLORS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gca_diagnostic_colors_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gca_diagnostic_colors_unref (old);
	}
}


void gca_value_take_diagnostic_colors (GValue* value, gpointer v_object) {
	GcaDiagnosticColors* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCA_TYPE_DIAGNOSTIC_COLORS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCA_TYPE_DIAGNOSTIC_COLORS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gca_diagnostic_colors_unref (old);
	}
}


static void gca_diagnostic_colors_class_init (GcaDiagnosticColorsClass * klass) {
	gca_diagnostic_colors_parent_class = g_type_class_peek_parent (klass);
	((GcaDiagnosticColorsClass *) klass)->finalize = gca_diagnostic_colors_finalize;
	g_type_class_add_private (klass, sizeof (GcaDiagnosticColorsPrivate));
}


static void gca_diagnostic_colors_instance_init (GcaDiagnosticColors * self) {
	self->priv = GCA_DIAGNOSTIC_COLORS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gca_diagnostic_colors_finalize (GcaDiagnosticColors* obj) {
	GcaDiagnosticColors * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColors);
	g_signal_handlers_destroy (self);
}


GType gca_diagnostic_colors_get_type (void) {
	static volatile gsize gca_diagnostic_colors_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_colors_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gca_value_diagnostic_colors_init, gca_value_diagnostic_colors_free_value, gca_value_diagnostic_colors_copy_value, gca_value_diagnostic_colors_peek_pointer, "p", gca_value_diagnostic_colors_collect_value, "p", gca_value_diagnostic_colors_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GcaDiagnosticColorsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_diagnostic_colors_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDiagnosticColors), 0, (GInstanceInitFunc) gca_diagnostic_colors_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gca_diagnostic_colors_type_id;
		gca_diagnostic_colors_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcaDiagnosticColors", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gca_diagnostic_colors_type_id__volatile, gca_diagnostic_colors_type_id);
	}
	return gca_diagnostic_colors_type_id__volatile;
}


gpointer gca_diagnostic_colors_ref (gpointer instance) {
	GcaDiagnosticColors* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gca_diagnostic_colors_unref (gpointer instance) {
	GcaDiagnosticColors* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCA_DIAGNOSTIC_COLORS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



