/* gca-source-range.c generated by valac 0.26.1, the Vala compiler
 * generated from gca-source-range.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>


#define GCA_TYPE_SOURCE_RANGE (gca_source_range_get_type ())

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;
typedef struct _GcaSourceRange GcaSourceRange;

#define GCA_DBUS_TYPE_SOURCE_RANGE (gca_dbus_source_range_get_type ())

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;
typedef struct _GcaDBusSourceRange GcaDBusSourceRange;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _GcaSourceRange {
	GcaSourceLocation start;
	GcaSourceLocation end;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaDBusSourceRange {
	gint64 file;
	GcaDBusSourceLocation start;
	GcaDBusSourceLocation end;
};



GType gca_source_range_get_type (void) G_GNUC_CONST;
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
GcaSourceRange* gca_source_range_dup (const GcaSourceRange* self);
void gca_source_range_free (GcaSourceRange* self);
void gca_source_range_from_iter (GtkTextIter* iter, GcaSourceRange* result);
void gca_source_location_from_iter (GtkTextIter* iter, GcaSourceLocation* result);
GType gca_dbus_source_range_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
GcaDBusSourceRange* gca_dbus_source_range_dup (const GcaDBusSourceRange* self);
void gca_dbus_source_range_free (GcaDBusSourceRange* self);
void gca_source_range_from_dbus (GcaDBusSourceRange* range, GcaSourceRange* result);
void gca_source_location_from_dbus (GcaDBusSourceLocation* location, GcaSourceLocation* result);
gint gca_source_range_compare_to (GcaSourceRange *self, GcaSourceRange* other);
gint gca_source_location_compare_to (GcaSourceLocation *self, GcaSourceLocation* other);
gboolean gca_source_range_get_iters (GcaSourceRange *self, GtkTextBuffer* buffer, GtkTextIter* start, GtkTextIter* end);
gboolean gca_source_location_get_iter (GcaSourceLocation *self, GtkTextBuffer* buffer, GtkTextIter* iter);
gboolean gca_source_range_contains_range (GcaSourceRange *self, GcaSourceRange* range);
gboolean gca_source_range_contains_location (GcaSourceRange *self, GcaSourceLocation* location);
gboolean gca_source_range_contains (GcaSourceRange *self, gint line, gint column);
gboolean gca_source_range_contains_line (GcaSourceRange *self, gint line);
gchar* gca_source_range_to_string (GcaSourceRange *self);
gchar* gca_source_location_to_string (GcaSourceLocation *self);


void gca_source_range_from_iter (GtkTextIter* iter, GcaSourceRange* result) {
	GcaSourceLocation loc = {0};
	GtkTextIter _tmp0_ = {0};
	GcaSourceLocation _tmp1_ = {0};
	GcaSourceLocation _tmp2_ = {0};
	GcaSourceLocation _tmp3_ = {0};
	GcaSourceRange _tmp4_ = {0};
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gca_source_location_from_iter (&_tmp0_, &_tmp1_);
	loc = _tmp1_;
	_tmp2_ = loc;
	_tmp3_ = loc;
	memset (&_tmp4_, 0, sizeof (GcaSourceRange));
	_tmp4_.start = _tmp2_;
	_tmp4_.end = _tmp3_;
	*result = _tmp4_;
	return;
}


void gca_source_range_from_dbus (GcaDBusSourceRange* range, GcaSourceRange* result) {
	GcaDBusSourceRange _tmp0_ = {0};
	GcaDBusSourceLocation _tmp1_ = {0};
	GcaSourceLocation _tmp2_ = {0};
	GcaDBusSourceRange _tmp3_ = {0};
	GcaDBusSourceLocation _tmp4_ = {0};
	GcaSourceLocation _tmp5_ = {0};
	GcaSourceRange _tmp6_ = {0};
	g_return_if_fail (range != NULL);
	_tmp0_ = *range;
	_tmp1_ = _tmp0_.start;
	gca_source_location_from_dbus (&_tmp1_, &_tmp2_);
	_tmp3_ = *range;
	_tmp4_ = _tmp3_.end;
	gca_source_location_from_dbus (&_tmp4_, &_tmp5_);
	memset (&_tmp6_, 0, sizeof (GcaSourceRange));
	_tmp6_.start = _tmp2_;
	_tmp6_.end = _tmp5_;
	*result = _tmp6_;
	return;
}


gint gca_source_range_compare_to (GcaSourceRange *self, GcaSourceRange* other) {
	gint result = 0;
	gint st = 0;
	GcaSourceRange _tmp0_ = {0};
	GcaSourceLocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = *other;
	_tmp1_ = _tmp0_.start;
	_tmp2_ = gca_source_location_compare_to (&(*self).start, &_tmp1_);
	st = _tmp2_;
	_tmp3_ = st;
	if (_tmp3_ == 0) {
		GcaSourceLocation _tmp4_ = {0};
		gint _tmp5_ = 0;
		_tmp4_ = (*self).end;
		_tmp5_ = gca_source_location_compare_to (&(*other).end, &_tmp4_);
		st = _tmp5_;
	}
	result = st;
	return result;
}


gboolean gca_source_range_get_iters (GcaSourceRange *self, GtkTextBuffer* buffer, GtkTextIter* start, GtkTextIter* end) {
	GtkTextIter _vala_start = {0};
	GtkTextIter _vala_end = {0};
	gboolean result = FALSE;
	gboolean rets = FALSE;
	gboolean rete = FALSE;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (buffer != NULL, FALSE);
	_tmp0_ = buffer;
	_tmp2_ = gca_source_location_get_iter (&(*self).start, _tmp0_, &_tmp1_);
	_vala_start = _tmp1_;
	rets = _tmp2_;
	_tmp3_ = buffer;
	_tmp5_ = gca_source_location_get_iter (&(*self).end, _tmp3_, &_tmp4_);
	_vala_end = _tmp4_;
	rete = _tmp5_;
	_tmp7_ = rete;
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		_tmp8_ = gtk_text_iter_ends_line (&_vala_end);
		_tmp6_ = !_tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gtk_text_iter_forward_char (&_vala_end);
	}
	_tmp10_ = rets;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		_tmp11_ = rete;
		_tmp9_ = _tmp11_;
	} else {
		_tmp9_ = FALSE;
	}
	result = _tmp9_;
	if (start) {
		*start = _vala_start;
	}
	if (end) {
		*end = _vala_end;
	}
	return result;
}


gboolean gca_source_range_contains_range (GcaSourceRange *self, GcaSourceRange* range) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GcaSourceRange _tmp1_ = {0};
	GcaSourceLocation _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (range != NULL, FALSE);
	_tmp1_ = *range;
	_tmp2_ = _tmp1_.start;
	_tmp3_ = gca_source_range_contains_location (&(*self), &_tmp2_);
	if (_tmp3_) {
		GcaSourceRange _tmp4_ = {0};
		GcaSourceLocation _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		_tmp4_ = *range;
		_tmp5_ = _tmp4_.end;
		_tmp6_ = gca_source_range_contains_location (&(*self), &_tmp5_);
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean gca_source_range_contains_location (GcaSourceRange *self, GcaSourceLocation* location) {
	gboolean result = FALSE;
	GcaSourceLocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	GcaSourceLocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.line;
	_tmp2_ = *location;
	_tmp3_ = _tmp2_.column;
	_tmp4_ = gca_source_range_contains (&(*self), _tmp1_, _tmp3_);
	result = _tmp4_;
	return result;
}


gboolean gca_source_range_contains (GcaSourceRange *self, gint line, gint column) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GcaSourceLocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	_tmp2_ = (*self).start;
	_tmp3_ = _tmp2_.line;
	_tmp4_ = line;
	if (_tmp3_ < _tmp4_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		GcaSourceLocation _tmp6_ = {0};
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp6_ = (*self).start;
		_tmp7_ = _tmp6_.line;
		_tmp8_ = line;
		if (_tmp7_ == _tmp8_) {
			GcaSourceLocation _tmp9_ = {0};
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			_tmp9_ = (*self).start;
			_tmp10_ = _tmp9_.column;
			_tmp11_ = column;
			_tmp5_ = _tmp10_ <= _tmp11_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gboolean _tmp12_ = FALSE;
		GcaSourceLocation _tmp13_ = {0};
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp13_ = (*self).end;
		_tmp14_ = _tmp13_.line;
		_tmp15_ = line;
		if (_tmp14_ > _tmp15_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp16_ = FALSE;
			GcaSourceLocation _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp17_ = (*self).end;
			_tmp18_ = _tmp17_.line;
			_tmp19_ = line;
			if (_tmp18_ == _tmp19_) {
				GcaSourceLocation _tmp20_ = {0};
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				_tmp20_ = (*self).end;
				_tmp21_ = _tmp20_.column;
				_tmp22_ = column;
				_tmp16_ = _tmp21_ >= _tmp22_;
			} else {
				_tmp16_ = FALSE;
			}
			_tmp12_ = _tmp16_;
		}
		_tmp0_ = _tmp12_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean gca_source_range_contains_line (GcaSourceRange *self, gint line) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GcaSourceLocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	_tmp1_ = (*self).start;
	_tmp2_ = _tmp1_.line;
	_tmp3_ = line;
	if (_tmp2_ <= _tmp3_) {
		GcaSourceLocation _tmp4_ = {0};
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp4_ = (*self).end;
		_tmp5_ = _tmp4_.line;
		_tmp6_ = line;
		_tmp0_ = _tmp5_ >= _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gchar* gca_source_range_to_string (GcaSourceRange *self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GcaSourceLocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	GcaSourceLocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	_tmp1_ = (*self).start;
	_tmp2_ = _tmp1_.line;
	_tmp3_ = (*self).end;
	_tmp4_ = _tmp3_.line;
	if (_tmp2_ == _tmp4_) {
		GcaSourceLocation _tmp5_ = {0};
		gint _tmp6_ = 0;
		GcaSourceLocation _tmp7_ = {0};
		gint _tmp8_ = 0;
		_tmp5_ = (*self).end;
		_tmp6_ = _tmp5_.column;
		_tmp7_ = (*self).start;
		_tmp8_ = _tmp7_.column;
		_tmp0_ = (_tmp6_ - _tmp8_) <= 1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = gca_source_location_to_string (&(*self).start);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = gca_source_location_to_string (&(*self).start);
	_tmp11_ = _tmp10_;
	_tmp12_ = gca_source_location_to_string (&(*self).end);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%s-%s", _tmp11_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = _tmp15_;
	return result;
}


GcaSourceRange* gca_source_range_dup (const GcaSourceRange* self) {
	GcaSourceRange* dup;
	dup = g_new0 (GcaSourceRange, 1);
	memcpy (dup, self, sizeof (GcaSourceRange));
	return dup;
}


void gca_source_range_free (GcaSourceRange* self) {
	g_free (self);
}


GType gca_source_range_get_type (void) {
	static volatile gsize gca_source_range_type_id__volatile = 0;
	if (g_once_init_enter (&gca_source_range_type_id__volatile)) {
		GType gca_source_range_type_id;
		gca_source_range_type_id = g_boxed_type_register_static ("GcaSourceRange", (GBoxedCopyFunc) gca_source_range_dup, (GBoxedFreeFunc) gca_source_range_free);
		g_once_init_leave (&gca_source_range_type_id__volatile, gca_source_range_type_id);
	}
	return gca_source_range_type_id__volatile;
}



