/* gca-backend.c generated by valac 0.20.1, the Vala compiler
 * generated from gca-backend.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define GCA_TYPE_BACKEND (gca_backend_get_type ())
#define GCA_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_BACKEND, GcaBackend))
#define GCA_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_BACKEND, GcaBackendClass))
#define GCA_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_BACKEND))
#define GCA_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_BACKEND))
#define GCA_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_BACKEND, GcaBackendClass))

typedef struct _GcaBackend GcaBackend;
typedef struct _GcaBackendClass GcaBackendClass;
typedef struct _GcaBackendPrivate GcaBackendPrivate;

#define GCA_TYPE_VIEW (gca_view_get_type ())
#define GCA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_VIEW, GcaView))
#define GCA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_VIEW, GcaViewClass))
#define GCA_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_VIEW))
#define GCA_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_VIEW))
#define GCA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_VIEW, GcaViewClass))

typedef struct _GcaView GcaView;
typedef struct _GcaViewClass GcaViewClass;

#define GCA_DBUS_TYPE_SERVICE (gca_dbus_service_get_type ())
#define GCA_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_SERVICE, GcaDBusService))
#define GCA_DBUS_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_SERVICE))
#define GCA_DBUS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_SERVICE, GcaDBusServiceIface))

typedef struct _GcaDBusService GcaDBusService;
typedef struct _GcaDBusServiceIface GcaDBusServiceIface;

#define GCA_DBUS_TYPE_SERVICE_PROXY (gca_dbus_service_proxy_get_type ())

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;

#define GCA_DBUS_TYPE_PROJECT (gca_dbus_project_get_type ())
#define GCA_DBUS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_PROJECT, GcaDBusProject))
#define GCA_DBUS_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_PROJECT))
#define GCA_DBUS_PROJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_PROJECT, GcaDBusProjectIface))

typedef struct _GcaDBusProject GcaDBusProject;
typedef struct _GcaDBusProjectIface GcaDBusProjectIface;

#define GCA_DBUS_TYPE_PROJECT_PROXY (gca_dbus_project_proxy_get_type ())

#define GCA_DBUS_TYPE_OPEN_DOCUMENT (gca_dbus_open_document_get_type ())
typedef struct _GcaDBusOpenDocument GcaDBusOpenDocument;

#define GCA_DBUS_TYPE_REMOTE_DOCUMENT (gca_dbus_remote_document_get_type ())
typedef struct _GcaDBusRemoteDocument GcaDBusRemoteDocument;

#define GCA_TYPE_REMOTE_SERVICES (gca_remote_services_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GcaBackendCreateData GcaBackendCreateData;

#define GCA_DBUS_TYPE_INTROSPECTABLE (gca_dbus_introspectable_get_type ())
#define GCA_DBUS_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_INTROSPECTABLE, GcaDBusIntrospectable))
#define GCA_DBUS_IS_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_INTROSPECTABLE))
#define GCA_DBUS_INTROSPECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_INTROSPECTABLE, GcaDBusIntrospectableIface))

typedef struct _GcaDBusIntrospectable GcaDBusIntrospectable;
typedef struct _GcaDBusIntrospectableIface GcaDBusIntrospectableIface;

#define GCA_DBUS_TYPE_INTROSPECTABLE_PROXY (gca_dbus_introspectable_proxy_get_type ())
#define _g_dbus_interface_info_unref0(var) ((var == NULL) ? NULL : (var = (g_dbus_interface_info_unref (var), NULL)))
#define _g_dbus_node_info_unref0(var) ((var == NULL) ? NULL : (var = (g_dbus_node_info_unref (var), NULL)))
typedef struct _GcaBackendGetRemoteServicesData GcaBackendGetRemoteServicesData;
typedef struct _GcaBackendGetProjectData GcaBackendGetProjectData;

#define GCA_TYPE_DOCUMENT (gca_document_get_type ())
#define GCA_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DOCUMENT, GcaDocument))
#define GCA_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DOCUMENT, GcaDocumentClass))
#define GCA_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DOCUMENT))
#define GCA_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DOCUMENT))
#define GCA_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DOCUMENT, GcaDocumentClass))

typedef struct _GcaDocument GcaDocument;
typedef struct _GcaDocumentClass GcaDocumentClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GcaBackendUnsavedDocumentData GcaBackendUnsavedDocumentData;
typedef struct _GcaBackendOpenDocumentsData GcaBackendOpenDocumentsData;
typedef struct _Block2Data Block2Data;

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;

#define GCA_TYPE_REMOTE_DOCUMENT (gca_remote_document_get_type ())
#define GCA_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocument))
#define GCA_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))
#define GCA_IS_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_IS_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_REMOTE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))

typedef struct _GcaRemoteDocument GcaRemoteDocument;
typedef struct _GcaRemoteDocumentClass GcaRemoteDocumentClass;
#define _gca_remote_document_unref0(var) ((var == NULL) ? NULL : (var = (gca_remote_document_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _GcaBackend {
	GObject parent_instance;
	GcaBackendPrivate * priv;
};

struct _GcaBackendClass {
	GObjectClass parent_class;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaDBusServiceIface {
	GTypeInterface parent_iface;
	void (*parse) (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*parse_finish) (GcaDBusService* self, GAsyncResult* _res_, GError** error);
	void (*dispose) (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*dispose_finish) (GcaDBusService* self, GAsyncResult* _res_, GError** error);
};

struct _GcaDBusOpenDocument {
	gchar* path;
	gchar* data_path;
};

struct _GcaDBusRemoteDocument {
	gchar* path;
	char* remote_path;
};

struct _GcaDBusProjectIface {
	GTypeInterface parent_iface;
	void (*parse_all) (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GcaDBusRemoteDocument* (*parse_all_finish) (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

typedef enum  {
	GCA_REMOTE_SERVICES_DIAGNOSTICS = 1 << 0,
	GCA_REMOTE_SERVICES_SEMANTIC_VALUES = 1 << 1,
	GCA_REMOTE_SERVICES_SYMBOLS = 1 << 2
} GcaRemoteServices;

struct _GcaBackendPrivate {
	GeeArrayList* d_views;
	GeeHashMap* d_paths;
	gchar* d_name;
	GcaDBusService* d_service;
	GcaDBusProject* d_project;
	GcaRemoteServices d_supported_services;
};

struct _GcaBackendCreateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* language;
	GcaBackend* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* name;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* path;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GcaDBusProject* _tmp6_;
	GcaDBusProject* project;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GcaRemoteServices _tmp9_;
	GcaRemoteServices services;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GcaDBusService* _tmp12_;
	GcaDBusService* service;
	const gchar* _tmp13_;
	GcaDBusService* _tmp14_;
	GcaDBusProject* _tmp15_;
	GcaRemoteServices _tmp16_;
	GcaBackend* _tmp17_;
	GError * _inner_error_;
};

struct _GcaDBusIntrospectableIface {
	GTypeInterface parent_iface;
	void (*Introspect) (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*Introspect_finish) (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error);
};

struct _GcaBackendGetRemoteServicesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* name;
	gchar* path;
	GcaRemoteServices result;
	GcaRemoteServices ret;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GcaDBusIntrospectable* _tmp4_;
	GcaDBusIntrospectable* _tmp5_;
	GcaDBusIntrospectable* intro;
	GcaDBusIntrospectable* _tmp6_;
	gchar* _tmp7_;
	gchar* xml;
	const gchar* _tmp8_;
	GDBusNodeInfo* _tmp9_;
	GDBusNodeInfo* node;
	GDBusNodeInfo* _tmp10_;
	GDBusInterfaceInfo** _tmp11_;
	gint _tmp11__length1;
	GDBusInterfaceInfo** iface_collection;
	gint iface_collection_length1;
	gint _iface_collection_size_;
	gint iface_it;
	GDBusInterfaceInfo* _tmp12_;
	GDBusInterfaceInfo* iface;
	GcaRemoteServices _tmp13_;
	GDBusInterfaceInfo* _tmp14_;
	const gchar* _tmp15_;
	GcaRemoteServices _tmp16_;
	GError * _inner_error_;
};

struct _GcaBackendGetProjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* name;
	gchar* path;
	GcaDBusProject* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GcaDBusIntrospectable* _tmp2_;
	GcaDBusIntrospectable* intro;
	GcaDBusIntrospectable* _tmp3_;
	gchar* _tmp4_;
	gchar* xml;
	const gchar* _tmp5_;
	GDBusNodeInfo* _tmp6_;
	GDBusNodeInfo* serviceintro;
	GcaDBusProject* project;
	GDBusNodeInfo* _tmp7_;
	GDBusInterfaceInfo* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GcaDBusProject* _tmp11_;
	GcaDBusProject* _tmp12_;
	GError * _inner_error_;
};

struct _GcaBackendUnsavedDocumentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GcaBackend* self;
	GcaView* v;
	gchar* result;
	GcaView* _tmp0_;
	GcaDocument* _tmp1_;
	GcaDocument* _tmp2_;
	GcaDocument* _tmp3_;
	GcaDocument* doc;
	GcaDocument* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GcaDocument* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError * _inner_error_;
};

struct _GcaBackendOpenDocumentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GcaBackend* self;
	GcaView* primary;
	GcaDBusOpenDocument* result;
	gint result_length1;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GcaDBusOpenDocument* _tmp3_;
	GcaDBusOpenDocument* ret;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _v_list;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _v_size;
	gint _v_index;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gpointer _tmp15_;
	GcaView* v;
	GcaView* _tmp16_;
	gchar* _tmp17_;
	gchar* dp;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GcaDBusOpenDocument* _tmp21_;
	gint _tmp21__length1;
	GcaView* _tmp22_;
	GcaDocument* _tmp23_;
	GcaDocument* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	GcaDBusOpenDocument _tmp29_;
	GcaDBusOpenDocument* _tmp30_;
	gint _tmp30__length1;
};

struct _Block2Data {
	int _ref_count_;
	GcaBackend * self;
	GcaView* view;
};

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _Block3Data {
	int _ref_count_;
	GcaBackend * self;
	GcaView* view;
};


static gpointer gca_backend_parent_class = NULL;

GType gca_backend_get_type (void) G_GNUC_CONST;
GType gca_view_get_type (void) G_GNUC_CONST;
GType gca_dbus_service_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
GType gca_dbus_service_get_type (void) G_GNUC_CONST;
GType gca_dbus_project_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_project_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_open_document_get_type (void) G_GNUC_CONST;
GcaDBusOpenDocument* gca_dbus_open_document_dup (const GcaDBusOpenDocument* self);
void gca_dbus_open_document_free (GcaDBusOpenDocument* self);
void gca_dbus_open_document_copy (const GcaDBusOpenDocument* self, GcaDBusOpenDocument* dest);
void gca_dbus_open_document_destroy (GcaDBusOpenDocument* self);
GType gca_dbus_remote_document_get_type (void) G_GNUC_CONST;
GcaDBusRemoteDocument* gca_dbus_remote_document_dup (const GcaDBusRemoteDocument* self);
void gca_dbus_remote_document_free (GcaDBusRemoteDocument* self);
void gca_dbus_remote_document_copy (const GcaDBusRemoteDocument* self, GcaDBusRemoteDocument* dest);
void gca_dbus_remote_document_destroy (GcaDBusRemoteDocument* self);
GType gca_dbus_project_get_type (void) G_GNUC_CONST;
GType gca_remote_services_get_type (void) G_GNUC_CONST;
#define GCA_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_BACKEND, GcaBackendPrivate))
enum  {
	GCA_BACKEND_DUMMY_PROPERTY
};
static void gca_backend_create_data_free (gpointer _data);
void gca_backend_create (const gchar* language, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaBackend* gca_backend_create_finish (GAsyncResult* _res_, GError** error);
static gboolean gca_backend_create_co (GcaBackendCreateData* _data_);
static void gca_backend_get_project (const gchar* name, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GcaDBusProject* gca_backend_get_project_finish (GAsyncResult* _res_, GError** error);
static void gca_backend_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gca_backend_get_remote_services (const gchar* name, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GcaRemoteServices gca_backend_get_remote_services_finish (GAsyncResult* _res_, GError** error);
static GcaBackend* gca_backend_new (const gchar* name, GcaDBusService* service, GcaDBusProject* project, GcaRemoteServices services);
static GcaBackend* gca_backend_construct (GType object_type, const gchar* name, GcaDBusService* service, GcaDBusProject* project, GcaRemoteServices services);
static void gca_backend_get_remote_services_data_free (gpointer _data);
static gboolean gca_backend_get_remote_services_co (GcaBackendGetRemoteServicesData* _data_);
static void gca_backend_get_remote_services_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType gca_dbus_introspectable_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_introspectable_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_introspectable_get_type (void) G_GNUC_CONST;
void gca_dbus_introspectable_Introspect (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* gca_dbus_introspectable_Introspect_finish (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error);
GcaRemoteServices gca_remote_services_parse (const gchar* s);
static void gca_backend_get_project_data_free (gpointer _data);
static gboolean gca_backend_get_project_co (GcaBackendGetProjectData* _data_);
static void gca_backend_get_project_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean gca_backend_supports (GcaBackend* self, GcaRemoteServices services);
void gca_backend_register (GcaBackend* self, GcaView* view);
GType gca_document_get_type (void) G_GNUC_CONST;
GcaDocument* gca_view_get_document (GcaView* self);
gchar* gca_document_get_path (GcaDocument* self);
static void gca_backend_on_view_changed (GcaBackend* self, GcaView* view);
static void _gca_backend_on_view_changed_gca_view_changed (GcaView* _sender, gpointer self);
static void gca_backend_on_view_path_changed (GcaBackend* self, GcaView* view, const gchar* prevpath);
static void _gca_backend_on_view_path_changed_gca_view_path_changed (GcaView* _sender, const gchar* prevpath, gpointer self);
static void gca_backend_dispose (GcaBackend* self, const gchar* path);
void gca_dbus_service_dispose (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gca_dbus_service_dispose_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error);
static void __lambda6_ (GcaBackend* self, GObject* obj, GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void gca_backend_unregister (GcaBackend* self, GcaView* view);
static void gca_backend_unsaved_document_data_free (gpointer _data);
static void gca_backend_unsaved_document (GcaBackend* self, GcaView* v, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* gca_backend_unsaved_document_finish (GcaBackend* self, GAsyncResult* _res_);
static gboolean gca_backend_unsaved_document_co (GcaBackendUnsavedDocumentData* _data_);
gboolean gca_document_get_is_modified (GcaDocument* self);
void gca_document_unsaved_data_path (GcaDocument* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* gca_document_unsaved_data_path_finish (GcaDocument* self, GAsyncResult* _res_, GError** error);
static void gca_backend_unsaved_document_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void gca_log_debug (const gchar* format, ...);
static void _vala_GcaDBusOpenDocument_array_free (GcaDBusOpenDocument* array, gint array_length);
static void gca_backend_open_documents_data_free (gpointer _data);
static void gca_backend_open_documents (GcaBackend* self, GcaView* primary, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GcaDBusOpenDocument* gca_backend_open_documents_finish (GcaBackend* self, GAsyncResult* _res_, int* result_length1);
static gboolean gca_backend_open_documents_co (GcaBackendOpenDocumentsData* _data_);
static void gca_backend_open_documents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add1 (GcaDBusOpenDocument** array, int* length, int* size, const GcaDBusOpenDocument* value);
static void gca_backend_parse_single (GcaBackend* self, GcaView* view);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda4_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
void gca_document_get_cursor (GcaDocument* self, GcaSourceLocation* result);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
void gca_dbus_service_parse (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
char* gca_dbus_service_parse_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error);
static void __lambda5_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
gpointer gca_remote_document_ref (gpointer instance);
void gca_remote_document_unref (gpointer instance);
GParamSpec* gca_param_spec_remote_document (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_remote_document (GValue* value, gpointer v_object);
void gca_value_take_remote_document (GValue* value, gpointer v_object);
gpointer gca_value_get_remote_document (const GValue* value);
GType gca_remote_document_get_type (void) G_GNUC_CONST;
void gca_view_update (GcaView* self, GcaRemoteDocument* doc);
GcaRemoteDocument* gca_remote_document_new (const gchar* service, const char* path);
GcaRemoteDocument* gca_remote_document_construct (GType object_type, const gchar* service, const char* path);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gca_backend_parse_project (GcaBackend* self, GcaView* view);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda2_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
void gca_dbus_project_parse_all (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaDBusRemoteDocument* gca_dbus_project_parse_all_finish (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void __lambda3_ (GcaBackend* self, GObject* obj, GAsyncResult* res);
static void _vala_GcaDBusRemoteDocument_array_free (GcaDBusRemoteDocument* array, gint array_length);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gca_backend_parse (GcaBackend* self, GcaView* view);
static void gca_backend_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);


static void gca_backend_create_data_free (gpointer _data) {
	GcaBackendCreateData* _data_;
	_data_ = _data;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->language);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->result);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_slice_free (GcaBackendCreateData, _data_);
#line 515 "gca-backend.c"
}


void gca_backend_create (const gchar* language, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendCreateData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_slice_new0 (GcaBackendCreateData);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gca_backend_create);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_create_data_free);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = language;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->language);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->language = _tmp1_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_create_co (_data_);
#line 539 "gca-backend.c"
}


GcaBackend* gca_backend_create_finish (GAsyncResult* _res_, GError** error) {
	GcaBackend* result;
	GcaBackendCreateData* _data_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return NULL;
#line 550 "gca-backend.c"
	}
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	result = _data_->result;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = NULL;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return result;
#line 560 "gca-backend.c"
}


static void gca_backend_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendCreateData* _data_;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = _user_data_;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_source_object_ = source_object;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_res_ = _res_;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_create_co (_data_);
#line 574 "gca-backend.c"
}


static gboolean gca_backend_create_co (GcaBackendCreateData* _data_) {
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	switch (_data_->_state_) {
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 0:
#line 583 "gca-backend.c"
		goto _state_0;
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 1:
#line 587 "gca-backend.c"
		goto _state_1;
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 2:
#line 591 "gca-backend.c"
		goto _state_2;
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 3:
#line 595 "gca-backend.c"
		goto _state_3;
		default:
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_assert_not_reached ();
#line 600 "gca-backend.c"
	}
	_state_0:
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp0_ = _data_->language;
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp1_ = g_strconcat ("org.gnome.CodeAssist.v1.", _data_->_tmp0_, NULL);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->name = _data_->_tmp1_;
#line 35 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp2_ = _data_->language;
#line 35 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp3_ = g_strconcat ("/org/gnome/CodeAssist/v1/", _data_->_tmp2_, NULL);
#line 35 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->path = _data_->_tmp3_;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp4_ = _data_->name;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp5_ = _data_->path;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_state_ = 1;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_get_project (_data_->_tmp4_, _data_->_tmp5_, gca_backend_create_ready, _data_);
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 625 "gca-backend.c"
	_state_1:
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp6_ = NULL;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp6_ = gca_backend_get_project_finish (_data_->_res_, &_data_->_inner_error_);
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->project = _data_->_tmp6_;
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (_data_->path);
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (_data_->name);
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 647 "gca-backend.c"
		} else {
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 651 "gca-backend.c"
		}
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 657 "gca-backend.c"
	}
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp7_ = _data_->name;
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp8_ = _data_->path;
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_state_ = 2;
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_get_remote_services (_data_->_tmp7_, _data_->_tmp8_, gca_backend_create_ready, _data_);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 669 "gca-backend.c"
	_state_2:
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp9_ = 0;
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp9_ = gca_backend_get_remote_services_finish (_data_->_res_, &_data_->_inner_error_);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->services = _data_->_tmp9_;
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data_->project);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (_data_->path);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (_data_->name);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 693 "gca-backend.c"
		} else {
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 697 "gca-backend.c"
		}
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 703 "gca-backend.c"
	}
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp10_ = _data_->name;
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp11_ = _data_->path;
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_state_ = 3;
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_async_initable_new_async (GCA_DBUS_TYPE_SERVICE_PROXY, 0, NULL, gca_backend_create_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp10_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp11_, "g-interface-name", "org.gnome.CodeAssist.v1.Service", NULL);
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 715 "gca-backend.c"
	_state_3:
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp12_ = NULL;
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp12_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->service = (GcaDBusService*) _data_->_tmp12_;
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data_->project);
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (_data_->path);
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (_data_->name);
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 739 "gca-backend.c"
		} else {
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 743 "gca-backend.c"
		}
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 39 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 749 "gca-backend.c"
	}
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp13_ = _data_->name;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp14_ = _data_->service;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp15_ = _data_->project;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp16_ = _data_->services;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp17_ = gca_backend_new (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = _data_->_tmp17_;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->service);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->project);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->path);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->name);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 775 "gca-backend.c"
	} else {
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 779 "gca-backend.c"
	}
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->service);
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->project);
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->path);
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->name);
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 797 "gca-backend.c"
	} else {
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 801 "gca-backend.c"
	}
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 807 "gca-backend.c"
}


static void gca_backend_get_remote_services_data_free (gpointer _data) {
	GcaBackendGetRemoteServicesData* _data_;
	_data_ = _data;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->name);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->path);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_slice_free (GcaBackendGetRemoteServicesData, _data_);
#line 820 "gca-backend.c"
}


static void gca_backend_get_remote_services (const gchar* name, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendGetRemoteServicesData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_slice_new0 (GcaBackendGetRemoteServicesData);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gca_backend_get_remote_services);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_get_remote_services_data_free);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = name;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->name);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->name = _tmp1_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = path;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->path);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->path = _tmp3_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_get_remote_services_co (_data_);
#line 854 "gca-backend.c"
}


static GcaRemoteServices gca_backend_get_remote_services_finish (GAsyncResult* _res_, GError** error) {
	GcaRemoteServices result;
	GcaBackendGetRemoteServicesData* _data_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return 0;
#line 865 "gca-backend.c"
	}
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	result = _data_->result;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return result;
#line 873 "gca-backend.c"
}


static void gca_backend_get_remote_services_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendGetRemoteServicesData* _data_;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = _user_data_;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_source_object_ = source_object;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_res_ = _res_;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_get_remote_services_co (_data_);
#line 887 "gca-backend.c"
}


static gpointer _g_dbus_interface_info_ref0 (gpointer self) {
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return self ? g_dbus_interface_info_ref (self) : NULL;
#line 894 "gca-backend.c"
}


static gboolean gca_backend_get_remote_services_co (GcaBackendGetRemoteServicesData* _data_) {
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	switch (_data_->_state_) {
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 0:
#line 903 "gca-backend.c"
		goto _state_0;
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 1:
#line 907 "gca-backend.c"
		goto _state_1;
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 2:
#line 911 "gca-backend.c"
		goto _state_2;
		default:
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_assert_not_reached ();
#line 916 "gca-backend.c"
	}
	_state_0:
#line 46 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->ret = 0;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp0_ = _data_->name;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp1_ = _data_->path;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp2_ = g_strconcat (_data_->_tmp1_, "/document", NULL);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_state_ = 1;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_async_initable_new_async (GCA_DBUS_TYPE_INTROSPECTABLE_PROXY, 0, NULL, gca_backend_get_remote_services_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp3_, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 935 "gca-backend.c"
	_state_1:
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp4_ = NULL;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp4_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp5_ = (GcaDBusIntrospectable*) _data_->_tmp4_;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->_tmp3_);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->intro = _data_->_tmp5_;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 957 "gca-backend.c"
		} else {
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 961 "gca-backend.c"
		}
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 967 "gca-backend.c"
	}
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp6_ = _data_->intro;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_state_ = 2;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_dbus_introspectable_Introspect (_data_->_tmp6_, gca_backend_get_remote_services_ready, _data_);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 977 "gca-backend.c"
	_state_2:
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp7_ = NULL;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp7_ = gca_dbus_introspectable_Introspect_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->xml = _data_->_tmp7_;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data_->intro);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 997 "gca-backend.c"
		} else {
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1001 "gca-backend.c"
		}
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 1007 "gca-backend.c"
	}
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp8_ = _data_->xml;
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp9_ = g_dbus_node_info_new_for_xml (_data_->_tmp8_, &_data_->_inner_error_);
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->node = _data_->_tmp9_;
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (_data_->xml);
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data_->intro);
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1029 "gca-backend.c"
		} else {
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1033 "gca-backend.c"
		}
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 51 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 1039 "gca-backend.c"
	}
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp10_ = _data_->node;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp11_ = _data_->_tmp10_->interfaces;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp11__length1 = _vala_array_length (_data_->_tmp10_->interfaces);
#line 1047 "gca-backend.c"
	{
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->iface_collection_length1 = 0;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_iface_collection_size_ = 0;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->iface_collection = _data_->_tmp11_;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->iface_collection_length1 = _data_->_tmp11__length1;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		for (_data_->iface_it = 0; _data_->iface_it < _data_->_tmp11__length1; _data_->iface_it = _data_->iface_it + 1) {
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp12_ = _g_dbus_interface_info_ref0 (_data_->iface_collection[_data_->iface_it]);
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->iface = _data_->_tmp12_;
#line 1063 "gca-backend.c"
			{
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->_tmp13_ = _data_->ret;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->_tmp14_ = _data_->iface;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->_tmp15_ = _data_->_tmp14_->name;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->_tmp16_ = 0;
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->_tmp16_ = gca_remote_services_parse (_data_->_tmp15_);
#line 55 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->ret = _data_->_tmp13_ | _data_->_tmp16_;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_g_dbus_interface_info_unref0 (_data_->iface);
#line 1079 "gca-backend.c"
			}
		}
	}
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = _data_->ret;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_dbus_node_info_unref0 (_data_->node);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->xml);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->intro);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1095 "gca-backend.c"
	} else {
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1099 "gca-backend.c"
	}
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_dbus_node_info_unref0 (_data_->node);
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->xml);
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->intro);
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1115 "gca-backend.c"
	} else {
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1119 "gca-backend.c"
	}
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 1125 "gca-backend.c"
}


static void gca_backend_get_project_data_free (gpointer _data) {
	GcaBackendGetProjectData* _data_;
	_data_ = _data;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->name);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->path);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->result);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_slice_free (GcaBackendGetProjectData, _data_);
#line 1140 "gca-backend.c"
}


static void gca_backend_get_project (const gchar* name, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendGetProjectData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_slice_new0 (GcaBackendGetProjectData);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gca_backend_get_project);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_get_project_data_free);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = name;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->name);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->name = _tmp1_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = path;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->path);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->path = _tmp3_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_get_project_co (_data_);
#line 1174 "gca-backend.c"
}


static GcaDBusProject* gca_backend_get_project_finish (GAsyncResult* _res_, GError** error) {
	GcaDBusProject* result;
	GcaBackendGetProjectData* _data_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return NULL;
#line 1185 "gca-backend.c"
	}
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	result = _data_->result;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = NULL;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return result;
#line 1195 "gca-backend.c"
}


static void gca_backend_get_project_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendGetProjectData* _data_;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = _user_data_;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_source_object_ = source_object;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_res_ = _res_;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_get_project_co (_data_);
#line 1209 "gca-backend.c"
}


static gboolean gca_backend_get_project_co (GcaBackendGetProjectData* _data_) {
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	switch (_data_->_state_) {
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 0:
#line 1218 "gca-backend.c"
		goto _state_0;
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 1:
#line 1222 "gca-backend.c"
		goto _state_1;
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 2:
#line 1226 "gca-backend.c"
		goto _state_2;
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 3:
#line 1230 "gca-backend.c"
		goto _state_3;
		default:
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_assert_not_reached ();
#line 1235 "gca-backend.c"
	}
	_state_0:
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp0_ = _data_->name;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp1_ = _data_->path;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_state_ = 1;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_async_initable_new_async (GCA_DBUS_TYPE_INTROSPECTABLE_PROXY, 0, NULL, gca_backend_get_project_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp1_, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 1248 "gca-backend.c"
	_state_1:
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp2_ = NULL;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp2_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->intro = (GcaDBusIntrospectable*) _data_->_tmp2_;
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1266 "gca-backend.c"
		} else {
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1270 "gca-backend.c"
		}
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 1276 "gca-backend.c"
	}
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp3_ = _data_->intro;
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_state_ = 2;
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_dbus_introspectable_Introspect (_data_->_tmp3_, gca_backend_get_project_ready, _data_);
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 1286 "gca-backend.c"
	_state_2:
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp4_ = NULL;
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp4_ = gca_dbus_introspectable_Introspect_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->xml = _data_->_tmp4_;
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data_->intro);
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1306 "gca-backend.c"
		} else {
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1310 "gca-backend.c"
		}
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 1316 "gca-backend.c"
	}
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp5_ = _data_->xml;
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp6_ = g_dbus_node_info_new_for_xml (_data_->_tmp5_, &_data_->_inner_error_);
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->serviceintro = _data_->_tmp6_;
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_error_free (_data_->_inner_error_);
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (_data_->xml);
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data_->intro);
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_state_ == 0) {
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1338 "gca-backend.c"
		} else {
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1342 "gca-backend.c"
		}
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_object_unref (_data_->_async_result);
#line 66 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 1348 "gca-backend.c"
	}
#line 68 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->project = NULL;
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp7_ = _data_->serviceintro;
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp8_ = NULL;
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp8_ = g_dbus_node_info_lookup_interface (_data_->_tmp7_, "org.gnome.CodeAssist.v1.Project");
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_tmp8_ != NULL) {
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp9_ = _data_->name;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp10_ = _data_->path;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_state_ = 3;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_async_initable_new_async (GCA_DBUS_TYPE_PROJECT_PROXY, 0, NULL, gca_backend_get_project_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp9_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp10_, "g-interface-name", "org.gnome.CodeAssist.v1.Project", NULL);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return FALSE;
#line 1370 "gca-backend.c"
		_state_3:
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp11_ = NULL;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp11_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp12_ = (GcaDBusProject*) _data_->_tmp11_;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_object_unref0 (_data_->project);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_dbus_node_info_unref0 (_data_->serviceintro);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_free0 (_data_->xml);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_object_unref0 (_data_->intro);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			if (_data_->_state_ == 0) {
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1396 "gca-backend.c"
			} else {
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1400 "gca-backend.c"
			}
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_object_unref (_data_->_async_result);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			return FALSE;
#line 1406 "gca-backend.c"
		}
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data_->project);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->project = _data_->_tmp12_;
#line 1412 "gca-backend.c"
	}
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = _data_->project;
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_dbus_node_info_unref0 (_data_->serviceintro);
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->xml);
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->intro);
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1426 "gca-backend.c"
	} else {
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1430 "gca-backend.c"
	}
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 75 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->project);
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_dbus_node_info_unref0 (_data_->serviceintro);
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->xml);
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->intro);
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1448 "gca-backend.c"
	} else {
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1452 "gca-backend.c"
	}
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 1458 "gca-backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 1465 "gca-backend.c"
}


static GcaBackend* gca_backend_construct (GType object_type, const gchar* name, GcaDBusService* service, GcaDBusProject* project, GcaRemoteServices services) {
	GcaBackend * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GcaDBusService* _tmp2_;
	GcaDBusService* _tmp3_;
	GcaDBusProject* _tmp4_;
	GcaDBusProject* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeHashMap* _tmp7_;
	GcaRemoteServices _tmp8_;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_val_if_fail (service != NULL, NULL);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self = (GcaBackend*) g_object_new (object_type, NULL);
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = name;
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (self->priv->d_name);
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self->priv->d_name = _tmp1_;
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = service;
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (self->priv->d_service);
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self->priv->d_service = _tmp3_;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp4_ = project;
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (self->priv->d_project);
#line 82 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self->priv->d_project = _tmp5_;
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp6_ = gee_array_list_new (GCA_TYPE_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (self->priv->d_views);
#line 84 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self->priv->d_views = _tmp6_;
#line 85 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GCA_TYPE_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 85 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (self->priv->d_paths);
#line 85 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self->priv->d_paths = _tmp7_;
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp8_ = services;
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self->priv->d_supported_services = _tmp8_;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return self;
#line 1528 "gca-backend.c"
}


static GcaBackend* gca_backend_new (const gchar* name, GcaDBusService* service, GcaDBusProject* project, GcaRemoteServices services) {
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return gca_backend_construct (GCA_TYPE_BACKEND, name, service, project, services);
#line 1535 "gca-backend.c"
}


gboolean gca_backend_supports (GcaBackend* self, GcaRemoteServices services) {
	gboolean result = FALSE;
	GcaRemoteServices _tmp0_;
	GcaRemoteServices _tmp1_;
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = self->priv->d_supported_services;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = services;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	result = (_tmp0_ & _tmp1_) != 0;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return result;
#line 1553 "gca-backend.c"
}


static void _gca_backend_on_view_changed_gca_view_changed (GcaView* _sender, gpointer self) {
#line 100 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_on_view_changed (self, _sender);
#line 1560 "gca-backend.c"
}


static void _gca_backend_on_view_path_changed_gca_view_path_changed (GcaView* _sender, const gchar* prevpath, gpointer self) {
#line 101 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_on_view_path_changed (self, _sender, prevpath);
#line 1567 "gca-backend.c"
}


void gca_backend_register (GcaBackend* self, GcaView* view) {
	GeeArrayList* _tmp0_;
	GcaView* _tmp1_;
	GeeHashMap* _tmp2_;
	GcaView* _tmp3_;
	GcaDocument* _tmp4_;
	GcaDocument* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GcaView* _tmp9_;
	GcaView* _tmp10_;
	GcaView* _tmp11_;
#line 95 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (view != NULL);
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = self->priv->d_views;
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = view;
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = self->priv->d_paths;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp3_ = view;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp4_ = gca_view_get_document (_tmp3_);
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp5_ = _tmp4_;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp6_ = gca_document_get_path (_tmp5_);
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp7_ = _tmp6_;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp8_ = _tmp7_;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp9_ = view;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp8_, _tmp9_);
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_tmp8_);
#line 100 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp10_ = view;
#line 100 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_signal_connect_object (_tmp10_, "changed", (GCallback) _gca_backend_on_view_changed_gca_view_changed, self, 0);
#line 101 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp11_ = view;
#line 101 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_signal_connect_object (_tmp11_, "path-changed", (GCallback) _gca_backend_on_view_path_changed_gca_view_path_changed, self, 0);
#line 1622 "gca-backend.c"
}


static void __lambda6_ (GcaBackend* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 106 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (res != NULL);
#line 1630 "gca-backend.c"
	{
		GcaDBusService* _tmp0_;
		GAsyncResult* _tmp1_;
#line 109 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp0_ = self->priv->d_service;
#line 109 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp1_ = res;
#line 109 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		gca_dbus_service_dispose_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 109 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_inner_error_ != NULL) {
#line 1642 "gca-backend.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
#line 107 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_clear_error (&_inner_error_);
#line 107 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_inner_error_ = NULL;
#line 1653 "gca-backend.c"
	}
	__finally6:
#line 107 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_inner_error_ != NULL) {
#line 107 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_clear_error (&_inner_error_);
#line 107 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return;
#line 1664 "gca-backend.c"
	}
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 106 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	__lambda6_ (self, source_object, res);
#line 106 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (self);
#line 1674 "gca-backend.c"
}


static void gca_backend_dispose (GcaBackend* self, const gchar* path) {
	GcaDBusService* _tmp0_;
	const gchar* _tmp1_;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (path != NULL);
#line 106 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = self->priv->d_service;
#line 106 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = path;
#line 106 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_dbus_service_dispose (_tmp0_, _tmp1_, ___lambda6__gasync_ready_callback, g_object_ref (self));
#line 1691 "gca-backend.c"
}


void gca_backend_unregister (GcaBackend* self, GcaView* view) {
	GcaView* _tmp0_;
	GcaDocument* _tmp1_;
	GcaDocument* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GcaView* _tmp6_;
	guint _tmp7_ = 0U;
	GcaView* _tmp8_;
	guint _tmp9_ = 0U;
	GeeArrayList* _tmp10_;
	GcaView* _tmp11_;
	GeeHashMap* _tmp12_;
	GcaView* _tmp13_;
	GcaDocument* _tmp14_;
	GcaDocument* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
#line 114 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (view != NULL);
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = view;
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = gca_view_get_document (_tmp0_);
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = _tmp1_;
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp3_ = gca_document_get_path (_tmp2_);
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp4_ = _tmp3_;
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp5_ = _tmp4_;
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_dispose (self, _tmp5_);
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_tmp5_);
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp6_ = view;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_signal_parse_name ("changed", GCA_TYPE_VIEW, &_tmp7_, NULL, FALSE);
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gca_backend_on_view_changed_gca_view_changed, self);
#line 119 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp8_ = view;
#line 119 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_signal_parse_name ("path-changed", GCA_TYPE_VIEW, &_tmp9_, NULL, FALSE);
#line 119 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _gca_backend_on_view_path_changed_gca_view_path_changed, self);
#line 121 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp10_ = self->priv->d_views;
#line 121 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp11_ = view;
#line 121 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp10_, _tmp11_);
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp12_ = self->priv->d_paths;
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp13_ = view;
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp14_ = gca_view_get_document (_tmp13_);
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp15_ = _tmp14_;
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp16_ = gca_document_get_path (_tmp15_);
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp17_ = _tmp16_;
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp18_ = _tmp17_;
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, _tmp18_, NULL);
#line 122 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_tmp18_);
#line 1771 "gca-backend.c"
}


static void gca_backend_on_view_path_changed (GcaBackend* self, GcaView* view, const gchar* prevpath) {
	const gchar* _tmp0_;
	GeeHashMap* _tmp4_;
	GcaView* _tmp5_;
	GcaDocument* _tmp6_;
	GcaDocument* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GcaView* _tmp11_;
#line 125 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (self != NULL);
#line 125 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (view != NULL);
#line 127 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = prevpath;
#line 127 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_tmp0_ != NULL) {
#line 1793 "gca-backend.c"
		GeeHashMap* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
#line 129 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp1_ = self->priv->d_paths;
#line 129 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp2_ = prevpath;
#line 129 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp2_, NULL);
#line 130 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp3_ = prevpath;
#line 130 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		gca_backend_dispose (self, _tmp3_);
#line 1807 "gca-backend.c"
	}
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp4_ = self->priv->d_paths;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp5_ = view;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp6_ = gca_view_get_document (_tmp5_);
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp7_ = _tmp6_;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp8_ = gca_document_get_path (_tmp7_);
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp9_ = _tmp8_;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp10_ = _tmp9_;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp11_ = view;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp10_, _tmp11_);
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_tmp10_);
#line 1829 "gca-backend.c"
}


static void gca_backend_unsaved_document_data_free (gpointer _data) {
	GcaBackendUnsavedDocumentData* _data_;
	_data_ = _data;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->v);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (_data_->result);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_slice_free (GcaBackendUnsavedDocumentData, _data_);
#line 1844 "gca-backend.c"
}


static void gca_backend_unsaved_document (GcaBackend* self, GcaView* v, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendUnsavedDocumentData* _data_;
	GcaBackend* _tmp0_;
	GcaView* _tmp1_;
	GcaView* _tmp2_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_slice_new0 (GcaBackendUnsavedDocumentData);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gca_backend_unsaved_document);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_unsaved_document_data_free);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->self = _tmp0_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = v;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->v);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->v = _tmp2_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_unsaved_document_co (_data_);
#line 1873 "gca-backend.c"
}


static gchar* gca_backend_unsaved_document_finish (GcaBackend* self, GAsyncResult* _res_) {
	gchar* result;
	GcaBackendUnsavedDocumentData* _data_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	result = _data_->result;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = NULL;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return result;
#line 1888 "gca-backend.c"
}


static void gca_backend_unsaved_document_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendUnsavedDocumentData* _data_;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = _user_data_;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_source_object_ = source_object;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_res_ = _res_;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_unsaved_document_co (_data_);
#line 1902 "gca-backend.c"
}


static gboolean gca_backend_unsaved_document_co (GcaBackendUnsavedDocumentData* _data_) {
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	switch (_data_->_state_) {
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 0:
#line 1911 "gca-backend.c"
		goto _state_0;
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 1:
#line 1915 "gca-backend.c"
		goto _state_1;
		default:
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_assert_not_reached ();
#line 1920 "gca-backend.c"
	}
	_state_0:
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp0_ = _data_->v;
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp1_ = gca_view_get_document (_data_->_tmp0_);
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->doc = _data_->_tmp3_;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp4_ = _data_->doc;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp5_ = gca_document_get_is_modified (_data_->_tmp4_);
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_tmp6_) {
#line 1941 "gca-backend.c"
		{
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp7_ = _data_->doc;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_state_ = 1;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			gca_document_unsaved_data_path (_data_->_tmp7_, gca_backend_unsaved_document_ready, _data_);
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			return FALSE;
#line 1951 "gca-backend.c"
			_state_1:
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp8_ = NULL;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp8_ = gca_document_unsaved_data_path_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			if (_data_->_inner_error_ != NULL) {
#line 1961 "gca-backend.c"
				goto __catch7_g_error;
			}
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->result = _data_->_tmp9_;
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_object_unref0 (_data_->doc);
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			if (_data_->_state_ == 0) {
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1972 "gca-backend.c"
			} else {
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1976 "gca-backend.c"
			}
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_object_unref (_data_->_async_result);
#line 144 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			return FALSE;
#line 1982 "gca-backend.c"
		}
		goto __finally7;
		__catch7_g_error:
		{
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->e = _data_->_inner_error_;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_inner_error_ = NULL;
#line 148 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp10_ = _data_->e;
#line 148 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp11_ = _data_->_tmp10_->message;
#line 148 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			gca_log_debug ("gca-backend.vala:148: Failed to get unsaved document: %s", _data_->_tmp11_);
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_error_free0 (_data_->e);
#line 1999 "gca-backend.c"
		}
		__finally7:
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_object_unref0 (_data_->doc);
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			return FALSE;
#line 2012 "gca-backend.c"
		}
	}
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = NULL;
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->doc);
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2023 "gca-backend.c"
	} else {
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2027 "gca-backend.c"
	}
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 152 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->doc);
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2039 "gca-backend.c"
	} else {
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2043 "gca-backend.c"
	}
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 2049 "gca-backend.c"
}


static void _vala_GcaDBusOpenDocument_array_free (GcaDBusOpenDocument* array, gint array_length) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (array != NULL) {
#line 2056 "gca-backend.c"
		int i;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			gca_dbus_open_document_destroy (&array[i]);
#line 2062 "gca-backend.c"
		}
	}
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_free (array);
#line 2067 "gca-backend.c"
}


static void gca_backend_open_documents_data_free (gpointer _data) {
	GcaBackendOpenDocumentsData* _data_;
	_data_ = _data;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->primary);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = (_vala_GcaDBusOpenDocument_array_free (_data_->result, _data_->result_length1), NULL);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_slice_free (GcaBackendOpenDocumentsData, _data_);
#line 2082 "gca-backend.c"
}


static void gca_backend_open_documents (GcaBackend* self, GcaView* primary, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendOpenDocumentsData* _data_;
	GcaBackend* _tmp0_;
	GcaView* _tmp1_;
	GcaView* _tmp2_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_slice_new0 (GcaBackendOpenDocumentsData);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gca_backend_open_documents);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_open_documents_data_free);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->self = _tmp0_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = primary;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data_->primary);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->primary = _tmp2_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_open_documents_co (_data_);
#line 2111 "gca-backend.c"
}


static GcaDBusOpenDocument* gca_backend_open_documents_finish (GcaBackend* self, GAsyncResult* _res_, int* result_length1) {
	GcaDBusOpenDocument* result;
	GcaBackendOpenDocumentsData* _data_;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	result = _data_->result;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	*result_length1 = _data_->result_length1;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = NULL;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return result;
#line 2128 "gca-backend.c"
}


static void gca_backend_open_documents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendOpenDocumentsData* _data_;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_ = _user_data_;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_source_object_ = source_object;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_res_ = _res_;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_open_documents_co (_data_);
#line 2142 "gca-backend.c"
}


static void _vala_array_add1 (GcaDBusOpenDocument** array, int* length, int* size, const GcaDBusOpenDocument* value) {
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if ((*length) == (*size)) {
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		*array = g_renew (GcaDBusOpenDocument, *array, *size);
#line 2153 "gca-backend.c"
	}
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	(*array)[(*length)++] = *value;
#line 2157 "gca-backend.c"
}


static gboolean gca_backend_open_documents_co (GcaBackendOpenDocumentsData* _data_) {
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	switch (_data_->_state_) {
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 0:
#line 2166 "gca-backend.c"
		goto _state_0;
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		case 1:
#line 2170 "gca-backend.c"
		goto _state_1;
		default:
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_assert_not_reached ();
#line 2175 "gca-backend.c"
	}
	_state_0:
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->d_views;
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp0_);
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp3_ = NULL;
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp3_ = g_new0 (GcaDBusOpenDocument, _data_->_tmp2_);
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->ret = _data_->_tmp3_;
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->ret_length1 = _data_->_tmp2_;
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_ret_size_ = _data_->ret_length1;
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->ret_length1 = 0;
#line 158 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp4_ = _data_->ret_length1;
#line 2198 "gca-backend.c"
	{
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp5_ = _data_->self->priv->d_views;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_v_list = _data_->_tmp6_;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp7_ = _data_->_v_list;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp7_);
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_v_size = _data_->_tmp9_;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_data_->_v_index = -1;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		while (TRUE) {
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp10_ = _data_->_v_index;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_v_index = _data_->_tmp10_ + 1;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp11_ = _data_->_v_index;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp12_ = _data_->_v_size;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			if (!(_data_->_tmp11_ < _data_->_tmp12_)) {
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				break;
#line 2230 "gca-backend.c"
			}
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp13_ = _data_->_v_list;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp14_ = _data_->_v_index;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp15_ = NULL;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp13_, _data_->_tmp14_);
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->v = (GcaView*) _data_->_tmp15_;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp16_ = _data_->v;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_state_ = 1;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			gca_backend_unsaved_document (_data_->self, _data_->_tmp16_, gca_backend_open_documents_ready, _data_);
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			return FALSE;
#line 2250 "gca-backend.c"
			_state_1:
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp17_ = NULL;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp17_ = gca_backend_unsaved_document_finish (_data_->self, _data_->_res_);
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->dp = _data_->_tmp17_;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp19_ = _data_->dp;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			if (_data_->_tmp19_ == NULL) {
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->_tmp18_ = "";
#line 2264 "gca-backend.c"
			} else {
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->_tmp20_ = _data_->dp;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_data_->_tmp18_ = _data_->_tmp20_;
#line 2270 "gca-backend.c"
			}
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp21_ = _data_->ret;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp21__length1 = _data_->ret_length1;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp22_ = _data_->v;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp23_ = gca_view_get_document (_data_->_tmp22_);
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp24_ = _data_->_tmp23_;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp25_ = gca_document_get_path (_data_->_tmp24_);
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp26_ = _data_->_tmp25_;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp27_ = _data_->_tmp18_;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp28_ = g_strdup (_data_->_tmp27_);
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			memset (&_data_->_tmp29_, 0, sizeof (GcaDBusOpenDocument));
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			memset (&_data_->_tmp29_, 0, sizeof (GcaDBusOpenDocument));
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_free0 (_data_->_tmp29_.path);
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp29_.path = _data_->_tmp26_;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_free0 (_data_->_tmp29_.data_path);
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_data_->_tmp29_.data_path = _data_->_tmp28_;
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_vala_array_add1 (&_data_->ret, &_data_->ret_length1, &_data_->_ret_size_, &_data_->_tmp29_);
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_free0 (_data_->dp);
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			_g_object_unref0 (_data_->v);
#line 2308 "gca-backend.c"
		}
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data_->_v_list);
#line 2312 "gca-backend.c"
	}
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp30_ = _data_->ret;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->_tmp30__length1 = _data_->ret_length1;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result_length1 = _data_->_tmp30__length1;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->result = _data_->_tmp30_;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2326 "gca-backend.c"
	} else {
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2330 "gca-backend.c"
	}
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data_->ret = (_vala_GcaDBusOpenDocument_array_free (_data_->ret, _data_->ret_length1), NULL);
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_data_->_state_ == 0) {
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2342 "gca-backend.c"
	} else {
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2346 "gca-backend.c"
	}
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (_data_->_async_result);
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return FALSE;
#line 2352 "gca-backend.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return _data2_;
#line 2361 "gca-backend.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2370 "gca-backend.c"
		GcaBackend * self;
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		self = _data2_->self;
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data2_->view);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (self);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 2380 "gca-backend.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 180 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	var = (g_free (var), NULL);
#line 2388 "gca-backend.c"
}


static void _g_variant_unref0_ (gpointer var) {
#line 180 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
#line 2395 "gca-backend.c"
}


static void __lambda5_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	GcaBackend * self;
	char* ret = NULL;
	GcaView* _tmp6_;
	const gchar* _tmp7_;
	const char* _tmp8_;
	GcaRemoteDocument* _tmp9_;
	GcaRemoteDocument* _tmp10_;
	GError * _inner_error_ = NULL;
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self = _data2_->self;
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (res != NULL);
#line 2412 "gca-backend.c"
	{
		GcaDBusService* _tmp0_;
		GAsyncResult* _tmp1_;
		char* _tmp2_ = NULL;
		char* _tmp3_;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp0_ = self->priv->d_service;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp1_ = res;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp2_ = gca_dbus_service_parse_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp3_ = _tmp2_;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_inner_error_ != NULL) {
#line 2428 "gca-backend.c"
			goto __catch8_g_error;
		}
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (ret);
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		ret = _tmp3_;
#line 2435 "gca-backend.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		e = _inner_error_;
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_inner_error_ = NULL;
#line 201 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp4_ = e;
#line 201 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp5_ = _tmp4_->message;
#line 201 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		gca_log_debug ("gca-backend.vala:201: Failed to parse: %s", _tmp5_);
#line 202 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_error_free0 (e);
#line 202 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (ret);
#line 202 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return;
#line 2459 "gca-backend.c"
	}
	__finally8:
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_inner_error_ != NULL) {
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (ret);
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_clear_error (&_inner_error_);
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return;
#line 2472 "gca-backend.c"
	}
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp6_ = _data2_->view;
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp7_ = self->priv->d_name;
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp8_ = ret;
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp9_ = gca_remote_document_new (_tmp7_, _tmp8_);
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp10_ = _tmp9_;
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_view_update (_tmp6_, _tmp10_);
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_gca_remote_document_unref0 (_tmp10_);
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (ret);
#line 2490 "gca-backend.c"
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	__lambda5_ (self, source_object, res);
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	block2_data_unref (self);
#line 2499 "gca-backend.c"
}


static void __lambda4_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	GcaBackend * self;
	GAsyncResult* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* data_path;
	GcaView* _tmp2_;
	GcaDocument* _tmp3_;
	GcaDocument* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* path;
	GcaView* _tmp7_;
	GcaDocument* _tmp8_;
	GcaDocument* _tmp9_;
	GcaSourceLocation _tmp10_;
	GcaSourceLocation _tmp11_;
	GcaSourceLocation cursor;
	GHashFunc _tmp12_;
	GEqualFunc _tmp13_;
	GHashTable* _tmp14_;
	GHashTable* options;
	const gchar* _tmp15_;
	GcaSourceLocation _tmp18_;
	gint _tmp19_;
	GcaSourceLocation _tmp20_;
	gint _tmp21_;
	GcaDBusSourceLocation _tmp22_ = {0};
	GcaDBusSourceLocation dbuscurs;
	GcaDBusService* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GcaDBusSourceLocation _tmp26_;
	GHashTable* _tmp27_;
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self = _data2_->self;
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (res != NULL);
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = res;
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = gca_backend_unsaved_document_finish (self, _tmp0_);
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	data_path = _tmp1_;
#line 177 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = _data2_->view;
#line 177 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp3_ = gca_view_get_document (_tmp2_);
#line 177 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp4_ = _tmp3_;
#line 177 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp5_ = gca_document_get_path (_tmp4_);
#line 177 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp6_ = _tmp5_;
#line 177 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	path = _tmp6_;
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp7_ = _data2_->view;
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp8_ = gca_view_get_document (_tmp7_);
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp9_ = _tmp8_;
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_document_get_cursor (_tmp9_, &_tmp10_);
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp11_ = _tmp10_;
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	cursor = _tmp11_;
#line 180 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp12_ = g_str_hash;
#line 180 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp13_ = g_str_equal;
#line 180 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp14_ = g_hash_table_new_full (_tmp12_, _tmp13_, _g_free0_, _g_variant_unref0_);
#line 180 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	options = _tmp14_;
#line 182 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp15_ = data_path;
#line 182 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_tmp15_ == NULL) {
#line 2582 "gca-backend.c"
		const gchar* _tmp16_;
		gchar* _tmp17_;
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp16_ = path;
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_free0 (data_path);
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		data_path = _tmp17_;
#line 2593 "gca-backend.c"
	}
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp18_ = cursor;
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp19_ = _tmp18_.line;
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp20_ = cursor;
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp21_ = _tmp20_.column;
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	memset (&_tmp22_, 0, sizeof (GcaDBusSourceLocation));
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp22_.line = (gint64) _tmp19_;
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp22_.column = (gint64) _tmp21_;
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	dbuscurs = _tmp22_;
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp23_ = self->priv->d_service;
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp24_ = path;
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp25_ = data_path;
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp26_ = dbuscurs;
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp27_ = options;
#line 192 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_dbus_service_parse (_tmp23_, _tmp24_, _tmp25_, &_tmp26_, _tmp27_, ___lambda5__gasync_ready_callback, block2_data_ref (_data2_));
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_hash_table_unref0 (options);
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (path);
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (data_path);
#line 2629 "gca-backend.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	__lambda4_ (self, source_object, res);
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	block2_data_unref (self);
#line 2638 "gca-backend.c"
}


static void gca_backend_parse_single (GcaBackend* self, GcaView* view) {
	Block2Data* _data2_;
	GcaView* _tmp0_;
	GcaView* _tmp1_;
	GcaView* _tmp2_;
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (view != NULL);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data2_->_ref_count_ = 1;
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data2_->self = g_object_ref (self);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = view;
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data2_->view);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data2_->view = _tmp1_;
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = _data2_->view;
#line 175 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_unsaved_document (self, _tmp2_, ___lambda4__gasync_ready_callback, block2_data_ref (_data2_));
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	block2_data_unref (_data2_);
#line 173 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data2_ = NULL;
#line 2673 "gca-backend.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	return _data3_;
#line 2682 "gca-backend.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2691 "gca-backend.c"
		GcaBackend * self;
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		self = _data3_->self;
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (_data3_->view);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_object_unref0 (self);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_slice_free (Block3Data, _data3_);
#line 2701 "gca-backend.c"
	}
}


static void _vala_GcaDBusRemoteDocument_array_free (GcaDBusRemoteDocument* array, gint array_length) {
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (array != NULL) {
#line 2709 "gca-backend.c"
		int i;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			gca_dbus_remote_document_destroy (&array[i]);
#line 2715 "gca-backend.c"
		}
	}
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_free (array);
#line 2720 "gca-backend.c"
}


static void __lambda3_ (GcaBackend* self, GObject* obj, GAsyncResult* res) {
	GcaDBusRemoteDocument* ret = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GcaDBusRemoteDocument* _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (res != NULL);
#line 2733 "gca-backend.c"
	{
		GcaDBusProject* _tmp0_;
		GAsyncResult* _tmp1_;
		gint _tmp2_ = 0;
		GcaDBusRemoteDocument* _tmp3_ = NULL;
		GcaDBusRemoteDocument* _tmp4_;
		gint _tmp4__length1;
		gint __tmp4__size_;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp0_ = self->priv->d_project;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp1_ = res;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp3_ = gca_dbus_project_parse_all_finish (_tmp0_, _tmp1_, &_tmp2_, &_inner_error_);
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp4_ = _tmp3_;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp4__length1 = _tmp2_;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		__tmp4__size_ = _tmp4__length1;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		if (_inner_error_ != NULL) {
#line 2756 "gca-backend.c"
			goto __catch9_g_error;
		}
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		ret = (_vala_GcaDBusRemoteDocument_array_free (ret, ret_length1), NULL);
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		ret = _tmp4_;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		ret_length1 = _tmp4__length1;
#line 230 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_ret_size_ = ret_length1;
#line 2767 "gca-backend.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		e = _inner_error_;
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_inner_error_ = NULL;
#line 234 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp5_ = e;
#line 234 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp6_ = _tmp5_->message;
#line 234 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		gca_log_debug ("gca-backend.vala:234: Failed to parse: %s", _tmp6_);
#line 235 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_g_error_free0 (e);
#line 235 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		ret = (_vala_GcaDBusRemoteDocument_array_free (ret, ret_length1), NULL);
#line 235 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return;
#line 2791 "gca-backend.c"
	}
	__finally9:
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_inner_error_ != NULL) {
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		ret = (_vala_GcaDBusRemoteDocument_array_free (ret, ret_length1), NULL);
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		g_clear_error (&_inner_error_);
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		return;
#line 2804 "gca-backend.c"
	}
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp7_ = ret;
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp7__length1 = ret_length1;
#line 2810 "gca-backend.c"
	{
		GcaDBusRemoteDocument* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		d_collection = _tmp7_;
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		d_collection_length1 = _tmp7__length1;
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		for (d_it = 0; d_it < _tmp7__length1; d_it = d_it + 1) {
#line 2822 "gca-backend.c"
			GcaDBusRemoteDocument _tmp8_ = {0};
			GcaDBusRemoteDocument d = {0};
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			gca_dbus_remote_document_copy (&d_collection[d_it], &_tmp8_);
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
			d = _tmp8_;
#line 2829 "gca-backend.c"
			{
				GeeHashMap* _tmp9_;
				GcaDBusRemoteDocument _tmp10_;
				const gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_tmp9_ = self->priv->d_paths;
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_tmp10_ = d;
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_tmp11_ = _tmp10_.path;
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				_tmp12_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp11_);
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				if (_tmp12_) {
#line 2845 "gca-backend.c"
					GeeHashMap* _tmp13_;
					GcaDBusRemoteDocument _tmp14_;
					const gchar* _tmp15_;
					gpointer _tmp16_ = NULL;
					GcaView* vw;
					GcaView* _tmp17_;
					const gchar* _tmp18_;
					GcaDBusRemoteDocument _tmp19_;
					const char* _tmp20_;
					GcaRemoteDocument* _tmp21_;
					GcaRemoteDocument* _tmp22_;
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp13_ = self->priv->d_paths;
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp14_ = d;
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp15_ = _tmp14_.path;
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp15_);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					vw = (GcaView*) _tmp16_;
#line 243 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp17_ = vw;
#line 243 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp18_ = self->priv->d_name;
#line 243 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp19_ = d;
#line 243 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp20_ = _tmp19_.remote_path;
#line 243 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp21_ = gca_remote_document_new (_tmp18_, _tmp20_);
#line 243 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_tmp22_ = _tmp21_;
#line 243 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					gca_view_update (_tmp17_, _tmp22_);
#line 243 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_gca_remote_document_unref0 (_tmp22_);
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
					_g_object_unref0 (vw);
#line 2885 "gca-backend.c"
				}
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
				gca_dbus_remote_document_destroy (&d);
#line 2889 "gca-backend.c"
			}
		}
	}
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	ret = (_vala_GcaDBusRemoteDocument_array_free (ret, ret_length1), NULL);
#line 2895 "gca-backend.c"
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	__lambda3_ (self, source_object, res);
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_object_unref (self);
#line 2904 "gca-backend.c"
}


static void __lambda2_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	GcaBackend * self;
	GAsyncResult* _tmp0_;
	gint _tmp1_ = 0;
	GcaDBusOpenDocument* _tmp2_ = NULL;
	GcaDBusOpenDocument* docs;
	gint docs_length1;
	gint _docs_size_;
	GcaView* _tmp3_;
	GcaDocument* _tmp4_;
	GcaDocument* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* path;
	GcaView* _tmp8_;
	GcaDocument* _tmp9_;
	GcaDocument* _tmp10_;
	GcaSourceLocation _tmp11_;
	GcaSourceLocation _tmp12_;
	GcaSourceLocation cursor;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GHashTable* _tmp15_;
	GHashTable* options;
	GcaSourceLocation _tmp16_;
	gint _tmp17_;
	GcaSourceLocation _tmp18_;
	gint _tmp19_;
	GcaDBusSourceLocation _tmp20_ = {0};
	GcaDBusSourceLocation dbuscurs;
	GcaDBusProject* _tmp21_;
	GcaDBusSourceLocation _tmp22_;
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self = _data3_->self;
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (res != NULL);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = res;
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = gca_backend_open_documents_finish (self, _tmp0_, &_tmp1_);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	docs = _tmp2_;
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	docs_length1 = _tmp1_;
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_docs_size_ = docs_length1;
#line 215 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp3_ = _data3_->view;
#line 215 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp4_ = gca_view_get_document (_tmp3_);
#line 215 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp5_ = _tmp4_;
#line 215 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp6_ = gca_document_get_path (_tmp5_);
#line 215 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp7_ = _tmp6_;
#line 215 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	path = _tmp7_;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp8_ = _data3_->view;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp9_ = gca_view_get_document (_tmp8_);
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp10_ = _tmp9_;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_document_get_cursor (_tmp10_, &_tmp11_);
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp12_ = _tmp11_;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	cursor = _tmp12_;
#line 218 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp13_ = g_str_hash;
#line 218 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp14_ = g_str_equal;
#line 218 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_variant_unref0_);
#line 218 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	options = _tmp15_;
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp16_ = cursor;
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp17_ = _tmp16_.line;
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp18_ = cursor;
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp19_ = _tmp18_.column;
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	memset (&_tmp20_, 0, sizeof (GcaDBusSourceLocation));
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp20_.line = (gint64) _tmp17_;
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp20_.column = (gint64) _tmp19_;
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	dbuscurs = _tmp20_;
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp21_ = self->priv->d_project;
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp22_ = dbuscurs;
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_dbus_project_parse_all (_tmp21_, path, docs, docs_length1, &_tmp22_, options, ___lambda3__gasync_ready_callback, g_object_ref (self));
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_hash_table_unref0 (options);
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (path);
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	docs = (_vala_GcaDBusOpenDocument_array_free (docs, docs_length1), NULL);
#line 3014 "gca-backend.c"
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	__lambda2_ (self, source_object, res);
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	block3_data_unref (self);
#line 3023 "gca-backend.c"
}


static void gca_backend_parse_project (GcaBackend* self, GcaView* view) {
	Block3Data* _data3_;
	GcaView* _tmp0_;
	GcaView* _tmp1_;
	GcaView* _tmp2_;
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (view != NULL);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data3_->_ref_count_ = 1;
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data3_->self = g_object_ref (self);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = view;
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (_data3_->view);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data3_->view = _tmp1_;
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp2_ = _data3_->view;
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_open_documents (self, _tmp2_, ___lambda2__gasync_ready_callback, block3_data_ref (_data3_));
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	block3_data_unref (_data3_);
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_data3_ = NULL;
#line 3058 "gca-backend.c"
}


static void gca_backend_parse (GcaBackend* self, GcaView* view) {
	GcaDBusProject* _tmp0_;
#line 250 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (self != NULL);
#line 250 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (view != NULL);
#line 252 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = self->priv->d_project;
#line 252 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	if (_tmp0_ != NULL) {
#line 3072 "gca-backend.c"
		GcaView* _tmp1_;
#line 254 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp1_ = view;
#line 254 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		gca_backend_parse_project (self, _tmp1_);
#line 3078 "gca-backend.c"
	} else {
		GcaView* _tmp2_;
#line 258 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		_tmp2_ = view;
#line 258 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
		gca_backend_parse_single (self, _tmp2_);
#line 3085 "gca-backend.c"
	}
}


static void gca_backend_on_view_changed (GcaBackend* self, GcaView* view) {
	GcaView* _tmp0_;
#line 262 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (self != NULL);
#line 262 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_return_if_fail (view != NULL);
#line 264 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_tmp0_ = view;
#line 264 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_parse (self, _tmp0_);
#line 3100 "gca-backend.c"
}


static void gca_backend_class_init (GcaBackendClass * klass) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	gca_backend_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	g_type_class_add_private (klass, sizeof (GcaBackendPrivate));
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = gca_backend_finalize;
#line 3111 "gca-backend.c"
}


static void gca_backend_instance_init (GcaBackend * self) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self->priv = GCA_BACKEND_GET_PRIVATE (self);
#line 3118 "gca-backend.c"
}


static void gca_backend_finalize (GObject* obj) {
	GcaBackend * self;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_BACKEND, GcaBackend);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (self->priv->d_views);
#line 26 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (self->priv->d_paths);
#line 27 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_free0 (self->priv->d_name);
#line 28 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (self->priv->d_service);
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	_g_object_unref0 (self->priv->d_project);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-backend.vala"
	G_OBJECT_CLASS (gca_backend_parent_class)->finalize (obj);
#line 3138 "gca-backend.c"
}


GType gca_backend_get_type (void) {
	static volatile gsize gca_backend_type_id__volatile = 0;
	if (g_once_init_enter (&gca_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaBackend), 0, (GInstanceInitFunc) gca_backend_instance_init, NULL };
		GType gca_backend_type_id;
		gca_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaBackend", &g_define_type_info, 0);
		g_once_init_leave (&gca_backend_type_id__volatile, gca_backend_type_id);
	}
	return gca_backend_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



