/* gcp-view.c generated by valac 0.15.1.31-a6582, the Vala compiler
 * generated from gcp-view.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-document.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksourceview.h>
#include <stdlib.h>
#include <gio/gio.h>


#define GCP_TYPE_VIEW (gcp_view_get_type ())
#define GCP_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_VIEW, GcpView))
#define GCP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_VIEW, GcpViewClass))
#define GCP_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_VIEW))
#define GCP_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_VIEW))
#define GCP_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_VIEW, GcpViewClass))

typedef struct _GcpView GcpView;
typedef struct _GcpViewClass GcpViewClass;
typedef struct _GcpViewPrivate GcpViewPrivate;

#define GCP_TYPE_BACKEND (gcp_backend_get_type ())
#define GCP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_BACKEND, GcpBackend))
#define GCP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_BACKEND, GcpBackendClass))
#define GCP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_BACKEND))
#define GCP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_BACKEND))
#define GCP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_BACKEND, GcpBackendClass))

typedef struct _GcpBackend GcpBackend;
typedef struct _GcpBackendClass GcpBackendClass;

#define GCP_TYPE_DOCUMENT (gcp_document_get_type ())
#define GCP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DOCUMENT, GcpDocument))
#define GCP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DOCUMENT, GcpDocumentClass))
#define GCP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DOCUMENT))
#define GCP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DOCUMENT))
#define GCP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DOCUMENT, GcpDocumentClass))

typedef struct _GcpDocument GcpDocument;
typedef struct _GcpDocumentClass GcpDocumentClass;

#define GCP_TYPE_DIAGNOSTIC_TAGS (gcp_diagnostic_tags_get_type ())
#define GCP_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTags))
#define GCP_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))
#define GCP_IS_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_IS_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_DIAGNOSTIC_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))

typedef struct _GcpDiagnosticTags GcpDiagnosticTags;
typedef struct _GcpDiagnosticTagsClass GcpDiagnosticTagsClass;

#define GCP_TYPE_SCROLLBAR_MARKER (gcp_scrollbar_marker_get_type ())
#define GCP_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarker))
#define GCP_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerClass))
#define GCP_IS_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SCROLLBAR_MARKER))
#define GCP_IS_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SCROLLBAR_MARKER))
#define GCP_SCROLLBAR_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerClass))

typedef struct _GcpScrollbarMarker GcpScrollbarMarker;
typedef struct _GcpScrollbarMarkerClass GcpScrollbarMarkerClass;

#define GCP_TYPE_DIAGNOSTIC (gcp_diagnostic_get_type ())
#define GCP_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnostic))
#define GCP_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))
#define GCP_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC))
#define GCP_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC))
#define GCP_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))

typedef struct _GcpDiagnostic GcpDiagnostic;
typedef struct _GcpDiagnosticClass GcpDiagnosticClass;

#define GCP_TYPE_DIAGNOSTIC_MESSAGE (gcp_diagnostic_message_get_type ())
#define GCP_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessage))
#define GCP_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessageClass))
#define GCP_IS_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE))
#define GCP_IS_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_MESSAGE))
#define GCP_DIAGNOSTIC_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessageClass))

typedef struct _GcpDiagnosticMessage GcpDiagnosticMessage;
typedef struct _GcpDiagnosticMessageClass GcpDiagnosticMessageClass;

#define GCP_TYPE_SEMANTIC_VALUE (gcp_semantic_value_get_type ())
#define GCP_SEMANTIC_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValue))
#define GCP_SEMANTIC_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValueClass))
#define GCP_IS_SEMANTIC_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SEMANTIC_VALUE))
#define GCP_IS_SEMANTIC_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SEMANTIC_VALUE))
#define GCP_SEMANTIC_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValueClass))

typedef struct _GcpSemanticValue GcpSemanticValue;
typedef struct _GcpSemanticValueClass GcpSemanticValueClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gcp_diagnostic_tags_unref0(var) ((var == NULL) ? NULL : (var = (gcp_diagnostic_tags_unref (var), NULL)))
#define _gcp_scrollbar_marker_unref0(var) ((var == NULL) ? NULL : (var = (gcp_scrollbar_marker_unref (var), NULL)))

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCP_TYPE_BACKEND_MANAGER (gcp_backend_manager_get_type ())
#define GCP_BACKEND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_BACKEND_MANAGER, GcpBackendManager))
#define GCP_BACKEND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_BACKEND_MANAGER, GcpBackendManagerClass))
#define GCP_IS_BACKEND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_BACKEND_MANAGER))
#define GCP_IS_BACKEND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_BACKEND_MANAGER))
#define GCP_BACKEND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_BACKEND_MANAGER, GcpBackendManagerClass))

typedef struct _GcpBackendManager GcpBackendManager;
typedef struct _GcpBackendManagerClass GcpBackendManagerClass;

#define GCP_TYPE_DIAGNOSTIC_SUPPORT (gcp_diagnostic_support_get_type ())
#define GCP_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupport))
#define GCP_IS_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT))
#define GCP_DIAGNOSTIC_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupportIface))

typedef struct _GcpDiagnosticSupport GcpDiagnosticSupport;
typedef struct _GcpDiagnosticSupportIface GcpDiagnosticSupportIface;

#define GCP_TYPE_SOURCE_INDEX (gcp_source_index_get_type ())
#define GCP_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndex))
#define GCP_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))
#define GCP_IS_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_INDEX))
#define GCP_IS_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_INDEX))
#define GCP_SOURCE_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))

typedef struct _GcpSourceIndex GcpSourceIndex;
typedef struct _GcpSourceIndexClass GcpSourceIndexClass;

#define GCP_TYPE_SEMANTIC_VALUE_SUPPORT (gcp_semantic_value_support_get_type ())
#define GCP_SEMANTIC_VALUE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT, GcpSemanticValueSupport))
#define GCP_IS_SEMANTIC_VALUE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT))
#define GCP_SEMANTIC_VALUE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT, GcpSemanticValueSupportIface))

typedef struct _GcpSemanticValueSupport GcpSemanticValueSupport;
typedef struct _GcpSemanticValueSupportIface GcpSemanticValueSupportIface;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define GCP_TYPE_DIAGNOSTIC_COLORS (gcp_diagnostic_colors_get_type ())
#define GCP_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColors))
#define GCP_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))
#define GCP_IS_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_IS_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_DIAGNOSTIC_COLORS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))

typedef struct _GcpDiagnosticColors GcpDiagnosticColors;
typedef struct _GcpDiagnosticColorsClass GcpDiagnosticColorsClass;
typedef struct _Block2Data Block2Data;
#define _gcp_diagnostic_colors_unref0(var) ((var == NULL) ? NULL : (var = (gcp_diagnostic_colors_unref (var), NULL)))

#define GCP_SOURCE_INDEX_TYPE_ITERATOR (gcp_source_index_iterator_get_type ())
#define GCP_SOURCE_INDEX_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIterator))
#define GCP_SOURCE_INDEX_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))
#define GCP_SOURCE_INDEX_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))

typedef struct _GcpSourceIndexIterator GcpSourceIndexIterator;
typedef struct _GcpSourceIndexIteratorClass GcpSourceIndexIteratorClass;

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())

#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_SEMANTIC_VALUE_TYPE_KIND (gcp_semantic_value_kind_get_type ())

#define GCP_SEMANTIC_VALUE_TYPE_REFERENCE_TYPE (gcp_semantic_value_reference_type_get_type ())
typedef struct _Block3Data Block3Data;

struct _GcpView {
	GObject parent_instance;
	GcpViewPrivate * priv;
};

struct _GcpViewClass {
	GObjectClass parent_class;
	gboolean (*find_definition) (GcpView* self);
	gboolean (*find_reference) (GcpView* self, gint direction);
};

struct _GcpViewPrivate {
	GeditView* d_view;
	GeditDocument* d_buffer;
	GcpBackend* d_backend;
	GcpDocument* d_document;
	GcpDiagnosticTags* d_tags;
	GcpScrollbarMarker* d_scrollbarMarker;
	GeeHashMap* d_diagnosticsAtEnd;
	GcpDiagnostic** d_cursorDiagnostics;
	gint d_cursorDiagnostics_length1;
	gint _d_cursorDiagnostics_size_;
	GcpDiagnosticMessage* d_cursorDiagnosticMessage;
	GcpSemanticValue* d_semanticValue;
	GtkTextTag* d_semanticTag;
	guint d_lastMergeId;
	GdkRGBA d_refColor;
};

typedef void (*GcpDiagnosticSupportWithDiagnosticsCallback) (GcpSourceIndex* diagnostics, void* user_data);
struct _GcpDiagnosticSupportIface {
	GTypeInterface parent_iface;
	void (*with_diagnostics) (GcpDiagnosticSupport* self, GcpDiagnosticSupportWithDiagnosticsCallback callback, void* callback_target);
	GcpDiagnosticTags* (*get_tags) (GcpDiagnosticSupport* self);
	void (*set_tags) (GcpDiagnosticSupport* self, GcpDiagnosticTags* value);
};

typedef void (*GcpSemanticValueSupportWithSemanticValueCallback) (GcpSourceIndex* diagnostics, void* user_data);
struct _GcpSemanticValueSupportIface {
	GTypeInterface parent_iface;
	void (*with_semantics) (GcpSemanticValueSupport* self, GcpSemanticValueSupportWithSemanticValueCallback callback, void* callback_target);
};

struct _Block2Data {
	int _ref_count_;
	GcpView * self;
	GcpDiagnosticColors* colors;
	GcpDiagnosticColors* mixed;
	guint mid;
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

typedef enum  {
	GCP_SEMANTIC_VALUE_KIND_NONE,
	GCP_SEMANTIC_VALUE_KIND_STRUCT,
	GCP_SEMANTIC_VALUE_KIND_UNION,
	GCP_SEMANTIC_VALUE_KIND_CLASS,
	GCP_SEMANTIC_VALUE_KIND_ENUM,
	GCP_SEMANTIC_VALUE_KIND_FIELD,
	GCP_SEMANTIC_VALUE_KIND_ENUM_VALUE,
	GCP_SEMANTIC_VALUE_KIND_FUNCTION,
	GCP_SEMANTIC_VALUE_KIND_MEMBER_FUNCTION,
	GCP_SEMANTIC_VALUE_KIND_CONSTRUCTOR,
	GCP_SEMANTIC_VALUE_KIND_DESTRUCTOR,
	GCP_SEMANTIC_VALUE_KIND_VARIABLE,
	GCP_SEMANTIC_VALUE_KIND_PARAMETER,
	GCP_SEMANTIC_VALUE_KIND_TYPEDEF,
	GCP_SEMANTIC_VALUE_KIND_NAMESPACE,
	GCP_SEMANTIC_VALUE_KIND_BLOCK
} GcpSemanticValueKind;

typedef enum  {
	GCP_SEMANTIC_VALUE_REFERENCE_TYPE_NONE = 1 << 0,
	GCP_SEMANTIC_VALUE_REFERENCE_TYPE_DECLARATION = 1 << 0,
	GCP_SEMANTIC_VALUE_REFERENCE_TYPE_REFERENCE = 1 << 1,
	GCP_SEMANTIC_VALUE_REFERENCE_TYPE_DEFINITION = 1 << 2
} GcpSemanticValueReferenceType;

struct _Block3Data {
	int _ref_count_;
	GcpView * self;
	GcpSourceLocation* loc;
	GcpSemanticValue* ret;
};


static gpointer gcp_view_parent_class = NULL;
static GtkBindingSet* gcp_view_s_bindingSet;
static GtkBindingSet* gcp_view_s_bindingSet = NULL;
static GType gcp_view_type_id = 0;

GType gcp_view_get_type (void) G_GNUC_CONST;
GType gcp_view_register_type (GTypeModule * module);
GType gcp_backend_get_type (void) G_GNUC_CONST;
GType gcp_backend_register_type (GTypeModule * module);
GType gcp_document_get_type (void) G_GNUC_CONST;
GType gcp_document_register_type (GTypeModule * module);
gpointer gcp_diagnostic_tags_ref (gpointer instance);
void gcp_diagnostic_tags_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_tags (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_tags (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_tags (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_tags (const GValue* value);
GType gcp_diagnostic_tags_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_tags_register_type (GTypeModule * module);
gpointer gcp_scrollbar_marker_ref (gpointer instance);
void gcp_scrollbar_marker_unref (gpointer instance);
GParamSpec* gcp_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_scrollbar_marker (GValue* value, gpointer v_object);
void gcp_value_take_scrollbar_marker (GValue* value, gpointer v_object);
gpointer gcp_value_get_scrollbar_marker (const GValue* value);
GType gcp_scrollbar_marker_get_type (void) G_GNUC_CONST;
GType gcp_scrollbar_marker_register_type (GTypeModule * module);
GType gcp_diagnostic_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_register_type (GTypeModule * module);
GType gcp_diagnostic_message_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_message_register_type (GTypeModule * module);
GType gcp_semantic_value_get_type (void) G_GNUC_CONST;
GType gcp_semantic_value_register_type (GTypeModule * module);
#define GCP_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_VIEW, GcpViewPrivate))
enum  {
	GCP_VIEW_DUMMY_PROPERTY
};
GcpView* gcp_view_new (GeditView* view);
GcpView* gcp_view_construct (GType object_type, GeditView* view);
static void gcp_view_on_notify_buffer (GcpView* self);
static void _gcp_view_on_notify_buffer_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gcp_view_on_view_draw (GcpView* self, cairo_t* ctx);
static gboolean _gcp_view_on_view_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static gboolean gcp_view_on_view_key_press (GcpView* self, GdkEventKey* event);
static gboolean _gcp_view_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
GcpDiagnosticTags* gcp_diagnostic_tags_new (GtkTextView* view);
GcpDiagnosticTags* gcp_diagnostic_tags_construct (GType object_type, GtkTextView* view);
static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self);
static void gcp_view_connect_buffer (GcpView* self, GeditDocument* buffer);
GcpScrollbarMarker* gcp_scrollbar_marker_new (GtkScrollbar* scrollbar);
GcpScrollbarMarker* gcp_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar);
static void gcp_view_scroll_in_view (GcpView* self, GtkTextIter* iter);
static void gcp_view_move_cursor_to_semantic_value (GcpView* self, GcpSemanticValue* val);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
static GcpSourceRange* gcp_view_highlight_range (GcpView* self, GcpSemanticValue* val);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
gboolean gcp_source_location_get_iter (GcpSourceLocation* self, GtkTextBuffer* buffer, GtkTextIter* iter);
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
void gcp_view_deactivate (GcpView* self);
static void gcp_view_disconnect_buffer (GcpView* self);
static void gcp_view_on_notify_language (GcpView* self);
static void _gcp_view_on_notify_language_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gcp_view_on_buffer_changed (GcpView* self);
static void _gcp_view_on_buffer_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void gcp_view_on_buffer_mark_set (GcpView* self, GtkTextIter* location, GtkTextMark* mark);
static void _gcp_view_on_buffer_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void gcp_view_on_notify_style_scheme (GcpView* self);
static void _gcp_view_on_notify_style_scheme_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gcp_view_remove_references (GcpView* self);
static void gcp_view_unregister_backend (GcpView* self);
static void gcp_view_update_semantic_tag (GcpView* self);
static void gcp_view_update_references (GcpView* self);
static void gcp_view_update_backend (GcpView* self);
static void gcp_view_update_diagnostic_message (GcpView* self);
void gcp_scrollbar_marker_set_max_line (GcpScrollbarMarker* self, gint value);
gpointer gcp_backend_manager_ref (gpointer instance);
void gcp_backend_manager_unref (gpointer instance);
GParamSpec* gcp_param_spec_backend_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_backend_manager (GValue* value, gpointer v_object);
void gcp_value_take_backend_manager (GValue* value, gpointer v_object);
gpointer gcp_value_get_backend_manager (const GValue* value);
GType gcp_backend_manager_get_type (void) G_GNUC_CONST;
GType gcp_backend_manager_register_type (GTypeModule * module);
GcpBackendManager* gcp_backend_manager_get_instance (void);
GcpBackend* gcp_backend_manager_get (GcpBackendManager* self, const gchar* language);
static void gcp_view_register_backend (GcpView* self, GcpBackend* backend);
GType gcp_source_index_get_type (void) G_GNUC_CONST;
GType gcp_source_index_register_type (GTypeModule * module);
GType gcp_diagnostic_support_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_support_register_type (GTypeModule * module);
static gboolean gcp_view_on_view_query_tooltip (GcpView* self, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip);
static gboolean _gcp_view_on_view_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip, gpointer self);
static void gcp_view_on_cursor_diagnostics_moved (GcpView* self);
static void _gcp_view_on_cursor_diagnostics_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self);
GType gcp_semantic_value_support_get_type (void) G_GNUC_CONST;
GType gcp_semantic_value_support_register_type (GTypeModule * module);
static void gcp_view_on_cursor_semantics_moved (GcpView* self);
static void _gcp_view_on_cursor_semantics_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self);
void gcp_backend_unregister (GcpBackend* self, GcpDocument* document);
static gchar* gcp_view_format_diagnostics (GcpView* self, GcpDiagnostic** diagnostics, int diagnostics_length1);
gchar* gcp_diagnostic_to_markup (GcpDiagnostic* self, gboolean include_severity);
static gchar* gcp_view_on_diagnostic_tooltip (GcpView* self, GtkSourceMarkAttributes* attributes, GtkSourceMark* mark);
GcpDiagnostic** gcp_diagnostic_support_find_at_line (GcpDiagnosticSupport* self, gint line, int* result_length1);
GcpSourceLocation* gcp_source_location_new_iter (GtkTextIter* iter);
GcpSourceLocation* gcp_source_location_construct_iter (GType object_type, GtkTextIter* iter);
GcpDiagnostic** gcp_diagnostic_support_find_at (GcpDiagnosticSupport* self, GcpSourceLocation* location, int* result_length1);
GcpDocument* gcp_backend_register (GcpBackend* self, GeditDocument* document);
void gcp_diagnostic_support_set_tags (GcpDiagnosticSupport* self, GcpDiagnosticTags* value);
static void gcp_view_on_diagnostic_updated (GcpView* self, GcpDiagnosticSupport* diagnostics);
static void _gcp_view_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated (GcpDiagnosticSupport* _sender, gpointer self);
static gchar* _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup (GtkSourceMarkAttributes* _sender, GtkSourceMark* object, gpointer self);
const gchar* gcp_document_get_error_mark_category (void);
const gchar* gcp_document_get_warning_mark_category (void);
const gchar* gcp_document_get_info_mark_category (void);
static void gcp_view_on_semantics_updated (GcpView* self, GcpSemanticValueSupport* semantics);
static void _gcp_view_on_semantics_updated_gcp_semantic_value_support_semantic_values_updated (GcpSemanticValueSupport* _sender, gpointer self);
static gboolean gcp_view_diagnostic_is_at_end (GcpView* self, GcpSourceLocation* location);
gint gcp_source_location_get_line (GcpSourceLocation* self);
gint gcp_source_location_get_column (GcpSourceLocation* self);
static void gcp_view_add_diagnostic_at_end (GcpView* self, GcpSourceLocation* location, GdkRGBA* color);
void gcp_log_debug (const gchar* format, ...);
gpointer gcp_diagnostic_colors_ref (gpointer instance);
void gcp_diagnostic_colors_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_colors (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_colors (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_colors (const GValue* value);
GType gcp_diagnostic_colors_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_colors_register_type (GTypeModule * module);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
void gcp_scrollbar_marker_clear (GcpScrollbarMarker* self);
GtkScrollbar* gcp_scrollbar_marker_get_scrollbar (GcpScrollbarMarker* self);
GcpDiagnosticColors* gcp_diagnostic_colors_new (GtkStyleContext* context);
GcpDiagnosticColors* gcp_diagnostic_colors_construct (GType object_type, GtkStyleContext* context);
void gcp_diagnostic_colors_mix_in_widget (GcpDiagnosticColors* self, GtkWidget* widget);
guint gcp_scrollbar_marker_new_merge_id (GcpScrollbarMarker* self);
void gcp_diagnostic_support_with_diagnostics (GcpDiagnosticSupport* self, GcpDiagnosticSupportWithDiagnosticsCallback callback, void* callback_target);
static void __lambda20_ (Block2Data* _data2_, GcpSourceIndex* diagnostics);
GType gcp_source_index_iterator_get_type (void) G_GNUC_CONST;
GType gcp_source_index_iterator_register_type (GTypeModule * module);
GcpSourceIndexIterator* gcp_source_index_iterator (GcpSourceIndex* self);
gboolean gcp_source_index_iterator_next (GcpSourceIndexIterator* self);
gpointer gcp_source_index_iterator_get (GcpSourceIndexIterator* self);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
GdkRGBA* gcp_diagnostic_colors_get (GcpDiagnosticColors* self, GcpDiagnosticSeverity severity);
GcpDiagnosticSeverity gcp_diagnostic_get_severity (GcpDiagnostic* self);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
GcpSourceRange** gcp_source_range_support_get_ranges (GcpSourceRangeSupport* self, int* result_length1);
void gcp_scrollbar_marker_add_with_id (GcpScrollbarMarker* self, guint id, GcpSourceRange* range, GdkRGBA* color);
GcpSourceLocation* gcp_diagnostic_get_location (GcpDiagnostic* self);
GcpSourceRange* gcp_source_range_support_get_range (GcpSourceRangeSupport* self);
static void ___lambda20__gcp_diagnostic_support_with_diagnostics_callback (GcpSourceIndex* diagnostics, gpointer self);
static gboolean gcp_view_same_diagnostics (GcpView* self, GcpDiagnostic** first, int first_length1, GcpDiagnostic** second, int second_length1);
GcpDiagnosticMessage* gcp_diagnostic_message_new (GtkSourceView* view, GcpDiagnostic** diagnostics, int diagnostics_length1);
GcpDiagnosticMessage* gcp_diagnostic_message_construct (GType object_type, GtkSourceView* view, GcpDiagnostic** diagnostics, int diagnostics_length1);
static void __lambda18_ (GcpView* self);
static void ___lambda18__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static GcpDiagnostic** _vala_array_dup1 (GcpDiagnostic** self, int length);
GType gcp_semantic_value_kind_get_type (void) G_GNUC_CONST;
GcpSemanticValueKind gcp_semantic_value_get_kind (GcpSemanticValue* self);
GType gcp_semantic_value_reference_type_get_type (void) G_GNUC_CONST;
GcpSemanticValueReferenceType gcp_semantic_value_get_reference_type (GcpSemanticValue* self);
GcpSemanticValue* gcp_semantic_value_find_child (GcpSemanticValue* self, GcpSemanticValueKind kind);
GcpSourceLocation* gcp_source_location_copy (GcpSourceLocation* self);
GFile* gcp_source_location_get_file (GcpSourceLocation* self);
GcpSourceLocation* gcp_source_location_new (GFile* file, gint line, gint column);
GcpSourceLocation* gcp_source_location_construct (GType object_type, GFile* file, gint line, gint column);
GcpSourceRange* gcp_source_range_new (GcpSourceLocation* start, GcpSourceLocation* end);
GcpSourceRange* gcp_source_range_construct (GType object_type, GcpSourceLocation* start, GcpSourceLocation* end);
static void gcp_view_mark_reference (GcpView* self, GcpSemanticValue* val);
gboolean gcp_document_source_range (GcpDocument* self, GcpSourceRange* range, GtkTextIter* start, GtkTextIter* end);
static void gcp_view_mark_references (GcpView* self, GcpSemanticValue** refs, int refs_length1);
void gcp_scrollbar_marker_remove (GcpScrollbarMarker* self, guint id);
static GcpSemanticValue* gcp_view_semantic_value_at_cursor (GcpView* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
void gcp_semantic_value_support_with_semantics (GcpSemanticValueSupport* self, GcpSemanticValueSupportWithSemanticValueCallback callback, void* callback_target);
static void __lambda19_ (Block3Data* _data3_, GcpSourceIndex* semantics);
gpointer gcp_source_index_find_inner_at (GcpSourceIndex* self, GcpSourceLocation* location);
static void ___lambda19__gcp_semantic_value_support_with_semantic_value_callback (GcpSourceIndex* diagnostics, gpointer self);
static GcpSemanticValue** gcp_view_references_at_cursor (GcpView* self, GcpSemanticValue** val, gint* vidx, int* result_length1);
gint gcp_semantic_value_get_num_references (GcpSemanticValue* self);
GcpSemanticValue* gcp_semantic_value_reference (GcpSemanticValue* self, gint idx);
GFile* gcp_document_get_location (GcpDocument* self);
static gint gcp_view_compare_ranges (GcpSemanticValue* a, GcpSemanticValue* b);
gint gcp_source_range_compare_to (GcpSourceRange* self, GcpSourceRange* other);
static gboolean gcp_view_real_find_definition (GcpView* self);
GcpSemanticValue* gcp_semantic_value_get_definition (GcpSemanticValue* self);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static gboolean gcp_view_real_find_reference (GcpView* self, gint direction);
static void g_cclosure_user_marshal_BOOLEAN__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gcp_view_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _gcp_view_on_notify_buffer_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_view_on_notify_buffer (self);
}


static gboolean _gcp_view_on_view_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gcp_view_on_view_draw (self, cr);
	return result;
}


static gboolean _gcp_view_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = gcp_view_on_view_key_press (self, event);
	return result;
}


static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self) {
	GdkRGBA* dup;
	dup = g_new0 (GdkRGBA, 1);
	memcpy (dup, self, sizeof (GdkRGBA));
	return dup;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GcpView* gcp_view_construct (GType object_type, GeditView* view) {
	GcpView * self = NULL;
	GeditView* _tmp0_;
	GeditView* _tmp1_;
	GeditView* _tmp2_;
	GeditView* _tmp3_;
	GeditView* _tmp4_;
	GcpDiagnosticTags* _tmp5_;
	GeeHashMap* _tmp6_;
	GeditView* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GeditView* _tmp10_;
	GtkContainer* _tmp11_;
	GtkContainer* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	GtkScrolledWindow* sw;
	GtkScrolledWindow* _tmp14_;
	g_return_val_if_fail (view != NULL, NULL);
	self = (GcpView*) g_object_new (object_type, NULL);
	_tmp0_ = view;
	self->priv->d_view = _tmp0_;
	_tmp1_ = self->priv->d_view;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::buffer", (GCallback) _gcp_view_on_notify_buffer_g_object_notify, self, 0);
	_tmp2_ = self->priv->d_view;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "draw", (GCallback) _gcp_view_on_view_draw_gtk_widget_draw, self, G_CONNECT_AFTER);
	_tmp3_ = self->priv->d_view;
	g_signal_connect_object ((GtkWidget*) _tmp3_, "key-press-event", (GCallback) _gcp_view_on_view_key_press_gtk_widget_key_press_event, self, 0);
	_tmp4_ = self->priv->d_view;
	_tmp5_ = gcp_diagnostic_tags_new ((GtkTextView*) _tmp4_);
	_gcp_diagnostic_tags_unref0 (self->priv->d_tags);
	self->priv->d_tags = _tmp5_;
	_tmp6_ = gee_hash_map_new (GTK_TYPE_TEXT_MARK, (GBoxedCopyFunc) g_object_ref, g_object_unref, GDK_TYPE_RGBA, (GBoxedCopyFunc) _gdk_rgba_dup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_diagnosticsAtEnd);
	self->priv->d_diagnosticsAtEnd = _tmp6_;
	_tmp7_ = self->priv->d_view;
	_tmp8_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp7_);
	_tmp9_ = _tmp8_;
	gcp_view_connect_buffer (self, GEDIT_IS_DOCUMENT (_tmp9_) ? ((GeditDocument*) _tmp9_) : NULL);
	_tmp10_ = self->priv->d_view;
	_tmp11_ = gtk_widget_get_parent ((GtkWidget*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (GTK_IS_SCROLLED_WINDOW (_tmp12_) ? ((GtkScrolledWindow*) _tmp12_) : NULL);
	sw = _tmp13_;
	_tmp14_ = sw;
	if (_tmp14_ != NULL) {
		GtkScrolledWindow* _tmp15_;
		GtkWidget* _tmp16_ = NULL;
		GcpScrollbarMarker* _tmp17_;
		_tmp15_ = sw;
		_tmp16_ = gtk_scrolled_window_get_vscrollbar (_tmp15_);
		_tmp17_ = gcp_scrollbar_marker_new (GTK_IS_SCROLLBAR (_tmp16_) ? ((GtkScrollbar*) _tmp16_) : NULL);
		_gcp_scrollbar_marker_unref0 (self->priv->d_scrollbarMarker);
		self->priv->d_scrollbarMarker = _tmp17_;
	}
	_g_object_unref0 (sw);
	return self;
}


GcpView* gcp_view_new (GeditView* view) {
	return gcp_view_construct (GCP_TYPE_VIEW, view);
}


static void gcp_view_scroll_in_view (GcpView* self, GtkTextIter* iter) {
	GdkRectangle vrect = {0};
	GdkRectangle irect = {0};
	GeditView* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GeditView* _tmp2_;
	GtkTextIter _tmp3_;
	GdkRectangle _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	GdkRectangle _tmp8_;
	gint _tmp9_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->d_view;
	gtk_text_view_get_visible_rect ((GtkTextView*) _tmp0_, &_tmp1_);
	vrect = _tmp1_;
	_tmp2_ = self->priv->d_view;
	_tmp3_ = *iter;
	gtk_text_view_get_iter_location ((GtkTextView*) _tmp2_, &_tmp3_, &_tmp4_);
	irect = _tmp4_;
	_tmp6_ = irect;
	_tmp7_ = _tmp6_.y;
	_tmp8_ = vrect;
	_tmp9_ = _tmp8_.y;
	if (_tmp7_ < _tmp9_) {
		_tmp5_ = TRUE;
	} else {
		GdkRectangle _tmp10_;
		gint _tmp11_;
		GdkRectangle _tmp12_;
		gint _tmp13_;
		GdkRectangle _tmp14_;
		gint _tmp15_;
		GdkRectangle _tmp16_;
		gint _tmp17_;
		_tmp10_ = irect;
		_tmp11_ = _tmp10_.y;
		_tmp12_ = irect;
		_tmp13_ = _tmp12_.height;
		_tmp14_ = vrect;
		_tmp15_ = _tmp14_.y;
		_tmp16_ = vrect;
		_tmp17_ = _tmp16_.height;
		_tmp5_ = (_tmp11_ + _tmp13_) > (_tmp15_ + _tmp17_);
	}
	_tmp18_ = _tmp5_;
	if (_tmp18_) {
		GeditView* _tmp19_;
		GtkTextIter _tmp20_;
		_tmp19_ = self->priv->d_view;
		_tmp20_ = *iter;
		gtk_text_view_scroll_to_iter ((GtkTextView*) _tmp19_, &_tmp20_, (gdouble) 0, TRUE, (gdouble) 0, 0.5);
	}
}


static void gcp_view_move_cursor_to_semantic_value (GcpView* self, GcpSemanticValue* val) {
	GcpSemanticValue* _tmp0_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcpSemanticValue* _tmp1_;
	GcpSourceRange* _tmp2_ = NULL;
	GcpSourceRange* range;
	GcpSourceRange* _tmp3_;
	GcpSourceLocation* _tmp4_;
	GcpSourceLocation* _tmp5_;
	GeditDocument* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	GcpSourceRange* _tmp9_;
	GcpSourceLocation* _tmp10_;
	GcpSourceLocation* _tmp11_;
	GeditDocument* _tmp12_;
	GtkTextIter _tmp13_ = {0};
	gboolean _tmp14_ = FALSE;
	GeditDocument* _tmp15_;
	GtkTextIter _tmp16_;
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = val;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = val;
	_tmp2_ = gcp_view_highlight_range (self, _tmp1_);
	range = _tmp2_;
	_tmp3_ = range;
	_tmp4_ = gcp_source_range_get_start (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->d_buffer;
	_tmp8_ = gcp_source_location_get_iter (_tmp5_, (GtkTextBuffer*) _tmp6_, &_tmp7_);
	start = _tmp7_;
	if (!_tmp8_) {
		_g_object_unref0 (range);
		return;
	}
	_tmp9_ = range;
	_tmp10_ = gcp_source_range_get_end (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->d_buffer;
	_tmp14_ = gcp_source_location_get_iter (_tmp11_, (GtkTextBuffer*) _tmp12_, &_tmp13_);
	end = _tmp13_;
	if (!_tmp14_) {
		_g_object_unref0 (range);
		return;
	}
	_tmp15_ = self->priv->d_buffer;
	_tmp16_ = start;
	_tmp17_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp15_, &_tmp16_, &_tmp17_);
	_tmp18_ = start;
	gcp_view_scroll_in_view (self, &_tmp18_);
	_g_object_unref0 (range);
}


void gcp_view_deactivate (GcpView* self) {
	GeditView* _tmp0_;
	guint _tmp1_ = 0U;
	GQuark _tmp2_ = 0U;
	GeditView* _tmp3_;
	guint _tmp4_ = 0U;
	GeditView* _tmp5_;
	guint _tmp6_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_view;
	g_signal_parse_name ("notify::buffer", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _gcp_view_on_notify_buffer_g_object_notify, self);
	_tmp3_ = self->priv->d_view;
	g_signal_parse_name ("draw", GTK_TYPE_WIDGET, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _gcp_view_on_view_draw_gtk_widget_draw, self);
	_tmp5_ = self->priv->d_view;
	g_signal_parse_name ("key-press-event", GTK_TYPE_WIDGET, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _gcp_view_on_view_key_press_gtk_widget_key_press_event, self);
	gcp_view_disconnect_buffer (self);
	self->priv->d_view = NULL;
}


static void _gcp_view_on_notify_language_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_view_on_notify_language (self);
}


static void _gcp_view_on_buffer_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	gcp_view_on_buffer_changed (self);
}


static void _gcp_view_on_buffer_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	gcp_view_on_buffer_mark_set (self, location, mark);
}


static void _gcp_view_on_notify_style_scheme_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_view_on_notify_style_scheme (self);
}


static void gcp_view_disconnect_buffer (GcpView* self) {
	GeditDocument* _tmp0_;
	GeditDocument* _tmp1_;
	guint _tmp2_ = 0U;
	GQuark _tmp3_ = 0U;
	GeditDocument* _tmp4_;
	guint _tmp5_ = 0U;
	GeditDocument* _tmp6_;
	guint _tmp7_ = 0U;
	GeditDocument* _tmp8_;
	guint _tmp9_ = 0U;
	GQuark _tmp10_ = 0U;
	GtkTextTag* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_buffer;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->d_buffer;
	g_signal_parse_name ("notify::language", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _gcp_view_on_notify_language_g_object_notify, self);
	_tmp4_ = self->priv->d_buffer;
	g_signal_parse_name ("changed", GTK_TYPE_TEXT_BUFFER, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gcp_view_on_buffer_changed_gtk_text_buffer_changed, self);
	_tmp6_ = self->priv->d_buffer;
	g_signal_parse_name ("mark-set", GTK_TYPE_TEXT_BUFFER, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gcp_view_on_buffer_mark_set_gtk_text_buffer_mark_set, self);
	_tmp8_ = self->priv->d_buffer;
	g_signal_parse_name ("notify::style-scheme", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _gcp_view_on_notify_style_scheme_g_object_notify, self);
	_tmp11_ = self->priv->d_semanticTag;
	if (_tmp11_ != NULL) {
		GeditDocument* _tmp12_;
		GtkTextTagTable* _tmp13_;
		GtkTextTagTable* _tmp14_;
		GtkTextTag* _tmp15_;
		gcp_view_remove_references (self);
		_tmp12_ = self->priv->d_buffer;
		_tmp13_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->priv->d_semanticTag;
		gtk_text_tag_table_remove (_tmp14_, _tmp15_);
		_g_object_unref0 (self->priv->d_semanticValue);
		self->priv->d_semanticValue = NULL;
	}
	gcp_view_unregister_backend (self);
	_g_object_unref0 (self->priv->d_buffer);
	self->priv->d_buffer = NULL;
}


static void gcp_view_update_semantic_tag (GcpView* self) {
	GtkTextTag* _tmp0_;
	GeditDocument* _tmp5_;
	GtkSourceStyleScheme* _tmp6_;
	GtkSourceStyleScheme* _tmp7_;
	GtkSourceStyle* _tmp8_ = NULL;
	GtkSourceStyle* _tmp9_;
	GtkSourceStyle* style;
	GdkColor _tmp10_ = {0};
	GdkColor bg;
	GdkColor _tmp11_ = {0};
	GdkColor fg;
	GtkSourceStyle* _tmp12_;
	GdkColor _tmp53_;
	guint16 _tmp54_;
	GdkColor _tmp55_;
	guint16 _tmp56_;
	GdkColor _tmp57_;
	guint16 _tmp58_;
	GdkRGBA _tmp59_ = {0};
	GeditDocument* _tmp60_;
	GdkColor _tmp61_;
	GdkColor _tmp62_;
	GtkTextTag* _tmp63_ = NULL;
	GtkTextTag* _tmp64_;
	g_return_if_fail (self != NULL);
	gcp_view_remove_references (self);
	_g_object_unref0 (self->priv->d_semanticValue);
	self->priv->d_semanticValue = NULL;
	_tmp0_ = self->priv->d_semanticTag;
	if (_tmp0_ != NULL) {
		GeditDocument* _tmp1_;
		GtkTextTagTable* _tmp2_;
		GtkTextTagTable* _tmp3_;
		GtkTextTag* _tmp4_;
		_tmp1_ = self->priv->d_buffer;
		_tmp2_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->d_semanticTag;
		gtk_text_tag_table_remove (_tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->d_buffer;
	_tmp6_ = gtk_source_buffer_get_style_scheme ((GtkSourceBuffer*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_source_style_scheme_get_style (_tmp7_, "search-match");
	_tmp9_ = _g_object_ref0 (_tmp8_);
	style = _tmp9_;
	_tmp10_.pixel = (guint32) 0;
	_tmp10_.red = (guint16) 0;
	_tmp10_.green = (guint16) 0;
	_tmp10_.blue = (guint16) 0;
	bg = _tmp10_;
	_tmp11_.pixel = (guint32) 0;
	_tmp11_.red = (guint16) 0;
	_tmp11_.green = (guint16) 0;
	_tmp11_.blue = (guint16) 0;
	fg = _tmp11_;
	_tmp12_ = style;
	if (_tmp12_ == NULL) {
		GdkColor _tmp13_ = {0};
		GdkColor _tmp14_ = {0};
		gdk_color_parse ("#fff600", &_tmp13_);
		bg = _tmp13_;
		gdk_color_parse ("#333", &_tmp14_);
		fg = _tmp14_;
	} else {
		GtkStyleContext* ctx = NULL;
		GeditView* _tmp15_;
		GtkStyleContext* _tmp16_ = NULL;
		GtkStyleContext* _tmp17_;
		GtkStyleContext* _tmp18_;
		GtkStyleContext* _tmp19_;
		GdkRGBA fgcol = {0};
		GdkRGBA bgcol = {0};
		GtkStyleContext* _tmp20_;
		GdkRGBA _tmp21_ = {0};
		GtkStyleContext* _tmp22_;
		GdkRGBA _tmp23_ = {0};
		GdkRGBA _tmp24_;
		gdouble _tmp25_;
		GdkRGBA _tmp26_;
		gdouble _tmp27_;
		GdkRGBA _tmp28_;
		gdouble _tmp29_;
		GdkRGBA _tmp30_;
		gdouble _tmp31_;
		GdkRGBA _tmp32_;
		gdouble _tmp33_;
		GdkRGBA _tmp34_;
		gdouble _tmp35_;
		GtkStyleContext* _tmp36_;
		GtkSourceStyle* _tmp37_;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_;
		GtkSourceStyle* _tmp45_;
		gboolean _tmp46_ = FALSE;
		gboolean _tmp47_;
		_tmp15_ = self->priv->d_view;
		_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_g_object_unref0 (ctx);
		ctx = _tmp17_;
		_tmp18_ = ctx;
		gtk_style_context_save (_tmp18_);
		_tmp19_ = ctx;
		gtk_style_context_add_class (_tmp19_, GTK_STYLE_CLASS_VIEW);
		_tmp20_ = ctx;
		gtk_style_context_get_color (_tmp20_, GTK_STATE_FLAG_NORMAL, &_tmp21_);
		fgcol = _tmp21_;
		_tmp22_ = ctx;
		gtk_style_context_get_background_color (_tmp22_, GTK_STATE_FLAG_NORMAL, &_tmp23_);
		bgcol = _tmp23_;
		_tmp24_ = bgcol;
		_tmp25_ = _tmp24_.red;
		bg.red = (guint16) ((gushort) (_tmp25_ * 65535));
		_tmp26_ = bgcol;
		_tmp27_ = _tmp26_.green;
		bg.green = (guint16) ((gushort) (_tmp27_ * 65535));
		_tmp28_ = bgcol;
		_tmp29_ = _tmp28_.blue;
		bg.blue = (guint16) ((gushort) (_tmp29_ * 65535));
		_tmp30_ = fgcol;
		_tmp31_ = _tmp30_.red;
		fg.red = (guint16) ((gushort) (_tmp31_ * 65535));
		_tmp32_ = fgcol;
		_tmp33_ = _tmp32_.green;
		fg.green = (guint16) ((gushort) (_tmp33_ * 65535));
		_tmp34_ = fgcol;
		_tmp35_ = _tmp34_.blue;
		fg.blue = (guint16) ((gushort) (_tmp35_ * 65535));
		_tmp36_ = ctx;
		gtk_style_context_restore (_tmp36_);
		_tmp37_ = style;
		g_object_get (_tmp37_, "background-set", &_tmp38_, NULL);
		_tmp39_ = _tmp38_;
		if (_tmp39_) {
			GtkSourceStyle* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			gchar* _tmp43_;
			GdkColor _tmp44_ = {0};
			_tmp40_ = style;
			g_object_get (_tmp40_, "background", &_tmp41_, NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = _tmp42_;
			gdk_color_parse (_tmp43_, &_tmp44_);
			bg = _tmp44_;
			_g_free0 (_tmp43_);
		}
		_tmp45_ = style;
		g_object_get (_tmp45_, "foreground-set", &_tmp46_, NULL);
		_tmp47_ = _tmp46_;
		if (_tmp47_) {
			GtkSourceStyle* _tmp48_;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_;
			gchar* _tmp51_;
			GdkColor _tmp52_ = {0};
			_tmp48_ = style;
			g_object_get (_tmp48_, "foreground", &_tmp49_, NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = _tmp50_;
			gdk_color_parse (_tmp51_, &_tmp52_);
			fg = _tmp52_;
			_g_free0 (_tmp51_);
		}
		_g_object_unref0 (ctx);
	}
	_tmp53_ = bg;
	_tmp54_ = _tmp53_.red;
	_tmp55_ = bg;
	_tmp56_ = _tmp55_.green;
	_tmp57_ = bg;
	_tmp58_ = _tmp57_.blue;
	_tmp59_.red = _tmp54_ / 65535.0;
	_tmp59_.green = _tmp56_ / 65535.0;
	_tmp59_.blue = _tmp58_ / 65535.0;
	_tmp59_.alpha = (gdouble) 1;
	self->priv->d_refColor = _tmp59_;
	_tmp60_ = self->priv->d_buffer;
	_tmp61_ = bg;
	_tmp62_ = fg;
	_tmp63_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) _tmp60_, "Gcp.View.Semantic", "background-gdk", &_tmp61_, "foreground-gdk", &_tmp62_, "background-full-height", TRUE, NULL);
	_tmp64_ = _g_object_ref0 (_tmp63_);
	_g_object_unref0 (self->priv->d_semanticTag);
	self->priv->d_semanticTag = _tmp64_;
	gcp_view_update_references (self);
	_g_object_unref0 (style);
}


static void gcp_view_connect_buffer (GcpView* self, GeditDocument* buffer) {
	GeditDocument* _tmp0_;
	GeditDocument* _tmp1_;
	GeditDocument* _tmp2_;
	GeditDocument* _tmp3_;
	GeditDocument* _tmp4_;
	GeditDocument* _tmp5_;
	GeditDocument* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	_tmp0_ = buffer;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->d_buffer);
	self->priv->d_buffer = _tmp1_;
	_tmp2_ = self->priv->d_buffer;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->d_buffer;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::language", (GCallback) _gcp_view_on_notify_language_g_object_notify, self, 0);
	_tmp4_ = self->priv->d_buffer;
	g_signal_connect_object ((GtkTextBuffer*) _tmp4_, "changed", (GCallback) _gcp_view_on_buffer_changed_gtk_text_buffer_changed, self, 0);
	_tmp5_ = self->priv->d_buffer;
	g_signal_connect_object ((GtkTextBuffer*) _tmp5_, "mark-set", (GCallback) _gcp_view_on_buffer_mark_set_gtk_text_buffer_mark_set, self, 0);
	_tmp6_ = self->priv->d_buffer;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::style-scheme", (GCallback) _gcp_view_on_notify_style_scheme_g_object_notify, self, 0);
	gcp_view_update_semantic_tag (self);
	gcp_view_update_backend (self);
}


static void gcp_view_on_notify_style_scheme (GcpView* self) {
	g_return_if_fail (self != NULL);
	gcp_view_update_semantic_tag (self);
	gcp_view_update_diagnostic_message (self);
}


static void gcp_view_on_buffer_changed (GcpView* self) {
	GcpScrollbarMarker* _tmp0_;
	GeditDocument* _tmp1_;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_scrollbarMarker;
	_tmp1_ = self->priv->d_buffer;
	_tmp2_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) _tmp1_);
	gcp_scrollbar_marker_set_max_line (_tmp0_, _tmp2_);
}


static void gcp_view_update_backend (GcpView* self) {
	GcpBackend* backend;
	gboolean _tmp0_ = FALSE;
	GeditDocument* _tmp1_;
	gboolean _tmp5_;
	GcpBackend* _tmp14_;
	g_return_if_fail (self != NULL);
	backend = NULL;
	_tmp1_ = self->priv->d_buffer;
	if (_tmp1_ != NULL) {
		GeditDocument* _tmp2_;
		GtkSourceLanguage* _tmp3_;
		GtkSourceLanguage* _tmp4_;
		_tmp2_ = self->priv->d_buffer;
		_tmp3_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GcpBackendManager* _tmp6_;
		GcpBackendManager* _tmp7_;
		GeditDocument* _tmp8_;
		GtkSourceLanguage* _tmp9_;
		GtkSourceLanguage* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GcpBackend* _tmp13_ = NULL;
		_tmp6_ = gcp_backend_manager_get_instance ();
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->d_buffer;
		_tmp9_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gtk_source_language_get_id (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gcp_backend_manager_get (_tmp7_, _tmp12_);
		_g_object_unref0 (backend);
		backend = _tmp13_;
	}
	gcp_view_unregister_backend (self);
	_tmp14_ = backend;
	gcp_view_register_backend (self, _tmp14_);
	_g_object_unref0 (backend);
}


static gboolean _gcp_view_on_view_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip, gpointer self) {
	gboolean result;
	result = gcp_view_on_view_query_tooltip (self, x, y, keyboard_tooltip, tooltip);
	return result;
}


static void _gcp_view_on_cursor_diagnostics_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self) {
	gcp_view_on_cursor_diagnostics_moved (self);
}


static void _gcp_view_on_cursor_semantics_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self) {
	gcp_view_on_cursor_semantics_moved (self);
}


static void gcp_view_unregister_backend (GcpView* self) {
	GcpBackend* _tmp0_;
	GcpDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_backend;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->d_document;
	if (_tmp1_ != NULL) {
		GcpDocument* _tmp2_;
		GcpDocument* _tmp8_;
		GcpBackend* _tmp11_;
		GcpDocument* _tmp12_;
		_tmp2_ = self->priv->d_document;
		if (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp2_)) {
			GeditView* _tmp3_;
			guint _tmp4_ = 0U;
			GeditView* _tmp5_;
			GeditDocument* _tmp6_;
			guint _tmp7_ = 0U;
			_tmp3_ = self->priv->d_view;
			g_signal_parse_name ("query-tooltip", GTK_TYPE_WIDGET, &_tmp4_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _gcp_view_on_view_query_tooltip_gtk_widget_query_tooltip, self);
			_tmp5_ = self->priv->d_view;
			gtk_source_view_set_show_line_marks ((GtkSourceView*) _tmp5_, FALSE);
			_tmp6_ = self->priv->d_buffer;
			g_signal_parse_name ("cursor-moved", gedit_document_get_type (), &_tmp7_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gcp_view_on_cursor_diagnostics_moved_gedit_document_cursor_moved, self);
		}
		_tmp8_ = self->priv->d_document;
		if (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp8_)) {
			GeditDocument* _tmp9_;
			guint _tmp10_ = 0U;
			_tmp9_ = self->priv->d_buffer;
			g_signal_parse_name ("cursor-moved", gedit_document_get_type (), &_tmp10_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _gcp_view_on_cursor_semantics_moved_gedit_document_cursor_moved, self);
		}
		_tmp11_ = self->priv->d_backend;
		_tmp12_ = self->priv->d_document;
		gcp_backend_unregister (_tmp11_, _tmp12_);
	}
	_g_object_unref0 (self->priv->d_backend);
	self->priv->d_backend = NULL;
	_g_object_unref0 (self->priv->d_document);
	self->priv->d_document = NULL;
}


static gchar* gcp_view_format_diagnostics (GcpView* self, GcpDiagnostic** diagnostics, int diagnostics_length1) {
	gchar* result = NULL;
	GcpDiagnostic** _tmp0_;
	gint _tmp0__length1;
	GcpDiagnostic** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_ = NULL;
	gchar** markup;
	gint markup_length1;
	gint _markup_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = diagnostics;
	_tmp0__length1 = diagnostics_length1;
	if (_tmp0__length1 == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = diagnostics;
	_tmp1__length1 = diagnostics_length1;
	_tmp2_ = g_new0 (gchar*, _tmp1__length1 + 1);
	markup = _tmp2_;
	markup_length1 = _tmp1__length1;
	_markup_size_ = markup_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				GcpDiagnostic** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				GcpDiagnostic** _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				GcpDiagnostic* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = diagnostics;
				_tmp7__length1 = diagnostics_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = markup;
				_tmp8__length1 = markup_length1;
				_tmp9_ = i;
				_tmp10_ = diagnostics;
				_tmp10__length1 = diagnostics_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				_tmp13_ = gcp_diagnostic_to_markup (_tmp12_, FALSE);
				_g_free0 (_tmp8_[_tmp9_]);
				_tmp8_[_tmp9_] = _tmp13_;
				_tmp14_ = _tmp8_[_tmp9_];
			}
		}
	}
	_tmp15_ = markup;
	_tmp15__length1 = markup_length1;
	_tmp16_ = g_strjoinv ("\n", _tmp15_);
	result = _tmp16_;
	markup = (_vala_array_free (markup, markup_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* gcp_view_on_diagnostic_tooltip (GcpView* self, GtkSourceMarkAttributes* attributes, GtkSourceMark* mark) {
	gchar* result = NULL;
	GtkTextIter iter = {0};
	GtkSourceMark* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	GcpDiagnostic* _tmp2_;
	GcpDiagnostic* diagnostic;
	GcpDiagnostic* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attributes != NULL, NULL);
	g_return_val_if_fail (mark != NULL, NULL);
	_tmp0_ = mark;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "Gcp.Document.MarkDiagnostic");
	_tmp2_ = _g_object_ref0 ((GcpDiagnostic*) _tmp1_);
	diagnostic = _tmp2_;
	_tmp3_ = diagnostic;
	if (_tmp3_ == NULL) {
		GeditView* _tmp4_;
		GtkTextBuffer* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkSourceMark* _tmp7_;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gint line;
		GcpDocument* _tmp10_;
		GcpDiagnosticSupport* _tmp11_;
		GcpDiagnosticSupport* diag;
		GcpDiagnosticSupport* _tmp12_;
		gint _tmp13_;
		gint _tmp14_ = 0;
		GcpDiagnostic** _tmp15_ = NULL;
		GcpDiagnostic** _tmp16_;
		gint _tmp16__length1;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		_tmp4_ = self->priv->d_view;
		_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = mark;
		gtk_text_buffer_get_iter_at_mark (_tmp6_, &_tmp8_, (GtkTextMark*) _tmp7_);
		iter = _tmp8_;
		_tmp9_ = gtk_text_iter_get_line (&iter);
		line = _tmp9_ + 1;
		_tmp10_ = self->priv->d_document;
		_tmp11_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp10_) ? ((GcpDiagnosticSupport*) _tmp10_) : NULL);
		diag = _tmp11_;
		_tmp12_ = diag;
		_tmp13_ = line;
		_tmp15_ = gcp_diagnostic_support_find_at_line (_tmp12_, _tmp13_, &_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _tmp14_;
		_tmp17_ = gcp_view_format_diagnostics (self, _tmp16_, _tmp14_);
		_tmp18_ = _tmp17_;
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_object_unref), NULL);
		result = _tmp18_;
		_g_object_unref0 (diag);
		_g_object_unref0 (diagnostic);
		return result;
	} else {
		GcpDiagnostic* _tmp19_;
		gchar* _tmp20_ = NULL;
		_tmp19_ = diagnostic;
		_tmp20_ = gcp_diagnostic_to_markup (_tmp19_, FALSE);
		result = _tmp20_;
		_g_object_unref0 (diagnostic);
		return result;
	}
	_g_object_unref0 (diagnostic);
}


static gboolean gcp_view_on_view_query_tooltip (GcpView* self, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	gint bx = 0;
	gint by = 0;
	GeditView* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkTextIter iter = {0};
	GeditView* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_;
	GcpSourceLocation* _tmp10_;
	GcpSourceLocation* location;
	GcpDocument* _tmp11_;
	GcpDiagnosticSupport* _tmp12_;
	GcpDiagnosticSupport* diag;
	GcpDiagnosticSupport* _tmp13_;
	GcpSourceLocation* _tmp14_;
	gint _tmp15_ = 0;
	GcpDiagnostic** _tmp16_ = NULL;
	GcpDiagnostic** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* s;
	const gchar* _tmp20_;
	GtkTooltip* _tmp21_;
	const gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = x;
	_tmp2_ = y;
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) _tmp0_, GTK_TEXT_WINDOW_WIDGET, _tmp1_, _tmp2_, &_tmp3_, &_tmp4_);
	bx = _tmp3_;
	by = _tmp4_;
	_tmp5_ = self->priv->d_view;
	_tmp6_ = bx;
	_tmp7_ = by;
	gtk_text_view_get_iter_at_location ((GtkTextView*) _tmp5_, &_tmp8_, _tmp6_, _tmp7_);
	iter = _tmp8_;
	_tmp9_ = iter;
	_tmp10_ = gcp_source_location_new_iter (&_tmp9_);
	location = _tmp10_;
	_tmp11_ = self->priv->d_document;
	_tmp12_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp11_) ? ((GcpDiagnosticSupport*) _tmp11_) : NULL);
	diag = _tmp12_;
	_tmp13_ = diag;
	_tmp14_ = location;
	_tmp16_ = gcp_diagnostic_support_find_at (_tmp13_, _tmp14_, &_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp15_;
	_tmp18_ = gcp_view_format_diagnostics (self, _tmp17_, _tmp15_);
	_tmp19_ = _tmp18_;
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_object_unref), NULL);
	s = _tmp19_;
	_tmp20_ = s;
	if (_tmp20_ == NULL) {
		result = FALSE;
		_g_free0 (s);
		_g_object_unref0 (diag);
		_g_object_unref0 (location);
		return result;
	}
	_tmp21_ = tooltip;
	_tmp22_ = s;
	gtk_tooltip_set_markup (_tmp21_, _tmp22_);
	result = TRUE;
	_g_free0 (s);
	_g_object_unref0 (diag);
	_g_object_unref0 (location);
	return result;
}


static void _gcp_view_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated (GcpDiagnosticSupport* _sender, gpointer self) {
	gcp_view_on_diagnostic_updated (self, _sender);
}


static gchar* _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup (GtkSourceMarkAttributes* _sender, GtkSourceMark* object, gpointer self) {
	gchar* result;
	result = gcp_view_on_diagnostic_tooltip (self, _sender, object);
	return result;
}


static void _gcp_view_on_semantics_updated_gcp_semantic_value_support_semantic_values_updated (GcpSemanticValueSupport* _sender, gpointer self) {
	gcp_view_on_semantics_updated (self, _sender);
}


static void gcp_view_register_backend (GcpView* self, GcpBackend* backend) {
	GcpBackend* _tmp0_;
	GcpBackend* _tmp1_;
	GcpBackend* _tmp2_;
	GeditView* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = backend;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->d_backend);
	self->priv->d_backend = _tmp1_;
	_tmp2_ = backend;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->d_view;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		GcpBackend* _tmp6_;
		GeditView* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextBuffer* _tmp9_;
		GcpDocument* _tmp10_ = NULL;
		GcpDocument* _tmp11_;
		GcpDiagnosticSupport* _tmp12_;
		GcpDiagnosticSupport* diag;
		GcpDiagnosticSupport* _tmp13_;
		GcpDocument* _tmp47_;
		GcpSemanticValueSupport* _tmp48_;
		GcpSemanticValueSupport* sem;
		GcpSemanticValueSupport* _tmp49_;
		_tmp6_ = self->priv->d_backend;
		_tmp7_ = self->priv->d_view;
		_tmp8_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gcp_backend_register (_tmp6_, GEDIT_IS_DOCUMENT (_tmp9_) ? ((GeditDocument*) _tmp9_) : NULL);
		_g_object_unref0 (self->priv->d_document);
		self->priv->d_document = _tmp10_;
		_tmp11_ = self->priv->d_document;
		_tmp12_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp11_) ? ((GcpDiagnosticSupport*) _tmp11_) : NULL);
		diag = _tmp12_;
		_tmp13_ = diag;
		if (_tmp13_ != NULL) {
			GtkSourceMarkAttributes* attr = NULL;
			GcpDiagnosticSupport* _tmp14_;
			GcpDiagnosticTags* _tmp15_;
			GcpDiagnosticSupport* _tmp16_;
			GtkSourceMarkAttributes* _tmp17_;
			GtkSourceMarkAttributes* _tmp18_;
			GThemedIcon* _tmp19_;
			GThemedIcon* _tmp20_;
			GtkSourceMarkAttributes* _tmp21_;
			GeditView* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			GtkSourceMarkAttributes* _tmp25_;
			GtkSourceMarkAttributes* _tmp26_;
			GtkSourceMarkAttributes* _tmp27_;
			GThemedIcon* _tmp28_;
			GThemedIcon* _tmp29_;
			GtkSourceMarkAttributes* _tmp30_;
			GeditView* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			GtkSourceMarkAttributes* _tmp34_;
			GtkSourceMarkAttributes* _tmp35_;
			GtkSourceMarkAttributes* _tmp36_;
			GThemedIcon* _tmp37_;
			GThemedIcon* _tmp38_;
			GtkSourceMarkAttributes* _tmp39_;
			GeditView* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			GtkSourceMarkAttributes* _tmp43_;
			GeditView* _tmp44_;
			GeditView* _tmp45_;
			GeditDocument* _tmp46_;
			_tmp14_ = diag;
			_tmp15_ = self->priv->d_tags;
			gcp_diagnostic_support_set_tags (_tmp14_, _tmp15_);
			_tmp16_ = diag;
			g_signal_connect_object (_tmp16_, "diagnostics-updated", (GCallback) _gcp_view_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated, self, 0);
			_tmp17_ = gtk_source_mark_attributes_new ();
			_g_object_unref0 (attr);
			attr = _tmp17_;
			_tmp18_ = attr;
			_tmp19_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("dialog-error-symbolic");
			_tmp20_ = _tmp19_;
			gtk_source_mark_attributes_set_gicon (_tmp18_, (GIcon*) _tmp20_);
			_g_object_unref0 (_tmp20_);
			_tmp21_ = attr;
			g_signal_connect_object (_tmp21_, "query-tooltip-markup", (GCallback) _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup, self, 0);
			_tmp22_ = self->priv->d_view;
			_tmp23_ = gcp_document_get_error_mark_category ();
			_tmp24_ = _tmp23_;
			_tmp25_ = attr;
			gtk_source_view_set_mark_attributes ((GtkSourceView*) _tmp22_, _tmp24_, _tmp25_, 0);
			_tmp26_ = gtk_source_mark_attributes_new ();
			_g_object_unref0 (attr);
			attr = _tmp26_;
			_tmp27_ = attr;
			_tmp28_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("dialog-warning-symbolic");
			_tmp29_ = _tmp28_;
			gtk_source_mark_attributes_set_gicon (_tmp27_, (GIcon*) _tmp29_);
			_g_object_unref0 (_tmp29_);
			_tmp30_ = attr;
			g_signal_connect_object (_tmp30_, "query-tooltip-markup", (GCallback) _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup, self, 0);
			_tmp31_ = self->priv->d_view;
			_tmp32_ = gcp_document_get_warning_mark_category ();
			_tmp33_ = _tmp32_;
			_tmp34_ = attr;
			gtk_source_view_set_mark_attributes ((GtkSourceView*) _tmp31_, _tmp33_, _tmp34_, 0);
			_tmp35_ = gtk_source_mark_attributes_new ();
			_g_object_unref0 (attr);
			attr = _tmp35_;
			_tmp36_ = attr;
			_tmp37_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("dialog-information-symbolic");
			_tmp38_ = _tmp37_;
			gtk_source_mark_attributes_set_gicon (_tmp36_, (GIcon*) _tmp38_);
			_g_object_unref0 (_tmp38_);
			_tmp39_ = attr;
			g_signal_connect_object (_tmp39_, "query-tooltip-markup", (GCallback) _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup, self, 0);
			_tmp40_ = self->priv->d_view;
			_tmp41_ = gcp_document_get_info_mark_category ();
			_tmp42_ = _tmp41_;
			_tmp43_ = attr;
			gtk_source_view_set_mark_attributes ((GtkSourceView*) _tmp40_, _tmp42_, _tmp43_, 0);
			_tmp44_ = self->priv->d_view;
			g_signal_connect_object ((GtkWidget*) _tmp44_, "query-tooltip", (GCallback) _gcp_view_on_view_query_tooltip_gtk_widget_query_tooltip, self, 0);
			_tmp45_ = self->priv->d_view;
			gtk_source_view_set_show_line_marks ((GtkSourceView*) _tmp45_, TRUE);
			_tmp46_ = self->priv->d_buffer;
			g_signal_connect_object (_tmp46_, "cursor-moved", (GCallback) _gcp_view_on_cursor_diagnostics_moved_gedit_document_cursor_moved, self, 0);
			_g_object_unref0 (attr);
		}
		_tmp47_ = self->priv->d_document;
		_tmp48_ = _g_object_ref0 (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp47_) ? ((GcpSemanticValueSupport*) _tmp47_) : NULL);
		sem = _tmp48_;
		_tmp49_ = sem;
		if (_tmp49_ != NULL) {
			GcpSemanticValueSupport* _tmp50_;
			GeditDocument* _tmp51_;
			_tmp50_ = sem;
			g_signal_connect_object (_tmp50_, "semantic-values-updated", (GCallback) _gcp_view_on_semantics_updated_gcp_semantic_value_support_semantic_values_updated, self, 0);
			_tmp51_ = self->priv->d_buffer;
			g_signal_connect_object (_tmp51_, "cursor-moved", (GCallback) _gcp_view_on_cursor_semantics_moved_gedit_document_cursor_moved, self, 0);
		}
		_g_object_unref0 (sem);
		_g_object_unref0 (diag);
	} else {
		_g_object_unref0 (self->priv->d_document);
		self->priv->d_document = NULL;
	}
}


static gboolean gcp_view_diagnostic_is_at_end (GcpView* self, GcpSourceLocation* location) {
	gboolean result = FALSE;
	GtkTextIter iter = {0};
	GeditDocument* _tmp0_;
	GcpSourceLocation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GcpSourceLocation* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_ = 0;
	GcpSourceLocation* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = self->priv->d_buffer;
	_tmp1_ = location;
	_tmp2_ = gcp_source_location_get_line (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp0_, &_tmp4_, _tmp3_ - 1);
	iter = _tmp4_;
	_tmp5_ = location;
	_tmp6_ = gcp_source_location_get_column (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_text_iter_forward_chars (&iter, _tmp7_ - 1);
	_tmp8_ = gtk_text_iter_get_line (&iter);
	_tmp9_ = location;
	_tmp10_ = gcp_source_location_get_line (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp8_ != (_tmp11_ - 1)) {
		result = FALSE;
		return result;
	}
	_tmp12_ = gtk_text_iter_ends_line (&iter);
	result = _tmp12_;
	return result;
}


static void gcp_view_add_diagnostic_at_end (GcpView* self, GcpSourceLocation* location, GdkRGBA* color) {
	GtkTextIter iter = {0};
	GeditDocument* _tmp0_;
	GcpSourceLocation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GeditDocument* _tmp5_;
	GtkTextIter _tmp6_;
	GtkTextMark* _tmp7_ = NULL;
	GtkTextMark* _tmp8_;
	GtkTextMark* mark;
	GeeHashMap* _tmp9_;
	GdkRGBA _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = self->priv->d_buffer;
	_tmp1_ = location;
	_tmp2_ = gcp_source_location_get_line (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp0_, &_tmp4_, _tmp3_ - 1);
	iter = _tmp4_;
	_tmp5_ = self->priv->d_buffer;
	_tmp6_ = iter;
	_tmp7_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) _tmp5_, NULL, &_tmp6_, FALSE);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	mark = _tmp8_;
	_tmp9_ = self->priv->d_diagnosticsAtEnd;
	_tmp10_ = *color;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, mark, &_tmp10_);
	_g_object_unref0 (mark);
}


static void gcp_view_on_semantics_updated (GcpView* self, GcpSemanticValueSupport* semantics) {
	GTimer* _tmp0_;
	GTimer* timer;
	gdouble elapsed;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (semantics != NULL);
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	elapsed = (gdouble) 0;
	g_timer_start (timer);
	gcp_view_update_references (self);
	_tmp1_ = g_timer_elapsed (timer, NULL);
	elapsed = _tmp1_;
	_tmp2_ = elapsed;
	gcp_log_debug ("gcp-view.vala:509: Semantics update in: %f seconds...", _tmp2_);
	_g_timer_destroy0 (timer);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GcpView * self;
		self = _data2_->self;
		_gcp_diagnostic_colors_unref0 (_data2_->mixed);
		_gcp_diagnostic_colors_unref0 (_data2_->colors);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda20_ (Block2Data* _data2_, GcpSourceIndex* diagnostics) {
	GcpView * self;
	self = _data2_->self;
	g_return_if_fail (diagnostics != NULL);
	{
		GcpSourceIndex* _tmp0_;
		GcpSourceIndexIterator* _tmp1_ = NULL;
		GcpSourceIndexIterator* _d_it;
		_tmp0_ = diagnostics;
		_tmp1_ = gcp_source_index_iterator (_tmp0_);
		_d_it = _tmp1_;
		while (TRUE) {
			GcpSourceIndexIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GcpSourceIndexIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			GcpDiagnostic* d;
			GcpDiagnosticColors* _tmp6_;
			GcpDiagnostic* _tmp7_;
			GcpDiagnosticSeverity _tmp8_;
			GcpDiagnosticSeverity _tmp9_;
			GdkRGBA* _tmp10_ = NULL;
			GdkRGBA* _tmp11_;
			GdkRGBA _tmp12_;
			GdkRGBA color;
			GcpDiagnosticColors* _tmp13_;
			GcpDiagnostic* _tmp14_;
			GcpDiagnosticSeverity _tmp15_;
			GcpDiagnosticSeverity _tmp16_;
			GdkRGBA* _tmp17_ = NULL;
			GdkRGBA* _tmp18_;
			GdkRGBA _tmp19_;
			GdkRGBA mix;
			GcpDiagnostic* _tmp20_;
			GcpSourceRange** _tmp21_;
			gint _tmp21__length1;
			GcpSourceRange** _tmp22_;
			gint _tmp22__length1;
			GcpScrollbarMarker* _tmp57_;
			GcpDiagnostic* _tmp58_;
			GcpSourceLocation* _tmp59_;
			GcpSourceLocation* _tmp60_;
			GcpSourceRange* _tmp61_;
			GcpSourceRange* _tmp62_;
			GcpSourceRange* _tmp63_;
			GdkRGBA _tmp64_;
			GcpDiagnostic* _tmp65_;
			GcpSourceLocation* _tmp66_;
			GcpSourceLocation* _tmp67_;
			gboolean _tmp68_ = FALSE;
			_tmp2_ = _d_it;
			_tmp3_ = gcp_source_index_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _d_it;
			_tmp5_ = gcp_source_index_iterator_get (_tmp4_);
			d = (GcpDiagnostic*) _tmp5_;
			_tmp6_ = _data2_->colors;
			_tmp7_ = d;
			_tmp8_ = gcp_diagnostic_get_severity (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = gcp_diagnostic_colors_get (_tmp6_, _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = *_tmp11_;
			_g_free0 (_tmp11_);
			color = _tmp12_;
			_tmp13_ = _data2_->mixed;
			_tmp14_ = d;
			_tmp15_ = gcp_diagnostic_get_severity (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = gcp_diagnostic_colors_get (_tmp13_, _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = *_tmp18_;
			_g_free0 (_tmp18_);
			mix = _tmp19_;
			_tmp20_ = d;
			_tmp21_ = gcp_source_range_support_get_ranges ((GcpSourceRangeSupport*) _tmp20_, &_tmp21__length1);
			_tmp22_ = _tmp21_;
			_tmp22__length1 = _tmp21__length1;
			{
				GcpSourceRange** range_collection = NULL;
				gint range_collection_length1 = 0;
				gint _range_collection_size_ = 0;
				gint range_it = 0;
				range_collection = _tmp22_;
				range_collection_length1 = _tmp22__length1;
				for (range_it = 0; range_it < _tmp22__length1; range_it = range_it + 1) {
					GcpSourceRange* _tmp23_;
					GcpSourceRange* range = NULL;
					_tmp23_ = _g_object_ref0 (range_collection[range_it]);
					range = _tmp23_;
					{
						GcpScrollbarMarker* _tmp24_;
						GcpSourceRange* _tmp25_;
						GdkRGBA _tmp26_;
						gboolean _tmp27_ = FALSE;
						GcpSourceRange* _tmp28_;
						GcpSourceLocation* _tmp29_;
						GcpSourceLocation* _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						GcpSourceRange* _tmp33_;
						GcpSourceLocation* _tmp34_;
						GcpSourceLocation* _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						gboolean _tmp48_;
						_tmp24_ = self->priv->d_scrollbarMarker;
						_tmp25_ = range;
						_tmp26_ = color;
						gcp_scrollbar_marker_add_with_id (_tmp24_, _data2_->mid, _tmp25_, &_tmp26_);
						_tmp28_ = range;
						_tmp29_ = gcp_source_range_get_start (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = gcp_source_location_get_line (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = range;
						_tmp34_ = gcp_source_range_get_end (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = gcp_source_location_get_line (_tmp35_);
						_tmp37_ = _tmp36_;
						if (_tmp32_ == _tmp37_) {
							GcpSourceRange* _tmp38_;
							GcpSourceLocation* _tmp39_;
							GcpSourceLocation* _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							GcpSourceRange* _tmp43_;
							GcpSourceLocation* _tmp44_;
							GcpSourceLocation* _tmp45_;
							gint _tmp46_;
							gint _tmp47_;
							_tmp38_ = range;
							_tmp39_ = gcp_source_range_get_start (_tmp38_);
							_tmp40_ = _tmp39_;
							_tmp41_ = gcp_source_location_get_column (_tmp40_);
							_tmp42_ = _tmp41_;
							_tmp43_ = range;
							_tmp44_ = gcp_source_range_get_end (_tmp43_);
							_tmp45_ = _tmp44_;
							_tmp46_ = gcp_source_location_get_column (_tmp45_);
							_tmp47_ = _tmp46_;
							_tmp27_ = _tmp42_ == _tmp47_;
						} else {
							_tmp27_ = FALSE;
						}
						_tmp48_ = _tmp27_;
						if (_tmp48_) {
							GcpSourceRange* _tmp49_;
							GcpSourceLocation* _tmp50_;
							GcpSourceLocation* _tmp51_;
							gboolean _tmp52_ = FALSE;
							_tmp49_ = range;
							_tmp50_ = gcp_source_range_get_start (_tmp49_);
							_tmp51_ = _tmp50_;
							_tmp52_ = gcp_view_diagnostic_is_at_end (self, _tmp51_);
							if (_tmp52_) {
								GcpSourceRange* _tmp53_;
								GcpSourceLocation* _tmp54_;
								GcpSourceLocation* _tmp55_;
								GdkRGBA _tmp56_;
								_tmp53_ = range;
								_tmp54_ = gcp_source_range_get_start (_tmp53_);
								_tmp55_ = _tmp54_;
								_tmp56_ = mix;
								gcp_view_add_diagnostic_at_end (self, _tmp55_, &_tmp56_);
							}
						}
						_g_object_unref0 (range);
					}
				}
				range_collection = (_vala_array_free (range_collection, range_collection_length1, (GDestroyNotify) g_object_unref), NULL);
			}
			_tmp57_ = self->priv->d_scrollbarMarker;
			_tmp58_ = d;
			_tmp59_ = gcp_diagnostic_get_location (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = _tmp62_;
			_tmp64_ = color;
			gcp_scrollbar_marker_add_with_id (_tmp57_, _data2_->mid, _tmp63_, &_tmp64_);
			_g_object_unref0 (_tmp63_);
			_tmp65_ = d;
			_tmp66_ = gcp_diagnostic_get_location (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = gcp_view_diagnostic_is_at_end (self, _tmp67_);
			if (_tmp68_) {
				GcpDiagnostic* _tmp69_;
				GcpSourceLocation* _tmp70_;
				GcpSourceLocation* _tmp71_;
				GdkRGBA _tmp72_;
				_tmp69_ = d;
				_tmp70_ = gcp_diagnostic_get_location (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = mix;
				gcp_view_add_diagnostic_at_end (self, _tmp71_, &_tmp72_);
			}
			_g_object_unref0 (d);
		}
		_g_object_unref0 (_d_it);
	}
}


static void ___lambda20__gcp_diagnostic_support_with_diagnostics_callback (GcpSourceIndex* diagnostics, gpointer self) {
	__lambda20_ (self, diagnostics);
}


static void gcp_view_on_diagnostic_updated (GcpView* self, GcpDiagnosticSupport* diagnostics) {
	Block2Data* _data2_;
	GTimer* _tmp0_;
	GTimer* timer;
	gdouble elapsed;
	GTimer* _tmp1_;
	GcpScrollbarMarker* _tmp2_;
	GcpScrollbarMarker* _tmp3_;
	GtkScrollbar* _tmp4_;
	GtkScrollbar* _tmp5_;
	GtkStyleContext* _tmp6_ = NULL;
	GcpDiagnosticColors* _tmp7_;
	GcpScrollbarMarker* _tmp8_;
	GtkScrollbar* _tmp9_;
	GtkScrollbar* _tmp10_;
	GtkStyleContext* _tmp11_ = NULL;
	GcpDiagnosticColors* _tmp12_;
	GcpDiagnosticColors* _tmp13_;
	GeditView* _tmp14_;
	GeeHashMap* _tmp15_;
	GeeMapIterator* _tmp16_ = NULL;
	GeeMapIterator* it;
	GeeHashMap* _tmp23_;
	GcpScrollbarMarker* _tmp24_;
	guint _tmp25_ = 0U;
	GcpDiagnosticSupport* _tmp26_;
	GTimer* _tmp27_;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostics != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	elapsed = (gdouble) 0;
	_tmp1_ = timer;
	g_timer_start (_tmp1_);
	_tmp2_ = self->priv->d_scrollbarMarker;
	gcp_scrollbar_marker_clear (_tmp2_);
	_tmp3_ = self->priv->d_scrollbarMarker;
	_tmp4_ = gcp_scrollbar_marker_get_scrollbar (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	_tmp7_ = gcp_diagnostic_colors_new (_tmp6_);
	_gcp_diagnostic_colors_unref0 (_data2_->colors);
	_data2_->colors = _tmp7_;
	_tmp8_ = self->priv->d_scrollbarMarker;
	_tmp9_ = gcp_scrollbar_marker_get_scrollbar (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	_tmp12_ = gcp_diagnostic_colors_new (_tmp11_);
	_gcp_diagnostic_colors_unref0 (_data2_->mixed);
	_data2_->mixed = _tmp12_;
	_tmp13_ = _data2_->mixed;
	_tmp14_ = self->priv->d_view;
	gcp_diagnostic_colors_mix_in_widget (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->d_diagnosticsAtEnd;
	_tmp16_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp15_);
	it = _tmp16_;
	while (TRUE) {
		GeeMapIterator* _tmp17_;
		gboolean _tmp18_ = FALSE;
		GeditDocument* _tmp19_;
		GeeMapIterator* _tmp20_;
		gpointer _tmp21_ = NULL;
		GtkTextMark* _tmp22_;
		_tmp17_ = it;
		_tmp18_ = gee_map_iterator_next (_tmp17_);
		if (!_tmp18_) {
			break;
		}
		_tmp19_ = self->priv->d_buffer;
		_tmp20_ = it;
		_tmp21_ = gee_map_iterator_get_key (_tmp20_);
		_tmp22_ = (GtkTextMark*) _tmp21_;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp19_, _tmp22_);
		_g_object_unref0 (_tmp22_);
	}
	_tmp23_ = self->priv->d_diagnosticsAtEnd;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp23_);
	_tmp24_ = self->priv->d_scrollbarMarker;
	_tmp25_ = gcp_scrollbar_marker_new_merge_id (_tmp24_);
	_data2_->mid = _tmp25_;
	_tmp26_ = diagnostics;
	gcp_diagnostic_support_with_diagnostics (_tmp26_, ___lambda20__gcp_diagnostic_support_with_diagnostics_callback, _data2_);
	gcp_view_update_diagnostic_message (self);
	_tmp27_ = timer;
	_tmp28_ = g_timer_elapsed (_tmp27_, NULL);
	elapsed = _tmp28_;
	_tmp29_ = elapsed;
	gcp_log_debug ("gcp-view.vala:573: Diagnostics update in: %f seconds...", _tmp29_);
	_g_object_unref0 (it);
	_g_timer_destroy0 (timer);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void gcp_view_on_notify_buffer (GcpView* self) {
	GeditView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	g_return_if_fail (self != NULL);
	gcp_view_disconnect_buffer (self);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	gcp_view_connect_buffer (self, GEDIT_IS_DOCUMENT (_tmp2_) ? ((GeditDocument*) _tmp2_) : NULL);
}


static void gcp_view_on_notify_language (GcpView* self) {
	g_return_if_fail (self != NULL);
	gcp_view_update_backend (self);
}


static gboolean gcp_view_on_view_draw (GcpView* self, cairo_t* ctx) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeditView* _tmp3_;
	GdkWindow* _tmp4_ = NULL;
	GdkWindow* _tmp5_;
	GdkWindow* window;
	cairo_t* _tmp6_;
	GdkWindow* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GeeHashMap* _tmp9_;
	GeeMapIterator* _tmp10_ = NULL;
	GeeMapIterator* it;
	cairo_t* _tmp11_;
	GeditView* _tmp12_;
	GdkWindow* _tmp13_;
	GdkRectangle rect = {0};
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditView* _tmp14_;
	GdkRectangle _tmp15_ = {0};
	GeditView* _tmp16_;
	GdkRectangle _tmp17_;
	gint _tmp18_;
	GtkTextIter _tmp19_ = {0};
	GeditView* _tmp20_;
	GdkRectangle _tmp21_;
	gint _tmp22_;
	GdkRectangle _tmp23_;
	gint _tmp24_;
	GtkTextIter _tmp25_ = {0};
	GdkWindow* _tmp26_;
	gint _tmp27_ = 0;
	gint window_width;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->d_diagnosticsAtEnd;
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->d_view;
	_tmp4_ = gtk_text_view_get_window ((GtkTextView*) _tmp3_, GTK_TEXT_WINDOW_TEXT);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	window = _tmp5_;
	_tmp6_ = ctx;
	_tmp7_ = window;
	_tmp8_ = gtk_cairo_should_draw_window (_tmp6_, _tmp7_);
	if (!_tmp8_) {
		result = FALSE;
		_g_object_unref0 (window);
		return result;
	}
	_tmp9_ = self->priv->d_diagnosticsAtEnd;
	_tmp10_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp9_);
	it = _tmp10_;
	_tmp11_ = ctx;
	_tmp12_ = self->priv->d_view;
	_tmp13_ = window;
	gtk_cairo_transform_to_window (_tmp11_, (GtkWidget*) _tmp12_, _tmp13_);
	_tmp14_ = self->priv->d_view;
	gtk_text_view_get_visible_rect ((GtkTextView*) _tmp14_, &_tmp15_);
	rect = _tmp15_;
	_tmp16_ = self->priv->d_view;
	_tmp17_ = rect;
	_tmp18_ = _tmp17_.y;
	gtk_text_view_get_line_at_y ((GtkTextView*) _tmp16_, &_tmp19_, _tmp18_, NULL);
	start = _tmp19_;
	gtk_text_iter_backward_line (&start);
	_tmp20_ = self->priv->d_view;
	_tmp21_ = rect;
	_tmp22_ = _tmp21_.y;
	_tmp23_ = rect;
	_tmp24_ = _tmp23_.height;
	gtk_text_view_get_line_at_y ((GtkTextView*) _tmp20_, &_tmp25_, _tmp22_ + _tmp24_, NULL);
	end = _tmp25_;
	gtk_text_iter_forward_line (&end);
	_tmp26_ = window;
	_tmp27_ = gdk_window_get_width (_tmp26_);
	window_width = _tmp27_;
	while (TRUE) {
		GeeMapIterator* _tmp28_;
		gboolean _tmp29_ = FALSE;
		GtkTextIter iter = {0};
		GeditView* _tmp30_;
		GtkTextBuffer* _tmp31_;
		GtkTextBuffer* _tmp32_;
		GeeMapIterator* _tmp33_;
		gpointer _tmp34_ = NULL;
		GtkTextMark* _tmp35_;
		GtkTextIter _tmp36_ = {0};
		gboolean _tmp37_ = FALSE;
		GtkTextIter _tmp38_;
		GtkTextIter _tmp39_;
		gboolean _tmp40_ = FALSE;
		gboolean _tmp43_;
		gboolean _tmp44_ = FALSE;
		gint y = 0;
		gint height = 0;
		gint wy = 0;
		gint wx = 0;
		GdkRectangle irect = {0};
		GeditView* _tmp46_;
		GtkTextIter _tmp47_;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		GeditView* _tmp50_;
		GtkTextIter _tmp51_;
		GdkRectangle _tmp52_ = {0};
		GeditView* _tmp53_;
		GdkRectangle _tmp54_;
		gint _tmp55_;
		GdkRectangle _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		cairo_t* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		cairo_t* _tmp67_;
		GeeMapIterator* _tmp68_;
		gpointer _tmp69_ = NULL;
		GdkRGBA* _tmp70_;
		GdkRGBA _tmp71_;
		cairo_t* _tmp72_;
		_tmp28_ = it;
		_tmp29_ = gee_map_iterator_next (_tmp28_);
		if (!_tmp29_) {
			break;
		}
		_tmp30_ = self->priv->d_view;
		_tmp31_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = it;
		_tmp34_ = gee_map_iterator_get_key (_tmp33_);
		_tmp35_ = (GtkTextMark*) _tmp34_;
		gtk_text_buffer_get_iter_at_mark (_tmp32_, &_tmp36_, _tmp35_);
		iter = _tmp36_;
		_g_object_unref0 (_tmp35_);
		_tmp38_ = start;
		_tmp39_ = end;
		_tmp40_ = gtk_text_iter_in_range (&iter, &_tmp38_, &_tmp39_);
		if (!_tmp40_) {
			GtkTextIter _tmp41_;
			gboolean _tmp42_ = FALSE;
			_tmp41_ = end;
			_tmp42_ = gtk_text_iter_equal (&iter, &_tmp41_);
			_tmp37_ = !_tmp42_;
		} else {
			_tmp37_ = FALSE;
		}
		_tmp43_ = _tmp37_;
		if (_tmp43_) {
			continue;
		}
		_tmp44_ = gtk_text_iter_ends_line (&iter);
		if (!_tmp44_) {
			gboolean _tmp45_ = FALSE;
			_tmp45_ = gtk_text_iter_forward_visible_line (&iter);
			if (_tmp45_) {
				gtk_text_iter_backward_char (&iter);
			}
		}
		_tmp46_ = self->priv->d_view;
		_tmp47_ = iter;
		gtk_text_view_get_line_yrange ((GtkTextView*) _tmp46_, &_tmp47_, &_tmp48_, &_tmp49_);
		y = _tmp48_;
		height = _tmp49_;
		_tmp50_ = self->priv->d_view;
		_tmp51_ = iter;
		gtk_text_view_get_iter_location ((GtkTextView*) _tmp50_, &_tmp51_, &_tmp52_);
		irect = _tmp52_;
		_tmp53_ = self->priv->d_view;
		_tmp54_ = irect;
		_tmp55_ = _tmp54_.x;
		_tmp56_ = irect;
		_tmp57_ = _tmp56_.width;
		_tmp58_ = y;
		gtk_text_view_buffer_to_window_coords ((GtkTextView*) _tmp53_, GTK_TEXT_WINDOW_TEXT, _tmp55_ + _tmp57_, _tmp58_, &_tmp59_, &_tmp60_);
		wx = _tmp59_;
		wy = _tmp60_;
		_tmp61_ = ctx;
		_tmp62_ = wx;
		_tmp63_ = wy;
		_tmp64_ = window_width;
		_tmp65_ = wx;
		_tmp66_ = height;
		cairo_rectangle (_tmp61_, (gdouble) _tmp62_, (gdouble) _tmp63_, (gdouble) (_tmp64_ - _tmp65_), (gdouble) _tmp66_);
		_tmp67_ = ctx;
		_tmp68_ = it;
		_tmp69_ = gee_map_iterator_get_value (_tmp68_);
		_tmp70_ = (GdkRGBA*) _tmp69_;
		_tmp71_ = *_tmp70_;
		gdk_cairo_set_source_rgba (_tmp67_, &_tmp71_);
		_g_free0 (_tmp70_);
		_tmp72_ = ctx;
		cairo_fill (_tmp72_);
	}
	result = FALSE;
	_g_object_unref0 (it);
	_g_object_unref0 (window);
	return result;
}


static void gcp_view_on_buffer_mark_set (GcpView* self, GtkTextIter* location, GtkTextMark* mark) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	GtkTextMark* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (mark != NULL);
	_tmp1_ = self->priv->d_diagnosticsAtEnd;
	_tmp2_ = mark;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = gtk_text_iter_starts_line (location);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GeditDocument* _tmp6_;
		GtkTextMark* _tmp7_;
		GtkTextIter _tmp8_;
		gtk_text_iter_set_line_offset (location, 0);
		_tmp6_ = self->priv->d_buffer;
		_tmp7_ = mark;
		_tmp8_ = *location;
		gtk_text_buffer_move_mark ((GtkTextBuffer*) _tmp6_, _tmp7_, &_tmp8_);
	}
}


static gboolean gcp_view_same_diagnostics (GcpView* self, GcpDiagnostic** first, int first_length1, GcpDiagnostic** second, int second_length1) {
	gboolean result = FALSE;
	GcpDiagnostic** _tmp0_;
	gint _tmp0__length1;
	GcpDiagnostic** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_ = FALSE;
	GcpDiagnostic** _tmp3_;
	gint _tmp3__length1;
	gboolean _tmp5_;
	GcpDiagnostic** _tmp6_;
	gint _tmp6__length1;
	GcpDiagnostic** _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = first;
	_tmp0__length1 = first_length1;
	_tmp1_ = second;
	_tmp1__length1 = second_length1;
	if (_tmp0_ == _tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = first;
	_tmp3__length1 = first_length1;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GcpDiagnostic** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = second;
		_tmp4__length1 = second_length1;
		_tmp2_ = _tmp4_ == NULL;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = first;
	_tmp6__length1 = first_length1;
	_tmp7_ = second;
	_tmp7__length1 = second_length1;
	if (_tmp6__length1 != _tmp7__length1) {
		result = FALSE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				GcpDiagnostic** _tmp12_;
				gint _tmp12__length1;
				GcpDiagnostic** _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				GcpDiagnostic* _tmp15_;
				GcpDiagnostic** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				GcpDiagnostic* _tmp18_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = first;
				_tmp12__length1 = first_length1;
				if (!(_tmp11_ < _tmp12__length1)) {
					break;
				}
				_tmp13_ = first;
				_tmp13__length1 = first_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = second;
				_tmp16__length1 = second_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				if (_tmp15_ != _tmp18_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void __lambda18_ (GcpView* self) {
	_g_object_unref0 (self->priv->d_cursorDiagnosticMessage);
	self->priv->d_cursorDiagnosticMessage = NULL;
}


static void ___lambda18__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda18_ (self);
}


static GcpDiagnostic** _vala_array_dup1 (GcpDiagnostic** self, int length) {
	GcpDiagnostic** result;
	int i;
	result = g_new0 (GcpDiagnostic*, length + 1);
	for (i = 0; i < length; i++) {
		GcpDiagnostic* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gcp_view_update_diagnostic_message (GcpView* self) {
	GcpDocument* _tmp0_;
	GcpDiagnosticSupport* _tmp1_;
	GcpDiagnosticSupport* diag;
	GcpDiagnosticSupport* _tmp2_;
	GtkTextIter iter = {0};
	GeditDocument* _tmp3_;
	GeditDocument* _tmp4_;
	GtkTextMark* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_;
	GcpSourceLocation* _tmp8_;
	GcpSourceLocation* location;
	GcpDiagnosticSupport* _tmp9_;
	GcpSourceLocation* _tmp10_;
	gint _tmp11_ = 0;
	GcpDiagnostic** _tmp12_ = NULL;
	GcpDiagnostic** diagnostics;
	gint diagnostics_length1;
	gint _diagnostics_size_;
	GcpDiagnostic** _tmp13_;
	gint _tmp13__length1;
	GcpDiagnostic** _tmp14_;
	gint _tmp14__length1;
	gboolean _tmp15_ = FALSE;
	GcpDiagnosticMessage* _tmp16_;
	GeditView* _tmp18_;
	GcpDiagnostic** _tmp19_;
	gint _tmp19__length1;
	GcpDiagnosticMessage* _tmp20_;
	GcpDiagnosticMessage* _tmp21_;
	GcpDiagnosticMessage* _tmp22_;
	GcpDiagnosticMessage* _tmp23_;
	GcpDiagnostic** _tmp24_;
	gint _tmp24__length1;
	GcpDiagnostic** _tmp25_;
	gint _tmp25__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp0_) ? ((GcpDiagnosticSupport*) _tmp0_) : NULL);
	diag = _tmp1_;
	_tmp2_ = diag;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (diag);
		return;
	}
	_tmp3_ = self->priv->d_buffer;
	_tmp4_ = self->priv->d_buffer;
	_tmp5_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp4_);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp6_, _tmp5_);
	iter = _tmp6_;
	_tmp7_ = iter;
	_tmp8_ = gcp_source_location_new_iter (&_tmp7_);
	location = _tmp8_;
	_tmp9_ = diag;
	_tmp10_ = location;
	_tmp12_ = gcp_diagnostic_support_find_at (_tmp9_, _tmp10_, &_tmp11_);
	diagnostics = _tmp12_;
	diagnostics_length1 = _tmp11_;
	_diagnostics_size_ = diagnostics_length1;
	_tmp13_ = diagnostics;
	_tmp13__length1 = diagnostics_length1;
	_tmp14_ = self->priv->d_cursorDiagnostics;
	_tmp14__length1 = self->priv->d_cursorDiagnostics_length1;
	_tmp15_ = gcp_view_same_diagnostics (self, _tmp13_, _tmp13__length1, _tmp14_, _tmp14__length1);
	if (_tmp15_) {
		diagnostics = (_vala_array_free (diagnostics, diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (location);
		_g_object_unref0 (diag);
		return;
	}
	_tmp16_ = self->priv->d_cursorDiagnosticMessage;
	if (_tmp16_ != NULL) {
		GcpDiagnosticMessage* _tmp17_;
		_tmp17_ = self->priv->d_cursorDiagnosticMessage;
		gtk_widget_destroy ((GtkWidget*) _tmp17_);
	}
	_tmp18_ = self->priv->d_view;
	_tmp19_ = diagnostics;
	_tmp19__length1 = diagnostics_length1;
	_tmp20_ = gcp_diagnostic_message_new ((GtkSourceView*) _tmp18_, _tmp19_, _tmp19__length1);
	_tmp21_ = g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->d_cursorDiagnosticMessage);
	self->priv->d_cursorDiagnosticMessage = _tmp21_;
	_tmp22_ = self->priv->d_cursorDiagnosticMessage;
	g_signal_connect_object ((GtkWidget*) _tmp22_, "destroy", (GCallback) ___lambda18__gtk_widget_destroy, self, 0);
	_tmp23_ = self->priv->d_cursorDiagnosticMessage;
	gtk_widget_show ((GtkWidget*) _tmp23_);
	_tmp24_ = diagnostics;
	_tmp24__length1 = diagnostics_length1;
	_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup1 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
	_tmp25__length1 = _tmp24__length1;
	self->priv->d_cursorDiagnostics = (_vala_array_free (self->priv->d_cursorDiagnostics, self->priv->d_cursorDiagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_cursorDiagnostics = _tmp25_;
	self->priv->d_cursorDiagnostics_length1 = _tmp25__length1;
	self->priv->_d_cursorDiagnostics_size_ = self->priv->d_cursorDiagnostics_length1;
	diagnostics = (_vala_array_free (diagnostics, diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (location);
	_g_object_unref0 (diag);
}


static GcpSourceRange* gcp_view_highlight_range (GcpView* self, GcpSemanticValue* val) {
	GcpSourceRange* result = NULL;
	GcpSemanticValue* _tmp0_;
	GcpSourceRange* _tmp1_;
	GcpSourceRange* _tmp2_;
	GcpSourceRange* range;
	gboolean _tmp3_ = FALSE;
	GcpSemanticValue* _tmp4_;
	GcpSemanticValueKind _tmp5_;
	GcpSemanticValueKind _tmp6_;
	gboolean _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = val;
	_tmp1_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp0_);
	_tmp2_ = _tmp1_;
	range = _tmp2_;
	_tmp4_ = val;
	_tmp5_ = gcp_semantic_value_get_kind (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == GCP_SEMANTIC_VALUE_KIND_FUNCTION) {
		GcpSemanticValue* _tmp7_;
		GcpSemanticValueReferenceType _tmp8_;
		GcpSemanticValueReferenceType _tmp9_;
		_tmp7_ = val;
		_tmp8_ = gcp_semantic_value_get_reference_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = (_tmp9_ & GCP_SEMANTIC_VALUE_REFERENCE_TYPE_DEFINITION) != 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = _tmp3_;
	if (_tmp10_) {
		GcpSemanticValue* _tmp11_;
		GcpSemanticValue* _tmp12_ = NULL;
		GcpSemanticValue* par;
		GcpSemanticValue* _tmp13_;
		_tmp11_ = val;
		_tmp12_ = gcp_semantic_value_find_child (_tmp11_, GCP_SEMANTIC_VALUE_KIND_PARAMETER);
		par = _tmp12_;
		_tmp13_ = par;
		if (_tmp13_ != NULL) {
			GcpSemanticValue* _tmp14_;
			GcpSourceRange* _tmp15_;
			GcpSourceRange* _tmp16_;
			GcpSourceRange* _tmp17_;
			GcpSourceLocation* _tmp18_;
			GcpSourceLocation* _tmp19_;
			GcpSourceLocation* _tmp20_ = NULL;
			GcpSourceLocation* _tmp21_;
			GcpSourceLocation* paramstart;
			GcpSourceLocation* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			GcpSourceLocation* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GcpSourceLocation* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GcpSourceLocation* _tmp31_;
			GcpSemanticValue* _tmp32_;
			GcpSourceRange* _tmp33_;
			GcpSourceRange* _tmp34_;
			GcpSourceRange* _tmp35_;
			GcpSourceLocation* _tmp36_;
			GcpSourceLocation* _tmp37_;
			GcpSourceLocation* _tmp38_ = NULL;
			GcpSourceLocation* _tmp39_;
			GcpSourceLocation* _tmp40_;
			GcpSourceRange* _tmp41_;
			_tmp14_ = par;
			_tmp15_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			_tmp18_ = gcp_source_range_get_start (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = gcp_source_location_copy (_tmp19_);
			_tmp21_ = _tmp20_;
			_g_object_unref0 (_tmp17_);
			paramstart = _tmp21_;
			_tmp22_ = paramstart;
			_tmp23_ = gcp_source_location_get_file (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = paramstart;
			_tmp26_ = gcp_source_location_get_line (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = paramstart;
			_tmp29_ = gcp_source_location_get_column (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = gcp_source_location_new (_tmp24_, _tmp27_, _tmp30_ - 1);
			_g_object_unref0 (paramstart);
			paramstart = _tmp31_;
			_tmp32_ = val;
			_tmp33_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			_tmp36_ = gcp_source_range_get_start (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = gcp_source_location_copy (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = paramstart;
			_tmp41_ = gcp_source_range_new (_tmp39_, _tmp40_);
			_g_object_unref0 (range);
			range = _tmp41_;
			_g_object_unref0 (_tmp39_);
			_g_object_unref0 (_tmp35_);
			_g_object_unref0 (paramstart);
		}
		_g_object_unref0 (par);
	}
	result = range;
	return result;
}


static void gcp_view_mark_reference (GcpView* self, GcpSemanticValue* val) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcpSemanticValue* _tmp0_;
	GcpSourceRange* _tmp1_ = NULL;
	GcpSourceRange* range;
	GcpDocument* _tmp2_;
	GcpSourceRange* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GcpScrollbarMarker* _tmp11_;
	guint _tmp12_;
	GcpSourceRange* _tmp13_;
	GdkRGBA _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val;
	_tmp1_ = gcp_view_highlight_range (self, _tmp0_);
	range = _tmp1_;
	_tmp2_ = self->priv->d_document;
	_tmp3_ = range;
	_tmp6_ = gcp_document_source_range (_tmp2_, _tmp3_, &_tmp4_, &_tmp5_);
	start = _tmp4_;
	end = _tmp5_;
	if (_tmp6_) {
		GeditDocument* _tmp7_;
		GtkTextTag* _tmp8_;
		GtkTextIter _tmp9_;
		GtkTextIter _tmp10_;
		_tmp7_ = self->priv->d_buffer;
		_tmp8_ = self->priv->d_semanticTag;
		_tmp9_ = start;
		_tmp10_ = end;
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
	}
	_tmp11_ = self->priv->d_scrollbarMarker;
	_tmp12_ = self->priv->d_lastMergeId;
	_tmp13_ = range;
	_tmp14_ = self->priv->d_refColor;
	gcp_scrollbar_marker_add_with_id (_tmp11_, _tmp12_, _tmp13_, &_tmp14_);
	_g_object_unref0 (range);
}


static void gcp_view_mark_references (GcpView* self, GcpSemanticValue** refs, int refs_length1) {
	GcpSemanticValue** _tmp0_;
	gint _tmp0__length1;
	GcpScrollbarMarker* _tmp1_;
	guint _tmp2_ = 0U;
	GcpSemanticValue** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = refs;
	_tmp0__length1 = refs_length1;
	if (_tmp0__length1 <= 1) {
		return;
	}
	_tmp1_ = self->priv->d_scrollbarMarker;
	_tmp2_ = gcp_scrollbar_marker_new_merge_id (_tmp1_);
	self->priv->d_lastMergeId = _tmp2_;
	_tmp3_ = refs;
	_tmp3__length1 = refs_length1;
	{
		GcpSemanticValue** r_collection = NULL;
		gint r_collection_length1 = 0;
		gint _r_collection_size_ = 0;
		gint r_it = 0;
		r_collection = _tmp3_;
		r_collection_length1 = _tmp3__length1;
		for (r_it = 0; r_it < _tmp3__length1; r_it = r_it + 1) {
			GcpSemanticValue* _tmp4_;
			GcpSemanticValue* r = NULL;
			_tmp4_ = _g_object_ref0 (r_collection[r_it]);
			r = _tmp4_;
			{
				GcpSemanticValue* _tmp5_;
				_tmp5_ = r;
				gcp_view_mark_reference (self, _tmp5_);
				_g_object_unref0 (r);
			}
		}
	}
}


static void gcp_view_remove_references (GcpView* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	guint _tmp0_;
	GtkTextTag* _tmp3_;
	GeditDocument* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	GeditDocument* _tmp7_;
	GtkTextTag* _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_lastMergeId;
	if (_tmp0_ != ((guint) 0)) {
		GcpScrollbarMarker* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->d_scrollbarMarker;
		_tmp2_ = self->priv->d_lastMergeId;
		gcp_scrollbar_marker_remove (_tmp1_, _tmp2_);
		self->priv->d_lastMergeId = (guint) 0;
	}
	_tmp3_ = self->priv->d_semanticTag;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->d_buffer;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, &_tmp6_);
	start = _tmp5_;
	end = _tmp6_;
	_tmp7_ = self->priv->d_buffer;
	_tmp8_ = self->priv->d_semanticTag;
	_tmp9_ = start;
	_tmp10_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) _tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GcpView * self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->ret);
		_g_object_unref0 (_data3_->loc);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda19_ (Block3Data* _data3_, GcpSourceIndex* semantics) {
	GcpView * self;
	GcpSourceIndex* _tmp0_;
	GcpSourceLocation* _tmp1_;
	gpointer _tmp2_ = NULL;
	self = _data3_->self;
	g_return_if_fail (semantics != NULL);
	_tmp0_ = semantics;
	_tmp1_ = _data3_->loc;
	_tmp2_ = gcp_source_index_find_inner_at (_tmp0_, _tmp1_);
	_g_object_unref0 (_data3_->ret);
	_data3_->ret = (GcpSemanticValue*) _tmp2_;
}


static void ___lambda19__gcp_semantic_value_support_with_semantic_value_callback (GcpSourceIndex* diagnostics, gpointer self) {
	__lambda19_ (self, diagnostics);
}


static GcpSemanticValue* gcp_view_semantic_value_at_cursor (GcpView* self) {
	GcpSemanticValue* result = NULL;
	Block3Data* _data3_;
	GcpDocument* _tmp0_;
	GcpSemanticValueSupport* _tmp1_;
	GcpSemanticValueSupport* sem;
	GcpSemanticValueSupport* _tmp2_;
	GtkTextIter iter = {0};
	GeditDocument* _tmp3_;
	GeditDocument* _tmp4_;
	GtkTextMark* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_;
	GcpSourceLocation* _tmp8_;
	GcpSemanticValueSupport* _tmp9_;
	GcpSemanticValue* _tmp10_;
	GcpSemanticValue* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = _g_object_ref0 (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp0_) ? ((GcpSemanticValueSupport*) _tmp0_) : NULL);
	sem = _tmp1_;
	_tmp2_ = sem;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (sem);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp3_ = self->priv->d_buffer;
	_tmp4_ = self->priv->d_buffer;
	_tmp5_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp4_);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp6_, _tmp5_);
	iter = _tmp6_;
	_tmp7_ = iter;
	_tmp8_ = gcp_source_location_new_iter (&_tmp7_);
	_data3_->loc = _tmp8_;
	_data3_->ret = NULL;
	_tmp9_ = sem;
	gcp_semantic_value_support_with_semantics (_tmp9_, ___lambda19__gcp_semantic_value_support_with_semantic_value_callback, _data3_);
	_tmp10_ = _data3_->ret;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	result = _tmp11_;
	_g_object_unref0 (sem);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


static GcpSemanticValue** gcp_view_references_at_cursor (GcpView* self, GcpSemanticValue** val, gint* vidx, int* result_length1) {
	GcpSemanticValue* _vala_val = NULL;
	gint _vala_vidx = 0;
	GcpSemanticValue** result = NULL;
	GcpSemanticValue* _tmp0_ = NULL;
	GcpSemanticValue* _tmp1_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* refs;
	GeeLinkedList* _tmp35_;
	GcpSemanticValue* _tmp36_;
	GeeLinkedList* _tmp37_;
	GeeLinkedList* _tmp38_;
	gint _tmp39_ = 0;
	gpointer* _tmp40_ = NULL;
	GcpSemanticValue** ret;
	gint ret_length1;
	gint _ret_size_;
	GcpSemanticValue** _tmp51_;
	gint _tmp51__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_vidx = -1;
	_tmp0_ = gcp_view_semantic_value_at_cursor (self);
	_g_object_unref0 (_vala_val);
	_vala_val = _tmp0_;
	_tmp1_ = _vala_val;
	if (_tmp1_ == NULL) {
		GcpSemanticValue** _tmp2_ = NULL;
		GcpSemanticValue** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (GcpSemanticValue*, 0 + 1);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		if (val) {
			*val = _vala_val;
		} else {
			_g_object_unref0 (_vala_val);
		}
		if (vidx) {
			*vidx = _vala_vidx;
		}
		return result;
	}
	_tmp4_ = gee_linked_list_new (GCP_TYPE_SEMANTIC_VALUE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	refs = _tmp4_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				GcpSemanticValue* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GcpSemanticValue* _tmp12_;
				gint _tmp13_;
				GcpSemanticValue* _tmp14_ = NULL;
				GcpSemanticValue* r;
				GcpSemanticValue* _tmp15_;
				GcpSourceRange* _tmp16_;
				GcpSourceRange* _tmp17_;
				GcpSourceRange* _tmp18_;
				GcpSourceLocation* _tmp19_;
				GcpSourceLocation* _tmp20_;
				GFile* _tmp21_;
				GFile* _tmp22_;
				GFile* _tmp23_;
				GFile* _tmp24_;
				GFile* f;
				gboolean _tmp25_ = FALSE;
				GFile* _tmp26_;
				gboolean _tmp32_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = _vala_val;
				_tmp10_ = gcp_semantic_value_get_num_references (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(_tmp8_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _vala_val;
				_tmp13_ = i;
				_tmp14_ = gcp_semantic_value_reference (_tmp12_, _tmp13_);
				r = _tmp14_;
				_tmp15_ = r;
				_tmp16_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_;
				_tmp19_ = gcp_source_range_get_start (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gcp_source_location_get_file (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp18_);
				f = _tmp24_;
				_tmp26_ = f;
				if (_tmp26_ != NULL) {
					GFile* _tmp27_;
					GcpDocument* _tmp28_;
					GFile* _tmp29_;
					GFile* _tmp30_;
					gboolean _tmp31_ = FALSE;
					_tmp27_ = f;
					_tmp28_ = self->priv->d_document;
					_tmp29_ = gcp_document_get_location (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_file_equal (_tmp27_, _tmp30_);
					_tmp25_ = _tmp31_;
				} else {
					_tmp25_ = FALSE;
				}
				_tmp32_ = _tmp25_;
				if (_tmp32_) {
					GeeLinkedList* _tmp33_;
					GcpSemanticValue* _tmp34_;
					_tmp33_ = refs;
					_tmp34_ = r;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
				}
				_g_object_unref0 (f);
				_g_object_unref0 (r);
			}
		}
	}
	_tmp35_ = refs;
	_tmp36_ = _vala_val;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
	_tmp37_ = refs;
	gee_list_sort ((GeeList*) _tmp37_, (GCompareFunc) gcp_view_compare_ranges);
	_tmp38_ = refs;
	_tmp40_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp38_, &_tmp39_);
	ret = _tmp40_;
	ret_length1 = _tmp39_;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp41_;
			_tmp41_ = TRUE;
			while (TRUE) {
				gboolean _tmp42_;
				gint _tmp44_;
				GcpSemanticValue** _tmp45_;
				gint _tmp45__length1;
				GcpSemanticValue** _tmp46_;
				gint _tmp46__length1;
				gint _tmp47_;
				GcpSemanticValue* _tmp48_;
				GcpSemanticValue* _tmp49_;
				_tmp42_ = _tmp41_;
				if (!_tmp42_) {
					gint _tmp43_;
					_tmp43_ = i;
					i = _tmp43_ + 1;
				}
				_tmp41_ = FALSE;
				_tmp44_ = i;
				_tmp45_ = ret;
				_tmp45__length1 = ret_length1;
				if (!(_tmp44_ < _tmp45__length1)) {
					break;
				}
				_tmp46_ = ret;
				_tmp46__length1 = ret_length1;
				_tmp47_ = i;
				_tmp48_ = _tmp46_[_tmp47_];
				_tmp49_ = _vala_val;
				if (_tmp48_ == _tmp49_) {
					gint _tmp50_;
					_tmp50_ = i;
					_vala_vidx = _tmp50_;
					break;
				}
			}
		}
	}
	_tmp51_ = ret;
	_tmp51__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp51__length1;
	}
	result = _tmp51_;
	_g_object_unref0 (refs);
	if (val) {
		*val = _vala_val;
	} else {
		_g_object_unref0 (_vala_val);
	}
	if (vidx) {
		*vidx = _vala_vidx;
	}
	return result;
}


static gint gcp_view_compare_ranges (GcpSemanticValue* a, GcpSemanticValue* b) {
	gint result = 0;
	GcpSemanticValue* _tmp0_;
	GcpSourceRange* _tmp1_;
	GcpSourceRange* _tmp2_;
	GcpSourceRange* _tmp3_;
	GcpSemanticValue* _tmp4_;
	GcpSourceRange* _tmp5_;
	GcpSourceRange* _tmp6_;
	GcpSourceRange* _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp9_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = gcp_source_range_compare_to (_tmp3_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp3_);
	result = _tmp9_;
	return result;
}


static void gcp_view_update_references (GcpView* self) {
	GcpDocument* _tmp0_;
	GcpSemanticValueSupport* _tmp1_;
	GcpSemanticValueSupport* sem;
	GcpSemanticValueSupport* _tmp2_;
	GcpSemanticValue* v = NULL;
	gint vidx = 0;
	GcpSemanticValue* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GcpSemanticValue** _tmp6_ = NULL;
	GcpSemanticValue** refs;
	gint refs_length1;
	gint _refs_size_;
	GcpSemanticValue* _tmp7_;
	GcpSemanticValue* _tmp8_;
	GcpSemanticValue* _tmp9_;
	GcpSemanticValue* _tmp10_;
	GcpSemanticValue* _tmp11_;
	GcpSemanticValue* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = _g_object_ref0 (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp0_) ? ((GcpSemanticValueSupport*) _tmp0_) : NULL);
	sem = _tmp1_;
	_tmp2_ = sem;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (sem);
		return;
	}
	_tmp6_ = gcp_view_references_at_cursor (self, &_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (v);
	v = _tmp3_;
	vidx = _tmp4_;
	refs = _tmp6_;
	refs_length1 = _tmp5_;
	_refs_size_ = refs_length1;
	_tmp7_ = v;
	_tmp8_ = self->priv->d_semanticValue;
	if (_tmp7_ == _tmp8_) {
		refs = (_vala_array_free (refs, refs_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (v);
		_g_object_unref0 (sem);
		return;
	}
	_tmp9_ = self->priv->d_semanticValue;
	if (_tmp9_ != NULL) {
		gcp_view_remove_references (self);
	}
	_tmp10_ = v;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->d_semanticValue);
	self->priv->d_semanticValue = _tmp11_;
	_tmp12_ = self->priv->d_semanticValue;
	if (_tmp12_ != NULL) {
		GcpSemanticValue** _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = refs;
		_tmp13__length1 = refs_length1;
		gcp_view_mark_references (self, _tmp13_, _tmp13__length1);
	}
	refs = (_vala_array_free (refs, refs_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (v);
	_g_object_unref0 (sem);
}


static void gcp_view_on_cursor_diagnostics_moved (GcpView* self) {
	g_return_if_fail (self != NULL);
	gcp_view_update_diagnostic_message (self);
}


static void gcp_view_on_cursor_semantics_moved (GcpView* self) {
	g_return_if_fail (self != NULL);
	gcp_view_update_references (self);
}


static gboolean gcp_view_on_view_key_press (GcpView* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GtkBindingSet* _tmp0_;
	GtkBindingSet* _tmp1_;
	GdkEventKey _tmp2_;
	guint _tmp3_;
	GdkEventKey _tmp4_;
	GdkModifierType _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gcp_view_s_bindingSet;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gcp_view_s_bindingSet;
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.state;
	_tmp6_ = gtk_binding_set_activate (_tmp1_, _tmp3_, _tmp5_, (GObject*) self);
	result = _tmp6_;
	return result;
}


static gboolean gcp_view_real_find_definition (GcpView* self) {
	gboolean result = FALSE;
	GcpSemanticValue* _tmp0_ = NULL;
	GcpSemanticValue* v;
	GcpSemanticValue* _tmp1_;
	GcpSemanticValue* _tmp2_;
	GcpSemanticValueReferenceType _tmp3_;
	GcpSemanticValueReferenceType _tmp4_;
	GcpSemanticValue* _tmp5_;
	GcpSemanticValue* _tmp6_;
	GcpSemanticValue* _tmp7_;
	GcpSemanticValue* _tmp8_;
	_tmp0_ = gcp_view_semantic_value_at_cursor (self);
	v = _tmp0_;
	_tmp1_ = v;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (v);
		return result;
	}
	_tmp2_ = v;
	_tmp3_ = gcp_semantic_value_get_reference_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if ((_tmp4_ & GCP_SEMANTIC_VALUE_REFERENCE_TYPE_DEFINITION) != 0) {
		result = TRUE;
		_g_object_unref0 (v);
		return result;
	}
	_tmp5_ = v;
	_tmp6_ = gcp_semantic_value_get_definition (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gcp_view_move_cursor_to_semantic_value (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	result = TRUE;
	_g_object_unref0 (v);
	return result;
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}


static gboolean gcp_view_real_find_reference (GcpView* self, gint direction) {
	gboolean result = FALSE;
	GcpDocument* _tmp0_;
	GcpSemanticValueSupport* _tmp1_;
	GcpSemanticValueSupport* sem;
	GcpSemanticValueSupport* _tmp2_;
	GcpSemanticValue* v = NULL;
	gint vidx = 0;
	GcpSemanticValue* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GcpSemanticValue** _tmp6_ = NULL;
	GcpSemanticValue** refs;
	gint refs_length1;
	gint _refs_size_;
	gboolean _tmp7_ = FALSE;
	GcpSemanticValue* _tmp8_;
	gboolean _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GcpSemanticValue** _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	GcpSemanticValue** _tmp17_;
	gint _tmp17__length1;
	gint _tmp18_;
	GcpSemanticValue* _tmp19_;
	_tmp0_ = self->priv->d_document;
	_tmp1_ = _g_object_ref0 (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp0_) ? ((GcpSemanticValueSupport*) _tmp0_) : NULL);
	sem = _tmp1_;
	_tmp2_ = sem;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (sem);
		return result;
	}
	_tmp6_ = gcp_view_references_at_cursor (self, &_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (v);
	v = _tmp3_;
	vidx = _tmp4_;
	refs = _tmp6_;
	refs_length1 = _tmp5_;
	_refs_size_ = refs_length1;
	_tmp8_ = v;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		GcpSemanticValue** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = refs;
		_tmp9__length1 = refs_length1;
		_tmp7_ = _tmp9__length1 <= 1;
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		result = TRUE;
		refs = (_vala_array_free (refs, refs_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (v);
		_g_object_unref0 (sem);
		return result;
	}
	_tmp11_ = vidx;
	_tmp12_ = direction;
	_tmp13_ = refs;
	_tmp13__length1 = refs_length1;
	vidx = (_tmp11_ + _tmp12_) % _tmp13__length1;
	_tmp14_ = vidx;
	if (_tmp14_ < 0) {
		GcpSemanticValue** _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_;
		_tmp15_ = refs;
		_tmp15__length1 = refs_length1;
		_tmp16_ = vidx;
		vidx = _tmp15__length1 + _tmp16_;
	}
	_tmp17_ = refs;
	_tmp17__length1 = refs_length1;
	_tmp18_ = vidx;
	_tmp19_ = _tmp17_[_tmp18_];
	gcp_view_move_cursor_to_semantic_value (self, _tmp19_);
	result = TRUE;
	refs = (_vala_array_free (refs, refs_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (v);
	_g_object_unref0 (sem);
	return result;
}


static void g_cclosure_user_marshal_BOOLEAN__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT) (gpointer data1, gint arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void gcp_view_class_init (GcpViewClass * klass) {
	GtkBindingSet* _tmp0_ = NULL;
	gcp_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpViewPrivate));
	GCP_VIEW_CLASS (klass)->find_definition = gcp_view_real_find_definition;
	GCP_VIEW_CLASS (klass)->find_reference = gcp_view_real_find_reference;
	G_OBJECT_CLASS (klass)->finalize = gcp_view_finalize;
	g_signal_new ("find_definition", GCP_TYPE_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GcpViewClass, find_definition), NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	g_signal_new ("find_reference", GCP_TYPE_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GcpViewClass, find_reference), NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT, G_TYPE_BOOLEAN, 1, G_TYPE_INT);
	_tmp0_ = gtk_binding_set_find ("GcpViewBindings");
	gcp_view_s_bindingSet = _tmp0_;
}


static void gcp_view_instance_init (GcpView * self) {
	self->priv = GCP_VIEW_GET_PRIVATE (self);
}


static void gcp_view_finalize (GObject* obj) {
	GcpView * self;
	self = GCP_VIEW (obj);
	_g_object_unref0 (self->priv->d_buffer);
	_g_object_unref0 (self->priv->d_backend);
	_g_object_unref0 (self->priv->d_document);
	_gcp_diagnostic_tags_unref0 (self->priv->d_tags);
	_gcp_scrollbar_marker_unref0 (self->priv->d_scrollbarMarker);
	_g_object_unref0 (self->priv->d_diagnosticsAtEnd);
	self->priv->d_cursorDiagnostics = (_vala_array_free (self->priv->d_cursorDiagnostics, self->priv->d_cursorDiagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->d_cursorDiagnosticMessage);
	_g_object_unref0 (self->priv->d_semanticValue);
	_g_object_unref0 (self->priv->d_semanticTag);
	G_OBJECT_CLASS (gcp_view_parent_class)->finalize (obj);
}


GType gcp_view_get_type (void) {
	return gcp_view_type_id;
}


GType gcp_view_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpView), 0, (GInstanceInitFunc) gcp_view_instance_init, NULL };
	gcp_view_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpView", &g_define_type_info, 0);
	return gcp_view_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



