/* Copyright 2012 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution. 
 */

// Trash generally is the same as other mail folders, but it doesn't support key features,
// like archiving.
//
// Service-specific accounts can use this or subclass it for further customization

private class Geary.ImapEngine.GenericTrashFolder : GenericFolder, Geary.FolderSupportsRemove {
    public GenericTrashFolder(GenericAccount account, Imap.Account remote, ImapDB.Account local,
        ImapDB.Folder local_folder, SpecialFolderType special_folder_type) {
        base (account, remote, local, local_folder, special_folder_type);
    }
    
    public async void remove_email_async(Gee.List<Geary.EmailIdentifier> email_ids,
        Cancellable? cancellable = null) throws Error {
        yield expunge_email_async(email_ids, cancellable);
    }
}

