// $Id: value.h,v 1.4 2002/02/17 18:53:39 murrayc Exp $ -*- c++ -*-

/* value.h
 *
 * Copyright (C) 2000-2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GCONFMM_VALUE_H
#define GCONFMM_VALUE_H

extern "C"
{
#include <gconf/gconf-value.h>
}

#include <glibmm/sarray.h>
#include <list>
#include <utility> // for std::pair

namespace Gnome
{

namespace Conf
{

class Schema;

class Value;

typedef GConfValueType ValueType;
typedef std::pair<Value, Value> ValuePair;    
typedef std::pair<ValueType, ValueType> ValueTypePair;
    
class Value
{
public:
  Value(GConfValueType type = GCONF_VALUE_INVALID);
  explicit Value(const GConfValue* pValue);
  Value(const Value& src);
  Value::~Value();

  Value& operator=(const Value& src);

  void set(gint val);
  void set(const Glib::ustring& val);
  void set(gdouble val);
  void set(bool val);
  void set(const Schema& sc);
  void set_car(const Value& car);
  void set_cdr(const Value& cdr);


  typedef std::list<gdouble> type_list_float;
  typedef std::list<int> type_list_int;
  typedef std::list<bool> type_list_bool;
  typedef std::list<Schema> type_list_schema;

  //It looks like the set(list) methods can only be
  //used once on a new Value(GCONF_VALUE_LIST).
  void set(const Glib::SArray& array);
  void set(const type_list_int& list);
  void set(const type_list_bool& list);
  void set(const type_list_float& list);
  void set(const type_list_schema& list);


  GConfValueType get_type() const;

  Glib::ustring get_string() const;
  gint get_int() const;
  gdouble get_float() const;
  bool get_bool() const;
  Value get_car() const;
  Value get_cdr() const;
  const void get_schema(Schema& schema) const; //Can't return by value, because of #include loops.

  GConfValueType get_list_type() const;

  type_list_float get_list_of_floats() const;
  type_list_int get_list_of_ints() const;
  type_list_bool get_list_of_bools() const;
  void get_list_of_schemas(type_list_schema& list) const;
  Glib::SArray get_list_of_strings() const;


  Glib::ustring to_string() const;

  GConfValue* Value::gobj();
  const GConfValue* Value::gobj() const;

protected:
  void clear();

  GConfValue* m_pValue;
};


} /* namespace Conf */
} /* namespace Gnome */

#endif //GCONFMM_VALUE_H
