%define ver      0.0.16
%define prefix   /usr

Summary: gb library
Name: gb
Version: %ver
Release: 1
Copyright: LGPL
Group: X11/Libraries
Source: gb-%{ver}.tar.gz
BuildRoot: /var/tmp/gb-%{PACKAGE_VERSION}-root
Provides: libgb.so.0

Docdir: %{prefix}/doc

%description
This is GB

%package devel
Summary: Libraries, includes, etc to develop gb applications
Group: X11/libraries
Requires: gb

%description devel
Libraries, include files, etc you can use to develop gb applications.

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
%ifarch alpha
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --host=alpha-redhat-linux --prefix=%prefix --sysconfdir=/etc --without-runtime-debug
%else
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix --sysconfdir=/etc --without-runtime-debug
%endif
else
%ifarch alpha
  CFLAGS="$RPM_OPT_FLAGS" ./configure --host=alpha-redhat-linux --prefix=%prefix --sysconfdir=/etc --without-runtime-debug
%else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --sysconfdir=/etc --without-runtime-debug
%endif
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

# Note how DESTDIR is passed. Using prefix=$RPM_BUILD_ROOT%{prefix} instaead
# nearly worked, but problems occured for /etc/CORBA/servers, where prefix
# was ignored completely.
make -k DESTDIR=$RPM_BUILD_ROOT prefix=%{prefix} install


%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS ChangeLog NEWS README COPYING TODO
%{prefix}/lib/lib*.so.*

%files devel
%defattr(-, root, root)

%{prefix}/lib/lib*.so
%{prefix}/lib/*a
%{prefix}/lib/*.sh
%{prefix}/include/*
