/*
 * GNOME Basic Text Box.
 *
 * Author:
 *	Frank Chiulli (fc-linux@home.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */
#include "gbrun-form-item.h"

#define ITEM_NAME "gb-vb.textbox"


enum {
	ARG_FIRST = 0,
	LOCKED,
	TOOLTIP_TEXT,
	TEXT,
	ALIGNMENT
};

#define GBRUN_TEXTBOX(obj) (GTK_CHECK_CAST ((obj), gbrun_textbox_get_type (), GBRunTextBox))

typedef struct {
	GBRunFormItem   item;

	gboolean        locked;
} GBRunTextBox;

/*
 * _GBETextBox defines a VB Text Box
 *
 * alignment		Determines whether the text box's text appears left-
 *			justified, centered, or right-justified with the
 *			text box's boundaries.
 * back_color		Specifies the text box's background color.
 * border_style		Determines whether a single-line border appears
 *			around the text box.
 * enabled		Determines whether the text box is active.
 * font		 	Text's font name, style and size.
 * height		The height of the text box's outline in twips.
 * left			The number of twips from the text box's left edge to
 *			the Form window's left edge.
 * locked		Determines whether the user can edit the text inside 
 *			the text box.
 * max_length		Specifies the number of characters the user can type
 *			into the text box.
 * mouse_ptr		The shape of the mouse cursor when the user moves the 
 *			mouse over the text box.
 * multi_line		Lets the text box hold multiple lines of text or sets
 *			the text box to hold only a single line of text.
 * pwd_char		Determines the character that appears in the text box
 *			when the user enters a password, which keeps prying
 *			eyes from knowing what the user enters into the box.
 * scroll_bars		Determines whether scrollbars appear on the edges of a
 *			multiline text box.
 * tab_index		Specifies the order of the text box in the focus order.
 * tab_stop		Determines whether the text box can receive the focus.
 * text			Holds the value of the text inside the text box.
 * tool_tip_text		Holds the text that appears as a ToolTip at runtime.
 * top			Holds the number of twips from the text box's top edge
 *			to the Form window's top edge.
 * visible		Determines whether the text box appears or is hidden
 *			from the user.
 * width		The width of the text box in twips.
 *
 * text_box
 *
 * Definitions:
 * twip		1,440th of an inch (the smallest screen measurement)
 */

struct _GBETextBox {
/*	guint8		 alignment;
	guint32		 back_color;
	guint8		 border_style;
	gboolean	 enabled;
	GBEFormFont	 font;
	guint32		 fore_color;
	guint16		 height;
	guint16		 left;
	gboolean	 locked;
	guint16		 max_length;
	guint8		 mouse_ptr;
	gboolean	 multi_line;
	gchar		 pwd_vhar;
	gboolean	 scroll_bars;
	guint8		 tab_index;
	guint8		 tab_stop;
	gchar		*text;
	gchar		*tool_tip_text;
	guint16		 top;
	gboolean	 visible;
	guint16		 width;

	GtkWidget	*text_box;*/
};



/**
 * textbox_setarg
 *
 **/
static gboolean
textbox_setarg (GBRunEvalContext *ec,
		GBRunObject      *object,
		int               property,
		GBValue          *val)
{
	GBRunTextBox *textbox = GBRUN_TEXTBOX (object);
	GtkEntry     *entry = GTK_ENTRY (
		gbrun_form_item_get_widget (GBRUN_FORM_ITEM (object)));

	g_return_val_if_fail (textbox != NULL, FALSE);

	switch (property) {
	case LOCKED:
		textbox->locked = (val->v.i == VB_FALSE);
		gtk_entry_set_editable (entry, 
		                        textbox->locked);
		return TRUE;

	case TOOLTIP_TEXT: {
		GtkTooltips *t = gtk_tooltips_new();
		gtk_tooltips_set_tip (t, GTK_WIDGET (entry), 
		                      val->v.s->str, NULL);
		return TRUE;
	}

	case TEXT: 
		gtk_entry_set_editable (entry, TRUE);
		gtk_entry_set_text (entry, val->v.s->str);
		gtk_entry_set_editable (entry, textbox->locked);
		return TRUE;

	case ALIGNMENT: {
		static gboolean warned = FALSE;
		if (!warned) {
			g_warning ("GtkEntry alignment unsupported");
			warned = TRUE;
		}

		return TRUE;
	}

	default:
		g_warning ("Unhandled property '%d'", property);
		return FALSE;
	}
}


/**
 * textbox_getarg:
 *   @ec
 *   @object
 *   @property
 **/
static GBValue *
textbox_getarg (GBRunEvalContext *ec,
		GBRunObject      *object,
		int               property)
{
	GBRunTextBox *textbox = GBRUN_TEXTBOX (object);
	GtkEntry     *entry = GTK_ENTRY (
		gbrun_form_item_get_widget (GBRUN_FORM_ITEM (object)));

	g_return_val_if_fail (textbox != NULL, NULL);

	switch (property) {
	case LOCKED:
		return gb_value_new_boolean (textbox->locked);

	case TEXT:
		return gb_value_new_string_chars (
			gtk_entry_get_text (entry));

	default:
		g_warning ("Unhandled property '%d'", property);
		return NULL;
	}
}

static void
gbrun_textbox_construct (GBRunEvalContext *ec, GBRunFormItem *item)
{
	GBRunTextBox *dest = GBRUN_TEXTBOX (item);

	gbrun_form_item_set_widget (item, gtk_entry_new ());
	dest->locked = FALSE;
}

static void
gbrun_textbox_class_init (GBRunObjectClass *klass)
{
	GBRunFormItemClass *form_class   = (GBRunFormItemClass *) klass;

	klass->set_arg = textbox_setarg;
	klass->get_arg = textbox_getarg;

	gbrun_object_add_property (klass, "locked", 
				   gb_type_int, LOCKED);

	gbrun_object_add_property (klass, "tooltiptext",
				   gb_type_string, TOOLTIP_TEXT);

        gbrun_object_add_property (klass, "text",
				   gb_type_string, TEXT);

	gbrun_object_add_property (klass, "alignment",
				   gb_type_int, ALIGNMENT);

	form_class->construct = gbrun_textbox_construct;
}

GtkType
gbrun_textbox_get_type (void)
{
	static GtkType object_type = 0;

	if (!object_type) {
		static const GtkTypeInfo object_info = {
			ITEM_NAME,
			sizeof (GBRunTextBox),
			sizeof (GBRunFormItemClass),
			(GtkClassInitFunc)  gbrun_textbox_class_init,
			(GtkObjectInitFunc) NULL,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		object_type = gtk_type_unique (GBRUN_TYPE_FORM_ITEM, &object_info);
		gtk_type_class (object_type);
	}

	return object_type;	
}

/**
 * gbrun_textbox_register
 *
 **/
void
gbrun_textbox_register ()
{
	gbrun_textbox_get_type ();	
}


/**
 * gbrun_textbox_shutdown
 *
 **/
void
gbrun_textbox_shutdown ()
{
}
