/* ANSI-C code produced by gperf version 2.7 */
/* Command-line: gperf -k 1-5,$ -t -L ANSI-C -l -C -c -N keywords_lookup keywords.gperf  */
/*
 * Gnome Basic keywords.
 *
 * Author:
 *     Jody Goldberg(jgoldberg@home.com)
 */
#include <glib.h>
#include "gb-statement.h"
#include "gb-expr.h"
#include "grammar.h"
#include <string.h>
#include <ctype.h>
struct GBKeyword { char const * const name; int const id; };

#define TOTAL_KEYWORDS 101
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 13
#define MIN_HASH_VALUE 3
#define MAX_HASH_VALUE 439
/* maximum key range = 437, duplicates = 0 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440,  30,  20,  85,  95,   0,
       40,  60, 440,  70, 440,  10, 125,   0,  25, 105,
       77, 440, 115,   0,   5,   0,   0,  35,   5, 440,
      440, 440, 440, 440, 440, 440, 440,   0,  20,   0,
       15,   0,  35,  25,   5,   0, 440,  10,  10,   0,
       45, 125,   0,  10,   0,   5,   0,   0,   5,  10,
        7,  90, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440, 440, 440, 440, 440,
      440, 440, 440, 440, 440, 440
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 5:
        hval += asso_values[(unsigned char)str[4]];
      case 4:
        hval += asso_values[(unsigned char)str[3]];
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval + asso_values[(unsigned char)str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct GBKeyword *
keywords_lookup (register const char *str, register unsigned int len)
{
  static const unsigned char lengthtable[] =
    {
       0,  0,  0,  3,  4,  0,  6,  7,  0,  4,  5,  4,  0,  0,
       4,  5,  6,  0,  0,  4,  0,  0,  0,  3,  4,  8,  0,  0,
       0,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  9,  5,  0,
       2,  3,  4,  0, 11,  0,  3,  4,  0,  0,  0,  0,  0,  5,
       6,  7,  0,  0,  5,  0,  0,  3,  0,  0,  0,  0,  0,  0,
       5,  0,  0,  3,  0,  0,  0,  0,  3,  0,  3,  0,  2,  8,
       0,  0,  0,  0,  0,  7,  8,  0,  0,  0,  4,  0,  6,  0,
       3,  4,  0,  0,  0,  0,  4,  0,  0,  2,  3,  0,  0,  6,
       7,  6,  4,  5,  0,  0,  3,  4,  5,  0,  0,  8,  4,  5,
       6,  5,  3,  4,  5,  0,  0,  3,  4,  5,  0,  0,  8,  4,
       5,  0,  2, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,
       0,  0,  6,  0,  3,  0,  0,  6,  2,  0,  0,  0,  6,  0,
       3,  0,  0,  0,  0,  0,  4,  0,  0, 10,  0,  0,  0,  0,
       0,  0,  0,  5,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,
       6,  2,  0,  4,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  7,  3,  0,  0,  0,  0,  0,
       0,  0,  0,  7,  0,  0,  5,  6,  0,  0,  0,  5,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,
       0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  5,
       0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,
       0,  6,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  6,  0,
       0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  4
    };
  static const struct GBKeyword wordlist[] =
    {
      {""}, {""}, {""},
      {"Set",		GB_SET},
      {"Step",		GB_STEP},
      {""},
      {"Static",		GB_STATIC},
      {"Setattr",	GB_SETATTR},
      {""},
      {"True",		GB_TRUE},
      {"Erase",		GB_ERASE},
      {"Exit",		GB_EXIT},
      {""}, {""},
      {"Each",		GB_EACH},
      {"Scale",	 	GB_SCALE},
      {"Select",		GB_SELECT},
      {""}, {""},
      {"Else",		GB_ELSE},
      {""}, {""}, {""},
      {"Eqv",		GB_EQV},
      {"Seek",		GB_SEEK},
      {"Explicit",	GB_EXPLICIT},
      {""}, {""}, {""},
      {"Base",		GB_BASE},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Next",		GB_NEXT},
      {""}, {""},
      {"Attribute",	GB_ATTRIBUTE},
      {"Write",		GB_WRITE},
      {""},
      {"As",		GB_AS},
      {"Sub",		GB_SUB},
      {"Kill",		GB_KILL},
      {""},
      {"Savesetting",	GB_SAVESETTING},
      {""},
      {"New",            GB_NEW},
      {"With",		GB_WITH},
      {""}, {""}, {""}, {""}, {""},
      {"While",		GB_WHILE},
      {"Elseif",		GB_ELSE_IF},
      {"Version", 	GB_VERSION},
      {""}, {""},
      {"False",		GB_FALSE},
      {""}, {""},
      {"Get",		GB_GET},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Until",		GB_UNTIL},
      {""}, {""},
      {"Imp",		GB_IMP},
      {""}, {""}, {""}, {""},
      {"End",		GB_END},
      {""},
      {"Put",		GB_PUT},
      {""},
      {"Is",		GB_IS},
      {"Sendkeys",	GB_SENDKEYS},
      {""}, {""}, {""}, {""}, {""},
      {"Private",	GB_PRIVATE},
      {"Preserve",	GB_PRESERVE},
      {""}, {""}, {""},
      {"Case",		GB_CASE},
      {""},
      {"Append",		GB_APPEND},
      {""},
      {"Dim",		GB_DIM},
      {"Type",           GB_TYPE},
      {""}, {""}, {""}, {""},
      {"Then",		GB_THEN},
      {""}, {""},
      {"Or",		GB_OR},
      {"And",		GB_AND},
      {""}, {""},
      {"Output",		GB_OUTPUT},
      {"Declare",	GB_DECLARE},
      {"Public",		GB_PUBLIC},
      {"Wend",		GB_WEND},
      {"Class",          GB_CLASS},
      {""}, {""},
      {"Rem",		GB_REM},
      {"Call",		GB_CALL},
      {"Input",		GB_INPUT},
      {""}, {""},
      {"Database",	GB_DATABASE},
      {"Rset",		GB_RSET},
      {"Reset",		GB_RESET},
      {"Resume",		GB_RESUME},
      {"Print",	        GB_PRINT},
      {"Let",		GB_LET},
      {"Stop",		GB_STOP},
      {"Error",		GB_ERROR},
      {""}, {""},
      {"Xor",		GB_XOR},
      {"Lset",		GB_LSET},
      {"Redim",		GB_REDIM},
      {""}, {""},
      {"Function",	GB_FUNCTION},
      {"Like",		GB_LIKE},
      {"Byval",		GB_BYVAL},
      {""},
      {"If",		GB_IF},
      {"Deletesetting",	GB_DELETESETTING},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Not",		GB_NOT},
      {""}, {""},
      {"Module",		GB_MODULE},
      {""},
      {"Mod",		GB_MOD},
      {""}, {""},
      {"Binary",		GB_BINARY},
      {"In",		GB_IN},
      {""}, {""}, {""},
      {"Return",		GB_RETURN},
      {""},
      {"For",		GB_FOR},
      {""}, {""}, {""}, {""}, {""},
      {"Line",		GB_LINE},
      {""}, {""},
      {"Paramarray",	GB_PARAM_ARRAY},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Byref",		GB_BYREF},
      {""},
      {"Nothing",	GB_NOTHING},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Unlock",		GB_UNLOCK},
      {"On",		GB_ON},
      {""},
      {"Open",		GB_OPEN},
      {""},
      {"Unload",		GB_UNLOAD},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Compare",	GB_COMPARE},
      {"Len",            GB_LEN},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Deftype",	GB_DEFTYPE},
      {""}, {""},
      {"Close",		GB_CLOSE},
      {"Global",		GB_GLOBAL},
      {""}, {""}, {""},
      {"Gosub",		GB_GOSUB},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"Optional",	GB_OPTIONAL},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"To",		GB_TO},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Const",		GB_CONST},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Lock",		GB_LOCK},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Option",		GB_OPTION},
      {""}, {""},
      {"Load",		GB_LOAD},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Property",	GB_PROPERTY},
      {""}, {""}, {""}, {""}, {""},
      {"Random",         GB_RANDOM},
      {""}, {""},
      {"Randomize",	GB_RANDOMIZE},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"Do",		GB_DO},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"Loop",		GB_LOOP},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"Goto",		GB_GOTO}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        if (len == lengthtable[key])
          {
            register const char *s = wordlist[key].name;

            if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
              return &wordlist[key];
          }
    }
  return 0;
}
char *
correct_case (char const *str)
{
	char *tmp = g_strdup (str);

	g_strdown (tmp);
	tmp[0] = (char) toupper ((int) tmp[0]);

	return tmp;
}

int
gb_is_keyword (char const *str, unsigned const len)
{
	char                   *str_case;
	const struct GBKeyword *keyword;

	str_case = correct_case (str);
	keyword  = keywords_lookup (str_case, len);
	g_free (str_case);

	if (keyword == NULL)
		return 0;
#if 0
	printf ("Keyword : %s\n", keyword->name);
#endif

	return keyword->id;
}
