/*
 * gbrun-picturebox.c
 *
 * Gnome Basic Interpreter Picturebox functions.
 *
 * Author:
 *	Thomas Meeks (thomas@imaginator.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */
#include "gbrun-form-item.h"
#include <gnome.h>

#define ITEM_NAME "VB.Picturebox"

typedef struct {
	GtkJustification alignment;
} GBRunPicturebox;

static void copy (GBEvalContext *, GBObject *, GBObject *);

static void
destruct (GBObject *object)
{
	g_warning ("Unimplemented %s destruct", ITEM_NAME);
}

static GBObjectClass *
picturebox_class (void)
{
	static GBObjectClass *oc = NULL;

	if (!oc) {
		static GBRunObjectPrivClass p;
		gb_object_priv_class_init (&p.priv, ITEM_NAME,
					   sizeof (GBRunPicturebox),
					   (GBObjectCopy *)copy,
					   (GBObjectDestructor *)destruct);
		gbrun_object_priv_class_init (&p);

		oc = gb_object_class_new_single (&p.priv, gbrun_form_item_class ());
		gbrun_object_register (ITEM_NAME, oc);
	}
		
	return oc;
}

#define PRIV(o) (gb_object_get_priv ((o), picturebox_class ()))

static GBRunObjProperty *p_picture  = NULL;

/**
 * picturebox_setarg:
 *   @ec
 *   @object
 *   @property
 *   @val
 **/
static void
picturebox_setarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property,
	      GBValue          *val)
{
	GBRunPicturebox *picturebox = PRIV (object);
	GnomePixmap   *w            = GNOME_PIXMAP (gbrun_form_item_get_widget (object));

	g_return_if_fail (picturebox != NULL);

	if (property == p_picture)
		gnome_pixmap_load_file (w, val->v.s->str);
	else
		g_warning ("Unhandled property '%s'", property->name);
}


/**
 * picturebox_getarg:
 *   @ec
 *   @object
 *   @property
 **/
static GBValue *
picturebox_getarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property)
{
	GBRunPicturebox *picturebox = PRIV (object);

	g_return_val_if_fail (picturebox != NULL, NULL);

	if (property == p_picture)
		return gb_value_new_string_chars ("It's A Picture!!");
		
	else
		g_warning ("Unhandled property '%s'", property->name);

	return NULL;
}


static void
copy (GBEvalContext  *ec,
      GBObject       *dest_obj,
      GBObject       *templ_obj)
{
	GtkWidget  *w;

	if (templ_obj)
		g_warning ("Copy unimplemented");

	w = gnome_pixmap_new_from_file ("tmp.png");
	g_assert (w != NULL);
	gbrun_form_item_set_widget (dest_obj, w);
}

/**
 * gbrun_picturebox_register
 *
 **/
void
gbrun_picturebox_register ()
{
	GBRunObjectPrivClass *picturebox;
	
	picturebox = gbrun_object_class_get_priv (picturebox_class ());

	picturebox->set_arg = picturebox_setarg;
	picturebox->get_arg = picturebox_getarg;
	
	p_picture           = gbrun_object_add_property_val (picturebox, "picture",
							     GB_VALUE_STRING);
}


/**
 * gbrun_picturebox_shutdown
 *
 **/
void
gbrun_picturebox_shutdown ()
{
}
