
/*
 * Gnome Basic ListBox implementation.
 *
 * Author:
 *	Frank Chiulli	(fc-linux@home.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */
#include "gbrun-form-item.h"

#define ITEM_NAME "VB.ListBox"

struct _GBRunListBox {
	GBRunObjectPriv priv;

	GtkCList	*clist;
	
	int		 columns;
	GBBoolean	 sorted;

};

static void copy (GBEvalContext *, GBObject *, GBObject *);

static void
destruct (GBObject *object)
{
	g_warning ("Unimplemented %s destruct", ITEM_NAME);
}


static GBObjectClass *
listbox_class (void)
{
	static GBObjectClass *oc = NULL;

	if (!oc) {
		static GBRunObjectPrivClass p;
		gb_object_priv_class_init (&p.priv, ITEM_NAME,
					   sizeof (GBRunListBox),
					   (GBObjectCopy *)copy,
					   (GBObjectDestructor *)destruct);
		gbrun_object_priv_class_init (&p);

		oc = gb_object_class_new_single (&p.priv, gbrun_form_item_class ());
		gbrun_object_register (ITEM_NAME, oc);
	}
		
	return oc;
}

#define PRIV(o) (gb_object_get_priv ((o), listbox_class ()))

/*
 * ListBox Properties:
 * columns		
 * itemdata		Specifies a specific number for each item in the ListBox
 *			window's left edge.
 * list			The items contained in the control's list portion.
 * sorted
 */
static GBRunObjProperty *p_columns  = NULL;
static GBRunObjProperty *p_itemdata = NULL;
static GBRunObjProperty *p_list     = NULL;
static GBRunObjProperty *p_sorted   = NULL;


/**
 * copy:
 *   @ec
 *   @dest_obj
 *   @templ_obj
 **/
static void
copy (GBEvalContext  *ec,
      GBObject       *dest_obj,
      GBObject       *templ_obj)
{
	GtkWidget    *sw;
	GBRunListBox *dest = PRIV (dest_obj);

	if (templ_obj)
		g_warning ("Copy unimplemented");

	/* Create a scrolled window to pack the CList widget into */
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				    	GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gbrun_form_item_set_widget (dest_obj, sw);

	dest->clist = GTK_CLIST (gtk_clist_new (1));

	gtk_container_add (GTK_CONTAINER (sw), GTK_WIDGET (dest->clist));
}


/**
 * listbox_setarg:
 *   @ec
 *   @object
 *   @property
 *   @val
 **/
static void
listbox_setarg (GBRunEvalContext *ec,
		GBRunObject      *object,
		GBRunObjProperty *property,
		GBValue          *val)
{
	gchar		*cptr;
	gint		 i;
	gint		 row;
	
	guint		 no_ptrs;

	GBRunListBox 	*listbox = PRIV (object);

	g_return_if_fail (listbox != NULL);
	g_return_if_fail (listbox->clist != NULL);

	if        (property == p_columns) {
		g_warning ("Unhandled property '%s'", property->name);
	
	} else if (property == p_itemdata) {
		g_warning ("Unhandled property '%s'", property->name);

	} else if (property == p_list) {
		no_ptrs = val->v.list->len;
		for (i = 0; i < no_ptrs; i++) {
			cptr = (char *)g_ptr_array_index (val->v.list, i);
			row = gtk_clist_append (listbox->clist, &cptr);
		}

	} else if (property == p_sorted) {
		listbox->sorted = (val->v.i == VB_FALSE);
	
	} else
		g_warning ("Unhandled property '%s'", property->name);

}


/**
 * listbox_getarg:
 *   @ec
 *   @object
 *   @property
 **/
static GBValue *
listbox_getarg (GBRunEvalContext *ec,
		GBRunObject      *object,
		GBRunObjProperty *property)
{
	GBRunListBox *listbox = PRIV (object);
/*	GtkList      *l       = GTK_LIST (gbrun_form_item_get_widget (object));  */

	g_return_val_if_fail (listbox != NULL, NULL);

        if        (property == p_columns) {
	
	} else if (property == p_itemdata) {

	} else if (property == p_list) {

	} else if (property == p_sorted) {
		return gb_value_new_boolean (listbox->sorted);
	}
	else
		g_warning ("Unhandled property '%s'", property->name);

	return NULL;
}


/**
 * gbrun_listbox_register
 *
 **/
void
gbrun_listbox_register ()
{
	GBRunObjectPrivClass *listbox;
	
	listbox = gbrun_object_class_get_priv (listbox_class ());

	listbox->set_arg = listbox_setarg;
	listbox->get_arg = listbox_getarg;
/*	GTK_OBJECT_CLASS (listbox)->destroy = listbox_destroy;*/

	p_columns  = gbrun_object_add_property_val (listbox, "columns",
						    GB_VALUE_INT);
	p_itemdata = gbrun_object_add_property_val (listbox, "itemdata",
						    GB_VALUE_LIST);
	p_list     = gbrun_object_add_property_val (listbox, "list",
						    GB_VALUE_LIST);
	p_sorted   = gbrun_object_add_property_val (listbox, "sorted",
						    GB_VALUE_INT);
}


/**
 * gbrun_listbox_shutdown
 *
 **/
void
gbrun_listbox_shutdown ()
{
}
