/*
 * gbrun-frame.c
 *
 * Gnome Basic Interpreter Frame functions.
 *
 * Author:
 *	Thomas Meeks (thomas@imaginator.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */

#include "gbrun-form-item.h"

#define ITEM_NAME "VB.Frame"

struct _GBRunFrame {
	GtkJustification alignment;
};

static void copy (GBEvalContext *, GBObject *, GBObject *);

static void
destruct (GBObject *object)
{
	g_warning ("Unimplemented %s destruct", ITEM_NAME);
}

static GBObjectClass *
frame_class (void)
{
	static GBObjectClass *oc = NULL;

	if (!oc) {
		static GBRunObjectPrivClass p;
		gb_object_priv_class_init (&p.priv, ITEM_NAME,
					   sizeof (GBRunFrame),
					   (GBObjectCopy *)copy,
					   (GBObjectDestructor *)destruct);
		gbrun_object_priv_class_init (&p);

		oc = gb_object_class_new_single (&p.priv, gbrun_form_item_class ());
		gbrun_object_register (ITEM_NAME, oc);
	}
		
	return oc;
}

#define PRIV(o) (gb_object_get_priv ((o), frame_class ()))

static GBRunObjProperty *p_align    = NULL;
static GBRunObjProperty *p_caption  = NULL;

/**
 * frame_setarg:
 *   @ec
 *   @object
 *   @property
 *   @val
 **/
static void
frame_setarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property,
	      GBValue          *val)
{
	GBRunFrame *frame = PRIV (object);
	GtkFrame   *w     = GTK_FRAME (gbrun_form_item_get_widget (object));

	g_return_if_fail (frame != NULL);

	if (property == p_caption)
		gtk_frame_set_label (w, val->v.s->str);

	else if (property == p_align)
		switch (val->v.i) {
			case VB_LEFT_JUSTIFY:
				frame->alignment = GTK_JUSTIFY_LEFT;
				gtk_frame_set_label_align (w, GTK_JUSTIFY_LEFT, 0.2);
				break;

			case VB_RIGHT_JUSTIFY:
				frame->alignment = GTK_JUSTIFY_RIGHT;
				gtk_frame_set_label_align (w, GTK_JUSTIFY_RIGHT, 0.2);
				break;

			case VB_CENTER_JUSTIFY:
				frame->alignment = GTK_JUSTIFY_CENTER;
				gtk_frame_set_label_align (w, GTK_JUSTIFY_CENTER, 0.2);
				break;

			default:
				g_warning ("Unhandled alignment: %d", val->v.i);
		}

	else
		g_warning ("Unhandled property '%s'", property->name);
}


/**
 * frame_getarg:
 *   @ec
 *   @object
 *   @property
 **/
static GBValue *
frame_getarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property)
{
	GBRunFrame *frame = PRIV (object);
	GtkFrame   *w     = GTK_FRAME (gbrun_form_item_get_widget (object));

	g_return_val_if_fail (frame != NULL, NULL);

	if (property == p_caption)
		return gb_value_new_string_chars (w->label);

	else if (property == p_align)
		return gb_value_new_int (w->label_xalign);
		
	else
		g_warning ("Unhandled property '%s'", property->name);

	return NULL;
}


static void
copy (GBEvalContext  *ec,
      GBObject       *dest_obj,
      GBObject       *templ_obj)
{
	GtkWidget  *w;
	GBRunFrame *dest = PRIV (dest_obj);

	if (templ_obj)
		g_warning ("Copy unimplemented");

	w = gtk_frame_new ("");
	gbrun_form_item_set_widget (dest_obj, w);
	
	/* Makes it look like a standard windows frame */
	gtk_frame_set_shadow_type (GTK_FRAME (w), GTK_SHADOW_ETCHED_IN);

	dest->alignment = GTK_JUSTIFY_LEFT;
	gtk_frame_set_label_align (GTK_FRAME (w), GTK_JUSTIFY_LEFT, 0.2);
}

/**
 * gbrun_frame_register
 *
 **/
void
gbrun_frame_register ()
{
	GBRunObjectPrivClass *frame;
	
	frame = gbrun_object_class_get_priv (frame_class ());

	frame->set_arg = frame_setarg;
	frame->get_arg = frame_getarg;
	
	p_align   = gbrun_object_add_property_val (frame, "alignment",
						   GB_VALUE_INT);
	p_caption = gbrun_object_add_property_val (frame, "caption",
						   GB_VALUE_STRING);
}


/**
 * gbrun_frame_shutdown
 *
 **/
void
gbrun_frame_shutdown ()
{
}
