
/*
 * GNOME Abstract Form item base class
 *
 * Authors:
 *   Michael Meeks (michael@helixcode.com)
 */

#ifndef GBRUN_FORM_ITEM_H
#define GBRUN_FORM_ITEM_H

#define VB_LEFT_JUSTIFY		0
#define VB_RIGHT_JUSTIFY	1
#define VB_CENTER_JUSTIFY	2

#define VB_TRUE		       -1
#define VB_FALSE		0

#include "gbrun-form.h"

struct _GBRunFormItem {
	GBRunObjectPriv priv;

	GBRunObject    *form;
	int             x, y;
	GtkWidget      *widget;
	char           *name;
	int             tabindex;
};

#define GBRUN_FORM_ITEM_KEY "GBRunFormItemWidgetKey"

GBObjectClass *gbrun_form_item_class       (void);
void           gbrun_form_item_set_widget  (GBObject    *object,
					    GtkWidget   *widget);
GtkWidget     *gbrun_form_item_get_widget  (GBObject    *object);
GBRunObject   *gbrun_form_item_get_form    (GBObject    *object);
void           gbrun_form_item_setup       (GBObject    *object,
					    GtkFixed    *parent,
					    const char  *name);
void           gbrun_form_item_invoke      (GBRunEvalContext *ec,
					    GtkWidget        *widget,
					    char             *suffix);

void           gbrun_form_item_register    (void);
void           gbrun_form_item_shutdown    (void);

#endif
