/*
 * gbrun-check.c
 *
 * Gnome Basic Interpreter Check functions.
 *
 * Author:
 *	Thomas Meeks (thomas@imaginator.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */
#include "gbrun-form-item.h"

#define ITEM_NAME "VB.CheckBox"

struct _GBRunLabel {
	GtkJustification alignment;
};

static void copy (GBEvalContext *, GBObject *, GBObject *);

static void
destruct (GBObject *object)
{
	g_warning ("Unimplemented %s destruct", ITEM_NAME);
}

static GBObjectClass *
check_class (void)
{
	static GBObjectClass *oc = NULL;

	if (!oc) {
		static GBRunObjectPrivClass p;
		gb_object_priv_class_init (&p.priv, ITEM_NAME,
					   sizeof (GBRunLabel),
					   (GBObjectCopy *)copy,
					   (GBObjectDestructor *)destruct);
		gbrun_object_priv_class_init (&p);

		oc = gb_object_class_new_single (&p.priv, gbrun_form_item_class ());
		gbrun_object_register (ITEM_NAME, oc);
	}
		
	return oc;
}

#define PRIV(o) (gb_object_get_priv ((o), check_class ()))

static GBRunObjProperty *p_caption  = NULL;
static GBRunObjProperty *p_value  = NULL;

/**
 * check_setarg:
 *   @ec
 *   @object
 *   @property
 *   @val
 **/
static void
check_setarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property,
	      GBValue          *val)
{
	GBRunLabel *check = PRIV (object);
	GtkCheckButton *w = GTK_CHECK_BUTTON (gbrun_form_item_get_widget (object));
  
	g_return_if_fail (check != NULL);
  
	if (property == p_caption) {
		gtk_label_set_text (GTK_LABEL (GTK_BIN (w)->child),
				    val->v.s->str);
	} else if (property == p_value) {
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w),
					      val->v.i);
	} else
		g_warning ("Unhandled property '%s'", property->name);
}


/**
 * check_getarg:
 *   @ec
 *   @object
 *   @property
 **/
static GBValue *
check_getarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property)
{
	GBRunLabel *check = PRIV (object);
	GtkCheckButton *w = GTK_CHECK_BUTTON (gbrun_form_item_get_widget (object));
  
	g_return_val_if_fail (check != NULL, NULL);
  
	if (property == p_caption)
		return gb_value_new_string_chars (
			GTK_LABEL (GTK_BIN (w)->child)->label);
	else if (property == p_value)
		return gb_value_new_int (
			GTK_TOGGLE_BUTTON (w)->active);
	else
		g_warning ("Unhandled property '%s'", property->name);
  
	return NULL;
}


static void
copy (GBEvalContext  *ec,
      GBObject       *dest_obj,
      GBObject       *templ_obj)
{
	GtkWidget  *w;

	if (templ_obj)
		g_warning ("Copy unimplemented");

	w = gtk_check_button_new_with_label ("");
	gtk_widget_show_all (w);
	gbrun_form_item_set_widget (dest_obj, w);
}

/**
 * gbrun_check_register
 *
 **/
void
gbrun_check_register ()
{
	GBRunObjectPrivClass *check;
	
	check = gbrun_object_class_get_priv (check_class ());

	check->set_arg = check_setarg;
	check->get_arg = check_getarg;
	p_value = gbrun_object_add_property_val (check, "value",
						 GB_VALUE_INT);
	p_caption = gbrun_object_add_property_val (check, "caption",
						   GB_VALUE_STRING);
}


/**
 * gbrun_check_shutdown
 *
 **/
void
gbrun_check_shutdown ()
{
}
