
/*
 * GNOME Basic Enterpreter Function registration
 *
 * Authors:
 *    Michael Meeks (mmeeks@gnu.org)
 *    Thomas Meeks  (meekte95@christs-hospital.org.uk)
 *    Ariel Rios    (ariel@arcavia.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */



#include <gnome.h>

#include <gbrun/gbrun.h>
#include <gbrun/gbrun-value.h>
#include <gbrun/gbrun-eval.h>
#include <gbrun/gbrun-array.h>
#include <gbrun/gbrun-object.h>

#include <gb/gb-constants.h>

#include "gba-interaction.h"

#define ITEM_NAME "VBA.Interaction"

#if 0
static GBValue *
gbrun_func_choose (GBRunEvalContext *ec,
                 GBRunObject      *object,
		 GBValue         **args)
{
	GBInt i = gb_value_get_as_int (args [0]);

	return args [i];
}
#endif

static GBValue *
gbrun_sub_msgbox (GBRunEvalContext *ec,
		GBRunObject      *object,
		GBValue         **args)
{
	GtkWidget   *dialog;
	char        *type;
	const char **buttons;
	const char  *buttons_0[] = { GNOME_STOCK_BUTTON_OK, NULL };
	const char  *buttons_1[] = { GNOME_STOCK_BUTTON_OK, GNOME_STOCK_BUTTON_CANCEL, NULL };
	const char  *buttons_2[] = { GBRUN_STOCK_BUTTON_ABORT, GBRUN_STOCK_BUTTON_RETRY,
				     GNOME_STOCK_BUTTON_CANCEL, NULL };
	const char  *buttons_3[] = { GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO,
				     GNOME_STOCK_BUTTON_CANCEL, NULL };
	const char  *buttons_4[] = { GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, NULL };
	const char  *buttons_5[] = { GBRUN_STOCK_BUTTON_RETRY, GNOME_STOCK_BUTTON_CANCEL, NULL };
	long         b;
	int          buts, i;
	
	GB_IS_VALUE     (ec, args [0], GB_VALUE_STRING);
	GB_IS_VALUE_OPT (ec, args [1], GB_VALUE_LONG);

	if (args [1])
		b = args [1]->v.l;
	else
		b = 0;

	if (b & GB_C_Critical)
		type = GNOME_MESSAGE_BOX_ERROR;
	else if (b & GB_C_Question)
		type = GNOME_MESSAGE_BOX_QUESTION;
	else if (b & GB_C_Exclamation)
		type = GNOME_MESSAGE_BOX_WARNING;
	else if (b & GB_C_Information)
		type = GNOME_MESSAGE_BOX_INFO;
	else
		type = GNOME_MESSAGE_BOX_GENERIC;

	buts = b & 0xf;
	switch (buts) {

	case GB_C_OKCancel:
		buttons = buttons_1;
		break;

	case GB_C_AbortRetryIgnore:
		buttons = buttons_2;
		break;

	case GB_C_YesNoCancel:
		buttons = buttons_3;
		break;

	case GB_C_YesNo:
		buttons = buttons_4;
		break;

	case GB_C_RetryCancel:
		buttons = buttons_5;
		break;

	case GB_C_OKOnly:
	default:
		buttons = buttons_0;
		break;
	};

	dialog = gnome_message_box_newv (args [0]->v.s->str, type, buttons);

	i = gnome_dialog_run (GNOME_DIALOG (dialog));

	if (i < 0 || !buttons [i] ||
	    !strcmp (buttons [i], GNOME_STOCK_BUTTON_CANCEL))
		return gb_value_new_int (GB_C_Cancel);

	if (!strcmp (buttons [i], GBRUN_STOCK_BUTTON_ABORT))
		return gb_value_new_int (GB_C_Abort);

	if (!strcmp (buttons [i], GBRUN_STOCK_BUTTON_RETRY))
		return gb_value_new_int (GB_C_Retry);

	if (!strcmp (buttons [i], GBRUN_STOCK_BUTTON_IGNORE))
		return gb_value_new_int (GB_C_Ignore);

	if (!strcmp (buttons [i], GNOME_STOCK_BUTTON_YES))
		return gb_value_new_int (GB_C_Yes);

	if (!strcmp (buttons [i], GNOME_STOCK_BUTTON_NO))
		return gb_value_new_int (GB_C_No);

	return gb_value_new_int (GB_C_OK);
}




static GBValue *
gbrun_func_iif (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBValue         **args)
{
	GB_IS_VALUE (ec, args [0], GB_VALUE_BOOLEAN);

	return gb_value_copy (GB_EVAL_CONTEXT (ec),
			      args [args [0]->v.bool ? 1: 2]);
}


static GBValue *
gbrun_func_shell (GBRunEvalContext *ec,
		GBRunObject      *object,
		GBValue         **args)
{
	GBString str = gb_value_get_as_string (args [0]);

	/*
	 * FIXME: We need to include the optional argument.
	 */
	
	return gb_value_new_int (gnome_execute_shell (NULL, str->str));	
}



void
gba_interaction_register (GBEvalContext *ec)
{
	GBObjectClass        *gba_object;
	GBRunObjectPrivClass *gba;

	gba_object = gbrun_object_create (ITEM_NAME, NULL);
	gba = gbrun_object_class_get_priv (gba_object);

        gbrun_object_globalize      (gb_object_new (ec, gba_object));

	gbrun_object_add_method_arg (gba, "func;iif;truth,boolean;truepart,string;falsepart,string;string;n",
				     gbrun_func_iif);

        gbrun_object_add_method_arg (gba, "func;shell;a,string;integer;x",
                                     gbrun_func_shell);

	gbrun_object_add_method_arg (gba, "func;msgbox;prompt,string;"
				     "buttons,long,byval,0;"
				     "title,string,byref, ;"
				     "helpfile,string,byref, ;"
				     "context,integer,byval,0;"
				     "integer;g", gbrun_sub_msgbox);

}

void
gba_interaction_shutdown (void)
{

}
