
/*
 * GNOME Basic Values manipulation.
 *
 * Authors:
 *    Michael Meeks <mmeeks@gnu.org>
 *    Ariel Rios    <ariel@arcavia.com>
 *
 * Copyright 2000, Helix Code, Inc.
 */

#ifndef GBE_VALUE_H
#define GBE_VALUE_H

#include <gbrun/gbrun.h>
#include <gb/gb-value.h>
#include <gbrun/gbrun-eval.h>

/*
 * NB. if you accidentaly use GB_VALUE_INTEGER instead of
 * GB_VALUE_INT you're on a sticky wicket.
 */
#define GB_IS_VALUE(e,v,t)     if (!(v) || ((v)->type != (t))) \
      return gbrun_exception_firev ((e),"... Incorrect argument type: %s should be %s", \
				    gb_value_type_name ((v)?((v)->type):GB_VALUE_EMPTY), \
				    gb_value_type_name (t))

#define GB_IS_VALUE_OPT(e,v,t) if ( (v) && ((v)->type != (t))) \
      return gbrun_exception_firev ((e),"... Incorrect argument type: %s should be %s", \
				    gb_value_type_name ((v)?((v)->type):GB_VALUE_EMPTY), \
				    gb_value_type_name (t))

#define  gbrun_value_promote(ec,v,to)    (gb_value_promote      (GB_EVAL_CONTEXT (ec), (v), (to)))

GBValue *gbrun_value_promote_name        (GBRunEvalContext *ec,
					  GBValue          *v,
					  const char       *type_name);

#define  gbrun_value_copy(ec,v)          (gb_value_copy (GB_EVAL_CONTEXT (ec), (v)))

struct _GBEArray {
	GSList   *indicees;
	gpointer  data;
};

GBValue *gbrun_value_new_array        (GBRunEvalContext *ec,
				     GSList   *indicees,
				     GBValue  *def);

GBValue *gbrun_value_array_lookup     (GBRunEvalContext *ec,
				     GBValue          *array,
				     const GBObjRef   *ref);

GBValue *gbrun_objref_deref         (GBRunEvalContext *ec,
				     GBRunObject      *object,
				     const GBObjRef   *ref);

GBValue *gbrun_eval_objref          (GBRunEvalContext *ec,
				     const GBExpr     *objref);

gboolean gbrun_eval_assign          (GBRunEvalContext *ec,
				     const GSList     *objref,
				     GBValue          *value);
#endif
