
/*
 * GNOME Basic Stack handling
 *
 * Author:
 *    Michael Meeks <mmeeks@gnu.org>
 *
 * Copyright 2000, Helix Code, Inc
 */
#ifndef GBRUN_STACK_H
#define GBRUN_STACK_H

#include <gbrun/gbrun.h>
#include <gb/gb-value.h>
#include <gbrun/gbrun-eval.h>

struct _GBRunStack {
	GBRunStackLevelList *level;
};

struct _GBRunVar {
	char    *name;
	GBValue *val;
};

GBRunStack *gbrun_stack_new      (void);
void        gbrun_stack_destroy  (GBRunStack       *stack);

void        gbrun_stack_call     (GBRunEvalContext *ec,
				  const char       *name);

void        gbrun_stack_return   (GBRunEvalContext *ec);

GBRunFrame *gbrun_stack_frame    (GBRunStack       *stack);

typedef enum {
	GBRUN_STACK_LOCAL = 0,
	GBRUN_STACK_MODULE = 1,
	GBRUN_STACK_GLOBAL = 2
} GBRunStackScope;

void      gbrun_stack_add      (GBRunEvalContext *ec,
				const char       *name,
				const GBValue    *val,
				GBRunStackScope   scope);

void      gbrun_stack_set      (GBRunEvalContext *ec,
				const char       *name,
				GBValue          *value);

GBValue **gbrun_stack_get      (GBRunEvalContext *ec,
				const char       *name);

char    **gbrun_stack_dump     (GBRunStack       *stack);

GBRunStackLevel *gbrun_stack_level_new     (const char       *name);
GBValue        **gbrun_stack_level_lookup  (GBRunStackLevel  *l,
					    const char       *name);
void             gbrun_stack_level_add     (GBRunEvalContext *ec,
					    GBRunStackLevel  *l,
					    const char       *name,
					    const GBValue    *val);
void             gbrun_stack_level_destroy (GBRunStackLevel  *l);

#endif /* GBRUN_STACK_H */
