
/*
 * GNOME Arrays
 *
 * Author:
 *    Michael Meeks <michael@imaginator.com>
 *
 * Copyright 2000, Helix Code, Inc.
 */

#ifndef GBRUN_ARRAY_H
#define GBRUN_ARRAY_H

#include <gbrun/gbrun-object.h>

#define GBRUN_IS_ARRAY(obj) (gb_object_implements (GB_OBJECT (obj), \
			     gbrun_array_get_class ()))

/*
 *   Ideally all of this should inherit from some nice
 * argument passing / dereferencing interface.
 */

struct _GBRunArray {
	GBObjectPriv        priv;

	enum { GBRUN_ARRAY_OBJECT, GBRUN_ARRAY_VALUE } type;
	union {
		char       *object;
		GBValueType value;
	} t;
	GSList             *indicees;
	gpointer            data;
};

struct _GBRunArrayClass {
	GBObjectPrivClass priv;

	GBValue *(*dereference) (GBRunEvalContext *ec,
				 GBRunObject      *a,
				 const GBObjRef   *func,
				 const GBValue    *assign);
};

GBObjectClass *gbrun_array_get_class (void);

GBObject     *gbrun_array_new      (GBRunEvalContext *ec,
				    const GBVar      *var);
GBObject     *gbrun_array_new_vals (GBRunEvalContext *ec,
				    GSList           *values);
GBValue      *gbrun_array_deref    (GBRunEvalContext *ec,
				    GBObject         *array,
				    const GBObjRef   *func);
gboolean      gbrun_array_assign   (GBRunEvalContext *ec,
				    GBObject         *array,
				    const GBObjRef   *func,
				    const GBValue    *value);

#endif /* GBRUN_ARRAY_H */
