
/*
 * gbrun-timer.c
 *
 * Gnome Basic Interpreter Timer functions.
 *
 * Author:
 *	Michael Meeks	(michael@helixcode.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */
#include <gtk/gtkinvisible.h>
#include "gbrun-form-item.h"

#define ITEM_NAME "VB.Timer"

typedef struct {
	int      interval;
	gboolean waiting;
} GBRunTimer;

static void copy (GBEvalContext *, GBObject *, GBObject *);

static void
destruct (GBObject *object)
{
	g_warning ("Unimplemented %s destruct", ITEM_NAME);
}

static GBObjectClass *
timer_class (void)
{
	static GBObjectClass *oc = NULL;

	if (!oc) {
		static GBRunObjectPrivClass p;
		gb_object_priv_class_init (&p.priv, ITEM_NAME,
					   sizeof (GBRunTimer),
					   (GBObjectCopy *)copy,
					   (GBObjectDestructor *)destruct);
		gbrun_object_priv_class_init (&p);

		oc = gb_object_class_new_single (&p.priv, gbrun_form_item_class ());
		gbrun_object_register (ITEM_NAME, oc);
	}
		
	return oc;
}

#define PRIV(o) (gb_object_get_priv ((o), timer_class ()))

static GBRunObjProperty *p_interval = NULL;

typedef struct {
	GBRunEvalContext *ec;
	GBRunObject      *timer;
} timer_closure_t;

void
closure_destroy (gpointer d)
{
	g_free (d);
}

gboolean
timer_func (gpointer data)
{
	timer_closure_t *c = data;

	gbrun_form_item_invoke (c->ec, gbrun_form_item_get_widget (c->timer),
				"_Timer");

	return TRUE;
}

/**
 * timer_setarg:
 *   @ec
 *   @object
 *   @property
 *   @val
 **/
static void
timer_setarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property,
	      GBValue          *val)
{
	GBRunTimer *timer = PRIV (object);

	g_return_if_fail (timer != NULL);

	/* This implementation sucks badly */
	if (property == p_interval) {
		timer_closure_t *c = g_new (timer_closure_t, 1);

		timer->interval = val->v.l;
		c->ec    = ec;
		c->timer = object;

		if (!timer->waiting)
			g_timeout_add_full (G_PRIORITY_DEFAULT, timer->interval,
					    timer_func, c, closure_destroy);
		timer->waiting = TRUE;
	} else
		g_warning ("Unhandled property '%s'", property->name);
}


/**
 * timer_getarg:
 *   @ec
 *   @object
 *   @property
 **/
static GBValue *
timer_getarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property)
{
	GBRunTimer *timer = PRIV (object);

	g_return_val_if_fail (timer != NULL, NULL);

	if (property == p_interval)
		return gb_value_new_long (timer->interval);

	else
		g_warning ("Unhandled property '%s'", property->name);

	return NULL;
}


static void
copy (GBEvalContext  *ec,
      GBObject       *dest_obj,
      GBObject       *templ_obj)
{
	GtkWidget  *w;
	GBRunTimer *dest = PRIV (dest_obj);

	if (templ_obj)
		g_warning ("Copy unimplemented");
	
	dest->waiting = FALSE;
	dest->interval = 1000;

	w = gtk_invisible_new ();
	gbrun_form_item_set_widget (dest_obj, w);
}

/**
 * gbrun_timer_register
 *
 **/
void
gbrun_timer_register ()
{
	GBRunObjectPrivClass *timer;
	
	timer = gbrun_object_class_get_priv (timer_class ());

	timer->set_arg = timer_setarg;
	timer->get_arg = timer_getarg;
	
	p_interval = gbrun_object_add_property_val (timer, "interval",
						    GB_VALUE_LONG);
}


/**
 * gbrun_timer_shutdown
 *
 **/
void
gbrun_timer_shutdown ()
{
}
