
/*
 * GNOME Basic Text Box.
 *
 * Author:
 *	Frank Chiulli (fc-linux@home.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */
#include "gbrun-form-item.h"

#define ITEM_NAME "VB.TextBox"

struct _GBRunTextBox {
	GBBoolean	locked;
};

static void copy (GBEvalContext *, GBObject *, GBObject *);

static void
destruct (GBObject *object)
{
	g_warning ("Unimplemented %s destruct", ITEM_NAME);
}

static GBObjectClass *
textbox_class (void)
{
	static GBObjectClass *oc = NULL;

	if (!oc) {
		static GBRunObjectPrivClass p;
		gb_object_priv_class_init (&p.priv, ITEM_NAME,
					   sizeof (GBRunTextBox),
					   (GBObjectCopy *)copy,
					   (GBObjectDestructor *)destruct);
		gbrun_object_priv_class_init (&p);

		oc = gb_object_class_new_single (&p.priv, gbrun_form_item_class ());
		gbrun_object_register (ITEM_NAME, oc);
	}
		
	return oc;
}

#define PRIV(o) (gb_object_get_priv ((o), textbox_class ()))

/*
 * _GBETextBox defines a VB Text Box
 *
 * alignment		Determines whether the text box's text appears left-
 *			justified, centered, or right-justified with the
 *			text box's boundaries.
 * back_color		Specifies the text box's background color.
 * border_style		Determines whether a single-line border appears
 *			around the text box.
 * enabled		Determines whether the text box is active.
 * font		 	Text's font name, style and size.
 * height		The height of the text box's outline in twips.
 * left			The number of twips from the text box's left edge to
 *			the Form window's left edge.
 * locked		Determines whether the user can edit the text inside 
 *			the text box.
 * max_length		Specifies the number of characters the user can type
 *			into the text box.
 * mouse_ptr		The shape of the mouse cursor when the user moves the 
 *			mouse over the text box.
 * multi_line		Lets the text box hold multiple lines of text or sets
 *			the text box to hold only a single line of text.
 * pwd_char		Determines the character that appears in the text box
 *			when the user enters a password, which keeps prying
 *			eyes from knowing what the user enters into the box.
 * scroll_bars		Determines whether scrollbars appear on the edges of a
 *			multiline text box.
 * tab_index		Specifies the order of the text box in the focus order.
 * tab_stop		Determines whether the text box can receive the focus.
 * text			Holds the value of the text inside the text box.
 * tool_tip_text		Holds the text that appears as a ToolTip at runtime.
 * top			Holds the number of twips from the text box's top edge
 *			to the Form window's top edge.
 * visible		Determines whether the text box appears or is hidden
 *			from the user.
 * width		The width of the text box in twips.
 *
 * text_box
 *
 * Definitions:
 * twip		1,440th of an inch (the smallest screen measurement)
 */

struct _GBETextBox {
/*	guint8		 alignment;
	guint32		 back_color;
	guint8		 border_style;
	gboolean	 enabled;
	GBEFormFont	 font;
	guint32		 fore_color;
	guint16		 height;
	guint16		 left;
	gboolean	 locked;
	guint16		 max_length;
	guint8		 mouse_ptr;
	gboolean	 multi_line;
	gchar		 pwd_vhar;
	gboolean	 scroll_bars;
	guint8		 tab_index;
	guint8		 tab_stop;
	gchar		*text;
	gchar		*tool_tip_text;
	guint16		 top;
	gboolean	 visible;
	guint16		 width;

	GtkWidget	*text_box;*/
};


static GBRunObjProperty *p_locked        = NULL;
static GBRunObjProperty *p_tool_tip_text = NULL;
static GBRunObjProperty *p_text          = NULL;
static GBRunObjProperty *p_alignment     = NULL;

/**
 * textbox_setarg
 *
 **/
static void
textbox_setarg (GBRunEvalContext *ec,
	        GBRunObject      *object,
	        GBRunObjProperty *property,
	        GBValue          *val)
{
	GBRunTextBox *textbox = PRIV (object);
	GtkEntry     *entry = GTK_ENTRY (gbrun_form_item_get_widget (object));

	g_return_if_fail (textbox != NULL);

	if (property == p_locked) {
		textbox->locked = (val->v.i == VB_FALSE);
		gtk_entry_set_editable (entry, 
		                        textbox->locked);

	} else if (property == p_tool_tip_text) {
		GtkTooltips *t = gtk_tooltips_new();
		gtk_tooltips_set_tip (t, GTK_WIDGET (entry), 
		                      val->v.s->str, NULL);
		
	} else if (property == p_text) {
		gtk_entry_set_editable (entry, TRUE);
		gtk_entry_set_text (entry, val->v.s->str);
		gtk_entry_set_editable (entry, textbox->locked);

	} else if (property == p_alignment) {
		static gboolean warned = FALSE;
		if (!warned) {
			g_warning ("GtkEntry alignment unsupported");
			warned = TRUE;
		}

	} else
		g_warning ("Unhandled property '%s'", property->name);
}


/**
 * textbox_getarg:
 *   @ec
 *   @object
 *   @property
 **/
static GBValue *
textbox_getarg (GBRunEvalContext *ec,
	        GBRunObject      *object,
	        GBRunObjProperty *property)
{
	GBRunTextBox *textbox = PRIV (object);
	GtkEntry     *entry = GTK_ENTRY (gbrun_form_item_get_widget (object));

	g_return_val_if_fail (textbox != NULL, NULL);

	if (property == p_locked)
		return gb_value_new_boolean (textbox->locked);

	else if (property == p_text)
		return gb_value_new_string_chars (gtk_entry_get_text (entry));

	else
		g_warning ("Unhandled property '%s'", property->name);

	return NULL;
}


static void
copy (GBEvalContext  *ec,
      GBObject       *dest_obj,
      GBObject       *templ_obj)
{
	GBRunTextBox *dest = PRIV (dest_obj);

	if (templ_obj)
		g_warning ("Copy unimplemented");

	gbrun_form_item_set_widget (dest_obj, gtk_entry_new ());
	dest->locked = FALSE;
}

/**
 * gbrun_textbox_register
 *
 **/
void
gbrun_textbox_register ()
{
	GBRunObjectPrivClass *textbox;
	
	textbox = gbrun_object_class_get_priv (textbox_class ());

	textbox->set_arg = textbox_setarg;
	textbox->get_arg = textbox_getarg;
	
	p_locked        = gbrun_object_add_property_val (textbox, "locked", 
	                                                 GB_VALUE_INT);
	p_tool_tip_text = gbrun_object_add_property_val (textbox, "tooltiptext",
						         GB_VALUE_STRING);
	p_text          = gbrun_object_add_property_val (textbox, "Text",
							 GB_VALUE_STRING);
	p_alignment     = gbrun_object_add_property_val (textbox, "Alignment",
							 GB_VALUE_INT);
}


/**
 * gbrun_textbox_shutdown
 *
 **/
void
gbrun_textbox_shutdown ()
{
}
