
/*
 * gbrun-label.c
 *
 * Gnome Basic Interpreter Label functions.
 *
 * Author:
 *	Michael Meeks	(michael@helixcode.com)
 *	Frank Chiulli	(fc-linux@home.com)
 *
 * Copyright 2000, Helix Code, Inc.
 */
#include "gbrun-form-item.h"

#define ITEM_NAME "VB.Label"

struct _GBRunLabel {
	GtkJustification alignment;
};

static void copy (GBEvalContext *, GBObject *, GBObject *);

static void
destruct (GBObject *object)
{
	g_warning ("Unimplemented %s destruct", ITEM_NAME);
}

static GBObjectClass *
label_class (void)
{
	static GBObjectClass *oc = NULL;

	if (!oc) {
		static GBRunObjectPrivClass p;
		gb_object_priv_class_init (&p.priv, ITEM_NAME,
					   sizeof (GBRunLabel),
					   (GBObjectCopy *)copy,
					   (GBObjectDestructor *)destruct);
		gbrun_object_priv_class_init (&p);

		oc = gb_object_class_new_single (&p.priv, gbrun_form_item_class ());
		gbrun_object_register (ITEM_NAME, oc);
	}
		
	return oc;
}

#define PRIV(o) (gb_object_get_priv ((o), label_class ()))

/*
 * _GBELabel defines a VB Label
 *
 * alignment		Determines whether the label's caption appears left-
 *			justified, centered, or right-justified with the
 *			label's boundaries.
 * auto_size		Enlarges the label's size properties, when True, if
 *			you assign a caption that is too large to fit in the
 *			current label's boundaries at runtime.
 * back_color		Specifies the label's background color.
 * back_style		Determines whether the background shows through the
 *			label or if the label covers up its background text,
 *			graphics, and color.
 * border_style		Determines whether a single-line border appears
 *			around the label.
 * caption		The text that appears on the label.
 * enabled		Determines whether the label is active.
 * font		 	Caption's font name, style and size.
 * fore_color		The color of the label's text.
 * height		The height of label's outline in twips.
 * left			The number of twips from the label's left edge to the 
 *			Form window's left edge.
 * mouse_ptr		The shape of the mouse cursor when the user moves the
 *			mouse over the label.
 * tabindex		Specifies the order of the label in the focus order.
 * tool_tip_text	Holds the text that appears as a ToolTip at runtime.
 * top			Holds the number of twips from the label's top edge to
 *			the Form window's top edge.
 * visible		Determines whether the label appears or is hidden from
 *			the user.
 * width		The width of the label in twips.
 * word_wrap		Determines whether the label expands to fit whatever
 *			text appears in the caption.
 *
 * label
 */
/*struct _GBELabel {
	guint8		 alignment;
	gboolean	 auto_size;
	guint32		 back_color;
	gboolean	 back_style;
	guint8		 border_style;
	gchar		*caption;
	gboolean	 enabled;
	GBEFormFont	 font;
	guint32		 fore_color;
	guint16		 height;
	guint16		 left;
	guint8		 mouse_ptr;
	guint8		 tab_index;
	gchar		*tool_tip_text;
	guint16		 top;
	gboolean	 visible;
	guint16		 width;
	gboolean	 word_wrap;
	
	GtkWidget	*label;
	};*/

static GBRunObjProperty *p_align    = NULL;
static GBRunObjProperty *p_caption  = NULL;

/**
 * label_setarg:
 *   @ec
 *   @object
 *   @property
 *   @val
 **/
static void
label_setarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property,
	      GBValue          *val)
{
	GBRunLabel *label = PRIV (object);
	GtkLabel   *w     = GTK_LABEL (gbrun_form_item_get_widget (object));

	g_return_if_fail (label != NULL);

	if (property == p_caption)
		gtk_label_set_text (w, val->v.s->str);

	else if (property == p_align)
		switch (val->v.i) {
			case VB_LEFT_JUSTIFY:
				label->alignment = GTK_JUSTIFY_LEFT;
				gtk_label_set_justify (w, GTK_JUSTIFY_LEFT);
				break;

			case VB_RIGHT_JUSTIFY:
				label->alignment = GTK_JUSTIFY_RIGHT;
				gtk_label_set_justify (w, GTK_JUSTIFY_RIGHT);
				break;

			case VB_CENTER_JUSTIFY:
				label->alignment = GTK_JUSTIFY_CENTER;
				gtk_label_set_justify (w, GTK_JUSTIFY_CENTER);
				break;

			default:
				g_warning ("Unhandled alignment: %d", val->v.i);
		}

	else
		g_warning ("Unhandled property '%s'", property->name);
}


/**
 * label_getarg:
 *   @ec
 *   @object
 *   @property
 **/
static GBValue *
label_getarg (GBRunEvalContext *ec,
	      GBRunObject      *object,
	      GBRunObjProperty *property)
{
	GBRunLabel *label = PRIV (object);
	GtkLabel   *w     = GTK_LABEL (gbrun_form_item_get_widget (object));

	g_return_val_if_fail (label != NULL, NULL);

	if (property == p_caption)
		return gb_value_new_string_chars (w->label);

	else if (property == p_align)
		return gb_value_new_int (label->alignment);
		
	else
		g_warning ("Unhandled property '%s'", property->name);

	return NULL;
}


static void
copy (GBEvalContext  *ec,
      GBObject       *dest_obj,
      GBObject       *templ_obj)
{
	GtkWidget  *w;
	GBRunLabel *dest = PRIV (dest_obj);

	if (templ_obj)
		g_warning ("Copy unimplemented");

	w = gtk_label_new ("");
	gbrun_form_item_set_widget (dest_obj, w);

	dest->alignment = GTK_JUSTIFY_LEFT;
	gtk_label_set_justify (GTK_LABEL (w), GTK_JUSTIFY_LEFT);
}

/**
 * gbrun_label_register
 *
 **/
void
gbrun_label_register ()
{
	GBRunObjectPrivClass *label;
	
	label = gbrun_object_class_get_priv (label_class ());

	label->set_arg = label_setarg;
	label->get_arg = label_getarg;
	
	p_align   = gbrun_object_add_property_val (label, "alignment",
						   GB_VALUE_INT);
	p_caption = gbrun_object_add_property_val (label, "caption",
						   GB_VALUE_STRING);
}


/**
 * gbrun_label_shutdown
 *
 **/
void
gbrun_label_shutdown ()
{
}
