
/*
 * GNOME Object
 *
 * Author:
 *    Michael Meeks <michael@helixcode.com>
 *
 * Copyright 2000, Helix Code, Inc.
 */

#ifndef GBRUN_OBJECT_H
#define GBRUN_OBJECT_H

#include <gbrun/gbrun.h>
#include <gb/gb-value.h>
#include <gb/gb-expr.h>
#include <gb/gb-object.h>

#define GBRUN_OBJECT_GET_CLASS(obj)  (GB_OBJECT_CLASS (GTK_OBJECT (obj)->klass))

struct _GBRunObjectPriv {
	GBObjectPriv     priv;
	GBRunStackLevel *vars;
};

#define GBRUN_OBJECT_PRIV_GET_CLASS(p) ((GBRunObjectPrivClass *)(((GBObjectPriv *)(p))->klass))

struct _GBRunObjectPrivClass {
	GBObjectPrivClass priv;

	GHashTable    *vars;

	char          *name;
	GList         *properties;
	GSList        *methods;

	/* Exception handling arg system */
	GBRunSetArg   *set_arg;
	GBRunGetArg   *get_arg;
};

typedef enum { GBRUN_PROPERTY, GBRUN_METHOD } GBRunObjectElementType;

struct _GBRunObjProperty {
	char          *name;
	int            idx; /* FIXME: we should use an ordinal to switch on */
	GBRunSetArg   *set_arg;
	GBRunGetArg   *get_arg;

	enum { GBRUN_PROP_VAL, GBRUN_PROP_OBJ } type;
	union {
		GBValueType  prop_type;
		char        *objname;
	} u;
};

struct _GBRunObjMethod {
	char             *name;
	GSList           *args;
	gint              max_args;
	gint              min_args;
	GBRunSecurityFlag mask;
	gboolean          is_sub;

	enum { GBRUN_METHOD_VAR, GBRUN_METHOD_ARG, GBRUN_METHOD_VB } type;
	union {
		GBRunMethodVar *var;
		GBRunMethodArg *arg;
		GBRoutine      *vb;
	} handler;
};

/*
 * This is hillariously complicated ... simplify me.
 */

GtkType           gbrun_object_get_type        (void);
GBObjectClass    *gbrun_object_class           (void);
#define           gbrun_object_newc(ec,c)      (gb_object_new (GB_EVAL_CONTEXT (ec), c))
GBRunObject      *gbrun_object_new             (GBRunEvalContext *ec,
						const char       *vb_name);
void              gbrun_object_register        (const char       *vb_name,
						GBObjectClass    *klass);
void              gbrun_object_globalize       (GBObject         *object);
GBObjectClass    *gbrun_object_lookup          (const char       *vb_name);
const char       *gbrun_object_name            (GBObject         *object);

GBObjectClass    *gbrun_object_create          (const char       *vb_name,
						GSList           *parents);
GBObjectClass    *gbrun_object_create_single   (const char       *vb_name,
						GBObjectClass    *parent);

void                  gbrun_object_priv_class_init (GBRunObjectPrivClass *pc);
void                  gbrun_object_priv_copy       (GBEvalContext *ec,
						    GBObject      *dest,
						    GBObject      *templ);
void                  gbrun_object_priv_destruct   (GBObject      *object);

GBRunObjectPriv      *gbrun_object_get_priv        (GBObject      *object);
GBRunObjectPrivClass *gbrun_object_class_get_priv  (GBObjectClass *klass);


void                  gbrun_object_var_add         (GBRunEvalContext *ec,
						    GBRunObject      *obj,
						    const char       *name,
						    GBValue          *value);
void                  gbrun_object_var_set         (GBRunEvalContext *ec,
						    GBRunObject      *obj,
						    const char       *name,
						    GBValue          *value);
GBValue             **gbrun_object_var_get         (GBRunEvalContext *ec,
						    GBRunObject      *obj,
						    const char       *name);

GBRunObjMethod   *gbrun_object_get_method       (GBObjectClass *klass,
						 const char    *name);
GSList           *gbrun_object_get_methods      (GBObjectClass *klass);

GBRunObjMethod   *gbrun_object_global_func      (const char    *name);

GBRunObjProperty *gbrun_object_add_property_val (GBRunObjectPrivClass  *klass,
						 const char            *name,
						 GBValueType            type);
GBRunObjProperty *gbrun_object_add_property_obj (GBRunObjectPrivClass  *klass,
						 const char            *name,
						 const char            *objname);
GBRunObjProperty *gbrun_object_get_property     (GBObjectClass         *klass,
						 const char            *name);

void              gbrun_object_add_method_var   (GBRunObjectPrivClass *klass,
						 const char           *desc,
						 GBRunMethodVar       *method);

void              gbrun_object_add_method_arg   (GBRunObjectPrivClass *klass,
						 const char           *desc,
						 GBRunMethodArg       *method);

void              gbrun_object_add_routine    (GBRunObjectPrivClass *klass,
					       GBRoutine            *routine);
void              gbrun_object_add_routines   (GBRunEvalContext     *ec,
					       GBRunObjectPrivClass *klass,
					       GHashTable           *routines);

void              gbrun_object_init           (GBEvalContext *ec);
void              gbrun_object_shutdown       (void);

/*
 * End of Class maniupulators, start of object manipulators.
 */ 

#define           gbrun_object_ref(e,o)            (gb_object_ref     (GB_EVAL_CONTEXT (e), GB_OBJECT (o)))
#define           gbrun_object_unref(o)            (gb_object_unref   (GB_OBJECT (o)))

void              gbrun_object_set_arg             (GBRunEvalContext *ec,
						    GBRunObject      *object,
						    const char       *prop_name,
						    GBValue          *val);
GBValue          *gbrun_object_get_arg             (GBRunEvalContext *ec,
						    GBRunObject      *object,
						    const char       *prop_name);

GBValue          *gbrun_method_invoke              (GBRunEvalContext *ec,
						    GBRunObject      *obj,
						    const GBObjRef   *func);
#endif /* GBRUN_OBJECT_H */
