
/*
 * GNOME Basic File I/O statements handler
 *
 * Author:
 *    Ravi Pratap <ravi_pratap@email.com>
 *
 * Copyright 2000, Helix Code, Inc.
 */

#ifndef GBRUN_FILE_H
#define GBRUN_FILE_H

#include <gbrun/gbrun.h>
#include <gb/gb-statement.h>

GBValue *gbrun_func_eof         (GBRunEvalContext *ec,
				 GBObject         *object,
				 GBValue         **args);
GBValue *gbrun_func_freefile    (GBRunEvalContext *ec,
				 GBObject         *object,
				 GBValue         **args);
GBValue *gbrun_func_loc         (GBRunEvalContext *ec,
				 GBObject         *object,
				 GBValue         **args);
GBValue *gbrun_func_lof         (GBRunEvalContext *ec,
				 GBObject         *object,
				 GBValue         **args);
GBValue *gbrun_func_seek        (GBRunEvalContext *ec,
				 GBObject         *object,
				 GBValue         **args);
GBValue *gbrun_func_loc         (GBRunEvalContext *ec,
				 GBObject         *object,
				 GBValue         **args);
GBValue *gbrun_func_lof          (GBRunEvalContext *ec,
				  GBObject         *object,
				  GBValue         **args);


gboolean gbrun_stmt_open        (GBRunEvalContext *ec, const GBStatement *stmt);
gboolean gbrun_stmt_close       (GBRunEvalContext *ec, const GBStatement *stmt);
gboolean gbrun_stmt_line_input  (GBRunEvalContext *ec, const GBStatement *stmt);
gboolean gbrun_stmt_input       (GBRunEvalContext *ec, const GBStatement *stmt);
gboolean gbrun_stmt_get         (GBRunEvalContext *ec, const GBStatement *stmt);
gboolean gbrun_stmt_put         (GBRunEvalContext *ec, const GBStatement *stmt);
gboolean gbrun_stmt_seek        (GBRunEvalContext *ec, const GBStatement *stmt);

gboolean gbrun_files_clean      (GBRunEvalContext *ec);

#endif /* GBRUN_FILE_H */
