/* ANSI-C code produced by gperf version 2.7 */
/* Command-line: gperf -k 1-5,$ -t -L ANSI-C -l -C -c -N keywords_lookup keywords.gperf  */
/*
 * Gnome Basic keywords.
 *
 * Author:
 *     Jody Goldberg(jgoldberg@home.com)
 */
#include <glib.h>
#include "gb-statement.h"
#include "gb-expr.h"
#include "grammar.h"
#include <string.h>
#include <ctype.h>
struct GBKeyword { char const * const name; int const id; };

#define TOTAL_KEYWORDS 98
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 13
#define MIN_HASH_VALUE 3
#define MAX_HASH_VALUE 499
/* maximum key range = 497, duplicates = 0 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500,  20,  65,  40, 107,   0,
       60, 120, 500,  55, 500,   0,  35,   5,  65, 100,
        5, 500,  67,   0,   5,   0,   0,  45,   5, 500,
      500, 500, 500, 500, 500, 500, 500,   0,  30,   0,
       20,   0,  25,   0,  10,   0, 500,  25,   5,   0,
       45, 125,   0,  20,   0,   5,   0,   0,   5,  15,
       30,  30, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
      500, 500, 500, 500, 500, 500
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 5:
        hval += asso_values[(unsigned char)str[4]];
      case 4:
        hval += asso_values[(unsigned char)str[3]];
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval + asso_values[(unsigned char)str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct GBKeyword *
keywords_lookup (register const char *str, register unsigned int len)
{
  static const unsigned char lengthtable[] =
    {
       0,  0,  0,  3,  4,  0,  6,  7,  3,  4,  5,  6,  0,  0,
       4,  0,  0,  7,  8,  4,  0, 11,  0,  0,  4,  0,  0,  0,
       0,  9,  0,  0,  2,  3,  4,  0,  0,  0,  3,  4,  0,  6,
       0,  8,  4, 10,  6,  0,  0,  4,  5,  0,  0,  0,  4,  0,
       0,  7,  3,  4,  5,  0,  0,  3,  4,  5,  0,  2,  0,  4,
       3,  0,  0,  0,  4,  5,  4,  5,  6,  0,  0,  0,  0,  0,
       4,  0,  0,  0,  3,  0,  0,  6,  5,  0,  0,  0,  0,  0,
       3,  4,  0,  0,  2,  8,  0,  5,  6,  2,  3,  4,  3,  0,
       0,  0,  0,  5,  0,  0,  6,  7,  0,  0,  0,  3,  0, 13,
       0,  0,  3,  4,  5,  0,  0,  3,  4,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  8,  6,  2,  0,  0,  5,  0,  0,  0,
       0,  0,  0,  0,  8,  0,  0,  6,  0,  0,  0,  0,  0,  0,
       8,  7,  0,  0,  7,  3,  0,  0,  0,  0,  0,  0,  5,  0,
       0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  2,  3,  4,  0,
       0,  0,  0,  0,  0,  6,  0,  0,  4,  0,  6,  7,  0,  0,
       0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  5,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  2,  0,  0,  0,  0,  0,  6,  0,  0,
       9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  6,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  4
    };
  static const struct GBKeyword wordlist[] =
    {
      {""}, {""}, {""},
      {"Set",		GB_SET},
      {"Step",		GB_STEP},
      {""},
      {"Static",		GB_STATIC},
      {"Setattr",	GB_SETATTR},
      {"Put",		GB_PUT},
      {"True",		GB_TRUE},
      {"Erase",		GB_ERASE},
      {"Select",		GB_SELECT},
      {""}, {""},
      {"Else",		GB_ELSE},
      {""}, {""},
      {"Private",	GB_PRIVATE},
      {"Preserve",	GB_PRESERVE},
      {"Kill",		GB_KILL},
      {""},
      {"Savesetting",	GB_SAVESETTING},
      {""}, {""},
      {"Each",		GB_EACH},
      {""}, {""}, {""}, {""},
      {"Attribute",	GB_ATTRIBUTE},
      {""}, {""},
      {"As",		GB_AS},
      {"Eqv",		GB_EQV},
      {"Exit",		GB_EXIT},
      {""}, {""}, {""},
      {"Let",		GB_LET},
      {"Type",           GB_TYPE},
      {""},
      {"Elseif",		GB_ELSE_IF},
      {""},
      {"Explicit",	GB_EXPLICIT},
      {"Lset",		GB_LSET},
      {"Paramarray",	GB_PARAM_ARRAY},
      {"Public",		GB_PUBLIC},
      {""}, {""},
      {"Case",		GB_CASE},
      {"Write",		GB_WRITE},
      {""}, {""}, {""},
      {"Seek",		GB_SEEK},
      {""}, {""},
      {"Version", 	GB_VERSION},
      {"Imp",		GB_IMP},
      {"Call",		GB_CALL},
      {"Until",		GB_UNTIL},
      {""}, {""},
      {"Sub",		GB_SUB},
      {"Like",		GB_LIKE},
      {"While",		GB_WHILE},
      {""},
      {"Is",		GB_IS},
      {""},
      {"With",		GB_WITH},
      {"Rem",		GB_REM},
      {""}, {""}, {""},
      {"Base",		GB_BASE},
      {"False",		GB_FALSE},
      {"Rset",		GB_RSET},
      {"Reset",		GB_RESET},
      {"Resume",		GB_RESUME},
      {""}, {""}, {""}, {""}, {""},
      {"Line",		GB_LINE},
      {""}, {""}, {""},
      {"End",		GB_END},
      {""}, {""},
      {"Append",		GB_APPEND},
      {"Redim",		GB_REDIM},
      {""}, {""}, {""}, {""}, {""},
      {"New",            GB_NEW},
      {"Next",		GB_NEXT},
      {""}, {""},
      {"Or",		GB_OR},
      {"Sendkeys",	GB_SENDKEYS},
      {""},
      {"Input",		GB_INPUT},
      {"Output",		GB_OUTPUT},
      {"If",		GB_IF},
      {"And",		GB_AND},
      {"Then",		GB_THEN},
      {"Dim",		GB_DIM},
      {""}, {""}, {""}, {""},
      {"Byval",		GB_BYVAL},
      {""}, {""},
      {"Return",		GB_RETURN},
      {"Declare",	GB_DECLARE},
      {""}, {""}, {""},
      {"Get",		GB_GET},
      {""},
      {"Deletesetting",	GB_DELETESETTING},
      {""}, {""},
      {"Len",            GB_LEN},
      {"Stop",		GB_STOP},
      {"Error",		GB_ERROR},
      {""}, {""},
      {"Xor",		GB_XOR},
      {"Wend",		GB_WEND},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"Database",	GB_DATABASE},
      {"Binary",		GB_BINARY},
      {"In",		GB_IN},
      {""}, {""},
      {"Byref",		GB_BYREF},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Function",	GB_FUNCTION},
      {""}, {""},
      {"Module",		GB_MODULE},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Property",	GB_PROPERTY},
      {"Deftype",	GB_DEFTYPE},
      {""}, {""},
      {"Compare",	GB_COMPARE},
      {"Mod",		GB_MOD},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Close",		GB_CLOSE},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"For",		GB_FOR},
      {""}, {""}, {""},
      {"On",		GB_ON},
      {"Not",		GB_NOT},
      {"Open",		GB_OPEN},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Unload",		GB_UNLOAD},
      {""}, {""},
      {"Load",		GB_LOAD},
      {""},
      {"Unlock",		GB_UNLOCK},
      {"Nothing",	GB_NOTHING},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"Lock",		GB_LOCK},
      {""}, {""}, {""}, {""}, {""},
      {"Const",		GB_CONST},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Optional",	GB_OPTIONAL},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"To",		GB_TO},
      {""}, {""}, {""}, {""}, {""},
      {"Random",         GB_RANDOM},
      {""}, {""},
      {"Randomize",	GB_RANDOMIZE},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Option",		GB_OPTION},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"Loop",		GB_LOOP},
      {""},
      {"Global",		GB_GLOBAL},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"Gosub",		GB_GOSUB},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"Do",		GB_DO},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"Goto",		GB_GOTO}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        if (len == lengthtable[key])
          {
            register const char *s = wordlist[key].name;

            if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
              return &wordlist[key];
          }
    }
  return 0;
}
char *
correct_case (char const *str)
{
	char *tmp = g_strdup (str);

	g_strdown (tmp);
	tmp[0] = (char) toupper ((int) tmp[0]);

	return tmp;
}

int
gb_is_keyword (char const *str, unsigned const len)
{
	char                   *str_case;
	const struct GBKeyword *keyword;

	str_case = correct_case (str);
	keyword  = keywords_lookup (str_case, len);
	g_free (str_case);

	if (keyword == NULL)
		return 0;
#if 0
	printf ("Keyword : %s\n", keyword->name);
#endif

	return keyword->id;
}
