/**
 * gbrun-load-frx
 *   Load data from the binary frx file.
 *
 * Author:
 *	Frank Chiulli	(fc-linux@home.com)
 *
 * Copyright 2000, Helix Code, Inc.
 **/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <glib.h>

#include "gb.h"
#include "gb-lex.h"
#include "gb-stream.h"
#include "gb-value.h"


/**
 * load_stream
 *   @v		A string consisting of the filename, a colon and an offset.
 *   @type	Type indicator - single item or list.
 *
 **/
GPtrArray *
gb_get_stream_text (const GBValue *v)
{
	gchar		*item;

	guint		 cur_offset;
	guint		 item_len;

	GPtrArray	*ptr_array;
	
	g_return_val_if_fail (v, NULL);
	g_return_val_if_fail (v->v.stream, NULL);
	
	ptr_array   = g_ptr_array_new ();
	cur_offset  = v->v.stream->offset;
	item_len    = gb_lexer_stream_getu8 (v->v.stream->s, cur_offset);
	if (item_len > 0) {
		cur_offset++;
		item = g_new (gchar, item_len + 1);

		item = gb_lexer_stream_getcn (v->v.stream->s, cur_offset, item_len);
		if (item != NULL)
			g_ptr_array_add (ptr_array, item);
	}
	
	return ptr_array;
}


GPtrArray *
gb_get_stream_list (const GBValue *v)
{
	int		 cur_item;

	gchar		*item; 

	guint		 cur_offset;
	guint		 no_items;
	guint		 item_len;

	GPtrArray	*ptr_array;
	
	g_return_val_if_fail (v, NULL);	
	g_return_val_if_fail (v->v.stream, NULL);
	
	cur_offset  = v->v.stream->offset;
	no_items    = gb_lexer_stream_getu16 (v->v.stream->s, cur_offset);
	
	if (no_items == 0) {
		g_warning ("gb_get_stream_list: no items");
		return NULL;
	}
	
	cur_offset += 4;
	ptr_array  = g_ptr_array_new ();

	for (cur_item = 0; cur_item < no_items; cur_item++) {
		item_len    = gb_lexer_stream_getu16 (v->v.stream->s, cur_offset);
		cur_offset += 2;

		if (item_len > 0) {
			item = g_new (gchar, item_len + 1);
			item = gb_lexer_stream_getcn (v->v.stream->s, cur_offset, item_len);

			if (item != NULL)
				g_ptr_array_add (ptr_array, item);

			cur_offset += item_len;
		} else
			g_warning ("gb_get_stream_list: item_len is zero.");
	}


	return ptr_array;
}
