/*
 * GNOME Object
 *
 * Author:
 *    Michael Meeks <michael@imaginator.com>
 *
 * Copyright 2000, Helix Code, Inc.
 */

#ifndef GB_OBJECT_H
#define GB_OBJECT_H

#include <gb/gb.h>

#define GB_TYPE_OBJECT            (gb_object_get_type ())
#define GB_OBJECT(obj)            (GTK_CHECK_CAST ((obj), GB_TYPE_OBJECT, GBObject))
#define GB_OBJECT_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GB_TYPE_OBJECT, GBObjectClass))
#define GB_IS_OBJECT(obj)         (GTK_CHECK_TYPE ((obj), GB_TYPE_OBJECT))
#define GB_IS_OBJECT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GB_TYPE_OBJECT))

struct _GBObject {
	GtkObject object;

	/*
	 *   The individual object private data follows this 
	 * at offsets defined in the class' hash.
	 */
	gpointer  priv;
};

struct _GBObjectClass {
	GtkObjectClass klass;

	/*
	 *  The total size of all private object data
	 * records.
	 */
	int                size;

	/*
	 *  The Primary object data, ie. this data is
	 * the class' private data.
	 */
	GBObjectPrivClass *primary;

	/*
	 *  An internal ordered list of parents of type
	 * GBObjectPrivClass. This is sorted
	 * highest -> lowest abstraction ie.
	 * base class -> derived class order.
	 */
	GSList            *parents;

	/*
	 *  The offsets into object->priv of
	 * each type's structure.
	 */
	GHashTable        *offsets;
};

#define GB_OBJECT_PRIV_GET_CLASS(p) (((GBObjectPriv *)(p))->klass)

struct _GBObjectPriv {
	GBObjectPrivClass *klass;
};

struct _GBObjectPrivClass {
	int	    type;
	int         priv_size;
	const char *name;

	GBObjectCopy       *copy;
	GBObjectDestructor *destructor;
};

/* And it is here that the action begins in earnest */

GtkType        gb_object_get_type   (void);

GBObject      *gb_object_new        (GBEvalContext *ec, GBObjectClass *klass);
GBObject      *gb_object_copy       (GBEvalContext *ec, GBObject *object);
GBObject      *gb_object_ref        (GBEvalContext *ec, GBObject *object);
void           gb_object_unref      (GBObject *object);

GBObjectClass *gb_object_class_new         (GBObjectPrivClass  *priv,
					    const GSList       *parents);
					    

GBObjectClass *gb_object_class_new_single  (GBObjectPrivClass  *priv,
					    GBObjectClass      *parent);
					    

/* gpointer saves tedious casting in fact it is a GBObjectPriv * */
gpointer       gb_object_get_priv       (GBObject      *object,
					 GBObjectClass *klass);

gboolean       gb_object_implements     (GBObject      *object,
					 GBObjectClass *klass);

/*
 * int type is the first element of GtkObjectClass & GBObjectPrivClass
 * klass pointer is the 1st element of GtkObject & GBObjectPriv.
 */
#define GB_TYPE_OBJECT_PRIV            (gb_object_priv_get_type ())
#define GB_OBJECT_PRIV(obj)            (GTK_CHECK_CAST ((obj), GB_TYPE_OBJECT_PRIV, GBObjectPriv))
#define GB_OBJECT_PRIV_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GB_TYPE_OBJECT_PRIV, GBObjectPrivClass))
#define GB_IS_OBJECT_PRIV(obj)	       (GTK_CHECK_TYPE ((obj), GB_TYPE_OBJECT_PRIV))
#define GB_IS_OBJECT_PRIV_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GB_TYPE_OBJECT_PRIV))

int            gb_object_priv_get_type   (void);
void           gb_object_priv_class_init (GBObjectPrivClass  *priv_class,
					  const char         *name,
					  int                 size,
					  GBObjectCopy       *copy,
					  GBObjectDestructor *destructor);

#endif /* GB_OBJECT_H */
