/*
 * GNOME Basic main parser routines.
 *
 * Authors:
 *    Jody Goldberg (jgoldberg@home.com)
 *    Michael Meeks (michael@helixcode.com)
 *
 * Copyright 1999, 2000, Helix Code, Inc.
 */

#ifndef GB_MAIN_H
#define GB_MAIN_H

#include <gb/gb.h>
#include <gb/gb-expr.h>

/* Function/Subroutine */
struct _GBRoutine {
	gchar const *name;
	gboolean     is_private;
	gboolean     is_function;
	
	/* Argument descriptions */
	GSList      *args;

	/* Statements in the routine */
	GSList      *body;
	
	/* variables local to the routine */
	GHashTable  *variables;
};

/* Variable */
struct _GBVar {
	gchar const *name;
	gboolean     object;
	char const  *type;
	gboolean     is_array;
	GSList      *indicees;
};

/* The GB file being parsed */
struct _GBParseData {
	/* The source of the source */
	GBLexerStream *ls;

	/* Set of routines declared within the file hashed by name */
	GHashTable *routines;

	/* Set of global variables hashed by name */
	GHashTable *variables;

	/* The current routine */
	GBRoutine  *current_routine;

	/* An evaluation context for const_exprs & exceptions */
	GBEvalContext *ec;

	/* Any associated form data */
	GBFormItem    *form;

	/* Support nested with statements */
	int with_depth;
};

/* Call before doing anything  */
void             gb_init          (void);
/* Frees up internal resources */
void             gb_shutdown      (void);

/* Return TRUE on error */
gboolean         gb_routine_start   (GBParseData      *module,
				     char const    *name,
				     GSList        *args,
				     gboolean const is_function);
GBRoutine const *gb_routine_finish  (GBParseData *module,
				     gboolean  is_private,
				     gboolean  is_function,
				     GSList   *body);
void             gb_routine_print   (FILE *sink, GBRoutine const *routine);

GBVar           *gb_var_lookup      (GBParseData *module, char const *const name);


void             gb_parse_data_start_form (GBParseData *module);
void             gb_parse_data_end_form   (GBParseData *module,
					   GBFormItem *form);

void  gb_module_with_depth_inc (GBParseData *module, GBExpr const *base_obj);


struct _GBIndex {
	const GBExpr *min;
	const GBExpr *max;
};

GBIndex *gb_index_new (const GBExpr *min, const GBExpr *max);

gboolean gb_decl_var  (GBParseData *parse_data,
		       const char  *name,
		       gboolean     obj,
		       gboolean     is_array,
		       GSList      *indicees,
		       const char  *type);

#endif /* GB_MAIN_H */
