# Copyright (C) 2005 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from gtk import gdk

SELECTION_NODE_SIZE = 7
BORDER_WIDTH = 3

class Annotator:
    def __init__(self, widget, window):
        self.widget = widget
        self.window = window
        self.gc = gdk.GC(window, line_width=BORDER_WIDTH)

    def draw_nodes(self, x, y, width, height):
        window = self.window
        gc = self.widget.style.black_gc
        
        if width > SELECTION_NODE_SIZE and height > SELECTION_NODE_SIZE:
            window.draw_rectangle(gc, True, x, y,
                                  SELECTION_NODE_SIZE, SELECTION_NODE_SIZE)
            window.draw_rectangle(gc, True, x, y + height -SELECTION_NODE_SIZE,
                                  SELECTION_NODE_SIZE, SELECTION_NODE_SIZE)
            window.draw_rectangle(gc, True, x + width - SELECTION_NODE_SIZE, y,
                                  SELECTION_NODE_SIZE, SELECTION_NODE_SIZE)
            window.draw_rectangle(gc, True, x + width - SELECTION_NODE_SIZE,
                                  y + height - SELECTION_NODE_SIZE,
                                  SELECTION_NODE_SIZE, SELECTION_NODE_SIZE)
        window.draw_rectangle(gc, False, x, y, width - 1, height - 1)

    def draw_border(self, x, y, width, height, color):
        window = self.window
        gc = self.gc
        
        gc.set_rgb_fg_color(gdk.Color(int(color[0] * 65535.999),
                                      int(color[1] * 65535.999),
                                      int(color[2] * 65535.999)))
        
        window.draw_rectangle(gc, False,
                              x - (BORDER_WIDTH / 2), y - (BORDER_WIDTH / 2),
                              width, height)
