/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "bookmarks-default-icon-provider.h"
#include "gul-gobject-misc.h"
#include "bookmarks-util.h"

/* to render the default icons */
#include "pixbuf-cache.h"
#include <gtk/gtktoolbar.h>

#define NOT_IMPLEMENTED g_warning ("not implemented: " G_STRLOC);
//#define DEBUG_MSG(x) g_print x
#define DEBUG_MSG(x)

/**
 * Private data
 */
struct _GbDefaultIconProviderPrivate 
{
	GdkPixbuf *folder_pixbuf_data;
	GdkPixbuf *folder_open_pixbuf_data;
	GdkPixbuf *default_folder_pixbuf_data;
	GdkPixbuf *default_folder_open_pixbuf_data;
	GdkPixbuf *site_pixbuf_data;
	GdkPixbuf *separator_pixbuf_data;
};

/**
 * Private functions, only availble from this file
 */
static void		gb_default_icon_provider_class_init		(GbDefaultIconProviderClass *klass);
static void		gb_default_icon_provider_icon_provider_init	(GbIconProviderIface *iface);
static void		gb_default_icon_provider_init			(GbDefaultIconProvider *dip);
static void		gb_default_icon_provider_finalize_impl		(GObject *o);
static GdkPixbuf *	gb_default_icon_provider_icon_provider_get_icon_impl (GbIconProvider *ip,
									      GbBookmark *b);

static gpointer g_object_class;

/**
 * DefaultIconProvider object
 */
MAKE_GET_TYPE_IFACE (gb_default_icon_provider, "DefaultIconProvider", GbDefaultIconProvider,
		     gb_default_icon_provider_class_init, gb_default_icon_provider_init, G_TYPE_OBJECT,
		     gb_default_icon_provider_icon_provider_init, GB_TYPE_ICON_PROVIDER);

static void
gb_default_icon_provider_class_init (GbDefaultIconProviderClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = gb_default_icon_provider_finalize_impl;
	g_object_class = g_type_class_peek_parent (klass);

	gul_pixbuf_cache_register_stocks ();
}

static void
gb_default_icon_provider_icon_provider_init (GbIconProviderIface *iface)
{
	iface->get_icon = gb_default_icon_provider_icon_provider_get_icon_impl;
}

static void 
gb_default_icon_provider_init (GbDefaultIconProvider *dip)
{
	GtkWidget *dummy = gtk_toolbar_new ();
	GbDefaultIconProviderPrivate *p = g_new0 (GbDefaultIconProviderPrivate, 1);
	dip->priv = p;
	
	p->folder_pixbuf_data =
		gtk_widget_render_icon (dummy, GALEON_STOCK_FOLDER, GTK_ICON_SIZE_MENU, NULL);
	p->folder_open_pixbuf_data =
		gtk_widget_render_icon (dummy, GALEON_STOCK_FOLDER_OPEN, GTK_ICON_SIZE_MENU, NULL);
	p->default_folder_pixbuf_data =
		gtk_widget_render_icon (dummy, GALEON_STOCK_DEFAULT, GTK_ICON_SIZE_MENU, NULL);
	p->default_folder_open_pixbuf_data =
		gtk_widget_render_icon (dummy, GALEON_STOCK_DEFAULT_OPEN, GTK_ICON_SIZE_MENU, NULL);
	p->site_pixbuf_data  =
		gtk_widget_render_icon (dummy, GALEON_STOCK_BOOKMARK, GTK_ICON_SIZE_MENU, NULL);
	p->separator_pixbuf_data  =
		gtk_widget_render_icon (dummy, GALEON_STOCK_SEPARATOR, GTK_ICON_SIZE_MENU, NULL);

	gtk_widget_destroy (dummy);
}

static void
gb_default_icon_provider_finalize_impl (GObject *o)
{
	GbDefaultIconProvider *dip = GB_DEFAULT_ICON_PROVIDER (o);
	GbDefaultIconProviderPrivate *p = dip->priv;
	
	g_object_unref (p->folder_pixbuf_data);
	g_object_unref (p->folder_open_pixbuf_data);
	g_object_unref (p->default_folder_pixbuf_data);
	g_object_unref (p->default_folder_open_pixbuf_data);
	g_object_unref (p->site_pixbuf_data);
	
	g_free (p);
	
	G_OBJECT_CLASS (g_object_class)->finalize (o);

}

GbDefaultIconProvider *
gb_default_icon_provider_new (void)
{
	GbDefaultIconProvider *ret = g_object_new (GB_TYPE_DEFAULT_ICON_PROVIDER, NULL);
	return ret;
}

static GdkPixbuf *
gb_default_icon_provider_icon_provider_get_icon_impl (GbIconProvider *ip, GbBookmark *b)
{
	GbDefaultIconProviderPrivate *p = GB_DEFAULT_ICON_PROVIDER (ip)->priv;
	GdkPixbuf *ret;

	DEBUG_MSG (("getting icon for %s\n", b->name));

	if (GB_IS_FOLDER (b))
	{
		if (gb_folder_is_default_folder (GB_FOLDER (b)))
		{
			ret = p->default_folder_pixbuf_data;
		}
		else
		{
			ret = p->folder_pixbuf_data;
		}
	}
	else if (GB_IS_SEPARATOR (b))
	{
		ret = p->separator_pixbuf_data;
	}
	else
	{
		ret = p->site_pixbuf_data;
	}

	if (gb_bookmark_is_alias (b))
	{
		ret = gb_util_make_alias_icon (ret);
	}
	
	return g_object_ref (ret);
}

